// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Lists resource snapshot jobs owned by the customer. This operation supports
//
// various filtering scenarios, including listing all jobs owned by the caller,
// jobs for a specific engagement, jobs with a specific status, or any combination
// of these filters.
func (c *Client) ListResourceSnapshotJobs(ctx context.Context, params *ListResourceSnapshotJobsInput, optFns ...func(*Options)) (*ListResourceSnapshotJobsOutput, error) {
	if params == nil {
		params = &ListResourceSnapshotJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListResourceSnapshotJobs", params, optFns, c.addOperationListResourceSnapshotJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListResourceSnapshotJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListResourceSnapshotJobsInput struct {

	//  Specifies the catalog related to the request.
	//
	// This member is required.
	Catalog *string

	//  The identifier of the engagement to filter the response.
	EngagementIdentifier *string

	//  The maximum number of results to return in a single call. If omitted, defaults
	// to 50.
	MaxResults *int32

	//  The token for the next set of results.
	NextToken *string

	//  Configures the sorting of the response. If omitted, results are sorted by
	// CreatedDate in descending order.
	Sort *types.SortObject

	//  The status of the jobs to filter the response.
	Status types.ResourceSnapshotJobStatus

	noSmithyDocumentSerde
}

type ListResourceSnapshotJobsOutput struct {

	//  An array of resource snapshot job summary objects.
	//
	// This member is required.
	ResourceSnapshotJobSummaries []types.ResourceSnapshotJobSummary

	//  The token to retrieve the next set of results. If there are no additional
	// results, this value is null.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListResourceSnapshotJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListResourceSnapshotJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListResourceSnapshotJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListResourceSnapshotJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListResourceSnapshotJobsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListResourceSnapshotJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListResourceSnapshotJobsPaginatorOptions is the paginator options for
// ListResourceSnapshotJobs
type ListResourceSnapshotJobsPaginatorOptions struct {
	//  The maximum number of results to return in a single call. If omitted, defaults
	// to 50.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListResourceSnapshotJobsPaginator is a paginator for ListResourceSnapshotJobs
type ListResourceSnapshotJobsPaginator struct {
	options   ListResourceSnapshotJobsPaginatorOptions
	client    ListResourceSnapshotJobsAPIClient
	params    *ListResourceSnapshotJobsInput
	nextToken *string
	firstPage bool
}

// NewListResourceSnapshotJobsPaginator returns a new
// ListResourceSnapshotJobsPaginator
func NewListResourceSnapshotJobsPaginator(client ListResourceSnapshotJobsAPIClient, params *ListResourceSnapshotJobsInput, optFns ...func(*ListResourceSnapshotJobsPaginatorOptions)) *ListResourceSnapshotJobsPaginator {
	if params == nil {
		params = &ListResourceSnapshotJobsInput{}
	}

	options := ListResourceSnapshotJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListResourceSnapshotJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListResourceSnapshotJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListResourceSnapshotJobs page.
func (p *ListResourceSnapshotJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListResourceSnapshotJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListResourceSnapshotJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListResourceSnapshotJobsAPIClient is a client that implements the
// ListResourceSnapshotJobs operation.
type ListResourceSnapshotJobsAPIClient interface {
	ListResourceSnapshotJobs(context.Context, *ListResourceSnapshotJobsInput, ...func(*Options)) (*ListResourceSnapshotJobsOutput, error)
}

var _ ListResourceSnapshotJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListResourceSnapshotJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListResourceSnapshotJobs",
	}
}
