// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the details of member partners in an Engagement. This operation can
// only be invoked by members of the Engagement. The ListEngagementMembers
// operation allows you to fetch information about the members of a specific
// Engagement. This action is restricted to members of the Engagement being
// queried.
func (c *Client) ListEngagementMembers(ctx context.Context, params *ListEngagementMembersInput, optFns ...func(*Options)) (*ListEngagementMembersOutput, error) {
	if params == nil {
		params = &ListEngagementMembersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEngagementMembers", params, optFns, c.addOperationListEngagementMembersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEngagementMembersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEngagementMembersInput struct {

	// The catalog related to the request.
	//
	// This member is required.
	Catalog *string

	// Identifier of the Engagement record to retrieve members from.
	//
	// This member is required.
	Identifier *string

	// The maximum number of results to return in a single call.
	MaxResults *int32

	// The token for the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEngagementMembersOutput struct {

	//  Provides a list of engagement members.
	//
	// This member is required.
	EngagementMemberList []types.EngagementMember

	// A pagination token used to retrieve the next set of results. If there are more
	// results available than can be returned in a single response, this token will be
	// present. Use this token in a subsequent request to retrieve the next page of
	// results. If there are no more results, this value will be null.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEngagementMembersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListEngagementMembers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListEngagementMembers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEngagementMembers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListEngagementMembersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEngagementMembers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEngagementMembersPaginatorOptions is the paginator options for
// ListEngagementMembers
type ListEngagementMembersPaginatorOptions struct {
	// The maximum number of results to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEngagementMembersPaginator is a paginator for ListEngagementMembers
type ListEngagementMembersPaginator struct {
	options   ListEngagementMembersPaginatorOptions
	client    ListEngagementMembersAPIClient
	params    *ListEngagementMembersInput
	nextToken *string
	firstPage bool
}

// NewListEngagementMembersPaginator returns a new ListEngagementMembersPaginator
func NewListEngagementMembersPaginator(client ListEngagementMembersAPIClient, params *ListEngagementMembersInput, optFns ...func(*ListEngagementMembersPaginatorOptions)) *ListEngagementMembersPaginator {
	if params == nil {
		params = &ListEngagementMembersInput{}
	}

	options := ListEngagementMembersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEngagementMembersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEngagementMembersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEngagementMembers page.
func (p *ListEngagementMembersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEngagementMembersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEngagementMembers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEngagementMembersAPIClient is a client that implements the
// ListEngagementMembers operation.
type ListEngagementMembersAPIClient interface {
	ListEngagementMembers(context.Context, *ListEngagementMembersInput, ...func(*Options)) (*ListEngagementMembersOutput, error)
}

var _ ListEngagementMembersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEngagementMembers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEngagementMembers",
	}
}
