// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Lists all in-progress, completed, or failed
//
// StartEngagementByAcceptingInvitationTask tasks that were initiated by the
// caller's account.
func (c *Client) ListEngagementByAcceptingInvitationTasks(ctx context.Context, params *ListEngagementByAcceptingInvitationTasksInput, optFns ...func(*Options)) (*ListEngagementByAcceptingInvitationTasksOutput, error) {
	if params == nil {
		params = &ListEngagementByAcceptingInvitationTasksInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEngagementByAcceptingInvitationTasks", params, optFns, c.addOperationListEngagementByAcceptingInvitationTasksMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEngagementByAcceptingInvitationTasksOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEngagementByAcceptingInvitationTasksInput struct {

	//  Specifies the catalog related to the request. Valid values are:
	//
	//   - AWS: Retrieves the request from the production AWS environment.
	//
	//   - Sandbox: Retrieves the request from a sandbox environment used for testing
	//   or development purposes.
	//
	// This member is required.
	Catalog *string

	//  Filters tasks by the identifiers of the engagement invitations they are
	// processing.
	EngagementInvitationIdentifier []string

	//  Use this parameter to control the number of items returned in each request,
	// which can be useful for performance tuning and managing large result sets.
	MaxResults *int32

	//  Use this parameter for pagination when the result set spans multiple pages.
	// This value is obtained from the NextToken field in the response of a previous
	// call to this API.
	NextToken *string

	//  Filters tasks by the identifiers of the opportunities they created or are
	// associated with.
	OpportunityIdentifier []string

	//  Specifies the sorting criteria for the returned results. This allows you to
	// order the tasks based on specific attributes.
	Sort *types.ListTasksSortBase

	//  Filters tasks by their unique identifiers. Use this when you want to retrieve
	// information about specific tasks.
	TaskIdentifier []string

	//  Filters the tasks based on their current status. This allows you to focus on
	// tasks in specific states.
	TaskStatus []types.TaskStatus

	noSmithyDocumentSerde
}

type ListEngagementByAcceptingInvitationTasksOutput struct {

	//  A token used for pagination to retrieve the next page of results.If there are
	// more results available, this field will contain a token that can be used in a
	// subsequent API call to retrieve the next page. If there are no more results,
	// this field will be null or an empty string.
	NextToken *string

	//  An array of EngagementByAcceptingInvitationTaskSummary objects, each
	// representing a task that matches the specified filters. The array may be empty
	// if no tasks match the criteria.
	TaskSummaries []types.ListEngagementByAcceptingInvitationTaskSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEngagementByAcceptingInvitationTasksMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListEngagementByAcceptingInvitationTasks{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListEngagementByAcceptingInvitationTasks{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEngagementByAcceptingInvitationTasks"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListEngagementByAcceptingInvitationTasksValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEngagementByAcceptingInvitationTasks(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEngagementByAcceptingInvitationTasksPaginatorOptions is the paginator
// options for ListEngagementByAcceptingInvitationTasks
type ListEngagementByAcceptingInvitationTasksPaginatorOptions struct {
	//  Use this parameter to control the number of items returned in each request,
	// which can be useful for performance tuning and managing large result sets.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEngagementByAcceptingInvitationTasksPaginator is a paginator for
// ListEngagementByAcceptingInvitationTasks
type ListEngagementByAcceptingInvitationTasksPaginator struct {
	options   ListEngagementByAcceptingInvitationTasksPaginatorOptions
	client    ListEngagementByAcceptingInvitationTasksAPIClient
	params    *ListEngagementByAcceptingInvitationTasksInput
	nextToken *string
	firstPage bool
}

// NewListEngagementByAcceptingInvitationTasksPaginator returns a new
// ListEngagementByAcceptingInvitationTasksPaginator
func NewListEngagementByAcceptingInvitationTasksPaginator(client ListEngagementByAcceptingInvitationTasksAPIClient, params *ListEngagementByAcceptingInvitationTasksInput, optFns ...func(*ListEngagementByAcceptingInvitationTasksPaginatorOptions)) *ListEngagementByAcceptingInvitationTasksPaginator {
	if params == nil {
		params = &ListEngagementByAcceptingInvitationTasksInput{}
	}

	options := ListEngagementByAcceptingInvitationTasksPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEngagementByAcceptingInvitationTasksPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEngagementByAcceptingInvitationTasksPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEngagementByAcceptingInvitationTasks page.
func (p *ListEngagementByAcceptingInvitationTasksPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEngagementByAcceptingInvitationTasksOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEngagementByAcceptingInvitationTasks(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEngagementByAcceptingInvitationTasksAPIClient is a client that implements
// the ListEngagementByAcceptingInvitationTasks operation.
type ListEngagementByAcceptingInvitationTasksAPIClient interface {
	ListEngagementByAcceptingInvitationTasks(context.Context, *ListEngagementByAcceptingInvitationTasksInput, ...func(*Options)) (*ListEngagementByAcceptingInvitationTasksOutput, error)
}

var _ ListEngagementByAcceptingInvitationTasksAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEngagementByAcceptingInvitationTasks(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEngagementByAcceptingInvitationTasks",
	}
}
