// Code generated by smithy-go-codegen DO NOT EDIT.

package notifications

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/notifications/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns a specified NotificationEvent .
//
// User Notifications stores notifications in the individual Regions you register
// as notification hubs and the Region of the source event rule.
// GetNotificationEvent only returns notifications stored in the same Region in
// which the action is called. User Notifications doesn't backfill notifications to
// new Regions selected as notification hubs. For this reason, we recommend that
// you make calls in your oldest registered notification hub. For more information,
// see [Notification hubs]in the Amazon Web Services User Notifications User Guide.
//
// [Notification hubs]: https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html
func (c *Client) GetNotificationEvent(ctx context.Context, params *GetNotificationEventInput, optFns ...func(*Options)) (*GetNotificationEventOutput, error) {
	if params == nil {
		params = &GetNotificationEventInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetNotificationEvent", params, optFns, c.addOperationGetNotificationEventMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetNotificationEventOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetNotificationEventInput struct {

	// The Amazon Resource Name (ARN) of the NotificationEvent to return.
	//
	// This member is required.
	Arn *string

	// The locale code of the language used for the retrieved NotificationEvent . The
	// default locale is English en_US .
	Locale types.LocaleCode

	noSmithyDocumentSerde
}

type GetNotificationEventOutput struct {

	// The ARN of the resource.
	//
	// This member is required.
	Arn *string

	// The content of the NotificationEvent .
	//
	// This member is required.
	Content *types.NotificationEventSchema

	// The creation time of the NotificationEvent .
	//
	// This member is required.
	CreationTime *time.Time

	// The ARN of the NotificationConfiguration .
	//
	// This member is required.
	NotificationConfigurationArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetNotificationEventMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetNotificationEvent{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetNotificationEvent{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetNotificationEvent"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetNotificationEventValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetNotificationEvent(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetNotificationEvent(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetNotificationEvent",
	}
}
