// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A custom action to use in stateless rule actions settings. This is used in CustomAction.
type ActionDefinition struct {

	// Stateless inspection criteria that publishes the specified metrics to Amazon
	// CloudWatch for the matching packet. This setting defines a CloudWatch dimension
	// value to be published.
	//
	// You can pair this custom action with any of the standard stateless rule
	// actions. For example, you could pair this in a rule action with the standard
	// action that forwards the packet for stateful inspection. Then, when a packet
	// matches the rule, Network Firewall publishes metrics for the packet and forwards
	// it.
	PublishMetricAction *PublishMetricAction

	noSmithyDocumentSerde
}

// A single IP address specification. This is used in the MatchAttributes source and destination
// specifications.
type Address struct {

	// Specify an IP address or a block of IP addresses in Classless Inter-Domain
	// Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4
	// and IPv6.
	//
	// Examples:
	//
	//   - To configure Network Firewall to inspect for the IP address 192.0.2.44,
	//   specify 192.0.2.44/32 .
	//
	//   - To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to
	//   192.0.2.255, specify 192.0.2.0/24 .
	//
	//   - To configure Network Firewall to inspect for the IP address
	//   1111:0000:0000:0000:0000:0000:0000:0111, specify
	//   1111:0000:0000:0000:0000:0000:0000:0111/128 .
	//
	//   - To configure Network Firewall to inspect for IP addresses from
	//   1111:0000:0000:0000:0000:0000:0000:0000 to
	//   1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
	//   1111:0000:0000:0000:0000:0000:0000:0000/64 .
	//
	// For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing].
	//
	// [Classless Inter-Domain Routing]: https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing
	//
	// This member is required.
	AddressDefinition *string

	noSmithyDocumentSerde
}

// A report that captures key activity from the last 30 days of network traffic
// monitored by your firewall.
//
// You can generate up to one report per traffic type, per 30 day period. For
// example, when you successfully create an HTTP traffic report, you cannot create
// another HTTP traffic report until 30 days pass. Alternatively, if you generate a
// report that combines metrics on both HTTP and HTTPS traffic, you cannot create
// another report for either traffic type until 30 days pass.
type AnalysisReport struct {

	// The unique ID of the query that ran when you requested an analysis report.
	AnalysisReportId *string

	// The type of traffic that will be used to generate a report.
	AnalysisType EnabledAnalysisType

	// The date and time the analysis report was ran.
	ReportTime *time.Time

	// The status of the analysis report you specify. Statuses include RUNNING ,
	// COMPLETED , or FAILED .
	Status *string

	noSmithyDocumentSerde
}

// The analysis result for Network Firewall's stateless rule group analyzer. Every
// time you call CreateRuleGroup, UpdateRuleGroup, or DescribeRuleGroup on a stateless rule group, Network Firewall analyzes the
// stateless rule groups in your account and identifies the rules that might
// adversely effect your firewall's functionality. For example, if Network Firewall
// detects a rule that's routing traffic asymmetrically, which impacts the
// service's ability to properly process traffic, the service includes the rule in
// a list of analysis results.
//
// The AnalysisResult data type is not related to traffic analysis reports you
// generate using StartAnalysisReport. For information on traffic analysis report results, see AnalysisTypeReportResult.
type AnalysisResult struct {

	// Provides analysis details for the identified rule.
	AnalysisDetail *string

	// The priority number of the stateless rules identified in the analysis.
	IdentifiedRuleIds []string

	// The types of rule configurations that Network Firewall analyzes your rule
	// groups for. Network Firewall analyzes stateless rule groups for the following
	// types of rule configurations:
	//
	//   - STATELESS_RULE_FORWARDING_ASYMMETRICALLY
	//
	// Cause: One or more stateless rules with the action pass or forward are
	//   forwarding traffic asymmetrically. Specifically, the rule's set of source IP
	//   addresses or their associated port numbers, don't match the set of destination
	//   IP addresses or their associated port numbers.
	//
	// To mitigate: Make sure that there's an existing return path. For example, if
	//   the rule allows traffic from source 10.1.0.0/24 to destination 20.1.0.0/24, you
	//   should allow return traffic from source 20.1.0.0/24 to destination 10.1.0.0/24.
	//
	//   - STATELESS_RULE_CONTAINS_TCP_FLAGS
	//
	// Cause: At least one stateless rule with the action pass or forward contains TCP
	//   flags that are inconsistent in the forward and return directions.
	//
	// To mitigate: Prevent asymmetric routing issues caused by TCP flags by following
	//   these actions:
	//
	//   - Remove unnecessary TCP flag inspections from the rules.
	//
	//   - If you need to inspect TCP flags, check that the rules correctly account
	//   for changes in TCP flags throughout the TCP connection cycle, for example SYN
	//   and ACK flags used in a 3-way TCP handshake.
	IdentifiedType IdentifiedType

	noSmithyDocumentSerde
}

// The results of a COMPLETED analysis report generated with StartAnalysisReport.
//
// For an example of traffic analysis report results, see the response syntax of GetAnalysisReportResults.
type AnalysisTypeReportResult struct {

	// The most frequently accessed domains.
	Domain *string

	// The date and time any domain was first accessed (within the last 30 day period).
	FirstAccessed *time.Time

	// The number of attempts made to access a observed domain.
	Hits *Hits

	// The date and time any domain was last accessed (within the last 30 day period).
	LastAccessed *time.Time

	// The type of traffic captured by the analysis report.
	Protocol *string

	// The number of unique source IP addresses that connected to a domain.
	UniqueSources *UniqueSources

	noSmithyDocumentSerde
}

// The definition and status of the firewall endpoint for a single subnet. In each
// configured subnet, Network Firewall instantiates a firewall endpoint to handle
// network traffic.
//
// This data type is used for any firewall endpoint type:
//
//   - For Firewall.SubnetMappings , this Attachment is part of the FirewallStatus
//     sync states information. You define firewall subnets using CreateFirewall and
//     AssociateSubnets .
//
//   - For VpcEndpointAssociation , this Attachment is part of the
//     VpcEndpointAssociationStatus sync states information. You define these subnets
//     using CreateVpcEndpointAssociation .
type Attachment struct {

	// The identifier of the firewall endpoint that Network Firewall has instantiated
	// in the subnet. You use this to identify the firewall endpoint in the VPC route
	// tables, when you redirect the VPC traffic through the endpoint.
	EndpointId *string

	// The current status of the firewall endpoint instantiation in the subnet.
	//
	// When this value is READY , the endpoint is available to handle network traffic.
	// Otherwise, this value reflects its state, for example CREATING or DELETING .
	Status AttachmentStatus

	// If Network Firewall fails to create or delete the firewall endpoint in the
	// subnet, it populates this with the reason for the error or failure and how to
	// resolve it. A FAILED status indicates a non-recoverable state, and a ERROR
	// status indicates an issue that you can fix. Depending on the error, it can take
	// as many as 15 minutes to populate this field. For more information about the
	// causes for failiure or errors and solutions available for this field, see [Troubleshooting firewall endpoint failures]in
	// the Network Firewall Developer Guide.
	//
	// [Troubleshooting firewall endpoint failures]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html
	StatusMessage *string

	// The unique identifier of the subnet that you've specified to be used for a
	// firewall endpoint.
	SubnetId *string

	noSmithyDocumentSerde
}

// High-level information about an Availability Zone where the firewall has an
// endpoint defined.
type AvailabilityZoneMetadata struct {

	// The IP address type of the Firewall subnet in the Availability Zone. You can't
	// change the IP address type after you create the subnet.
	IPAddressType IPAddressType

	noSmithyDocumentSerde
}

// The status of the firewall endpoint defined by a VpcEndpointAssociation .
type AZSyncState struct {

	// The definition and status of the firewall endpoint for a single subnet. In each
	// configured subnet, Network Firewall instantiates a firewall endpoint to handle
	// network traffic.
	//
	// This data type is used for any firewall endpoint type:
	//
	//   - For Firewall.SubnetMappings , this Attachment is part of the FirewallStatus
	//   sync states information. You define firewall subnets using CreateFirewall and
	//   AssociateSubnets .
	//
	//   - For VpcEndpointAssociation , this Attachment is part of the
	//   VpcEndpointAssociationStatus sync states information. You define these subnets
	//   using CreateVpcEndpointAssociation .
	Attachment *Attachment

	noSmithyDocumentSerde
}

// The capacity usage summary of the resources used by the ReferenceSets in a firewall.
type CapacityUsageSummary struct {

	// Describes the capacity usage of the CIDR blocks used by the IP set references
	// in a firewall.
	CIDRs *CIDRSummary

	noSmithyDocumentSerde
}

// Defines the actions to take on the SSL/TLS connection if the certificate
// presented by the server in the connection has a revoked or unknown status.
type CheckCertificateRevocationStatusActions struct {

	// Configures how Network Firewall processes traffic when it determines that the
	// certificate presented by the server in the SSL/TLS connection has a revoked
	// status.
	//
	//   - PASS - Allow the connection to continue, and pass subsequent packets to the
	//   stateful engine for inspection.
	//
	//   - DROP - Network Firewall closes the connection and drops subsequent packets
	//   for that connection.
	//
	//   - REJECT - Network Firewall sends a TCP reject packet back to your client.
	//   The service closes the connection and drops subsequent packets for that
	//   connection. REJECT is available only for TCP traffic.
	RevokedStatusAction RevocationCheckAction

	// Configures how Network Firewall processes traffic when it determines that the
	// certificate presented by the server in the SSL/TLS connection has an unknown
	// status, or a status that cannot be determined for any other reason, including
	// when the service is unable to connect to the OCSP and CRL endpoints for the
	// certificate.
	//
	//   - PASS - Allow the connection to continue, and pass subsequent packets to the
	//   stateful engine for inspection.
	//
	//   - DROP - Network Firewall closes the connection and drops subsequent packets
	//   for that connection.
	//
	//   - REJECT - Network Firewall sends a TCP reject packet back to your client.
	//   The service closes the connection and drops subsequent packets for that
	//   connection. REJECT is available only for TCP traffic.
	UnknownStatusAction RevocationCheckAction

	noSmithyDocumentSerde
}

// Summarizes the CIDR blocks used by the IP set references in a firewall. Network
// Firewall calculates the number of CIDRs by taking an aggregated count of all
// CIDRs used by the IP sets you are referencing.
type CIDRSummary struct {

	// The number of CIDR blocks available for use by the IP set references in a
	// firewall.
	AvailableCIDRCount *int32

	// The list of the IP set references used by a firewall.
	IPSetReferences map[string]IPSetMetadata

	// The number of CIDR blocks used by the IP set references in a firewall.
	UtilizedCIDRCount *int32

	noSmithyDocumentSerde
}

// An optional, non-standard action to use for stateless packet handling. You can
// define this in addition to the standard action that you must specify.
//
// You define and name the custom actions that you want to be able to use, and
// then you reference them by name in your actions settings.
//
// You can use custom actions in the following places:
//
//   - In a rule group's StatelessRulesAndCustomActionsspecification. The custom actions are available for use
//     by name inside the StatelessRulesAndCustomActions where you define them. You
//     can use them for your stateless rule actions to specify what to do with a packet
//     that matches the rule's match attributes.
//
//   - In a FirewallPolicyspecification, in StatelessCustomActions . The custom actions are
//     available for use inside the policy where you define them. You can use them for
//     the policy's default stateless actions settings to specify what to do with
//     packets that don't match any of the policy's stateless rules.
type CustomAction struct {

	// The custom action associated with the action name.
	//
	// This member is required.
	ActionDefinition *ActionDefinition

	// The descriptive name of the custom action. You can't change the name of a
	// custom action after you create it.
	//
	// This member is required.
	ActionName *string

	noSmithyDocumentSerde
}

// The value to use in an Amazon CloudWatch custom metric dimension. This is used
// in the PublishMetricsCustomAction . A CloudWatch custom metric dimension is a name/value
// pair that's part of the identity of a metric.
//
// Network Firewall sets the dimension name to CustomAction and you provide the
// dimension value.
//
// For more information about CloudWatch custom metric dimensions, see [Publishing Custom Metrics] in the [Amazon CloudWatch User Guide].
//
// [Amazon CloudWatch User Guide]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html
// [Publishing Custom Metrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#usingDimensions
type Dimension struct {

	// The value to use in the custom metric dimension.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A complex type that contains optional Amazon Web Services Key Management
// Service (KMS) encryption settings for your Network Firewall resources. Your data
// is encrypted by default with an Amazon Web Services owned key that Amazon Web
// Services owns and manages for you. You can use either the Amazon Web Services
// owned key, or provide your own customer managed key. To learn more about KMS
// encryption of your Network Firewall resources, see [Encryption at rest with Amazon Web Services Key Managment Service]in the Network Firewall
// Developer Guide.
//
// [Encryption at rest with Amazon Web Services Key Managment Service]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-encryption-at-rest.html
type EncryptionConfiguration struct {

	// The type of Amazon Web Services KMS key to use for encryption of your Network
	// Firewall resources.
	//
	// This member is required.
	Type EncryptionType

	// The ID of the Amazon Web Services Key Management Service (KMS) customer managed
	// key. You can use any of the key identifiers that KMS supports, unless you're
	// using a key that's managed by another account. If you're using a key managed by
	// another account, then specify the key ARN. For more information, see [Key ID]in the
	// Amazon Web Services KMS Developer Guide.
	//
	// [Key ID]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id
	KeyId *string

	noSmithyDocumentSerde
}

// A firewall defines the behavior of a firewall, the main VPC where the firewall
// is used, the Availability Zones where the firewall can be used, and one subnet
// to use for a firewall endpoint within each of the Availability Zones. The
// Availability Zones are defined implicitly in the subnet specifications.
//
// In addition to the firewall endpoints that you define in this Firewall
// specification, you can create firewall endpoints in VpcEndpointAssociation
// resources for any VPC, in any Availability Zone where the firewall is already in
// use.
//
// The status of the firewall, for example whether it's ready to filter network
// traffic, is provided in the corresponding FirewallStatus. You can retrieve both the firewall
// and firewall status by calling DescribeFirewall.
type Firewall struct {

	// The unique identifier for the firewall.
	//
	// This member is required.
	FirewallId *string

	// The Amazon Resource Name (ARN) of the firewall policy.
	//
	// The relationship of firewall to firewall policy is many to one. Each firewall
	// requires one firewall policy association, and you can use the same firewall
	// policy for multiple firewalls.
	//
	// This member is required.
	FirewallPolicyArn *string

	// The primary public subnets that Network Firewall is using for the firewall.
	// Network Firewall creates a firewall endpoint in each subnet. Create a subnet
	// mapping for each Availability Zone where you want to use the firewall.
	//
	// These subnets are all defined for a single, primary VPC, and each must belong
	// to a different Availability Zone. Each of these subnets establishes the
	// availability of the firewall in its Availability Zone.
	//
	// In addition to these subnets, you can define other endpoints for the firewall
	// in VpcEndpointAssociation resources. You can define these additional endpoints
	// for any VPC, and for any of the Availability Zones where the firewall resource
	// already has a subnet mapping. VPC endpoint associations give you the ability to
	// protect multiple VPCs using a single firewall, and to define multiple firewall
	// endpoints for a VPC in a single Availability Zone.
	//
	// This member is required.
	SubnetMappings []SubnetMapping

	// The unique identifier of the VPC where the firewall is in use.
	//
	// This member is required.
	VpcId *string

	// A flag indicating whether it is possible to delete the firewall. A setting of
	// TRUE indicates that the firewall is protected against deletion. Use this setting
	// to protect against accidentally deleting a firewall that is in use. When you
	// create a firewall, the operation initializes this flag to TRUE .
	DeleteProtection bool

	// A description of the firewall.
	Description *string

	// An optional setting indicating the specific traffic analysis types to enable on
	// the firewall.
	EnabledAnalysisTypes []EnabledAnalysisType

	// A complex type that contains the Amazon Web Services KMS encryption
	// configuration settings for your firewall.
	EncryptionConfiguration *EncryptionConfiguration

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string

	// A setting indicating whether the firewall is protected against a change to the
	// firewall policy association. Use this setting to protect against accidentally
	// modifying the firewall policy for a firewall that is in use. When you create a
	// firewall, the operation initializes this setting to TRUE .
	FirewallPolicyChangeProtection bool

	// The number of VpcEndpointAssociation resources that use this firewall.
	NumberOfAssociations *int32

	// A setting indicating whether the firewall is protected against changes to the
	// subnet associations. Use this setting to protect against accidentally modifying
	// the subnet associations for a firewall that is in use. When you create a
	// firewall, the operation initializes this setting to TRUE .
	SubnetChangeProtection bool

	//
	Tags []Tag

	noSmithyDocumentSerde
}

// High-level information about a firewall, returned by operations like create and
// describe. You can use the information provided in the metadata to retrieve and
// manage a firewall.
type FirewallMetadata struct {

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	FirewallName *string

	noSmithyDocumentSerde
}

// The firewall policy defines the behavior of a firewall using a collection of
// stateless and stateful rule groups and other settings. You can use one firewall
// policy for multiple firewalls.
//
// This, along with FirewallPolicyResponse, define the policy. You can retrieve all objects for a
// firewall policy by calling DescribeFirewallPolicy.
type FirewallPolicy struct {

	// The actions to take on a packet if it doesn't match any of the stateless rules
	// in the policy. If you want non-matching packets to be forwarded for stateful
	// inspection, specify aws:forward_to_sfe .
	//
	// You must specify one of the standard actions: aws:pass , aws:drop , or
	// aws:forward_to_sfe . In addition, you can specify custom actions that are
	// compatible with your standard section choice.
	//
	// For example, you could specify ["aws:pass"] or you could specify ["aws:pass",
	// “customActionName”] . For information about compatibility, see the custom action
	// descriptions under CustomAction.
	//
	// This member is required.
	StatelessDefaultActions []string

	// The actions to take on a fragmented UDP packet if it doesn't match any of the
	// stateless rules in the policy. Network Firewall only manages UDP packet
	// fragments and silently drops packet fragments for other protocols. If you want
	// non-matching fragmented UDP packets to be forwarded for stateful inspection,
	// specify aws:forward_to_sfe .
	//
	// You must specify one of the standard actions: aws:pass , aws:drop , or
	// aws:forward_to_sfe . In addition, you can specify custom actions that are
	// compatible with your standard section choice.
	//
	// For example, you could specify ["aws:pass"] or you could specify ["aws:pass",
	// “customActionName”] . For information about compatibility, see the custom action
	// descriptions under CustomAction.
	//
	// This member is required.
	StatelessFragmentDefaultActions []string

	// Contains variables that you can use to override default Suricata settings in
	// your firewall policy.
	PolicyVariables *PolicyVariables

	// The default actions to take on a packet that doesn't match any stateful rules.
	// The stateful default action is optional, and is only valid when using the strict
	// rule order.
	//
	// Valid values of the stateful default action:
	//
	//   - aws:drop_strict
	//
	//   - aws:drop_established
	//
	//   - aws:alert_strict
	//
	//   - aws:alert_established
	//
	// For more information, see [Strict evaluation order] in the Network Firewall Developer Guide.
	//
	// [Strict evaluation order]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html
	StatefulDefaultActions []string

	// Additional options governing how Network Firewall handles stateful rules. The
	// stateful rule groups that you use in your policy must have stateful rule options
	// settings that are compatible with these settings.
	StatefulEngineOptions *StatefulEngineOptions

	// References to the stateful rule groups that are used in the policy. These
	// define the inspection criteria in stateful rules.
	StatefulRuleGroupReferences []StatefulRuleGroupReference

	// The custom action definitions that are available for use in the firewall
	// policy's StatelessDefaultActions setting. You name each custom action that you
	// define, and then you can use it by name in your default actions specifications.
	StatelessCustomActions []CustomAction

	// References to the stateless rule groups that are used in the policy. These
	// define the matching criteria in stateless rules.
	StatelessRuleGroupReferences []StatelessRuleGroupReference

	// The Amazon Resource Name (ARN) of the TLS inspection configuration.
	TLSInspectionConfigurationArn *string

	noSmithyDocumentSerde
}

// High-level information about a firewall policy, returned by operations like
// create and describe. You can use the information provided in the metadata to
// retrieve and manage a firewall policy. You can retrieve all objects for a
// firewall policy by calling DescribeFirewallPolicy.
type FirewallPolicyMetadata struct {

	// The Amazon Resource Name (ARN) of the firewall policy.
	Arn *string

	// The descriptive name of the firewall policy. You can't change the name of a
	// firewall policy after you create it.
	Name *string

	noSmithyDocumentSerde
}

// The high-level properties of a firewall policy. This, along with the FirewallPolicy, define
// the policy. You can retrieve all objects for a firewall policy by calling DescribeFirewallPolicy.
type FirewallPolicyResponse struct {

	// The Amazon Resource Name (ARN) of the firewall policy.
	//
	// If this response is for a create request that had DryRun set to TRUE , then this
	// ARN is a placeholder that isn't attached to a valid resource.
	//
	// This member is required.
	FirewallPolicyArn *string

	// The unique identifier for the firewall policy.
	//
	// This member is required.
	FirewallPolicyId *string

	// The descriptive name of the firewall policy. You can't change the name of a
	// firewall policy after you create it.
	//
	// This member is required.
	FirewallPolicyName *string

	// The number of capacity units currently consumed by the policy's stateful rules.
	ConsumedStatefulRuleCapacity *int32

	// The number of capacity units currently consumed by the policy's stateless rules.
	ConsumedStatelessRuleCapacity *int32

	// A description of the firewall policy.
	Description *string

	// A complex type that contains the Amazon Web Services KMS encryption
	// configuration settings for your firewall policy.
	EncryptionConfiguration *EncryptionConfiguration

	// The current status of the firewall policy. You can retrieve this for a firewall
	// policy by calling DescribeFirewallPolicyand providing the firewall policy's name or ARN.
	FirewallPolicyStatus ResourceStatus

	// The last time that the firewall policy was changed.
	LastModifiedTime *time.Time

	// The number of firewalls that are associated with this firewall policy.
	NumberOfAssociations *int32

	// The key:value pairs to associate with the resource.
	Tags []Tag

	noSmithyDocumentSerde
}

// Detailed information about the current status of a Firewall. You can retrieve this for
// a firewall by calling DescribeFirewalland providing the firewall name and ARN.
//
// The firewall status indicates a combined status. It indicates whether all
// subnets are up-to-date with the latest firewall configurations, which is based
// on the sync states config values, and also whether all subnets have their
// endpoints fully enabled, based on their sync states attachment values.
type FirewallStatus struct {

	// The configuration sync state for the firewall. This summarizes the Config
	// settings in the SyncStates for this firewall status object.
	//
	// When you create a firewall or update its configuration, for example by adding a
	// rule group to its firewall policy, Network Firewall distributes the
	// configuration changes to all Availability Zones that have subnets defined for
	// the firewall. This summary indicates whether the configuration changes have been
	// applied everywhere.
	//
	// This status must be IN_SYNC for the firewall to be ready for use, but it
	// doesn't indicate that the firewall is ready. The Status setting indicates
	// firewall readiness. It's based on this setting and the readiness of the firewall
	// endpoints to take traffic.
	//
	// This member is required.
	ConfigurationSyncStateSummary ConfigurationSyncState

	// The readiness of the configured firewall to handle network traffic across all
	// of the Availability Zones where you have it configured. This setting is READY
	// only when the ConfigurationSyncStateSummary value is IN_SYNC and the Attachment
	// Status values for all of the configured subnets are READY .
	//
	// This member is required.
	Status FirewallStatusValue

	// Describes the capacity usage of the resources contained in a firewall's
	// reference sets. Network Firewall calculates the capacity usage by taking an
	// aggregated count of all of the resources used by all of the reference sets in a
	// firewall.
	CapacityUsageSummary *CapacityUsageSummary

	// Status for the subnets that you've configured in the firewall. This contains
	// one array element per Availability Zone where you've configured a subnet in the
	// firewall.
	//
	// These objects provide detailed information for the settings
	// ConfigurationSyncStateSummary and Status .
	SyncStates map[string]SyncState

	noSmithyDocumentSerde
}

// Any number of arrays, where each array is a single flow identified in the scope
// of the operation. If multiple flows were in the scope of the operation, multiple
// Flows arrays are returned.
type Flow struct {

	// Returned as info about age of the flows identified by the flow operation.
	Age *int32

	// Returns the number of bytes received or transmitted in a specific flow.
	ByteCount int64

	// A single IP address specification. This is used in the MatchAttributes source and destination
	// specifications.
	DestinationAddress *Address

	// The destination port to inspect for. You can specify an individual port, for
	// example 1994 and you can specify a port range, for example 1990:1994 . To match
	// with any port, specify ANY .
	DestinationPort *string

	// Returns the total number of data packets received or transmitted in a flow.
	PacketCount *int32

	// The protocols to inspect for, specified using the assigned internet protocol
	// number (IANA) for each protocol. If not specified, this matches with any
	// protocol.
	Protocol *string

	// A single IP address specification. This is used in the MatchAttributes source and destination
	// specifications.
	SourceAddress *Address

	// The source port to inspect for. You can specify an individual port, for example
	// 1994 and you can specify a port range, for example 1990:1994 . To match with any
	// port, specify ANY .
	SourcePort *string

	noSmithyDocumentSerde
}

// Defines the scope a flow operation. You can use up to 20 filters to configure a
// single flow operation.
type FlowFilter struct {

	// A single IP address specification. This is used in the MatchAttributes source and destination
	// specifications.
	DestinationAddress *Address

	// The destination port to inspect for. You can specify an individual port, for
	// example 1994 and you can specify a port range, for example 1990:1994 . To match
	// with any port, specify ANY .
	DestinationPort *string

	// The protocols to inspect for, specified using the assigned internet protocol
	// number (IANA) for each protocol. If not specified, this matches with any
	// protocol.
	Protocols []string

	// A single IP address specification. This is used in the MatchAttributes source and destination
	// specifications.
	SourceAddress *Address

	// The source port to inspect for. You can specify an individual port, for example
	// 1994 and you can specify a port range, for example 1990:1994 . To match with any
	// port, specify ANY .
	SourcePort *string

	noSmithyDocumentSerde
}

// Contains information about a flow operation, such as related statuses, unique
// identifiers, and all filters defined in the operation.
//
// Flow operations let you manage the flows tracked in the flow table, also known
// as the firewall table.
//
// A flow is network traffic that is monitored by a firewall, either by stateful
// or stateless rules. For traffic to be considered part of a flow, it must share
// Destination, DestinationPort, Direction, Protocol, Source, and SourcePort.
type FlowOperation struct {

	// Defines the scope a flow operation. You can use up to 20 filters to configure a
	// single flow operation.
	FlowFilters []FlowFilter

	// The reqested FlowOperation ignores flows with an age (in seconds) lower than
	// MinimumFlowAgeInSeconds . You provide this for start commands.
	MinimumFlowAgeInSeconds *int32

	noSmithyDocumentSerde
}

// An array of objects with metadata about the requested FlowOperation .
type FlowOperationMetadata struct {

	// A unique identifier for the flow operation. This ID is returned in the
	// responses to start and list commands. You provide to describe commands.
	FlowOperationId *string

	// Returns the status of the flow operation. This string is returned in the
	// responses to start, list, and describe commands.
	//
	// If the status is COMPLETED_WITH_ERRORS , results may be returned with any number
	// of Flows missing from the response. If the status is FAILED , Flows returned
	// will be empty.
	FlowOperationStatus FlowOperationStatus

	// Defines the type of FlowOperation .
	FlowOperationType FlowOperationType

	// A timestamp indicating when the Suricata engine identified flows impacted by an
	// operation.
	FlowRequestTimestamp *time.Time

	noSmithyDocumentSerde
}

// Describes the amount of time that can pass without any traffic sent through the
// firewall before the firewall determines that the connection is idle and Network
// Firewall removes the flow entry from its flow table. Existing connections and
// flows are not impacted when you update this value. Only new connections after
// you update this value are impacted.
type FlowTimeouts struct {

	// The number of seconds that can pass without any TCP traffic sent through the
	// firewall before the firewall determines that the connection is idle. After the
	// idle timeout passes, data packets are dropped, however, the next TCP SYN packet
	// is considered a new flow and is processed by the firewall. Clients or targets
	// can use TCP keepalive packets to reset the idle timeout.
	//
	// You can define the TcpIdleTimeoutSeconds value to be between 60 and 6000
	// seconds. If no value is provided, it defaults to 350 seconds.
	TcpIdleTimeoutSeconds *int32

	noSmithyDocumentSerde
}

// The basic rule criteria for Network Firewall to use to inspect packet headers
// in stateful traffic flow inspection. Traffic flows that match the criteria are a
// match for the corresponding StatefulRule.
type Header struct {

	// The destination IP address or address range to inspect for, in CIDR notation.
	// To match with any address, specify ANY .
	//
	// Specify an IP address or a block of IP addresses in Classless Inter-Domain
	// Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4
	// and IPv6.
	//
	// Examples:
	//
	//   - To configure Network Firewall to inspect for the IP address 192.0.2.44,
	//   specify 192.0.2.44/32 .
	//
	//   - To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to
	//   192.0.2.255, specify 192.0.2.0/24 .
	//
	//   - To configure Network Firewall to inspect for the IP address
	//   1111:0000:0000:0000:0000:0000:0000:0111, specify
	//   1111:0000:0000:0000:0000:0000:0000:0111/128 .
	//
	//   - To configure Network Firewall to inspect for IP addresses from
	//   1111:0000:0000:0000:0000:0000:0000:0000 to
	//   1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
	//   1111:0000:0000:0000:0000:0000:0000:0000/64 .
	//
	// For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing].
	//
	// [Classless Inter-Domain Routing]: https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing
	//
	// This member is required.
	Destination *string

	// The destination port to inspect for. You can specify an individual port, for
	// example 1994 and you can specify a port range, for example 1990:1994 . To match
	// with any port, specify ANY .
	//
	// This member is required.
	DestinationPort *string

	// The direction of traffic flow to inspect. If set to ANY , the inspection matches
	// bidirectional traffic, both from the source to the destination and from the
	// destination to the source. If set to FORWARD , the inspection only matches
	// traffic going from the source to the destination.
	//
	// This member is required.
	Direction StatefulRuleDirection

	// The protocol to inspect for. To specify all, you can use IP , because all
	// traffic on Amazon Web Services and on the internet is IP.
	//
	// This member is required.
	Protocol StatefulRuleProtocol

	// The source IP address or address range to inspect for, in CIDR notation. To
	// match with any address, specify ANY .
	//
	// Specify an IP address or a block of IP addresses in Classless Inter-Domain
	// Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4
	// and IPv6.
	//
	// Examples:
	//
	//   - To configure Network Firewall to inspect for the IP address 192.0.2.44,
	//   specify 192.0.2.44/32 .
	//
	//   - To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to
	//   192.0.2.255, specify 192.0.2.0/24 .
	//
	//   - To configure Network Firewall to inspect for the IP address
	//   1111:0000:0000:0000:0000:0000:0000:0111, specify
	//   1111:0000:0000:0000:0000:0000:0000:0111/128 .
	//
	//   - To configure Network Firewall to inspect for IP addresses from
	//   1111:0000:0000:0000:0000:0000:0000:0000 to
	//   1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
	//   1111:0000:0000:0000:0000:0000:0000:0000/64 .
	//
	// For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing].
	//
	// [Classless Inter-Domain Routing]: https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing
	//
	// This member is required.
	Source *string

	// The source port to inspect for. You can specify an individual port, for example
	// 1994 and you can specify a port range, for example 1990:1994 . To match with any
	// port, specify ANY .
	//
	// This member is required.
	SourcePort *string

	noSmithyDocumentSerde
}

// Attempts made to a access domain.
type Hits struct {

	// The number of attempts made to access a domain.
	Count int32

	noSmithyDocumentSerde
}

// A list of IP addresses and address ranges, in CIDR notation. This is part of a RuleVariables
// .
type IPSet struct {

	// The list of IP addresses and address ranges, in CIDR notation.
	//
	// This member is required.
	Definition []string

	noSmithyDocumentSerde
}

// General information about the IP set.
type IPSetMetadata struct {

	// Describes the total number of CIDR blocks currently in use by the IP set
	// references in a firewall. To determine how many CIDR blocks are available for
	// you to use in a firewall, you can call AvailableCIDRCount .
	ResolvedCIDRCount *int32

	noSmithyDocumentSerde
}

// Configures one or more IP set references for a Suricata-compatible rule group.
// This is used in CreateRuleGroupor UpdateRuleGroup. An IP set reference is a rule variable that references
// resources that you create and manage in another Amazon Web Services service,
// such as an Amazon VPC prefix list. Network Firewall IP set references enable you
// to dynamically update the contents of your rules. When you create, update, or
// delete the resource you are referencing in your rule, Network Firewall
// automatically updates the rule's content with the changes. For more information
// about IP set references in Network Firewall, see [Using IP set references]in the Network Firewall
// Developer Guide.
//
// Network Firewall currently supports [Amazon VPC prefix lists] and [resource groups] in IP set references.
//
// [Using IP set references]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references
// [Amazon VPC prefix lists]: https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html
// [resource groups]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references.html#rule-groups-referencing-resource-groups
type IPSetReference struct {

	// The Amazon Resource Name (ARN) of the resource that you are referencing in your
	// rule group.
	ReferenceArn *string

	noSmithyDocumentSerde
}

// Defines where Network Firewall sends logs for the firewall for one log type.
// This is used in LoggingConfiguration. You can send each type of log to an Amazon S3 bucket, a
// CloudWatch log group, or a Firehose delivery stream.
//
// Network Firewall generates logs for stateful rule groups. You can save alert,
// flow, and TLS log types.
type LogDestinationConfig struct {

	// The named location for the logs, provided in a key:value mapping that is
	// specific to the chosen destination type.
	//
	//   - For an Amazon S3 bucket, provide the name of the bucket, with key bucketName
	//   , and optionally provide a prefix, with key prefix .
	//
	// The following example specifies an Amazon S3 bucket named DOC-EXAMPLE-BUCKET and
	//   the prefix alerts :
	//
	// "LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix": "alerts" }
	//
	//   - For a CloudWatch log group, provide the name of the CloudWatch log group,
	//   with key logGroup . The following example specifies a log group named
	//   alert-log-group :
	//
	// "LogDestination": { "logGroup": "alert-log-group" }
	//
	//   - For a Firehose delivery stream, provide the name of the delivery stream,
	//   with key deliveryStream . The following example specifies a delivery stream
	//   named alert-delivery-stream :
	//
	// "LogDestination": { "deliveryStream": "alert-delivery-stream" }
	//
	// This member is required.
	LogDestination map[string]string

	// The type of storage destination to send these logs to. You can send logs to an
	// Amazon S3 bucket, a CloudWatch log group, or a Firehose delivery stream.
	//
	// This member is required.
	LogDestinationType LogDestinationType

	// The type of log to record. You can record the following types of logs from your
	// Network Firewall stateful engine.
	//
	//   - ALERT - Logs for traffic that matches your stateful rules and that have an
	//   action that sends an alert. A stateful rule sends alerts for the rule actions
	//   DROP, ALERT, and REJECT. For more information, see StatefulRule.
	//
	//   - FLOW - Standard network traffic flow logs. The stateful rules engine records
	//   flow logs for all network traffic that it receives. Each flow log record
	//   captures the network flow for a specific standard stateless rule group.
	//
	//   - TLS - Logs for events that are related to TLS inspection. For more
	//   information, see [Inspecting SSL/TLS traffic with TLS inspection configurations]in the Network Firewall Developer Guide.
	//
	// [Inspecting SSL/TLS traffic with TLS inspection configurations]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-configurations.html
	//
	// This member is required.
	LogType LogType

	noSmithyDocumentSerde
}

// Defines how Network Firewall performs logging for a Firewall.
type LoggingConfiguration struct {

	// Defines the logging destinations for the logs for a firewall. Network Firewall
	// generates logs for stateful rule groups.
	//
	// This member is required.
	LogDestinationConfigs []LogDestinationConfig

	noSmithyDocumentSerde
}

// Criteria for Network Firewall to use to inspect an individual packet in
// stateless rule inspection. Each match attributes set can include one or more
// items such as IP address, CIDR range, port number, protocol, and TCP flags.
type MatchAttributes struct {

	// The destination port to inspect for. You can specify an individual port, for
	// example 1994 and you can specify a port range, for example 1990:1994 . To match
	// with any port, specify ANY .
	//
	// This setting is only used for protocols 6 (TCP) and 17 (UDP).
	DestinationPorts []PortRange

	// The destination IP addresses and address ranges to inspect for, in CIDR
	// notation. If not specified, this matches with any destination address.
	Destinations []Address

	// The protocols to inspect for, specified using the assigned internet protocol
	// number (IANA) for each protocol. If not specified, this matches with any
	// protocol.
	Protocols []int32

	// The source port to inspect for. You can specify an individual port, for example
	// 1994 and you can specify a port range, for example 1990:1994 . To match with any
	// port, specify ANY .
	//
	// If not specified, this matches with any source port.
	//
	// This setting is only used for protocols 6 (TCP) and 17 (UDP).
	SourcePorts []PortRange

	// The source IP addresses and address ranges to inspect for, in CIDR notation. If
	// not specified, this matches with any source address.
	Sources []Address

	// The TCP flags and masks to inspect for. If not specified, this matches with any
	// settings. This setting is only used for protocol 6 (TCP).
	TCPFlags []TCPFlagField

	noSmithyDocumentSerde
}

// Provides configuration status for a single policy or rule group that is used
// for a firewall endpoint. Network Firewall provides each endpoint with the rules
// that are configured in the firewall policy. Each time you add a subnet or modify
// the associated firewall policy, Network Firewall synchronizes the rules in the
// endpoint, so it can properly filter network traffic. This is part of a SyncStatefor a
// firewall.
type PerObjectStatus struct {

	// Indicates whether this object is in sync with the version indicated in the
	// update token.
	SyncStatus PerObjectSyncStatus

	// The current version of the object that is either in sync or pending
	// synchronization.
	UpdateToken *string

	noSmithyDocumentSerde
}

// Contains variables that you can use to override default Suricata settings in
// your firewall policy.
type PolicyVariables struct {

	// The IPv4 or IPv6 addresses in CIDR notation to use for the Suricata HOME_NET
	// variable. If your firewall uses an inspection VPC, you might want to override
	// the HOME_NET variable with the CIDRs of your home networks. If you don't
	// override HOME_NET with your own CIDRs, Network Firewall by default uses the
	// CIDR of your inspection VPC.
	RuleVariables map[string]IPSet

	noSmithyDocumentSerde
}

// A single port range specification. This is used for source and destination port
// ranges in the stateless rule MatchAttributes, SourcePorts , and DestinationPorts settings.
type PortRange struct {

	// The lower limit of the port range. This must be less than or equal to the ToPort
	// specification.
	//
	// This member is required.
	FromPort int32

	// The upper limit of the port range. This must be greater than or equal to the
	// FromPort specification.
	//
	// This member is required.
	ToPort int32

	noSmithyDocumentSerde
}

// A set of port ranges for use in the rules in a rule group.
type PortSet struct {

	// The set of port ranges.
	Definition []string

	noSmithyDocumentSerde
}

// Stateless inspection criteria that publishes the specified metrics to Amazon
// CloudWatch for the matching packet. This setting defines a CloudWatch dimension
// value to be published.
type PublishMetricAction struct {

	//
	//
	// This member is required.
	Dimensions []Dimension

	noSmithyDocumentSerde
}

// Contains a set of IP set references.
type ReferenceSets struct {

	// The list of IP set references.
	IPSetReferences map[string]IPSetReference

	noSmithyDocumentSerde
}

// The inspection criteria and action for a single stateless rule. Network
// Firewall inspects each packet for the specified matching criteria. When a packet
// matches the criteria, Network Firewall performs the rule's actions on the
// packet.
type RuleDefinition struct {

	// The actions to take on a packet that matches one of the stateless rule
	// definition's match attributes. You must specify a standard action and you can
	// add custom actions.
	//
	// Network Firewall only forwards a packet for stateful rule inspection if you
	// specify aws:forward_to_sfe for a rule that the packet matches, or if the packet
	// doesn't match any stateless rule and you specify aws:forward_to_sfe for the
	// StatelessDefaultActions setting for the FirewallPolicy.
	//
	// For every rule, you must specify exactly one of the following standard actions.
	//
	//   - aws:pass - Discontinues all inspection of the packet and permits it to go
	//   to its intended destination.
	//
	//   - aws:drop - Discontinues all inspection of the packet and blocks it from
	//   going to its intended destination.
	//
	//   - aws:forward_to_sfe - Discontinues stateless inspection of the packet and
	//   forwards it to the stateful rule engine for inspection.
	//
	// Additionally, you can specify a custom action. To do this, you define a custom
	// action by name and type, then provide the name you've assigned to the action in
	// this Actions setting. For information about the options, see CustomAction.
	//
	// To provide more than one action in this setting, separate the settings with a
	// comma. For example, if you have a custom PublishMetrics action that you've
	// named MyMetricsAction , then you could specify the standard action aws:pass and
	// the custom action with [“aws:pass”, “MyMetricsAction”] .
	//
	// This member is required.
	Actions []string

	// Criteria for Network Firewall to use to inspect an individual packet in
	// stateless rule inspection. Each match attributes set can include one or more
	// items such as IP address, CIDR range, port number, protocol, and TCP flags.
	//
	// This member is required.
	MatchAttributes *MatchAttributes

	noSmithyDocumentSerde
}

// The object that defines the rules in a rule group. This, along with RuleGroupResponse, define
// the rule group. You can retrieve all objects for a rule group by calling DescribeRuleGroup.
//
// Network Firewall uses a rule group to inspect and control network traffic. You
// define stateless rule groups to inspect individual packets and you define
// stateful rule groups to inspect packets in the context of their traffic flow.
//
// To use a rule group, you include it by reference in an Network Firewall
// firewall policy, then you use the policy in a firewall. You can reference a rule
// group from more than one firewall policy, and you can use a firewall policy in
// more than one firewall.
type RuleGroup struct {

	// The stateful rules or stateless rules for the rule group.
	//
	// This member is required.
	RulesSource *RulesSource

	// The list of a rule group's reference sets.
	ReferenceSets *ReferenceSets

	// Settings that are available for use in the rules in the rule group. You can
	// only use these for stateful rule groups.
	RuleVariables *RuleVariables

	// Additional options governing how Network Firewall handles stateful rules. The
	// policies where you use your stateful rule group must have stateful rule options
	// settings that are compatible with these settings. Some limitations apply; for
	// more information, see [Strict evaluation order]in the Network Firewall Developer Guide.
	//
	// [Strict evaluation order]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-limitations-caveats.html
	StatefulRuleOptions *StatefulRuleOptions

	noSmithyDocumentSerde
}

// High-level information about a rule group, returned by ListRuleGroups. You can use the
// information provided in the metadata to retrieve and manage a rule group.
type RuleGroupMetadata struct {

	// The Amazon Resource Name (ARN) of the rule group.
	Arn *string

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	Name *string

	noSmithyDocumentSerde
}

// The high-level properties of a rule group. This, along with the RuleGroup, define the
// rule group. You can retrieve all objects for a rule group by calling DescribeRuleGroup.
type RuleGroupResponse struct {

	// The Amazon Resource Name (ARN) of the rule group.
	//
	// If this response is for a create request that had DryRun set to TRUE , then this
	// ARN is a placeholder that isn't attached to a valid resource.
	//
	// This member is required.
	RuleGroupArn *string

	// The unique identifier for the rule group.
	//
	// This member is required.
	RuleGroupId *string

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// This member is required.
	RuleGroupName *string

	// The list of analysis results for AnalyzeRuleGroup . If you set AnalyzeRuleGroup
	// to TRUE in CreateRuleGroup, UpdateRuleGroup, or DescribeRuleGroup, Network Firewall analyzes the rule group and identifies the
	// rules that might adversely effect your firewall's functionality. For example, if
	// Network Firewall detects a rule that's routing traffic asymmetrically, which
	// impacts the service's ability to properly process traffic, the service includes
	// the rule in the list of analysis results.
	AnalysisResults []AnalysisResult

	// The maximum operating resources that this rule group can use. Rule group
	// capacity is fixed at creation. When you update a rule group, you are limited to
	// this capacity. When you reference a rule group from a firewall policy, Network
	// Firewall reserves this capacity for the rule group.
	//
	// You can retrieve the capacity that would be required for a rule group before
	// you create the rule group by calling CreateRuleGroupwith DryRun set to TRUE .
	Capacity *int32

	// The number of capacity units currently consumed by the rule group rules.
	ConsumedCapacity *int32

	// A description of the rule group.
	Description *string

	// A complex type that contains the Amazon Web Services KMS encryption
	// configuration settings for your rule group.
	EncryptionConfiguration *EncryptionConfiguration

	// The last time that the rule group was changed.
	LastModifiedTime *time.Time

	// The number of firewall policies that use this rule group.
	NumberOfAssociations *int32

	// Detailed information about the current status of a rule group.
	RuleGroupStatus ResourceStatus

	// The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS
	// topic that's used to record changes to the managed rule group. You can subscribe
	// to the SNS topic to receive notifications when the managed rule group is
	// modified, such as for new versions and for version expiration. For more
	// information, see the [Amazon Simple Notification Service Developer Guide.].
	//
	// [Amazon Simple Notification Service Developer Guide.]: https://docs.aws.amazon.com/sns/latest/dg/welcome.html
	SnsTopic *string

	// A complex type that contains metadata about the rule group that your own rule
	// group is copied from. You can use the metadata to track the version updates made
	// to the originating rule group.
	SourceMetadata *SourceMetadata

	// The key:value pairs to associate with the resource.
	Tags []Tag

	// Indicates whether the rule group is stateless or stateful. If the rule group is
	// stateless, it contains stateless rules. If it is stateful, it contains stateful
	// rules.
	Type RuleGroupType

	noSmithyDocumentSerde
}

// Additional settings for a stateful rule. This is part of the StatefulRule configuration.
type RuleOption struct {

	// The keyword for the Suricata compatible rule option. You must include a sid
	// (signature ID), and can optionally include other keywords. For information about
	// Suricata compatible keywords, see [Rule options]in the Suricata documentation.
	//
	// [Rule options]: https://suricata.readthedocs.io/en/suricata-7.0.3/rules/intro.html#rule-options
	//
	// This member is required.
	Keyword *string

	// The settings of the Suricata compatible rule option. Rule options have zero or
	// more setting values, and the number of possible and required settings depends on
	// the Keyword . For more information about the settings for specific options, see [Rule options]
	// .
	//
	// [Rule options]: https://suricata.readthedocs.io/en/suricata-7.0.3/rules/intro.html#rule-options
	Settings []string

	noSmithyDocumentSerde
}

// The stateless or stateful rules definitions for use in a single rule group.
// Each rule group requires a single RulesSource . You can use an instance of this
// for either stateless rules or stateful rules.
type RulesSource struct {

	// Stateful inspection criteria for a domain list rule group.
	RulesSourceList *RulesSourceList

	// Stateful inspection criteria, provided in Suricata compatible rules. Suricata
	// is an open-source threat detection framework that includes a standard rule-based
	// language for network traffic inspection.
	//
	// These rules contain the inspection criteria and the action to take for traffic
	// that matches the criteria, so this type of rule group doesn't have a separate
	// action setting.
	//
	// You can't use the priority keyword if the RuleOrder option in StatefulRuleOptions is set to
	// STRICT_ORDER .
	RulesString *string

	// An array of individual stateful rules inspection criteria to be used together
	// in a stateful rule group. Use this option to specify simple Suricata rules with
	// protocol, source and destination, ports, direction, and rule options. For
	// information about the Suricata Rules format, see [Rules Format].
	//
	// [Rules Format]: https://suricata.readthedocs.io/en/suricata-7.0.3/rules/intro.html
	StatefulRules []StatefulRule

	// Stateless inspection criteria to be used in a stateless rule group.
	StatelessRulesAndCustomActions *StatelessRulesAndCustomActions

	noSmithyDocumentSerde
}

// Stateful inspection criteria for a domain list rule group.
//
// For HTTPS traffic, domain filtering is SNI-based. It uses the server name
// indicator extension of the TLS handshake.
//
// By default, Network Firewall domain list inspection only includes traffic
// coming from the VPC where you deploy the firewall. To inspect traffic from IP
// addresses outside of the deployment VPC, you set the HOME_NET rule variable to
// include the CIDR range of the deployment VPC plus the other CIDR ranges. For
// more information, see RuleVariablesin this guide and [Stateful domain list rule groups in Network Firewall] in the Network Firewall Developer
// Guide.
//
// [Stateful domain list rule groups in Network Firewall]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/stateful-rule-groups-domain-names.html
type RulesSourceList struct {

	// Whether you want to allow or deny access to the domains in your target list.
	//
	// This member is required.
	GeneratedRulesType GeneratedRulesType

	// The protocols you want to inspect. Specify TLS_SNI for HTTPS . Specify HTTP_HOST
	// for HTTP . You can specify either or both.
	//
	// This member is required.
	TargetTypes []TargetType

	// The domains that you want to inspect for in your traffic flows. Valid domain
	// specifications are the following:
	//
	//   - Explicit names. For example, abc.example.com matches only the domain
	//   abc.example.com .
	//
	//   - Names that use a domain wildcard, which you indicate with an initial ' . '.
	//   For example, .example.com matches example.com and matches all subdomains of
	//   example.com , such as abc.example.com and www.example.com .
	//
	// This member is required.
	Targets []string

	noSmithyDocumentSerde
}

// Settings that are available for use in the rules in the RuleGroup where this is defined.
type RuleVariables struct {

	// A list of IP addresses and address ranges, in CIDR notation.
	IPSets map[string]IPSet

	// A list of port ranges.
	PortSets map[string]PortSet

	noSmithyDocumentSerde
}

// Any Certificate Manager (ACM) Secure Sockets Layer/Transport Layer Security
// (SSL/TLS) server certificate that's associated with a ServerCertificateConfiguration. Used in a TLSInspectionConfiguration for
// inspection of inbound traffic to your firewall. You must request or import a
// SSL/TLS certificate into ACM for each domain Network Firewall needs to decrypt
// and inspect. Network Firewall uses the SSL/TLS certificates to decrypt specified
// inbound SSL/TLS traffic going to your firewall. For information about working
// with certificates in Certificate Manager, see [Request a public certificate]or [Importing certificates] in the Certificate Manager
// User Guide.
//
// [Request a public certificate]: https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html
// [Importing certificates]: https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html
type ServerCertificate struct {

	// The Amazon Resource Name (ARN) of the Certificate Manager SSL/TLS server
	// certificate that's used for inbound SSL/TLS inspection.
	ResourceArn *string

	noSmithyDocumentSerde
}

// Configures the Certificate Manager certificates and scope that Network Firewall
// uses to decrypt and re-encrypt traffic using a TLSInspectionConfiguration. You can configure
// ServerCertificates for inbound SSL/TLS inspection, a CertificateAuthorityArn
// for outbound SSL/TLS inspection, or both. For information about working with
// certificates for TLS inspection, see [Using SSL/TLS server certficiates with TLS inspection configurations]in the Network Firewall Developer Guide.
//
// If a server certificate that's associated with your TLSInspectionConfiguration is revoked, deleted, or
// expired it can result in client-side TLS errors.
//
// [Using SSL/TLS server certficiates with TLS inspection configurations]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html
type ServerCertificateConfiguration struct {

	// The Amazon Resource Name (ARN) of the imported certificate authority (CA)
	// certificate within Certificate Manager (ACM) to use for outbound SSL/TLS
	// inspection.
	//
	// The following limitations apply:
	//
	//   - You can use CA certificates that you imported into ACM, but you can't
	//   generate CA certificates with ACM.
	//
	//   - You can't use certificates issued by Private Certificate Authority.
	//
	// For more information about configuring certificates for outbound inspection,
	// see [Using SSL/TLS certificates with certificates with TLS inspection configurations]in the Network Firewall Developer Guide.
	//
	// For information about working with certificates in ACM, see [Importing certificates] in the Certificate
	// Manager User Guide.
	//
	// [Importing certificates]: https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html
	// [Using SSL/TLS certificates with certificates with TLS inspection configurations]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html
	CertificateAuthorityArn *string

	// When enabled, Network Firewall checks if the server certificate presented by
	// the server in the SSL/TLS connection has a revoked or unkown status. If the
	// certificate has an unknown or revoked status, you must specify the actions that
	// Network Firewall takes on outbound traffic. To check the certificate revocation
	// status, you must also specify a CertificateAuthorityArn in ServerCertificateConfiguration.
	CheckCertificateRevocationStatus *CheckCertificateRevocationStatusActions

	// A list of scopes.
	Scopes []ServerCertificateScope

	// The list of server certificates to use for inbound SSL/TLS inspection.
	ServerCertificates []ServerCertificate

	noSmithyDocumentSerde
}

// Settings that define the Secure Sockets Layer/Transport Layer Security
// (SSL/TLS) traffic that Network Firewall should decrypt for inspection by the
// stateful rule engine.
type ServerCertificateScope struct {

	// The destination ports to decrypt for inspection, in Transmission Control
	// Protocol (TCP) format. If not specified, this matches with any destination port.
	//
	// You can specify individual ports, for example 1994 , and you can specify port
	// ranges, such as 1990:1994 .
	DestinationPorts []PortRange

	// The destination IP addresses and address ranges to decrypt for inspection, in
	// CIDR notation. If not specified, this matches with any destination address.
	Destinations []Address

	// The protocols to inspect for, specified using the assigned internet protocol
	// number (IANA) for each protocol. If not specified, this matches with any
	// protocol.
	//
	// Network Firewall currently supports only TCP.
	Protocols []int32

	// The source ports to decrypt for inspection, in Transmission Control Protocol
	// (TCP) format. If not specified, this matches with any source port.
	//
	// You can specify individual ports, for example 1994 , and you can specify port
	// ranges, such as 1990:1994 .
	SourcePorts []PortRange

	// The source IP addresses and address ranges to decrypt for inspection, in CIDR
	// notation. If not specified, this matches with any source address.
	Sources []Address

	noSmithyDocumentSerde
}

// High-level information about the managed rule group that your own rule group is
// copied from. You can use the the metadata to track version updates made to the
// originating rule group. You can retrieve all objects for a rule group by calling
// [DescribeRuleGroup].
//
// [DescribeRuleGroup]: https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html
type SourceMetadata struct {

	// The Amazon Resource Name (ARN) of the rule group that your own rule group is
	// copied from.
	SourceArn *string

	// The update token of the Amazon Web Services managed rule group that your own
	// rule group is copied from. To determine the update token for the managed rule
	// group, call [DescribeRuleGroup].
	//
	// [DescribeRuleGroup]: https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html#networkfirewall-DescribeRuleGroup-response-UpdateToken
	SourceUpdateToken *string

	noSmithyDocumentSerde
}

// Configuration settings for the handling of the stateful rule groups in a
// firewall policy.
type StatefulEngineOptions struct {

	// Configures the amount of time that can pass without any traffic sent through
	// the firewall before the firewall determines that the connection is idle.
	FlowTimeouts *FlowTimeouts

	// Indicates how to manage the order of stateful rule evaluation for the policy.
	// STRICT_ORDER is the default and recommended option. With STRICT_ORDER , provide
	// your rules in the order that you want them to be evaluated. You can then choose
	// one or more default actions for packets that don't match any rules. Choose
	// STRICT_ORDER to have the stateful rules engine determine the evaluation order of
	// your rules. The default action for this rule order is PASS , followed by DROP ,
	// REJECT , and ALERT actions. Stateful rules are provided to the rule engine as
	// Suricata compatible strings, and Suricata evaluates them based on your settings.
	// For more information, see [Evaluation order for stateful rules]in the Network Firewall Developer Guide.
	//
	// [Evaluation order for stateful rules]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html
	RuleOrder RuleOrder

	// Configures how Network Firewall processes traffic when a network connection
	// breaks midstream. Network connections can break due to disruptions in external
	// networks or within the firewall itself.
	//
	//   - DROP - Network Firewall fails closed and drops all subsequent traffic going
	//   to the firewall. This is the default behavior.
	//
	//   - CONTINUE - Network Firewall continues to apply rules to the subsequent
	//   traffic without context from traffic before the break. This impacts the behavior
	//   of rules that depend on this context. For example, if you have a stateful rule
	//   to drop http traffic, Network Firewall won't match the traffic for this rule
	//   because the service won't have the context from session initialization defining
	//   the application layer protocol as HTTP. However, this behavior is rule
	//   dependent—a TCP-layer rule using a flow:stateless rule would still match, as
	//   would the aws:drop_strict default action.
	//
	//   - REJECT - Network Firewall fails closed and drops all subsequent traffic
	//   going to the firewall. Network Firewall also sends a TCP reject packet back to
	//   your client so that the client can immediately establish a new session. Network
	//   Firewall will have context about the new session and will apply rules to the
	//   subsequent traffic.
	StreamExceptionPolicy StreamExceptionPolicy

	noSmithyDocumentSerde
}

// A single Suricata rules specification, for use in a stateful rule group. Use
// this option to specify a simple Suricata rule with protocol, source and
// destination, ports, direction, and rule options. For information about the
// Suricata Rules format, see [Rules Format].
//
// [Rules Format]: https://suricata.readthedocs.io/en/suricata-7.0.3/rules/intro.html
type StatefulRule struct {

	// Defines what Network Firewall should do with the packets in a traffic flow when
	// the flow matches the stateful rule criteria. For all actions, Network Firewall
	// performs the specified action and discontinues stateful inspection of the
	// traffic flow.
	//
	// The actions for a stateful rule are defined as follows:
	//
	//   - PASS - Permits the packets to go to the intended destination.
	//
	//   - DROP - Blocks the packets from going to the intended destination and sends
	//   an alert log message, if alert logging is configured in the FirewallLoggingConfiguration.
	//
	//   - ALERT - Sends an alert log message, if alert logging is configured in the FirewallLoggingConfiguration.
	//
	// You can use this action to test a rule that you intend to use to drop traffic.
	//   You can enable the rule with ALERT action, verify in the logs that the rule is
	//   filtering as you want, then change the action to DROP .
	//
	//   - REJECT - Drops traffic that matches the conditions of the stateful rule,
	//   and sends a TCP reset packet back to sender of the packet. A TCP reset packet is
	//   a packet with no payload and an RST bit contained in the TCP header flags.
	//   REJECT is available only for TCP traffic. This option doesn't support FTP or
	//   IMAP protocols.
	//
	// This member is required.
	Action StatefulAction

	// The stateful inspection criteria for this rule, used to inspect traffic flows.
	//
	// This member is required.
	Header *Header

	// Additional options for the rule. These are the Suricata RuleOptions settings.
	//
	// This member is required.
	RuleOptions []RuleOption

	noSmithyDocumentSerde
}

// The setting that allows the policy owner to change the behavior of the rule
// group within a policy.
type StatefulRuleGroupOverride struct {

	// The action that changes the rule group from DROP to ALERT . This only applies to
	// managed rule groups.
	Action OverrideAction

	noSmithyDocumentSerde
}

// Identifier for a single stateful rule group, used in a firewall policy to refer
// to a rule group.
type StatefulRuleGroupReference struct {

	// The Amazon Resource Name (ARN) of the stateful rule group.
	//
	// This member is required.
	ResourceArn *string

	// The action that allows the policy owner to override the behavior of the rule
	// group within a policy.
	Override *StatefulRuleGroupOverride

	// An integer setting that indicates the order in which to run the stateful rule
	// groups in a single FirewallPolicy. This setting only applies to firewall policies that
	// specify the STRICT_ORDER rule order in the stateful engine options settings.
	//
	// Network Firewall evalutes each stateful rule group against a packet starting
	// with the group that has the lowest priority setting. You must ensure that the
	// priority settings are unique within each policy.
	//
	// You can change the priority settings of your rule groups at any time. To make
	// it easier to insert rule groups later, number them so there's a wide range in
	// between, for example use 100, 200, and so on.
	Priority *int32

	noSmithyDocumentSerde
}

// Additional options governing how Network Firewall handles the rule group. You
// can only use these for stateful rule groups.
type StatefulRuleOptions struct {

	// Indicates how to manage the order of the rule evaluation for the rule group.
	// DEFAULT_ACTION_ORDER is the default behavior. Stateful rules are provided to the
	// rule engine as Suricata compatible strings, and Suricata evaluates them based on
	// certain settings. For more information, see [Evaluation order for stateful rules]in the Network Firewall Developer
	// Guide.
	//
	// [Evaluation order for stateful rules]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html
	RuleOrder RuleOrder

	noSmithyDocumentSerde
}

// A single stateless rule. This is used in StatelessRulesAndCustomActions.
type StatelessRule struct {

	// Indicates the order in which to run this rule relative to all of the rules that
	// are defined for a stateless rule group. Network Firewall evaluates the rules in
	// a rule group starting with the lowest priority setting. You must ensure that the
	// priority settings are unique for the rule group.
	//
	// Each stateless rule group uses exactly one StatelessRulesAndCustomActions
	// object, and each StatelessRulesAndCustomActions contains exactly one
	// StatelessRules object. To ensure unique priority settings for your rule groups,
	// set unique priorities for the stateless rules that you define inside any single
	// StatelessRules object.
	//
	// You can change the priority settings of your rules at any time. To make it
	// easier to insert rules later, number them so there's a wide range in between,
	// for example use 100, 200, and so on.
	//
	// This member is required.
	Priority *int32

	// Defines the stateless 5-tuple packet inspection criteria and the action to take
	// on a packet that matches the criteria.
	//
	// This member is required.
	RuleDefinition *RuleDefinition

	noSmithyDocumentSerde
}

// Identifier for a single stateless rule group, used in a firewall policy to
// refer to the rule group.
type StatelessRuleGroupReference struct {

	// An integer setting that indicates the order in which to run the stateless rule
	// groups in a single FirewallPolicy. Network Firewall applies each stateless rule group to a
	// packet starting with the group that has the lowest priority setting. You must
	// ensure that the priority settings are unique within each policy.
	//
	// This member is required.
	Priority *int32

	// The Amazon Resource Name (ARN) of the stateless rule group.
	//
	// This member is required.
	ResourceArn *string

	noSmithyDocumentSerde
}

// Stateless inspection criteria. Each stateless rule group uses exactly one of
// these data types to define its stateless rules.
type StatelessRulesAndCustomActions struct {

	// Defines the set of stateless rules for use in a stateless rule group.
	//
	// This member is required.
	StatelessRules []StatelessRule

	// Defines an array of individual custom action definitions that are available for
	// use by the stateless rules in this StatelessRulesAndCustomActions
	// specification. You name each custom action that you define, and then you can use
	// it by name in your StatelessRuleRuleDefinitionActions specification.
	CustomActions []CustomAction

	noSmithyDocumentSerde
}

// The ID for a subnet that's used in an association with a firewall. This is used
// in CreateFirewall, AssociateSubnets, and CreateVpcEndpointAssociation. Network Firewall creates an instance of the associated firewall in
// each subnet that you specify, to filter traffic in the subnet's Availability
// Zone.
type SubnetMapping struct {

	// The unique identifier for the subnet.
	//
	// This member is required.
	SubnetId *string

	// The subnet's IP address type. You can't change the IP address type after you
	// create the subnet.
	IPAddressType IPAddressType

	noSmithyDocumentSerde
}

// The status of the firewall endpoint and firewall policy configuration for a
// single VPC subnet. This is part of the FirewallStatus.
//
// For each VPC subnet that you associate with a firewall, Network Firewall does
// the following:
//
//   - Instantiates a firewall endpoint in the subnet, ready to take traffic.
//
//   - Configures the endpoint with the current firewall policy settings, to
//     provide the filtering behavior for the endpoint.
//
// When you update a firewall, for example to add a subnet association or change a
// rule group in the firewall policy, the affected sync states reflect out-of-sync
// or not ready status until the changes are complete.
type SyncState struct {

	// The configuration and status for a single firewall subnet. For each configured
	// subnet, Network Firewall creates the attachment by instantiating the firewall
	// endpoint in the subnet so that it's ready to take traffic.
	Attachment *Attachment

	// The configuration status of the firewall endpoint in a single VPC subnet.
	// Network Firewall provides each endpoint with the rules that are configured in
	// the firewall policy. Each time you add a subnet or modify the associated
	// firewall policy, Network Firewall synchronizes the rules in the endpoint, so it
	// can properly filter network traffic.
	Config map[string]PerObjectStatus

	noSmithyDocumentSerde
}

// A key:value pair associated with an Amazon Web Services resource. The key:value
// pair can be anything you define. Typically, the tag key represents a category
// (such as "environment") and the tag value represents a specific value within
// that category (such as "test," "development," or "production"). You can add up
// to 50 tags to each Amazon Web Services resource.
type Tag struct {

	// The part of the key:value pair that defines a tag. You can use a tag key to
	// describe a category of information, such as "customer." Tag keys are
	// case-sensitive.
	//
	// This member is required.
	Key *string

	// The part of the key:value pair that defines a tag. You can use a tag value to
	// describe a specific value within a category, such as "companyA" or "companyB."
	// Tag values are case-sensitive.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// TCP flags and masks to inspect packets for, used in stateless rules MatchAttributes settings.
type TCPFlagField struct {

	// Used in conjunction with the Masks setting to define the flags that must be set
	// and flags that must not be set in order for the packet to match. This setting
	// can only specify values that are also specified in the Masks setting.
	//
	// For the flags that are specified in the masks setting, the following must be
	// true for the packet to match:
	//
	//   - The ones that are set in this flags setting must be set in the packet.
	//
	//   - The ones that are not set in this flags setting must also not be set in the
	//   packet.
	//
	// This member is required.
	Flags []TCPFlag

	// The set of flags to consider in the inspection. To inspect all flags in the
	// valid values list, leave this with no setting.
	Masks []TCPFlag

	noSmithyDocumentSerde
}

// Contains metadata about an Certificate Manager certificate.
type TlsCertificateData struct {

	// The Amazon Resource Name (ARN) of the certificate.
	CertificateArn *string

	// The serial number of the certificate.
	CertificateSerial *string

	// The status of the certificate.
	Status *string

	// Contains details about the certificate status, including information about
	// certificate errors.
	StatusMessage *string

	noSmithyDocumentSerde
}

// The object that defines a TLS inspection configuration. This, along with TLSInspectionConfigurationResponse,
// define the TLS inspection configuration. You can retrieve all objects for a TLS
// inspection configuration by calling DescribeTLSInspectionConfiguration.
//
// Network Firewall uses a TLS inspection configuration to decrypt traffic.
// Network Firewall re-encrypts the traffic before sending it to its destination.
//
// To use a TLS inspection configuration, you add it to a new Network Firewall
// firewall policy, then you apply the firewall policy to a firewall. Network
// Firewall acts as a proxy service to decrypt and inspect the traffic traveling
// through your firewalls. You can reference a TLS inspection configuration from
// more than one firewall policy, and you can use a firewall policy in more than
// one firewall. For more information about using TLS inspection configurations,
// see [Inspecting SSL/TLS traffic with TLS inspection configurations]in the Network Firewall Developer Guide.
//
// [Inspecting SSL/TLS traffic with TLS inspection configurations]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html
type TLSInspectionConfiguration struct {

	// Lists the server certificate configurations that are associated with the TLS
	// configuration.
	ServerCertificateConfigurations []ServerCertificateConfiguration

	noSmithyDocumentSerde
}

// High-level information about a TLS inspection configuration, returned by
// ListTLSInspectionConfigurations . You can use the information provided in the
// metadata to retrieve and manage a TLS configuration.
type TLSInspectionConfigurationMetadata struct {

	// The Amazon Resource Name (ARN) of the TLS inspection configuration.
	Arn *string

	// The descriptive name of the TLS inspection configuration. You can't change the
	// name of a TLS inspection configuration after you create it.
	Name *string

	noSmithyDocumentSerde
}

// The high-level properties of a TLS inspection configuration. This, along with
// the TLSInspectionConfiguration , define the TLS inspection configuration. You
// can retrieve all objects for a TLS inspection configuration by calling
// DescribeTLSInspectionConfiguration .
type TLSInspectionConfigurationResponse struct {

	// The Amazon Resource Name (ARN) of the TLS inspection configuration.
	//
	// This member is required.
	TLSInspectionConfigurationArn *string

	// A unique identifier for the TLS inspection configuration. This ID is returned
	// in the responses to create and list commands. You provide it to operations such
	// as update and delete.
	//
	// This member is required.
	TLSInspectionConfigurationId *string

	// The descriptive name of the TLS inspection configuration. You can't change the
	// name of a TLS inspection configuration after you create it.
	//
	// This member is required.
	TLSInspectionConfigurationName *string

	// Contains metadata about an Certificate Manager certificate.
	CertificateAuthority *TlsCertificateData

	// A list of the certificates associated with the TLS inspection configuration.
	Certificates []TlsCertificateData

	// A description of the TLS inspection configuration.
	Description *string

	// A complex type that contains the Amazon Web Services KMS encryption
	// configuration settings for your TLS inspection configuration.
	EncryptionConfiguration *EncryptionConfiguration

	// The last time that the TLS inspection configuration was changed.
	LastModifiedTime *time.Time

	// The number of firewall policies that use this TLS inspection configuration.
	NumberOfAssociations *int32

	// Detailed information about the current status of a TLSInspectionConfiguration. You can retrieve this for
	// a TLS inspection configuration by calling DescribeTLSInspectionConfigurationand providing the TLS inspection
	// configuration name and ARN.
	TLSInspectionConfigurationStatus ResourceStatus

	// The key:value pairs to associate with the resource.
	Tags []Tag

	noSmithyDocumentSerde
}

// A unique source IP address that connected to a domain.
type UniqueSources struct {

	// The number of unique source IP addresses that connected to a domain.
	Count int32

	noSmithyDocumentSerde
}

// A VPC endpoint association defines a single subnet to use for a firewall
// endpoint for a Firewall . You can define VPC endpoint associations only in the
// Availability Zones that already have a subnet mapping defined in the Firewall
// resource.
//
// You can retrieve the list of Availability Zones that are available for use by
// calling DescribeFirewallMetadata .
//
// To manage firewall endpoints, first, in the Firewall specification, you specify
// a single VPC and one subnet for each of the Availability Zones where you want to
// use the firewall. Then you can define additional endpoints as VPC endpoint
// associations.
//
// You can use VPC endpoint associations to expand the protections of the firewall
// as follows:
//
//   - Protect multiple VPCs with a single firewall - You can use the firewall to
//     protect other VPCs, either in your account or in accounts where the firewall is
//     shared. You can only specify Availability Zones that already have a firewall
//     endpoint defined in the Firewall subnet mappings.
//
//   - Define multiple firewall endpoints for a VPC in an Availability Zone - You
//     can create additional firewall endpoints for the VPC that you have defined in
//     the firewall, in any Availability Zone that already has an endpoint defined in
//     the Firewall subnet mappings. You can create multiple VPC endpoint
//     associations for any other VPC where you use the firewall.
//
// You can use Resource Access Manager to share a Firewall that you own with other
// accounts, which gives them the ability to use the firewall to create VPC
// endpoint associations. For information about sharing a firewall, see
// PutResourcePolicy in this guide and see [Sharing Network Firewall resources] in the Network Firewall Developer
// Guide.
//
// The status of the VPC endpoint association, which indicates whether it's ready
// to filter network traffic, is provided in the corresponding VpcEndpointAssociationStatus. You can retrieve
// both the association and its status by calling DescribeVpcEndpointAssociation.
//
// [Sharing Network Firewall resources]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/sharing.html
type VpcEndpointAssociation struct {

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// This member is required.
	FirewallArn *string

	// The ID for a subnet that's used in an association with a firewall. This is used
	// in CreateFirewall, AssociateSubnets, and CreateVpcEndpointAssociation. Network Firewall creates an instance of the associated firewall in
	// each subnet that you specify, to filter traffic in the subnet's Availability
	// Zone.
	//
	// This member is required.
	SubnetMapping *SubnetMapping

	// The Amazon Resource Name (ARN) of a VPC endpoint association.
	//
	// This member is required.
	VpcEndpointAssociationArn *string

	// The unique identifier of the VPC for the endpoint association.
	//
	// This member is required.
	VpcId *string

	// A description of the VPC endpoint association.
	Description *string

	// The key:value pairs to associate with the resource.
	Tags []Tag

	// The unique identifier of the VPC endpoint association.
	VpcEndpointAssociationId *string

	noSmithyDocumentSerde
}

// High-level information about a VPC endpoint association, returned by
// ListVpcEndpointAssociations . You can use the information provided in the
// metadata to retrieve and manage a VPC endpoint association.
type VpcEndpointAssociationMetadata struct {

	// The Amazon Resource Name (ARN) of a VPC endpoint association.
	VpcEndpointAssociationArn *string

	noSmithyDocumentSerde
}

// Detailed information about the current status of a VpcEndpointAssociation. You can retrieve this by
// calling DescribeVpcEndpointAssociationand providing the VPC endpoint association ARN.
type VpcEndpointAssociationStatus struct {

	// The readiness of the configured firewall endpoint to handle network traffic.
	//
	// This member is required.
	Status FirewallStatusValue

	// The list of the Availability Zone sync states for all subnets that are defined
	// by the firewall.
	AssociationSyncState map[string]AZSyncState

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
