// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deletes the specified VpcEndpointAssociation.
//
// You can check whether an endpoint association is in use by reviewing the route
// tables for the Availability Zones where you have the endpoint subnet mapping.
// You can retrieve the subnet mapping by calling DescribeVpcEndpointAssociation. You define and update the
// route tables through Amazon VPC. As needed, update the route tables for the
// Availability Zone to remove the firewall endpoint for the association. When the
// route tables no longer use the firewall endpoint, you can remove the endpoint
// association safely.
func (c *Client) DeleteVpcEndpointAssociation(ctx context.Context, params *DeleteVpcEndpointAssociationInput, optFns ...func(*Options)) (*DeleteVpcEndpointAssociationOutput, error) {
	if params == nil {
		params = &DeleteVpcEndpointAssociationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteVpcEndpointAssociation", params, optFns, c.addOperationDeleteVpcEndpointAssociationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteVpcEndpointAssociationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteVpcEndpointAssociationInput struct {

	// The Amazon Resource Name (ARN) of a VPC endpoint association.
	//
	// This member is required.
	VpcEndpointAssociationArn *string

	noSmithyDocumentSerde
}

type DeleteVpcEndpointAssociationOutput struct {

	// The configuration settings for the VPC endpoint association. These settings
	// include the firewall and the VPC and subnet to use for the firewall endpoint.
	VpcEndpointAssociation *types.VpcEndpointAssociation

	// Detailed information about the current status of a VpcEndpointAssociation. You can retrieve this by
	// calling DescribeVpcEndpointAssociationand providing the VPC endpoint association ARN.
	VpcEndpointAssociationStatus *types.VpcEndpointAssociationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteVpcEndpointAssociationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDeleteVpcEndpointAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDeleteVpcEndpointAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteVpcEndpointAssociation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteVpcEndpointAssociationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteVpcEndpointAssociation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteVpcEndpointAssociation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteVpcEndpointAssociation",
	}
}
