// Code generated by smithy-go-codegen DO NOT EDIT.

package macie2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/macie2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the configuration settings and status of automated sensitive data
// discovery for an organization or standalone account.
func (c *Client) GetAutomatedDiscoveryConfiguration(ctx context.Context, params *GetAutomatedDiscoveryConfigurationInput, optFns ...func(*Options)) (*GetAutomatedDiscoveryConfigurationOutput, error) {
	if params == nil {
		params = &GetAutomatedDiscoveryConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAutomatedDiscoveryConfiguration", params, optFns, c.addOperationGetAutomatedDiscoveryConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAutomatedDiscoveryConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAutomatedDiscoveryConfigurationInput struct {
	noSmithyDocumentSerde
}

type GetAutomatedDiscoveryConfigurationOutput struct {

	// Specifies whether automated sensitive data discovery is enabled automatically
	// for accounts in the organization. Possible values are: ALL, enable it for all
	// existing accounts and new member accounts; NEW, enable it only for new member
	// accounts; and, NONE, don't enable it for any accounts.
	AutoEnableOrganizationMembers types.AutoEnableMode

	// The unique identifier for the classification scope that's used when performing
	// automated sensitive data discovery. The classification scope specifies S3
	// buckets to exclude from analyses.
	ClassificationScopeId *string

	// The date and time, in UTC and extended ISO 8601 format, when automated
	// sensitive data discovery was most recently disabled. This value is null if
	// automated sensitive data discovery is currently enabled.
	DisabledAt *time.Time

	// The date and time, in UTC and extended ISO 8601 format, when automated
	// sensitive data discovery was initially enabled. This value is null if automated
	// sensitive data discovery has never been enabled.
	FirstEnabledAt *time.Time

	// The date and time, in UTC and extended ISO 8601 format, when the configuration
	// settings or status of automated sensitive data discovery was most recently
	// changed.
	LastUpdatedAt *time.Time

	// The unique identifier for the sensitivity inspection template that's used when
	// performing automated sensitive data discovery. The template specifies which
	// allow lists, custom data identifiers, and managed data identifiers to use when
	// analyzing data.
	SensitivityInspectionTemplateId *string

	// The current status of automated sensitive data discovery for the organization
	// or account. Possible values are: ENABLED, use the specified settings to perform
	// automated sensitive data discovery activities; and, DISABLED, don't perform
	// automated sensitive data discovery activities.
	Status types.AutomatedDiscoveryStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAutomatedDiscoveryConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetAutomatedDiscoveryConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetAutomatedDiscoveryConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAutomatedDiscoveryConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAutomatedDiscoveryConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAutomatedDiscoveryConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAutomatedDiscoveryConfiguration",
	}
}
