// Code generated by smithy-go-codegen DO NOT EDIT.

package ivsrealtime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ivsrealtime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all the replicas for a participant from a source stage.
func (c *Client) ListParticipantReplicas(ctx context.Context, params *ListParticipantReplicasInput, optFns ...func(*Options)) (*ListParticipantReplicasOutput, error) {
	if params == nil {
		params = &ListParticipantReplicasInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListParticipantReplicas", params, optFns, c.addOperationListParticipantReplicasMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListParticipantReplicasOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListParticipantReplicasInput struct {

	// Participant ID of the publisher that has been replicated. This is assigned by
	// IVS and returned by CreateParticipantTokenor the jti (JWT ID) used to [create a self signed token].
	//
	// [create a self signed token]: https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed
	//
	// This member is required.
	ParticipantId *string

	// ARN of the stage where the participant is publishing.
	//
	// This member is required.
	SourceStageArn *string

	// Maximum number of results to return. Default: 50.
	MaxResults *int32

	// The first participant to retrieve. This is used for pagination; see the
	// nextToken response field.
	NextToken *string

	noSmithyDocumentSerde
}

type ListParticipantReplicasOutput struct {

	// List of all participant replicas.
	//
	// This member is required.
	Replicas []types.ParticipantReplica

	// If there are more participants than maxResults , use nextToken in the request
	// to get the next set.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListParticipantReplicasMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListParticipantReplicas{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListParticipantReplicas{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListParticipantReplicas"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListParticipantReplicasValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListParticipantReplicas(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListParticipantReplicasPaginatorOptions is the paginator options for
// ListParticipantReplicas
type ListParticipantReplicasPaginatorOptions struct {
	// Maximum number of results to return. Default: 50.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListParticipantReplicasPaginator is a paginator for ListParticipantReplicas
type ListParticipantReplicasPaginator struct {
	options   ListParticipantReplicasPaginatorOptions
	client    ListParticipantReplicasAPIClient
	params    *ListParticipantReplicasInput
	nextToken *string
	firstPage bool
}

// NewListParticipantReplicasPaginator returns a new
// ListParticipantReplicasPaginator
func NewListParticipantReplicasPaginator(client ListParticipantReplicasAPIClient, params *ListParticipantReplicasInput, optFns ...func(*ListParticipantReplicasPaginatorOptions)) *ListParticipantReplicasPaginator {
	if params == nil {
		params = &ListParticipantReplicasInput{}
	}

	options := ListParticipantReplicasPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListParticipantReplicasPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListParticipantReplicasPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListParticipantReplicas page.
func (p *ListParticipantReplicasPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListParticipantReplicasOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListParticipantReplicas(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListParticipantReplicasAPIClient is a client that implements the
// ListParticipantReplicas operation.
type ListParticipantReplicasAPIClient interface {
	ListParticipantReplicas(context.Context, *ListParticipantReplicasInput, ...func(*Options)) (*ListParticipantReplicasOutput, error)
}

var _ ListParticipantReplicasAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListParticipantReplicas(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListParticipantReplicas",
	}
}
