// Code generated by smithy-go-codegen DO NOT EDIT.

package imagebuilder

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/imagebuilder/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Get a list of workflow steps that are waiting for action for workflows in your
// Amazon Web Services account.
func (c *Client) ListWaitingWorkflowSteps(ctx context.Context, params *ListWaitingWorkflowStepsInput, optFns ...func(*Options)) (*ListWaitingWorkflowStepsOutput, error) {
	if params == nil {
		params = &ListWaitingWorkflowStepsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListWaitingWorkflowSteps", params, optFns, c.addOperationListWaitingWorkflowStepsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListWaitingWorkflowStepsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListWaitingWorkflowStepsInput struct {

	// The maximum items to return in a request.
	MaxResults *int32

	// A token to specify where to start paginating. This is the nextToken from a
	// previously truncated response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListWaitingWorkflowStepsOutput struct {

	// The next token used for paginated responses. When this field isn't empty, there
	// are additional elements that the service hasn't included in this request. Use
	// this token with the next request to retrieve additional objects.
	NextToken *string

	// An array of the workflow steps that are waiting for action in your Amazon Web
	// Services account.
	Steps []types.WorkflowStepExecution

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListWaitingWorkflowStepsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListWaitingWorkflowSteps{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListWaitingWorkflowSteps{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListWaitingWorkflowSteps"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListWaitingWorkflowSteps(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListWaitingWorkflowStepsPaginatorOptions is the paginator options for
// ListWaitingWorkflowSteps
type ListWaitingWorkflowStepsPaginatorOptions struct {
	// The maximum items to return in a request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListWaitingWorkflowStepsPaginator is a paginator for ListWaitingWorkflowSteps
type ListWaitingWorkflowStepsPaginator struct {
	options   ListWaitingWorkflowStepsPaginatorOptions
	client    ListWaitingWorkflowStepsAPIClient
	params    *ListWaitingWorkflowStepsInput
	nextToken *string
	firstPage bool
}

// NewListWaitingWorkflowStepsPaginator returns a new
// ListWaitingWorkflowStepsPaginator
func NewListWaitingWorkflowStepsPaginator(client ListWaitingWorkflowStepsAPIClient, params *ListWaitingWorkflowStepsInput, optFns ...func(*ListWaitingWorkflowStepsPaginatorOptions)) *ListWaitingWorkflowStepsPaginator {
	if params == nil {
		params = &ListWaitingWorkflowStepsInput{}
	}

	options := ListWaitingWorkflowStepsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListWaitingWorkflowStepsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListWaitingWorkflowStepsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListWaitingWorkflowSteps page.
func (p *ListWaitingWorkflowStepsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListWaitingWorkflowStepsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListWaitingWorkflowSteps(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListWaitingWorkflowStepsAPIClient is a client that implements the
// ListWaitingWorkflowSteps operation.
type ListWaitingWorkflowStepsAPIClient interface {
	ListWaitingWorkflowSteps(context.Context, *ListWaitingWorkflowStepsInput, ...func(*Options)) (*ListWaitingWorkflowStepsOutput, error)
}

var _ ListWaitingWorkflowStepsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListWaitingWorkflowSteps(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListWaitingWorkflowSteps",
	}
}
