// Code generated by smithy-go-codegen DO NOT EDIT.

package geomaps

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/geomaps/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// GetStyleDescriptor returns information about the style.
func (c *Client) GetStyleDescriptor(ctx context.Context, params *GetStyleDescriptorInput, optFns ...func(*Options)) (*GetStyleDescriptorOutput, error) {
	if params == nil {
		params = &GetStyleDescriptorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetStyleDescriptor", params, optFns, c.addOperationGetStyleDescriptorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetStyleDescriptorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetStyleDescriptorInput struct {

	// Style specifies the desired map style.
	//
	// This member is required.
	Style types.MapStyle

	// Sets color tone for map such as dark and light for specific map styles. It
	// applies to only vector map styles such as Standard and Monochrome.
	//
	// Example: Light
	//
	// Default value: Light
	//
	// Valid values for ColorScheme are case sensitive.
	ColorScheme types.ColorScheme

	// Optional: The API key to be used for authorization. Either an API key or valid
	// SigV4 signature must be provided when making a request.
	Key *string

	// Specifies the political view using ISO 3166-2 or ISO 3166-3 country code format.
	//
	// The following political views are currently supported:
	//
	//   - ARG : Argentina's view on the Southern Patagonian Ice Field and Tierra Del
	//   Fuego, including the Falkland Islands, South Georgia, and South Sandwich Islands
	//
	//   - EGY : Egypt's view on Bir Tawil
	//
	//   - IND : India's view on Gilgit-Baltistan
	//
	//   - KEN : Kenya's view on the Ilemi Triangle
	//
	//   - MAR : Morocco's view on Western Sahara
	//
	//   - RUS : Russia's view on Crimea
	//
	//   - SDN : Sudan's view on the Halaib Triangle
	//
	//   - SRB : Serbia's view on Kosovo, Vukovar, and Sarengrad Islands
	//
	//   - SUR : Suriname's view on the Courantyne Headwaters and Lawa Headwaters
	//
	//   - SYR : Syria's view on the Golan Heights
	//
	//   - TUR : Turkey's view on Cyprus and Northern Cyprus
	//
	//   - TZA : Tanzania's view on Lake Malawi
	//
	//   - URY : Uruguay's view on Rincon de Artigas
	//
	//   - VNM : Vietnam's view on the Paracel Islands and Spratly Islands
	PoliticalView *string

	noSmithyDocumentSerde
}

type GetStyleDescriptorOutput struct {

	// This Blob contains the body of the style descriptor which is in
	// application/json format.
	Blob []byte

	// Header that instructs caching configuration for the client.
	CacheControl *string

	// Header that represents the format of the response. The response returns the
	// following as the HTTP body.
	ContentType *string

	// The style descriptor's Etag.
	ETag *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetStyleDescriptorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetStyleDescriptor{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetStyleDescriptor{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetStyleDescriptor"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetStyleDescriptorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetStyleDescriptor(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetStyleDescriptor(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetStyleDescriptor",
	}
}
