// Code generated by smithy-go-codegen DO NOT EDIT.

package gameliftstreams

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gameliftstreams/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Retrieves properties for a Amazon GameLift Streams stream session resource.
// Specify the Amazon Resource Name (ARN) of the stream session that you want to
// retrieve and its stream group ARN. If the operation is successful, it returns
// properties for the requested resource.
func (c *Client) GetStreamSession(ctx context.Context, params *GetStreamSessionInput, optFns ...func(*Options)) (*GetStreamSessionOutput, error) {
	if params == nil {
		params = &GetStreamSessionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetStreamSession", params, optFns, c.addOperationGetStreamSessionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetStreamSessionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetStreamSessionInput struct {

	// The stream group that runs this stream session.
	//
	// This value is an [Amazon Resource Name (ARN)] or ID that uniquely identifies the stream group resource.
	// Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4 .
	// Example ID: sg-1AB2C3De4 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Identifier *string

	// An [Amazon Resource Name (ARN)] or ID that uniquely identifies the stream session resource. Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:streamsession/sg-1AB2C3De4/ABC123def4567
	// . Example ID: ABC123def4567 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	StreamSessionIdentifier *string

	noSmithyDocumentSerde
}

type GetStreamSessionOutput struct {

	// A set of options that you can use to control the stream session runtime
	// environment, expressed as a set of key-value pairs. You can use this to
	// configure the application or stream session details. You can also provide custom
	// environment variables that Amazon GameLift Streams passes to your game client.
	//
	// If you want to debug your application with environment variables, we recommend
	// that you do so in a local environment outside of Amazon GameLift Streams. For
	// more information, refer to the Compatibility Guidance in the troubleshooting
	// section of the Developer Guide.
	//
	// AdditionalEnvironmentVariables and AdditionalLaunchArgs have similar purposes.
	// AdditionalEnvironmentVariables passes data using environment variables; while
	// AdditionalLaunchArgs passes data using command-line arguments.
	AdditionalEnvironmentVariables map[string]string

	// A list of CLI arguments that are sent to the streaming server when a stream
	// session launches. You can use this to configure the application or stream
	// session details. You can also provide custom arguments that Amazon GameLift
	// Streams passes to your game client.
	//
	// AdditionalEnvironmentVariables and AdditionalLaunchArgs have similar purposes.
	// AdditionalEnvironmentVariables passes data using environment variables; while
	// AdditionalLaunchArgs passes data using command-line arguments.
	AdditionalLaunchArgs []string

	// The application streaming in this session.
	//
	// This value is an [Amazon Resource Name (ARN)] that uniquely identifies the application resource. Example
	// ARN: arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	ApplicationArn *string

	// The [Amazon Resource Name (ARN)] that's assigned to a stream session resource. When combined with the
	// stream group resource ID, this value uniquely identifies the stream session
	// across all Amazon Web Services Regions. Format is arn:aws:gameliftstreams:[AWS
	// Region]:[AWS account]:streamsession/[stream group resource ID]/[stream session
	// resource ID] .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	Arn *string

	// The maximum length of time (in seconds) that Amazon GameLift Streams keeps the
	// stream session open. At this point, Amazon GameLift Streams ends the stream
	// session regardless of any existing client connections.
	ConnectionTimeoutSeconds *int32

	// A timestamp that indicates when this resource was created. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	CreatedAt *time.Time

	// A human-readable label for the stream session. You can update this value at any
	// time.
	Description *string

	// Provides details about the stream session's exported files.
	ExportFilesMetadata *types.ExportFilesMetadata

	// A timestamp that indicates when this resource was last updated. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	LastUpdatedAt *time.Time

	// The location where Amazon GameLift Streams is hosting the stream session.
	//
	// A location's name. For example, us-east-1 . For a complete list of locations
	// that Amazon GameLift Streams supports, refer to [Regions, quotas, and limitations]in the Amazon GameLift Streams
	// Developer Guide.
	//
	// [Regions, quotas, and limitations]: https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html
	Location *string

	// Access location for log files that your content generates during a stream
	// session. These log files are uploaded to cloud storage location at the end of a
	// stream session. The Amazon GameLift Streams application resource defines which
	// log files to upload.
	LogFileLocationUri *string

	// The data transfer protocol in use with the stream session.
	Protocol types.Protocol

	// The length of time that Amazon GameLift Streams keeps the game session open.
	SessionLengthSeconds *int32

	// The WebRTC ICE offer string that a client generates to initiate a connection to
	// the stream session.
	SignalRequest *string

	// The WebRTC answer string that the stream server generates in response to the
	// SignalRequest .
	SignalResponse *string

	// The current status of the stream session. A stream session can host clients
	// when in ACTIVE status.
	Status types.StreamSessionStatus

	// A short description of the reason the stream session is in ERROR status.
	StatusReason types.StreamSessionStatusReason

	// The unique identifier for the Amazon GameLift Streams stream group that is
	// hosting the stream session. Format example: sg-1AB2C3De4 .
	StreamGroupId *string

	//  An opaque, unique identifier for an end-user, defined by the developer.
	UserId *string

	// The URL of an S3 bucket that stores Amazon GameLift Streams WebSDK files. The
	// URL is used to establish connection with the client.
	WebSdkProtocolUrl *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetStreamSessionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetStreamSession{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetStreamSession{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetStreamSession"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetStreamSessionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetStreamSession(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// StreamSessionActiveWaiterOptions are waiter options for
// StreamSessionActiveWaiter
type StreamSessionActiveWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// StreamSessionActiveWaiter will use default minimum delay of 2 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, StreamSessionActiveWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetStreamSessionInput, *GetStreamSessionOutput, error) (bool, error)
}

// StreamSessionActiveWaiter defines the waiters for StreamSessionActive
type StreamSessionActiveWaiter struct {
	client GetStreamSessionAPIClient

	options StreamSessionActiveWaiterOptions
}

// NewStreamSessionActiveWaiter constructs a StreamSessionActiveWaiter.
func NewStreamSessionActiveWaiter(client GetStreamSessionAPIClient, optFns ...func(*StreamSessionActiveWaiterOptions)) *StreamSessionActiveWaiter {
	options := StreamSessionActiveWaiterOptions{}
	options.MinDelay = 2 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = streamSessionActiveStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &StreamSessionActiveWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for StreamSessionActive waiter. The maxWaitDur
// is the maximum wait duration the waiter will wait. The maxWaitDur is required
// and must be greater than zero.
func (w *StreamSessionActiveWaiter) Wait(ctx context.Context, params *GetStreamSessionInput, maxWaitDur time.Duration, optFns ...func(*StreamSessionActiveWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for StreamSessionActive waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *StreamSessionActiveWaiter) WaitForOutput(ctx context.Context, params *GetStreamSessionInput, maxWaitDur time.Duration, optFns ...func(*StreamSessionActiveWaiterOptions)) (*GetStreamSessionOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetStreamSession(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for StreamSessionActive waiter")
}

func streamSessionActiveStateRetryable(ctx context.Context, input *GetStreamSessionInput, output *GetStreamSessionOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Status
		expectedValue := "ACTIVE"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "ERROR"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// GetStreamSessionAPIClient is a client that implements the GetStreamSession
// operation.
type GetStreamSessionAPIClient interface {
	GetStreamSession(context.Context, *GetStreamSessionInput, ...func(*Options)) (*GetStreamSessionOutput, error)
}

var _ GetStreamSessionAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetStreamSession(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetStreamSession",
	}
}
