// Code generated by smithy-go-codegen DO NOT EDIT.

package gameliftstreams

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gameliftstreams/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates an application resource in Amazon GameLift Streams, which specifies the
// application content you want to stream, such as a game build or other software,
// and configures the settings to run it.
//
// Before you create an application, upload your application content files to an
// Amazon Simple Storage Service (Amazon S3) bucket. For more information, see
// Getting Started in the Amazon GameLift Streams Developer Guide.
//
// Make sure that your files in the Amazon S3 bucket are the correct version you
// want to use. If you change the files at a later time, you will need to create a
// new Amazon GameLift Streams application.
//
// If the request is successful, Amazon GameLift Streams begins to create an
// application and sets the status to INITIALIZED . When an application reaches
// READY status, you can use the application to set up stream groups and start
// streams. To track application status, call [GetApplication].
//
// [GetApplication]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetApplication.html
func (c *Client) CreateApplication(ctx context.Context, params *CreateApplicationInput, optFns ...func(*Options)) (*CreateApplicationOutput, error) {
	if params == nil {
		params = &CreateApplicationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateApplication", params, optFns, c.addOperationCreateApplicationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateApplicationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateApplicationInput struct {

	// The location of the content that you want to stream. Enter an Amazon S3 URI to
	// a bucket that contains your game or other application. The location can have a
	// multi-level prefix structure, but it must include all the files needed to run
	// the content. Amazon GameLift Streams copies everything under the specified
	// location.
	//
	// This value is immutable. To designate a different content location, create a
	// new application.
	//
	// The Amazon S3 bucket and the Amazon GameLift Streams application must be in the
	// same Amazon Web Services Region.
	//
	// This member is required.
	ApplicationSourceUri *string

	// A human-readable label for the application. You can update this value later.
	//
	// This member is required.
	Description *string

	// The path and file name of the executable file that launches the content for
	// streaming. Enter a path value that is relative to the location set in
	// ApplicationSourceUri .
	//
	// This member is required.
	ExecutablePath *string

	// Configuration settings that identify the operating system for an application
	// resource. This can also include a compatibility layer and other drivers.
	//
	// A runtime environment can be one of the following:
	//
	//   - For Linux applications
	//
	//   - Ubuntu 22.04 LTS ( Type=UBUNTU, Version=22_04_LTS )
	//
	//   - For Windows applications
	//
	//   - Microsoft Windows Server 2022 Base ( Type=WINDOWS, Version=2022 )
	//
	//   - Proton 8.0-5 ( Type=PROTON, Version=20241007 )
	//
	//   - Proton 8.0-2c ( Type=PROTON, Version=20230704 )
	//
	// This member is required.
	RuntimeEnvironment *types.RuntimeEnvironment

	// An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to
	// save application logs. Required if you specify one or more ApplicationLogPaths .
	//
	// The log bucket must have permissions that give Amazon GameLift Streams access
	// to write the log files. For more information, see [Application log bucket permission policy]in the Amazon GameLift
	// Streams Developer Guide.
	//
	// [Application log bucket permission policy]: https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/applications.html#application-bucket-permission-template
	ApplicationLogOutputUri *string

	// Locations of log files that your content generates during a stream session.
	// Enter path values that are relative to the ApplicationSourceUri location. You
	// can specify up to 10 log paths. Amazon GameLift Streams uploads designated log
	// files to the Amazon S3 bucket that you specify in ApplicationLogOutputUri at
	// the end of a stream session. To retrieve stored log files, call [GetStreamSession]and get the
	// LogFileLocationUri .
	//
	// [GetStreamSession]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html
	ApplicationLogPaths []string

	//  A unique identifier that represents a client request. The request is
	// idempotent, which ensures that an API request completes only once. When users
	// send a request, Amazon GameLift Streams automatically populates this field.
	ClientToken *string

	// A list of labels to assign to the new application resource. Tags are
	// developer-defined key-value pairs. Tagging Amazon Web Services resources is
	// useful for resource management, access management and cost allocation. See [Tagging Amazon Web Services Resources]in
	// the Amazon Web Services General Reference. You can use [TagResource]to add tags, [UntagResource] to remove
	// tags, and [ListTagsForResource]to view tags on existing resources.
	//
	// [Tagging Amazon Web Services Resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	// [TagResource]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TagResource.html
	// [UntagResource]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_UntagResource.html
	// [ListTagsForResource]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ListTagsForResource.html
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateApplicationOutput struct {

	// The [Amazon Resource Name (ARN)] that's assigned to an application resource and uniquely identifies it
	// across all Amazon Web Services Regions. Format is arn:aws:gameliftstreams:[AWS
	// Region]:[AWS account]:application/[resource ID] .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Arn *string

	// An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to
	// save application logs. Required if you specify one or more ApplicationLogPaths .
	ApplicationLogOutputUri *string

	// Locations of log files that your content generates during a stream session.
	// Amazon GameLift Streams uploads log files to the Amazon S3 bucket that you
	// specify in ApplicationLogOutputUri at the end of a stream session. To retrieve
	// stored log files, call [GetStreamSession]and get the LogFileLocationUri .
	//
	// [GetStreamSession]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html
	ApplicationLogPaths []string

	// The original Amazon S3 location of uploaded stream content for the application.
	ApplicationSourceUri *string

	// A newly created application is not associated to any stream groups. This value
	// is empty.
	AssociatedStreamGroups []string

	// A timestamp that indicates when this resource was created. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	CreatedAt *time.Time

	// A human-readable label for the application. You can edit this value.
	Description *string

	// The path and file name of the executable file that launches the content for
	// streaming.
	ExecutablePath *string

	// A unique ID value that is assigned to the resource when it's created. Format
	// example: a-9ZY8X7Wv6 .
	Id *string

	// A timestamp that indicates when this resource was last updated. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	LastUpdatedAt *time.Time

	// A set of replication statuses for each location.
	ReplicationStatuses []types.ReplicationStatus

	//  Configuration settings that identify the operating system for an application
	// resource. This can also include a compatibility layer and other drivers.
	//
	// A runtime environment can be one of the following:
	//
	//   - For Linux applications
	//
	//   - Ubuntu 22.04 LTS ( Type=UBUNTU, Version=22_04_LTS )
	//
	//   - For Windows applications
	//
	//   - Microsoft Windows Server 2022 Base ( Type=WINDOWS, Version=2022 )
	//
	//   - Proton 8.0-5 ( Type=PROTON, Version=20241007 )
	//
	//   - Proton 8.0-2c ( Type=PROTON, Version=20230704 )
	RuntimeEnvironment *types.RuntimeEnvironment

	// The current status of the application resource. Possible statuses include the
	// following:
	//
	//   - INITIALIZED : Amazon GameLift Streams has received the request and is
	//   initiating the work flow to create an application.
	//
	//   - PROCESSING : The create application work flow is in process. Amazon GameLift
	//   Streams is copying the content and caching for future deployment in a stream
	//   group.
	//
	//   - READY : The application is ready to deploy in a stream group.
	//
	//   - ERROR : An error occurred when setting up the application. See StatusReason
	//   for more information.
	//
	//   - DELETING : Amazon GameLift Streams is in the process of deleting the
	//   application.
	Status types.ApplicationStatus

	// A short description of the status reason when the application is in ERROR
	// status.
	StatusReason types.ApplicationStatusReason

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateApplicationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateApplication{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateApplication{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateApplication"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateApplicationMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateApplicationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateApplication(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateApplication struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateApplication) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateApplicationInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateApplicationMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateApplication{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateApplication(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateApplication",
	}
}
