// Code generated by smithy-go-codegen DO NOT EDIT.

package fms

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/fms/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The onboarding status of a Firewall Manager admin account to third-party
// firewall vendor tenant.
func (c *Client) GetThirdPartyFirewallAssociationStatus(ctx context.Context, params *GetThirdPartyFirewallAssociationStatusInput, optFns ...func(*Options)) (*GetThirdPartyFirewallAssociationStatusOutput, error) {
	if params == nil {
		params = &GetThirdPartyFirewallAssociationStatusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetThirdPartyFirewallAssociationStatus", params, optFns, c.addOperationGetThirdPartyFirewallAssociationStatusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetThirdPartyFirewallAssociationStatusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetThirdPartyFirewallAssociationStatusInput struct {

	// The name of the third-party firewall vendor.
	//
	// This member is required.
	ThirdPartyFirewall types.ThirdPartyFirewall

	noSmithyDocumentSerde
}

type GetThirdPartyFirewallAssociationStatusOutput struct {

	// The status for subscribing to the third-party firewall vendor in the Amazon Web
	// Services Marketplace.
	//
	//   - NO_SUBSCRIPTION - The Firewall Manager policy administrator isn't subscribed
	//   to the third-party firewall service in the Amazon Web Services Marketplace.
	//
	//   - NOT_COMPLETE - The Firewall Manager policy administrator is in the process
	//   of subscribing to the third-party firewall service in the Amazon Web Services
	//   Marketplace, but doesn't yet have an active subscription.
	//
	//   - COMPLETE - The Firewall Manager policy administrator has an active
	//   subscription to the third-party firewall service in the Amazon Web Services
	//   Marketplace.
	MarketplaceOnboardingStatus types.MarketplaceSubscriptionOnboardingStatus

	// The current status for setting a Firewall Manager policy administrators account
	// as an administrator of the third-party firewall tenant.
	//
	//   - ONBOARDING - The Firewall Manager policy administrator is being designated
	//   as a tenant administrator.
	//
	//   - ONBOARD_COMPLETE - The Firewall Manager policy administrator is designated
	//   as a tenant administrator.
	//
	//   - OFFBOARDING - The Firewall Manager policy administrator is being removed as
	//   a tenant administrator.
	//
	//   - OFFBOARD_COMPLETE - The Firewall Manager policy administrator has been
	//   removed as a tenant administrator.
	//
	//   - NOT_EXIST - The Firewall Manager policy administrator doesn't exist as a
	//   tenant administrator.
	ThirdPartyFirewallStatus types.ThirdPartyFirewallAssociationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetThirdPartyFirewallAssociationStatusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetThirdPartyFirewallAssociationStatus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetThirdPartyFirewallAssociationStatus{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetThirdPartyFirewallAssociationStatus"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetThirdPartyFirewallAssociationStatusValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetThirdPartyFirewallAssociationStatus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetThirdPartyFirewallAssociationStatus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetThirdPartyFirewallAssociationStatus",
	}
}
