// Code generated by smithy-go-codegen DO NOT EDIT.

package devopsguru

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/devopsguru/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Returns a list of insights in your organization. You can specify which
//
// insights are returned by their start time, one or more statuses ( ONGOING ,
// CLOSED , and CLOSED ), one or more severities ( LOW , MEDIUM , and HIGH ), and
// type ( REACTIVE or PROACTIVE ).
//
// Use the Filters parameter to specify status and severity search parameters. Use
// the Type parameter to specify REACTIVE or PROACTIVE in your search.
func (c *Client) SearchOrganizationInsights(ctx context.Context, params *SearchOrganizationInsightsInput, optFns ...func(*Options)) (*SearchOrganizationInsightsOutput, error) {
	if params == nil {
		params = &SearchOrganizationInsightsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchOrganizationInsights", params, optFns, c.addOperationSearchOrganizationInsightsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchOrganizationInsightsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchOrganizationInsightsInput struct {

	// The ID of the Amazon Web Services account.
	//
	// This member is required.
	AccountIds []string

	//  A time range used to specify when the behavior of an insight or anomaly
	// started.
	//
	// This member is required.
	StartTimeRange *types.StartTimeRange

	//  The type of insights you are searching for ( REACTIVE or PROACTIVE ).
	//
	// This member is required.
	Type types.InsightType

	//  A SearchOrganizationInsightsFilters object that is used to set the severity
	// and status filters on your insight search.
	Filters *types.SearchOrganizationInsightsFilters

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string

	noSmithyDocumentSerde
}

type SearchOrganizationInsightsOutput struct {

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string

	// An integer that specifies the number of open proactive insights in your Amazon
	// Web Services account.
	ProactiveInsights []types.ProactiveInsightSummary

	// An integer that specifies the number of open reactive insights in your Amazon
	// Web Services account.
	ReactiveInsights []types.ReactiveInsightSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchOrganizationInsightsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchOrganizationInsights{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchOrganizationInsights{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchOrganizationInsights"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchOrganizationInsightsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchOrganizationInsights(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// SearchOrganizationInsightsPaginatorOptions is the paginator options for
// SearchOrganizationInsights
type SearchOrganizationInsightsPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchOrganizationInsightsPaginator is a paginator for
// SearchOrganizationInsights
type SearchOrganizationInsightsPaginator struct {
	options   SearchOrganizationInsightsPaginatorOptions
	client    SearchOrganizationInsightsAPIClient
	params    *SearchOrganizationInsightsInput
	nextToken *string
	firstPage bool
}

// NewSearchOrganizationInsightsPaginator returns a new
// SearchOrganizationInsightsPaginator
func NewSearchOrganizationInsightsPaginator(client SearchOrganizationInsightsAPIClient, params *SearchOrganizationInsightsInput, optFns ...func(*SearchOrganizationInsightsPaginatorOptions)) *SearchOrganizationInsightsPaginator {
	if params == nil {
		params = &SearchOrganizationInsightsInput{}
	}

	options := SearchOrganizationInsightsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchOrganizationInsightsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchOrganizationInsightsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchOrganizationInsights page.
func (p *SearchOrganizationInsightsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchOrganizationInsightsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.SearchOrganizationInsights(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchOrganizationInsightsAPIClient is a client that implements the
// SearchOrganizationInsights operation.
type SearchOrganizationInsightsAPIClient interface {
	SearchOrganizationInsights(context.Context, *SearchOrganizationInsightsInput, ...func(*Options)) (*SearchOrganizationInsightsOutput, error)
}

var _ SearchOrganizationInsightsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearchOrganizationInsights(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchOrganizationInsights",
	}
}
