// Code generated by smithy-go-codegen DO NOT EDIT.

package deadline

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/deadline/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Gets a queue.
func (c *Client) GetQueue(ctx context.Context, params *GetQueueInput, optFns ...func(*Options)) (*GetQueueOutput, error) {
	if params == nil {
		params = &GetQueueInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetQueue", params, optFns, c.addOperationGetQueueMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetQueueOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetQueueInput struct {

	// The farm ID of the farm in the queue.
	//
	// This member is required.
	FarmId *string

	// The queue ID for the queue to retrieve.
	//
	// This member is required.
	QueueId *string

	noSmithyDocumentSerde
}

type GetQueueOutput struct {

	// The date and time the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user or system that created this resource.
	//
	// This member is required.
	CreatedBy *string

	// The default action taken on a queue if a budget wasn't configured.
	//
	// This member is required.
	DefaultBudgetAction types.DefaultQueueBudgetAction

	// The display name of the queue.
	//
	// This field can store any content. Escape or encode this content before
	// displaying it on a webpage or any other system that might interpret the content
	// of this field.
	//
	// This member is required.
	DisplayName *string

	// The farm ID for the queue.
	//
	// This member is required.
	FarmId *string

	// The queue ID.
	//
	// This member is required.
	QueueId *string

	// The status of the queue.
	//
	//   - ACTIVE –The queue is active.
	//
	//   - SCHEDULING –The queue is scheduling.
	//
	//   - SCHEDULING_BLOCKED –The queue scheduling is blocked. See the provided reason.
	//
	// This member is required.
	Status types.QueueStatus

	// The storage profile IDs for the queue.
	AllowedStorageProfileIds []string

	// The reason the queue was blocked.
	BlockedReason types.QueueBlockedReason

	// The description of the queue.
	//
	// This field can store any content. Escape or encode this content before
	// displaying it on a webpage or any other system that might interpret the content
	// of this field.
	Description *string

	// The job attachment settings for the queue.
	JobAttachmentSettings *types.JobAttachmentSettings

	// The jobs in the queue ran as this specified POSIX user.
	JobRunAsUser *types.JobRunAsUser

	// A list of the required file system location names in the queue.
	RequiredFileSystemLocationNames []string

	// The IAM role ARN.
	RoleArn *string

	// The date and time the resource was updated.
	UpdatedAt *time.Time

	// The user or system that updated this resource.
	UpdatedBy *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetQueueMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetQueue{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetQueue{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetQueue"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opGetQueueMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetQueueValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetQueue(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// QueueSchedulingBlockedWaiterOptions are waiter options for
// QueueSchedulingBlockedWaiter
type QueueSchedulingBlockedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// QueueSchedulingBlockedWaiter will use default minimum delay of 10 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, QueueSchedulingBlockedWaiter will use default max delay of 300
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetQueueInput, *GetQueueOutput, error) (bool, error)
}

// QueueSchedulingBlockedWaiter defines the waiters for QueueSchedulingBlocked
type QueueSchedulingBlockedWaiter struct {
	client GetQueueAPIClient

	options QueueSchedulingBlockedWaiterOptions
}

// NewQueueSchedulingBlockedWaiter constructs a QueueSchedulingBlockedWaiter.
func NewQueueSchedulingBlockedWaiter(client GetQueueAPIClient, optFns ...func(*QueueSchedulingBlockedWaiterOptions)) *QueueSchedulingBlockedWaiter {
	options := QueueSchedulingBlockedWaiterOptions{}
	options.MinDelay = 10 * time.Second
	options.MaxDelay = 300 * time.Second
	options.Retryable = queueSchedulingBlockedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &QueueSchedulingBlockedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for QueueSchedulingBlocked waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *QueueSchedulingBlockedWaiter) Wait(ctx context.Context, params *GetQueueInput, maxWaitDur time.Duration, optFns ...func(*QueueSchedulingBlockedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for QueueSchedulingBlocked waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *QueueSchedulingBlockedWaiter) WaitForOutput(ctx context.Context, params *GetQueueInput, maxWaitDur time.Duration, optFns ...func(*QueueSchedulingBlockedWaiterOptions)) (*GetQueueOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 300 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetQueue(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for QueueSchedulingBlocked waiter")
}

func queueSchedulingBlockedStateRetryable(ctx context.Context, input *GetQueueInput, output *GetQueueOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Status
		expectedValue := "SCHEDULING_BLOCKED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// QueueSchedulingWaiterOptions are waiter options for QueueSchedulingWaiter
type QueueSchedulingWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// QueueSchedulingWaiter will use default minimum delay of 10 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, QueueSchedulingWaiter will use default max delay of 700 seconds.
	// Note that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetQueueInput, *GetQueueOutput, error) (bool, error)
}

// QueueSchedulingWaiter defines the waiters for QueueScheduling
type QueueSchedulingWaiter struct {
	client GetQueueAPIClient

	options QueueSchedulingWaiterOptions
}

// NewQueueSchedulingWaiter constructs a QueueSchedulingWaiter.
func NewQueueSchedulingWaiter(client GetQueueAPIClient, optFns ...func(*QueueSchedulingWaiterOptions)) *QueueSchedulingWaiter {
	options := QueueSchedulingWaiterOptions{}
	options.MinDelay = 10 * time.Second
	options.MaxDelay = 700 * time.Second
	options.Retryable = queueSchedulingStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &QueueSchedulingWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for QueueScheduling waiter. The maxWaitDur is
// the maximum wait duration the waiter will wait. The maxWaitDur is required and
// must be greater than zero.
func (w *QueueSchedulingWaiter) Wait(ctx context.Context, params *GetQueueInput, maxWaitDur time.Duration, optFns ...func(*QueueSchedulingWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for QueueScheduling waiter and returns
// the output of the successful operation. The maxWaitDur is the maximum wait
// duration the waiter will wait. The maxWaitDur is required and must be greater
// than zero.
func (w *QueueSchedulingWaiter) WaitForOutput(ctx context.Context, params *GetQueueInput, maxWaitDur time.Duration, optFns ...func(*QueueSchedulingWaiterOptions)) (*GetQueueOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 700 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetQueue(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for QueueScheduling waiter")
}

func queueSchedulingStateRetryable(ctx context.Context, input *GetQueueInput, output *GetQueueOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Status
		expectedValue := "SCHEDULING"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

type endpointPrefix_opGetQueueMiddleware struct {
}

func (*endpointPrefix_opGetQueueMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opGetQueueMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "management." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opGetQueueMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opGetQueueMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// GetQueueAPIClient is a client that implements the GetQueue operation.
type GetQueueAPIClient interface {
	GetQueue(context.Context, *GetQueueInput, ...func(*Options)) (*GetQueueOutput, error)
}

var _ GetQueueAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetQueue(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetQueue",
	}
}
