// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets an evinronment profile in Amazon DataZone.
func (c *Client) GetEnvironmentProfile(ctx context.Context, params *GetEnvironmentProfileInput, optFns ...func(*Options)) (*GetEnvironmentProfileOutput, error) {
	if params == nil {
		params = &GetEnvironmentProfileInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEnvironmentProfile", params, optFns, c.addOperationGetEnvironmentProfileMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEnvironmentProfileOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEnvironmentProfileInput struct {

	// The ID of the Amazon DataZone domain in which this environment profile exists.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the environment profile.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetEnvironmentProfileOutput struct {

	// The Amazon DataZone user who created this environment profile.
	//
	// This member is required.
	CreatedBy *string

	// The ID of the Amazon DataZone domain in which this environment profile exists.
	//
	// This member is required.
	DomainId *string

	// The ID of the blueprint with which this environment profile is created.
	//
	// This member is required.
	EnvironmentBlueprintId *string

	// The ID of the environment profile.
	//
	// This member is required.
	Id *string

	// The name of the environment profile.
	//
	// This member is required.
	Name *string

	// The ID of the Amazon Web Services account where this environment profile exists.
	AwsAccountId *string

	// The Amazon Web Services region where this environment profile exists.
	AwsAccountRegion *string

	// The timestamp of when this environment profile was created.
	CreatedAt *time.Time

	// The description of the environment profile.
	Description *string

	// The ID of the Amazon DataZone project in which this environment profile is
	// created.
	ProjectId *string

	// The timestamp of when this environment profile was upated.
	UpdatedAt *time.Time

	// The user parameters of the environment profile.
	UserParameters []types.CustomParameter

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEnvironmentProfileMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetEnvironmentProfile{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetEnvironmentProfile{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEnvironmentProfile"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetEnvironmentProfileValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEnvironmentProfile(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetEnvironmentProfile(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEnvironmentProfile",
	}
}
