// Code generated by smithy-go-codegen DO NOT EDIT.

package dataexchange

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/dataexchange/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAcceptDataGrant struct {
}

func (*validateOpAcceptDataGrant) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAcceptDataGrant) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AcceptDataGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAcceptDataGrantInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCancelJob struct {
}

func (*validateOpCancelJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateDataGrant struct {
}

func (*validateOpCreateDataGrant) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDataGrant) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDataGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDataGrantInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateDataSet struct {
}

func (*validateOpCreateDataSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDataSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDataSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDataSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateEventAction struct {
}

func (*validateOpCreateEventAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateEventAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateEventActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateEventActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateJob struct {
}

func (*validateOpCreateJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateRevision struct {
}

func (*validateOpCreateRevision) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateRevision) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateRevisionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateRevisionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAsset struct {
}

func (*validateOpDeleteAsset) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAsset) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAssetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAssetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDataGrant struct {
}

func (*validateOpDeleteDataGrant) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDataGrant) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDataGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDataGrantInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDataSet struct {
}

func (*validateOpDeleteDataSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDataSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDataSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDataSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteEventAction struct {
}

func (*validateOpDeleteEventAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteEventAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteEventActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteEventActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteRevision struct {
}

func (*validateOpDeleteRevision) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteRevision) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteRevisionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteRevisionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAsset struct {
}

func (*validateOpGetAsset) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAsset) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAssetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAssetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDataGrant struct {
}

func (*validateOpGetDataGrant) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDataGrant) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDataGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDataGrantInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDataSet struct {
}

func (*validateOpGetDataSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDataSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDataSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDataSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetEventAction struct {
}

func (*validateOpGetEventAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetEventAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetEventActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetEventActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetJob struct {
}

func (*validateOpGetJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetReceivedDataGrant struct {
}

func (*validateOpGetReceivedDataGrant) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetReceivedDataGrant) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetReceivedDataGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetReceivedDataGrantInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetRevision struct {
}

func (*validateOpGetRevision) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetRevision) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetRevisionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetRevisionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListDataSetRevisions struct {
}

func (*validateOpListDataSetRevisions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListDataSetRevisions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListDataSetRevisionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListDataSetRevisionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListRevisionAssets struct {
}

func (*validateOpListRevisionAssets) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListRevisionAssets) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListRevisionAssetsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListRevisionAssetsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRevokeRevision struct {
}

func (*validateOpRevokeRevision) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRevokeRevision) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RevokeRevisionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRevokeRevisionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSendApiAsset struct {
}

func (*validateOpSendApiAsset) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSendApiAsset) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SendApiAssetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSendApiAssetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSendDataSetNotification struct {
}

func (*validateOpSendDataSetNotification) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSendDataSetNotification) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SendDataSetNotificationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSendDataSetNotificationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartJob struct {
}

func (*validateOpStartJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateAsset struct {
}

func (*validateOpUpdateAsset) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateAsset) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateAssetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateAssetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateDataSet struct {
}

func (*validateOpUpdateDataSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateDataSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateDataSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateDataSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateEventAction struct {
}

func (*validateOpUpdateEventAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateEventAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateEventActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateEventActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateRevision struct {
}

func (*validateOpUpdateRevision) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateRevision) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateRevisionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateRevisionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAcceptDataGrantValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAcceptDataGrant{}, middleware.After)
}

func addOpCancelJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelJob{}, middleware.After)
}

func addOpCreateDataGrantValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDataGrant{}, middleware.After)
}

func addOpCreateDataSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDataSet{}, middleware.After)
}

func addOpCreateEventActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateEventAction{}, middleware.After)
}

func addOpCreateJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateJob{}, middleware.After)
}

func addOpCreateRevisionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateRevision{}, middleware.After)
}

func addOpDeleteAssetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAsset{}, middleware.After)
}

func addOpDeleteDataGrantValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDataGrant{}, middleware.After)
}

func addOpDeleteDataSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDataSet{}, middleware.After)
}

func addOpDeleteEventActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteEventAction{}, middleware.After)
}

func addOpDeleteRevisionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteRevision{}, middleware.After)
}

func addOpGetAssetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAsset{}, middleware.After)
}

func addOpGetDataGrantValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDataGrant{}, middleware.After)
}

func addOpGetDataSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDataSet{}, middleware.After)
}

func addOpGetEventActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetEventAction{}, middleware.After)
}

func addOpGetJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetJob{}, middleware.After)
}

func addOpGetReceivedDataGrantValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetReceivedDataGrant{}, middleware.After)
}

func addOpGetRevisionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetRevision{}, middleware.After)
}

func addOpListDataSetRevisionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListDataSetRevisions{}, middleware.After)
}

func addOpListRevisionAssetsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListRevisionAssets{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpRevokeRevisionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRevokeRevision{}, middleware.After)
}

func addOpSendApiAssetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSendApiAsset{}, middleware.After)
}

func addOpSendDataSetNotificationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSendDataSetNotification{}, middleware.After)
}

func addOpStartJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartJob{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateAssetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateAsset{}, middleware.After)
}

func addOpUpdateDataSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateDataSet{}, middleware.After)
}

func addOpUpdateEventActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateEventAction{}, middleware.After)
}

func addOpUpdateRevisionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateRevision{}, middleware.After)
}

func validateAction(v *types.Action) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Action"}
	if v.ExportRevisionToS3 != nil {
		if err := validateAutoExportRevisionToS3RequestDetails(v.ExportRevisionToS3); err != nil {
			invalidParams.AddNested("ExportRevisionToS3", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAssetDestinationEntry(v *types.AssetDestinationEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssetDestinationEntry"}
	if v.AssetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetId"))
	}
	if v.Bucket == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Bucket"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAssetSourceEntry(v *types.AssetSourceEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssetSourceEntry"}
	if v.Bucket == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Bucket"))
	}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAutoExportRevisionDestinationEntry(v *types.AutoExportRevisionDestinationEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutoExportRevisionDestinationEntry"}
	if v.Bucket == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Bucket"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAutoExportRevisionToS3RequestDetails(v *types.AutoExportRevisionToS3RequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutoExportRevisionToS3RequestDetails"}
	if v.Encryption != nil {
		if err := validateExportServerSideEncryption(v.Encryption); err != nil {
			invalidParams.AddNested("Encryption", err.(smithy.InvalidParamsError))
		}
	}
	if v.RevisionDestination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionDestination"))
	} else if v.RevisionDestination != nil {
		if err := validateAutoExportRevisionDestinationEntry(v.RevisionDestination); err != nil {
			invalidParams.AddNested("RevisionDestination", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateS3DataAccessFromS3BucketRequestDetails(v *types.CreateS3DataAccessFromS3BucketRequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateS3DataAccessFromS3BucketRequestDetails"}
	if v.AssetSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetSource"))
	} else if v.AssetSource != nil {
		if err := validateS3DataAccessAssetSourceEntry(v.AssetSource); err != nil {
			invalidParams.AddNested("AssetSource", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDatabaseLFTagPolicyAndPermissions(v *types.DatabaseLFTagPolicyAndPermissions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DatabaseLFTagPolicyAndPermissions"}
	if v.Expression == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Expression"))
	} else if v.Expression != nil {
		if err := validateListOfLFTags(v.Expression); err != nil {
			invalidParams.AddNested("Expression", err.(smithy.InvalidParamsError))
		}
	}
	if v.Permissions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Permissions"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDeprecationRequestDetails(v *types.DeprecationRequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeprecationRequestDetails"}
	if v.DeprecationAt == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeprecationAt"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEvent(v *types.Event) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Event"}
	if v.RevisionPublished != nil {
		if err := validateRevisionPublished(v.RevisionPublished); err != nil {
			invalidParams.AddNested("RevisionPublished", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExportAssetsToS3RequestDetails(v *types.ExportAssetsToS3RequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportAssetsToS3RequestDetails"}
	if v.AssetDestinations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetDestinations"))
	} else if v.AssetDestinations != nil {
		if err := validateListOfAssetDestinationEntry(v.AssetDestinations); err != nil {
			invalidParams.AddNested("AssetDestinations", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.Encryption != nil {
		if err := validateExportServerSideEncryption(v.Encryption); err != nil {
			invalidParams.AddNested("Encryption", err.(smithy.InvalidParamsError))
		}
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExportAssetToSignedUrlRequestDetails(v *types.ExportAssetToSignedUrlRequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportAssetToSignedUrlRequestDetails"}
	if v.AssetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetId"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExportRevisionsToS3RequestDetails(v *types.ExportRevisionsToS3RequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportRevisionsToS3RequestDetails"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.Encryption != nil {
		if err := validateExportServerSideEncryption(v.Encryption); err != nil {
			invalidParams.AddNested("Encryption", err.(smithy.InvalidParamsError))
		}
	}
	if v.RevisionDestinations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionDestinations"))
	} else if v.RevisionDestinations != nil {
		if err := validateListOfRevisionDestinationEntry(v.RevisionDestinations); err != nil {
			invalidParams.AddNested("RevisionDestinations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExportServerSideEncryption(v *types.ExportServerSideEncryption) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExportServerSideEncryption"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImportAssetFromApiGatewayApiRequestDetails(v *types.ImportAssetFromApiGatewayApiRequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImportAssetFromApiGatewayApiRequestDetails"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.ApiName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiName"))
	}
	if v.ApiSpecificationMd5Hash == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiSpecificationMd5Hash"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if len(v.ProtocolType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ProtocolType"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if v.Stage == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Stage"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImportAssetFromSignedUrlRequestDetails(v *types.ImportAssetFromSignedUrlRequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImportAssetFromSignedUrlRequestDetails"}
	if v.AssetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetName"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.Md5Hash == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Md5Hash"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImportAssetsFromLakeFormationTagPolicyRequestDetails(v *types.ImportAssetsFromLakeFormationTagPolicyRequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImportAssetsFromLakeFormationTagPolicyRequestDetails"}
	if v.CatalogId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CatalogId"))
	}
	if v.Database != nil {
		if err := validateDatabaseLFTagPolicyAndPermissions(v.Database); err != nil {
			invalidParams.AddNested("Database", err.(smithy.InvalidParamsError))
		}
	}
	if v.Table != nil {
		if err := validateTableLFTagPolicyAndPermissions(v.Table); err != nil {
			invalidParams.AddNested("Table", err.(smithy.InvalidParamsError))
		}
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImportAssetsFromRedshiftDataSharesRequestDetails(v *types.ImportAssetsFromRedshiftDataSharesRequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImportAssetsFromRedshiftDataSharesRequestDetails"}
	if v.AssetSources == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetSources"))
	} else if v.AssetSources != nil {
		if err := validateListOfRedshiftDataShareAssetSourceEntry(v.AssetSources); err != nil {
			invalidParams.AddNested("AssetSources", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImportAssetsFromS3RequestDetails(v *types.ImportAssetsFromS3RequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImportAssetsFromS3RequestDetails"}
	if v.AssetSources == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetSources"))
	} else if v.AssetSources != nil {
		if err := validateListOfAssetSourceEntry(v.AssetSources); err != nil {
			invalidParams.AddNested("AssetSources", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKmsKeyToGrant(v *types.KmsKeyToGrant) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KmsKeyToGrant"}
	if v.KmsKeyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KmsKeyArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLFTag(v *types.LFTag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LFTag"}
	if v.TagKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKey"))
	}
	if v.TagValues == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagValues"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListOfAssetDestinationEntry(v []types.AssetDestinationEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfAssetDestinationEntry"}
	for i := range v {
		if err := validateAssetDestinationEntry(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListOfAssetSourceEntry(v []types.AssetSourceEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfAssetSourceEntry"}
	for i := range v {
		if err := validateAssetSourceEntry(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListOfKmsKeysToGrant(v []types.KmsKeyToGrant) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfKmsKeysToGrant"}
	for i := range v {
		if err := validateKmsKeyToGrant(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListOfLFTags(v []types.LFTag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfLFTags"}
	for i := range v {
		if err := validateLFTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListOfRedshiftDataShareAssetSourceEntry(v []types.RedshiftDataShareAssetSourceEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfRedshiftDataShareAssetSourceEntry"}
	for i := range v {
		if err := validateRedshiftDataShareAssetSourceEntry(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListOfRedshiftDataShares(v []types.RedshiftDataShareDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfRedshiftDataShares"}
	for i := range v {
		if err := validateRedshiftDataShareDetails(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListOfRevisionDestinationEntry(v []types.RevisionDestinationEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfRevisionDestinationEntry"}
	for i := range v {
		if err := validateRevisionDestinationEntry(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListOfSchemaChangeDetails(v []types.SchemaChangeDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOfSchemaChangeDetails"}
	for i := range v {
		if err := validateSchemaChangeDetails(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNotificationDetails(v *types.NotificationDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NotificationDetails"}
	if v.Deprecation != nil {
		if err := validateDeprecationRequestDetails(v.Deprecation); err != nil {
			invalidParams.AddNested("Deprecation", err.(smithy.InvalidParamsError))
		}
	}
	if v.SchemaChange != nil {
		if err := validateSchemaChangeRequestDetails(v.SchemaChange); err != nil {
			invalidParams.AddNested("SchemaChange", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRedshiftDataShareAssetSourceEntry(v *types.RedshiftDataShareAssetSourceEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RedshiftDataShareAssetSourceEntry"}
	if v.DataShareArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataShareArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRedshiftDataShareDetails(v *types.RedshiftDataShareDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RedshiftDataShareDetails"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if v.Database == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Database"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRequestDetails(v *types.RequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RequestDetails"}
	if v.ExportAssetToSignedUrl != nil {
		if err := validateExportAssetToSignedUrlRequestDetails(v.ExportAssetToSignedUrl); err != nil {
			invalidParams.AddNested("ExportAssetToSignedUrl", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExportAssetsToS3 != nil {
		if err := validateExportAssetsToS3RequestDetails(v.ExportAssetsToS3); err != nil {
			invalidParams.AddNested("ExportAssetsToS3", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExportRevisionsToS3 != nil {
		if err := validateExportRevisionsToS3RequestDetails(v.ExportRevisionsToS3); err != nil {
			invalidParams.AddNested("ExportRevisionsToS3", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImportAssetFromSignedUrl != nil {
		if err := validateImportAssetFromSignedUrlRequestDetails(v.ImportAssetFromSignedUrl); err != nil {
			invalidParams.AddNested("ImportAssetFromSignedUrl", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImportAssetsFromS3 != nil {
		if err := validateImportAssetsFromS3RequestDetails(v.ImportAssetsFromS3); err != nil {
			invalidParams.AddNested("ImportAssetsFromS3", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImportAssetsFromRedshiftDataShares != nil {
		if err := validateImportAssetsFromRedshiftDataSharesRequestDetails(v.ImportAssetsFromRedshiftDataShares); err != nil {
			invalidParams.AddNested("ImportAssetsFromRedshiftDataShares", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImportAssetFromApiGatewayApi != nil {
		if err := validateImportAssetFromApiGatewayApiRequestDetails(v.ImportAssetFromApiGatewayApi); err != nil {
			invalidParams.AddNested("ImportAssetFromApiGatewayApi", err.(smithy.InvalidParamsError))
		}
	}
	if v.CreateS3DataAccessFromS3Bucket != nil {
		if err := validateCreateS3DataAccessFromS3BucketRequestDetails(v.CreateS3DataAccessFromS3Bucket); err != nil {
			invalidParams.AddNested("CreateS3DataAccessFromS3Bucket", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImportAssetsFromLakeFormationTagPolicy != nil {
		if err := validateImportAssetsFromLakeFormationTagPolicyRequestDetails(v.ImportAssetsFromLakeFormationTagPolicy); err != nil {
			invalidParams.AddNested("ImportAssetsFromLakeFormationTagPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRevisionDestinationEntry(v *types.RevisionDestinationEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RevisionDestinationEntry"}
	if v.Bucket == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Bucket"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRevisionPublished(v *types.RevisionPublished) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RevisionPublished"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3DataAccessAssetSourceEntry(v *types.S3DataAccessAssetSourceEntry) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3DataAccessAssetSourceEntry"}
	if v.Bucket == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Bucket"))
	}
	if v.KmsKeysToGrant != nil {
		if err := validateListOfKmsKeysToGrant(v.KmsKeysToGrant); err != nil {
			invalidParams.AddNested("KmsKeysToGrant", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSchemaChangeDetails(v *types.SchemaChangeDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SchemaChangeDetails"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSchemaChangeRequestDetails(v *types.SchemaChangeRequestDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SchemaChangeRequestDetails"}
	if v.Changes != nil {
		if err := validateListOfSchemaChangeDetails(v.Changes); err != nil {
			invalidParams.AddNested("Changes", err.(smithy.InvalidParamsError))
		}
	}
	if v.SchemaChangeAt == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SchemaChangeAt"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScopeDetails(v *types.ScopeDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScopeDetails"}
	if v.RedshiftDataShares != nil {
		if err := validateListOfRedshiftDataShares(v.RedshiftDataShares); err != nil {
			invalidParams.AddNested("RedshiftDataShares", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTableLFTagPolicyAndPermissions(v *types.TableLFTagPolicyAndPermissions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TableLFTagPolicyAndPermissions"}
	if v.Expression == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Expression"))
	} else if v.Expression != nil {
		if err := validateListOfLFTags(v.Expression); err != nil {
			invalidParams.AddNested("Expression", err.(smithy.InvalidParamsError))
		}
	}
	if v.Permissions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Permissions"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAcceptDataGrantInput(v *AcceptDataGrantInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AcceptDataGrantInput"}
	if v.DataGrantArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataGrantArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelJobInput(v *CancelJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDataGrantInput(v *CreateDataGrantInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDataGrantInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.GrantDistributionScope) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("GrantDistributionScope"))
	}
	if v.ReceiverPrincipal == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReceiverPrincipal"))
	}
	if v.SourceDataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceDataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDataSetInput(v *CreateDataSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDataSetInput"}
	if len(v.AssetType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AssetType"))
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateEventActionInput(v *CreateEventActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateEventActionInput"}
	if v.Action == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	} else if v.Action != nil {
		if err := validateAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if v.Event == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Event"))
	} else if v.Event != nil {
		if err := validateEvent(v.Event); err != nil {
			invalidParams.AddNested("Event", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateJobInput(v *CreateJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateJobInput"}
	if v.Details == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Details"))
	} else if v.Details != nil {
		if err := validateRequestDetails(v.Details); err != nil {
			invalidParams.AddNested("Details", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateRevisionInput(v *CreateRevisionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateRevisionInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAssetInput(v *DeleteAssetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAssetInput"}
	if v.AssetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetId"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDataGrantInput(v *DeleteDataGrantInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDataGrantInput"}
	if v.DataGrantId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataGrantId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDataSetInput(v *DeleteDataSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDataSetInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteEventActionInput(v *DeleteEventActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteEventActionInput"}
	if v.EventActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventActionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteRevisionInput(v *DeleteRevisionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteRevisionInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAssetInput(v *GetAssetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAssetInput"}
	if v.AssetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetId"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDataGrantInput(v *GetDataGrantInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDataGrantInput"}
	if v.DataGrantId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataGrantId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDataSetInput(v *GetDataSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDataSetInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetEventActionInput(v *GetEventActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetEventActionInput"}
	if v.EventActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventActionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetJobInput(v *GetJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetReceivedDataGrantInput(v *GetReceivedDataGrantInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetReceivedDataGrantInput"}
	if v.DataGrantArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataGrantArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetRevisionInput(v *GetRevisionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetRevisionInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListDataSetRevisionsInput(v *ListDataSetRevisionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListDataSetRevisionsInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListRevisionAssetsInput(v *ListRevisionAssetsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListRevisionAssetsInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRevokeRevisionInput(v *RevokeRevisionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RevokeRevisionInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if v.RevocationComment == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevocationComment"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSendApiAssetInput(v *SendApiAssetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SendApiAssetInput"}
	if v.AssetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetId"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSendDataSetNotificationInput(v *SendDataSetNotificationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SendDataSetNotificationInput"}
	if v.Scope != nil {
		if err := validateScopeDetails(v.Scope); err != nil {
			invalidParams.AddNested("Scope", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.Details != nil {
		if err := validateNotificationDetails(v.Details); err != nil {
			invalidParams.AddNested("Details", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartJobInput(v *StartJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateAssetInput(v *UpdateAssetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateAssetInput"}
	if v.AssetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetId"))
	}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateDataSetInput(v *UpdateDataSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateDataSetInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateEventActionInput(v *UpdateEventActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateEventActionInput"}
	if v.Action != nil {
		if err := validateAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if v.EventActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventActionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateRevisionInput(v *UpdateRevisionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateRevisionInput"}
	if v.DataSetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSetId"))
	}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
