// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the template information for a specific object type.
//
// A template is a predefined ProfileObjectType, such as “Salesforce-Account” or
// “Salesforce-Contact.” When a user sends a ProfileObject, using the
// PutProfileObject API, with an ObjectTypeName that matches one of the
// TemplateIds, it uses the mappings from the template.
func (c *Client) GetProfileObjectTypeTemplate(ctx context.Context, params *GetProfileObjectTypeTemplateInput, optFns ...func(*Options)) (*GetProfileObjectTypeTemplateOutput, error) {
	if params == nil {
		params = &GetProfileObjectTypeTemplateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetProfileObjectTypeTemplate", params, optFns, c.addOperationGetProfileObjectTypeTemplateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetProfileObjectTypeTemplateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetProfileObjectTypeTemplateInput struct {

	// A unique identifier for the object template.
	//
	// This member is required.
	TemplateId *string

	noSmithyDocumentSerde
}

type GetProfileObjectTypeTemplateOutput struct {

	// Indicates whether a profile should be created when data is received if one
	// doesn’t exist for an object of this type. The default is FALSE . If the
	// AllowProfileCreation flag is set to FALSE , then the service tries to fetch a
	// standard profile and associate this object with the profile. If it is set to
	// TRUE , and if no match is found, then the service creates a new standard profile.
	AllowProfileCreation bool

	// A map of the name and ObjectType field.
	Fields map[string]types.ObjectTypeField

	// A list of unique keys that can be used to map data to the profile.
	Keys map[string][]types.ObjectTypeKey

	// The format of your sourceLastUpdatedTimestamp that was previously set up.
	SourceLastUpdatedTimestampFormat *string

	// The name of the source of the object template.
	SourceName *string

	// The source of the object template.
	SourceObject *string

	// A unique identifier for the object template.
	TemplateId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetProfileObjectTypeTemplateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetProfileObjectTypeTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetProfileObjectTypeTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetProfileObjectTypeTemplate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetProfileObjectTypeTemplateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetProfileObjectTypeTemplate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetProfileObjectTypeTemplate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetProfileObjectTypeTemplate",
	}
}
