// Code generated by smithy-go-codegen DO NOT EDIT.

package costexplorer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/costexplorer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing cost anomaly subscription. Specify the fields that you want
// to update. Omitted fields are unchanged.
//
// The JSON below describes the generic construct for each type. See [Request Parameters] for possible
// values as they apply to AnomalySubscription .
//
// [Request Parameters]: https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_UpdateAnomalySubscription.html#API_UpdateAnomalySubscription_RequestParameters
func (c *Client) UpdateAnomalySubscription(ctx context.Context, params *UpdateAnomalySubscriptionInput, optFns ...func(*Options)) (*UpdateAnomalySubscriptionOutput, error) {
	if params == nil {
		params = &UpdateAnomalySubscriptionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAnomalySubscription", params, optFns, c.addOperationUpdateAnomalySubscriptionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAnomalySubscriptionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAnomalySubscriptionInput struct {

	// A cost anomaly subscription Amazon Resource Name (ARN).
	//
	// This member is required.
	SubscriptionArn *string

	// The update to the frequency value that subscribers receive notifications.
	Frequency types.AnomalySubscriptionFrequency

	// A list of cost anomaly monitor ARNs.
	MonitorArnList []string

	// The update to the subscriber list.
	Subscribers []types.Subscriber

	// The new name of the subscription.
	SubscriptionName *string

	// (deprecated)
	//
	// The update to the threshold value for receiving notifications.
	//
	// This field has been deprecated. To update a threshold, use ThresholdExpression.
	// Continued use of Threshold will be treated as shorthand syntax for a
	// ThresholdExpression.
	//
	// You can specify either Threshold or ThresholdExpression, but not both.
	//
	// Deprecated: Threshold has been deprecated in favor of ThresholdExpression
	Threshold *float64

	// The update to the [Expression] object used to specify the anomalies that you want to
	// generate alerts for. This supports dimensions and nested expressions. The
	// supported dimensions are ANOMALY_TOTAL_IMPACT_ABSOLUTE and
	// ANOMALY_TOTAL_IMPACT_PERCENTAGE , corresponding to an anomaly’s TotalImpact and
	// TotalImpactPercentage, respectively (see [Impact]for more details). The supported
	// nested expression types are AND and OR . The match option GREATER_THAN_OR_EQUAL
	// is required. Values must be numbers between 0 and 10,000,000,000 in string
	// format.
	//
	// You can specify either Threshold or ThresholdExpression, but not both.
	//
	// The following are examples of valid ThresholdExpressions:
	//
	//   - Absolute threshold: { "Dimensions": { "Key":
	//   "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ],
	//   "Values": [ "100" ] } }
	//
	//   - Percentage threshold: { "Dimensions": { "Key":
	//   "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ],
	//   "Values": [ "100" ] } }
	//
	//   - AND two thresholds together: { "And": [ { "Dimensions": { "Key":
	//   "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ],
	//   "Values": [ "100" ] } }, { "Dimensions": { "Key":
	//   "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ],
	//   "Values": [ "100" ] } } ] }
	//
	//   - OR two thresholds together: { "Or": [ { "Dimensions": { "Key":
	//   "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ],
	//   "Values": [ "100" ] } }, { "Dimensions": { "Key":
	//   "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ],
	//   "Values": [ "100" ] } } ] }
	//
	// [Impact]: https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Impact.html
	// [Expression]: https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html
	ThresholdExpression *types.Expression

	noSmithyDocumentSerde
}

type UpdateAnomalySubscriptionOutput struct {

	// A cost anomaly subscription ARN.
	//
	// This member is required.
	SubscriptionArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAnomalySubscriptionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateAnomalySubscription{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateAnomalySubscription{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAnomalySubscription"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAnomalySubscriptionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAnomalySubscription(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAnomalySubscription(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAnomalySubscription",
	}
}
