// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Instructs Amazon Connect to resume the authentication process. The subsequent
// actions depend on the request body contents:
//
//   - If a code is provided: Connect retrieves the identity information from
//     Amazon Cognito and imports it into Connect Customer Profiles.
//
//   - If an error is provided: The error branch of the Authenticate Customer
//     block is executed.
//
// The API returns a success response to acknowledge the request. However, the
// interaction and exchange of identity information occur asynchronously after the
// response is returned.
func (c *Client) UpdateParticipantAuthentication(ctx context.Context, params *UpdateParticipantAuthenticationInput, optFns ...func(*Options)) (*UpdateParticipantAuthenticationOutput, error) {
	if params == nil {
		params = &UpdateParticipantAuthenticationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateParticipantAuthentication", params, optFns, c.addOperationUpdateParticipantAuthenticationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateParticipantAuthenticationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateParticipantAuthenticationInput struct {

	// The identifier of the Amazon Connect instance. You can [find the instance ID] in the Amazon Resource
	// Name (ARN) of the instance.
	//
	// [find the instance ID]: https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html
	//
	// This member is required.
	InstanceId *string

	// The state query parameter that was provided by Cognito in the redirectUri . This
	// will also match the state parameter provided in the AuthenticationUrl from the [GetAuthenticationUrl]
	// response.
	//
	// [GetAuthenticationUrl]: https://docs.aws.amazon.com/connect/latest/APIReference/API_GetAuthenticationUrl.html
	//
	// This member is required.
	State *string

	// The code query parameter provided by Cognito in the redirectUri .
	Code *string

	// The error query parameter provided by Cognito in the redirectUri .
	Error *string

	// The error_description parameter provided by Cognito in the redirectUri .
	ErrorDescription *string

	noSmithyDocumentSerde
}

type UpdateParticipantAuthenticationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateParticipantAuthenticationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateParticipantAuthentication{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateParticipantAuthentication{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateParticipantAuthentication"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateParticipantAuthenticationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateParticipantAuthentication(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateParticipantAuthentication(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateParticipantAuthentication",
	}
}
