// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an inbound email contact and initiates a flow to start the email
// contact for the customer. Response of this API provides the ContactId of the
// email contact created.
func (c *Client) StartEmailContact(ctx context.Context, params *StartEmailContactInput, optFns ...func(*Options)) (*StartEmailContactOutput, error) {
	if params == nil {
		params = &StartEmailContactInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartEmailContact", params, optFns, c.addOperationStartEmailContactMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartEmailContactOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartEmailContactInput struct {

	// The email address associated with the instance.
	//
	// This member is required.
	DestinationEmailAddress *string

	// The email message body to be sent to the newly created email.
	//
	// This member is required.
	EmailMessage *types.InboundEmailContent

	// The email address of the customer.
	//
	// This member is required.
	FromEmailAddress *types.EmailAddressInfo

	// The identifier of the Amazon Connect instance. You can [find the instance ID] in the Amazon Resource
	// Name (ARN) of the instance.
	//
	// [find the instance ID]: https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html
	//
	// This member is required.
	InstanceId *string

	// The addtional recipients address of the email.
	AdditionalRecipients *types.InboundAdditionalRecipients

	// List of S3 presigned URLs of email attachments and their file name.
	Attachments []types.EmailAttachment

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in flows just like any other
	// contact attributes.
	//
	// There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact.
	// Attribute keys can include only alphanumeric, dash, and underscore characters.
	Attributes map[string]string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see [Making retries safe with idempotent APIs].
	//
	// [Making retries safe with idempotent APIs]: https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/
	ClientToken *string

	// The identifier of the flow for initiating the emails. To see the ContactFlowId
	// in the Amazon Connect admin website, on the navigation menu go to Routing,
	// Flows. Choose the flow. On the flow page, under the name of the flow, choose
	// Show additional flow information. The ContactFlowId is the last part of the ARN,
	// shown here in bold:
	//
	// arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/846ec553-a005-41c0-8341-xxxxxxxxxxxx
	ContactFlowId *string

	// A description of the email contact.
	Description *string

	// The name of a email that is shown to an agent in the Contact Control Panel
	// (CCP).
	Name *string

	// A formatted URL that is shown to an agent in the Contact Control Panel (CCP).
	// Emails can have the following reference types at the time of creation: URL |
	// NUMBER | STRING | DATE . EMAIL | EMAIL_MESSAGE | ATTACHMENT are not a supported
	// reference type during email creation.
	References map[string]types.Reference

	// The contactId that is related to this contact. Linking emails together by using
	// RelatedContactID copies over contact attributes from the related email contact
	// to the new email contact. All updates to user-defined attributes in the new
	// email contact are limited to the individual contact ID. There are no limits to
	// the number of contacts that can be linked by using RelatedContactId .
	RelatedContactId *string

	// A set of system defined key-value pairs stored on individual contact segments
	// using an attribute map. The attributes are standard Amazon Connect attributes.
	// They can be accessed in flows.
	//
	// Attribute keys can include only alphanumeric, -, and _.
	//
	// This field can be used to show channel subtype, such as connect:Guide .
	//
	// To set contact expiry, a ValueMap must be specified containing the integer
	// number of minutes the contact will be active for before expiring, with
	// SegmentAttributes like {  "connect:ContactExpiry": {"ValueMap" : {
	// "ExpiryDuration": { "ValueInteger":135}}}} .
	SegmentAttributes map[string]types.SegmentAttributeValue

	noSmithyDocumentSerde
}

type StartEmailContactOutput struct {

	// The identifier of this contact within the Amazon Connect instance.
	ContactId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartEmailContactMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartEmailContact{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartEmailContact{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartEmailContact"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartEmailContactMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartEmailContactValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartEmailContact(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartEmailContact struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartEmailContact) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartEmailContact) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartEmailContactInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartEmailContactInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartEmailContactMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartEmailContact{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartEmailContact(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartEmailContact",
	}
}
