// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets metric data from the specified Amazon Connect instance.
//
// GetMetricDataV2 offers more features than [GetMetricData], the previous version of this API.
// It has new metrics, offers filtering at a metric level, and offers the ability
// to filter and group data by channels, queues, routing profiles, agents, and
// agent hierarchy levels. It can retrieve historical data for the last 3 months,
// at varying intervals. It does not support agent queues.
//
// For a description of the historical metrics that are supported by
// GetMetricDataV2 and GetMetricData , see [Metrics definitions] in the Amazon Connect Administrator
// Guide.
//
// [GetMetricData]: https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html
// [Metrics definitions]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html
func (c *Client) GetMetricDataV2(ctx context.Context, params *GetMetricDataV2Input, optFns ...func(*Options)) (*GetMetricDataV2Output, error) {
	if params == nil {
		params = &GetMetricDataV2Input{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetMetricDataV2", params, optFns, c.addOperationGetMetricDataV2Middlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetMetricDataV2Output)
	out.ResultMetadata = metadata
	return out, nil
}

type GetMetricDataV2Input struct {

	// The timestamp, in UNIX Epoch time format, at which to end the reporting
	// interval for the retrieval of historical metrics data. The time must be later
	// than the start time timestamp. It cannot be later than the current timestamp.
	//
	// This member is required.
	EndTime *time.Time

	// The filters to apply to returned metrics. You can filter on the following
	// resources:
	//
	//   - Agents
	//
	//   - Campaigns
	//
	//   - Channels
	//
	//   - Feature
	//
	//   - Queues
	//
	//   - Routing profiles
	//
	//   - Routing step expression
	//
	//   - User hierarchy groups
	//
	// At least one filter must be passed from queues, routing profiles, agents, or
	// user hierarchy groups.
	//
	// For metrics for outbound campaigns analytics, you can also use campaigns to
	// satisfy at least one filter requirement.
	//
	// To filter by phone number, see [Create a historical metrics report] in the Amazon Connect Administrator Guide.
	//
	// Note the following limits:
	//
	//   - Filter keys: A maximum of 5 filter keys are supported in a single request.
	//   Valid filter keys: AGENT | AGENT_HIERARCHY_LEVEL_ONE |
	//   AGENT_HIERARCHY_LEVEL_TWO | AGENT_HIERARCHY_LEVEL_THREE |
	//   AGENT_HIERARCHY_LEVEL_FOUR | AGENT_HIERARCHY_LEVEL_FIVE |
	//   ANSWERING_MACHINE_DETECTION_STATUS | BOT_ID | BOT_ALIAS | BOT_VERSION |
	//   BOT_LOCALE | BOT_INTENT_NAME | CAMPAIGN | CAMPAIGN_DELIVERY_EVENT_TYPE |
	//   CASE_TEMPLATE_ARN | CASE_STATUS | CHANNEL |
	//   contact/segmentAttributes/connect:Subtype | DISCONNECT_REASON |
	//   EVALUATION_FORM | EVALUATION_SECTION | EVALUATION_QUESTION | EVALUATION_SOURCE
	//   | FEATURE | FLOW_ACTION_ID | FLOW_TYPE | FLOWS_MODULE_RESOURCE_ID |
	//   FLOWS_NEXT_RESOURCE_ID | FLOWS_NEXT_RESOURCE_QUEUE_ID | FLOWS_OUTCOME_TYPE |
	//   FLOWS_RESOURCE_ID | FORM_VERSION | INITIATION_METHOD |
	//   INVOKING_RESOURCE_PUBLISHED_TIMESTAMP | INVOKING_RESOURCE_TYPE |
	//   PARENT_FLOWS_RESOURCE_ID | RESOURCE_PUBLISHED_TIMESTAMP | ROUTING_PROFILE |
	//   ROUTING_STEP_EXPRESSION | QUEUE | Q_CONNECT_ENABLED |
	//
	//   - Filter values: A maximum of 100 filter values are supported in a single
	//   request. VOICE, CHAT, and TASK are valid filterValue for the CHANNEL filter
	//   key. They do not count towards limitation of 100 filter values. For example, a
	//   GetMetricDataV2 request can filter by 50 queues, 35 agents, and 15 routing
	//   profiles for a total of 100 filter values, along with 3 channel filters.
	//
	// contact_lens_conversational_analytics is a valid filterValue for the FEATURE
	//   filter key. It is available only to contacts analyzed by Contact Lens
	//   conversational analytics.
	//
	// connect:Chat , connect:SMS , connect:Telephony , and connect:WebRTC are valid
	//   filterValue examples (not exhaustive) for the
	//   contact/segmentAttributes/connect:Subtype filter key.
	//
	// ROUTING_STEP_EXPRESSION is a valid filter key with a filter value up to 3000
	//   length. This filter is case and order sensitive. JSON string fields must be
	//   sorted in ascending order and JSON array order should be kept as is.
	//
	// Q_CONNECT_ENABLED . TRUE and FALSE are the only valid filterValues for the
	//   Q_CONNECT_ENABLED filter key.
	//
	//   - TRUE includes all contacts that had Amazon Q in Connect enabled as part of
	//   the flow.
	//
	//   - FALSE includes all contacts that did not have Amazon Q in Connect enabled
	//   as part of the flow
	//
	// This filter is available only for contact record-driven metrics.
	//
	// [Campaign]ARNs are valid filterValues for the CAMPAIGN filter key.
	//
	// [Create a historical metrics report]: https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html
	// [Campaign]: https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-outbound-campaigns_Campaign.html
	//
	// This member is required.
	Filters []types.FilterV2

	// The metrics to retrieve. Specify the name, groupings, and filters for each
	// metric. The following historical metrics are available. For a description of
	// each metric, see [Metrics definition]in the Amazon Connect Administrator Guide.
	//
	// ABANDONMENT_RATE Unit: Percent
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Abandonment rate]
	//
	// AGENT_ADHERENT_TIME This metric is available only in Amazon Web Services
	// Regions where [Forecasting, capacity planning, and scheduling]is available.
	//
	// Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy
	//
	// UI name: [Adherent time]
	//
	// AGENT_ANSWER_RATE Unit: Percent
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy
	//
	// UI name: [Agent answer rate]
	//
	// AGENT_NON_ADHERENT_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy
	//
	// UI name: [Non-adherent time]
	//
	// AGENT_NON_RESPONSE Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy
	//
	// UI name: [Agent non-response]
	//
	// AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy
	//
	// Data for this metric is available starting from October 1, 2023 0:00:00 GMT.
	//
	// UI name: [Agent non-response without customer abandons]
	//
	// AGENT_OCCUPANCY Unit: Percentage
	//
	// Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
	//
	// UI name: [Occupancy]
	//
	// AGENT_SCHEDULE_ADHERENCE This metric is available only in Amazon Web Services
	// Regions where [Forecasting, capacity planning, and scheduling]is available.
	//
	// Unit: Percent
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy
	//
	// UI name: [Adherence]
	//
	// AGENT_SCHEDULED_TIME This metric is available only in Amazon Web Services
	// Regions where [Forecasting, capacity planning, and scheduling]is available.
	//
	// Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy
	//
	// UI name: [Scheduled time]
	//
	// AVG_ABANDON_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average queue abandon time]
	//
	// AVG_ACTIVE_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Q in Connect
	//
	// UI name: [Average active time]
	//
	// AVG_AFTER_CONTACT_WORK_TIME Unit: Seconds
	//
	// Valid metric filter key: INITIATION_METHOD
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average after contact work time]
	//
	// Feature is a valid filter but not a valid grouping.
	//
	// AVG_AGENT_CONNECTING_TIME Unit: Seconds
	//
	// Valid metric filter key: INITIATION_METHOD . For now, this metric only supports
	// the following as INITIATION_METHOD : INBOUND | OUTBOUND | CALLBACK | API
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy
	//
	// UI name: [Average agent API connecting time]
	//
	// The Negate key in metric-level filters is not applicable for this metric.
	//
	// AVG_AGENT_PAUSE_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Q in Connect
	//
	// UI name: [Average agent pause time]
	//
	// AVG_BOT_CONVERSATION_TIME Unit: Seconds
	//
	// Valid groupings and filters: Channel,
	// contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot version, Bot
	// locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
	// Invoking resource published timestamp, Initiation method, Invoking resource
	// type, Parent flows resource ID
	//
	// UI name: [Average bot conversation time]
	//
	// AVG_BOT_CONVERSATION_TURNS Unit: Count
	//
	// Valid groupings and filters: Channel,
	// contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot version, Bot
	// locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
	// Invoking resource published timestamp, Initiation method, Invoking resource
	// type, Parent flows resource ID
	//
	// UI name: [Average bot conversation turns]
	//
	// AVG_CASE_RELATED_CONTACTS Unit: Count
	//
	// Required filter key: CASE_TEMPLATE_ARN
	//
	// Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
	//
	// UI name: [Average contacts per case]
	//
	// AVG_CASE_RESOLUTION_TIME Unit: Seconds
	//
	// Required filter key: CASE_TEMPLATE_ARN
	//
	// Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
	//
	// UI name: [Average case resolution time]
	//
	// AVG_CONTACT_DURATION Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average contact duration]
	//
	// Feature is a valid filter but not a valid grouping.
	//
	// AVG_CONVERSATION_DURATION Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average conversation duration]
	//
	// AVG_DIALS_PER_MINUTE This metric is available only for outbound campaigns that
	// use the agent assisted voice and automated voice delivery modes.
	//
	// Unit: Count
	//
	// Valid groupings and filters: Agent, Campaign, Queue, Routing Profile
	//
	// UI name: [Average dials per minute]
	//
	// AVG_EVALUATION_SCORE Unit: Percent
	//
	// Valid groupings and filters: Agent, Agent Hierarchy, Channel, Evaluation Form
	// ID, Evaluation Section ID, Evaluation Question ID, Evaluation Source, Form
	// Version, Queue, Routing Profile
	//
	// UI name: [Average evaluation score]
	//
	// AVG_FLOW_TIME Unit: Seconds
	//
	// Valid groupings and filters: Channel,
	// contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID,
	// Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
	// resource ID, Initiation method, Resource published timestamp
	//
	// UI name: [Average flow time]
	//
	// AVG_GREETING_TIME_AGENT This metric is available only for contacts analyzed by
	// Contact Lens conversational analytics.
	//
	// Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average agent greeting time]
	//
	// AVG_HANDLE_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Feature, contact/segmentAttributes/connect:Subtype,
	// RoutingStepExpression
	//
	// UI name: [Average handle time]
	//
	// Feature is a valid filter but not a valid grouping.
	//
	// AVG_HOLD_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average customer hold time]
	//
	// Feature is a valid filter but not a valid grouping.
	//
	// AVG_HOLD_TIME_ALL_CONTACTS Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average customer hold time all contacts]
	//
	// AVG_HOLDS Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average holds]
	//
	// Feature is a valid filter but not a valid grouping.
	//
	// AVG_INTERACTION_AND_HOLD_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average agent interaction and customer hold time]
	//
	// AVG_INTERACTION_TIME Unit: Seconds
	//
	// Valid metric filter key: INITIATION_METHOD
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
	// contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average agent interaction time]
	//
	// Feature is a valid filter but not a valid grouping.
	//
	// AVG_INTERRUPTIONS_AGENT This metric is available only for contacts analyzed by
	// Contact Lens conversational analytics.
	//
	// Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average agent interruptions]
	//
	// AVG_INTERRUPTION_TIME_AGENT This metric is available only for contacts analyzed
	// by Contact Lens conversational analytics.
	//
	// Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average agent interruption time]
	//
	// AVG_NON_TALK_TIME This metric is available only for contacts analyzed by
	// Contact Lens conversational analytics.
	//
	// Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average non-talk time]
	//
	// AVG_QUEUE_ANSWER_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
	// contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average queue answer time]
	//
	// Feature is a valid filter but not a valid grouping.
	//
	// AVG_RESOLUTION_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile,
	// contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average resolution time]
	//
	// AVG_TALK_TIME This metric is available only for contacts analyzed by Contact
	// Lens conversational analytics.
	//
	// Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average talk time]
	//
	// AVG_TALK_TIME_AGENT This metric is available only for contacts analyzed by
	// Contact Lens conversational analytics.
	//
	// Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average agent talk time]
	//
	// AVG_TALK_TIME_CUSTOMER This metric is available only for contacts analyzed by
	// Contact Lens conversational analytics.
	//
	// Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Average customer talk time]
	//
	// AVG_WAIT_TIME_AFTER_CUSTOMER_CONNECTION This metric is available only for
	// outbound campaigns that use the agent assisted voice and automated voice
	// delivery modes.
	//
	// Unit: Seconds
	//
	// Valid groupings and filters: Campaign
	//
	// UI name: [Average wait time after customer connection]
	//
	// AVG_WEIGHTED_EVALUATION_SCORE Unit: Percent
	//
	// Valid groupings and filters: Agent, Agent Hierarchy, Channel, Evaluation Form
	// Id, Evaluation Section ID, Evaluation Question ID, Evaluation Source, Form
	// Version, Queue, Routing Profile
	//
	// UI name: [Average weighted evaluation score]
	//
	// BOT_CONVERSATIONS_COMPLETED Unit: Count
	//
	// Valid groupings and filters: Channel,
	// contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot version, Bot
	// locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
	// Invoking resource published timestamp, Initiation method, Invoking resource
	// type, Parent flows resource ID
	//
	// UI name: [Bot conversations completed]
	//
	// BOT_INTENTS_COMPLETED Unit: Count
	//
	// Valid groupings and filters: Channel,
	// contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot version, Bot
	// locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type,
	// Flow action ID, Invoking resource published timestamp, Initiation method,
	// Invoking resource type, Parent flows resource ID
	//
	// UI name: [Bot intents completed]
	//
	// CAMPAIGN_CONTACTS_ABANDONED_AFTER_X This metric is available only for outbound
	// campaigns using the agent assisted voice and automated voice delivery modes.
	//
	// Unit: Count
	//
	// Valid groupings and filters: Agent, Campaign
	//
	// Threshold: For ThresholdValue , enter any whole number from 1 to 604800
	// (inclusive), in seconds. For Comparison , you must enter GT (for Greater than).
	//
	// UI name: [Campaign contacts abandoned after X]
	//
	// CAMPAIGN_CONTACTS_ABANDONED_AFTER_X_RATE This metric is available only for
	// outbound campaigns using the agent assisted voice and automated voice delivery
	// modes.
	//
	// Unit: Percent
	//
	// Valid groupings and filters: Agent, Campaign
	//
	// Threshold: For ThresholdValue , enter any whole number from 1 to 604800
	// (inclusive), in seconds. For Comparison , you must enter GT (for Greater than).
	//
	// UI name: [Campaign contacts abandoned after X rate]
	//
	// CAMPAIGN_INTERACTIONS This metric is available only for outbound campaigns
	// using the email delivery mode.
	//
	// Unit: Count
	//
	// Valid metric filter key: CAMPAIGN_INTERACTION_EVENT_TYPE
	//
	// Valid groupings and filters: Campaign
	//
	// UI name: [Campaign interactions]
	//
	// CAMPAIGN_SEND_ATTEMPTS This metric is available only for outbound campaigns.
	//
	// Unit: Count
	//
	// Valid groupings and filters: Campaign, Channel,
	// contact/segmentAttributes/connect:Subtype
	//
	// UI name: [Campaign send attempts]
	//
	// CASES_CREATED Unit: Count
	//
	// Required filter key: CASE_TEMPLATE_ARN
	//
	// Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
	//
	// UI name: [Cases created]
	//
	// CONTACTS_CREATED Unit: Count
	//
	// Valid metric filter key: INITIATION_METHOD
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
	// contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Contacts created]
	//
	// Feature is a valid filter but not a valid grouping.
	//
	// CONTACTS_HANDLED Unit: Count
	//
	// Valid metric filter key: INITIATION_METHOD , DISCONNECT_REASON
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Feature, contact/segmentAttributes/connect:Subtype,
	// RoutingStepExpression, Q in Connect
	//
	// UI name: [API contacts handled]
	//
	// Feature is a valid filter but not a valid grouping.
	//
	// CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT Unit: Count
	//
	// Valid metric filter key: INITIATION_METHOD
	//
	// Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
	// contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Contacts handled (connected to agent timestamp)]
	//
	// CONTACTS_HOLD_ABANDONS Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Contacts hold disconnect]
	//
	// CONTACTS_ON_HOLD_AGENT_DISCONNECT Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Q in Connect
	//
	// UI name: [Contacts hold agent disconnect]
	//
	// CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Q in Connect
	//
	// UI name: [Contacts hold customer disconnect]
	//
	// CONTACTS_PUT_ON_HOLD Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Q in Connect
	//
	// UI name: [Contacts put on hold]
	//
	// CONTACTS_TRANSFERRED_OUT_EXTERNAL Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Q in Connect
	//
	// UI name: [Contacts transferred out external]
	//
	// CONTACTS_TRANSFERRED_OUT_INTERNAL Unit: Percent
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Q in Connect
	//
	// UI name: [Contacts transferred out internal]
	//
	// CONTACTS_QUEUED Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Contacts queued]
	//
	// CONTACTS_QUEUED_BY_ENQUEUE Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
	// contact/segmentAttributes/connect:Subtype
	//
	// UI name: [Contacts queued (enqueue timestamp)]
	//
	// CONTACTS_REMOVED_FROM_QUEUE_IN_X Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
	//
	// Threshold: For ThresholdValue , enter any whole number from 1 to 604800
	// (inclusive), in seconds. For Comparison , you can use LT (for "Less than") or
	// LTE (for "Less than equal").
	//
	// UI name: [Contacts removed from queue in X seconds]
	//
	// CONTACTS_RESOLVED_IN_X Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile,
	// contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// Threshold: For ThresholdValue , enter any whole number from 1 to 604800
	// (inclusive), in seconds. For Comparison , you can use LT (for "Less than") or
	// LTE (for "Less than equal").
	//
	// UI name: [Contacts resolved in X]
	//
	// CONTACTS_TRANSFERRED_OUT Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Contacts transferred out]
	//
	// Feature is a valid filter but not a valid grouping.
	//
	// CONTACTS_TRANSFERRED_OUT_BY_AGENT Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Contacts transferred out by agent]
	//
	// CONTACTS_TRANSFERRED_OUT_FROM_QUEUE Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Contacts transferred out queue]
	//
	// CURRENT_CASES Unit: Count
	//
	// Required filter key: CASE_TEMPLATE_ARN
	//
	// Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
	//
	// UI name: [Current cases]
	//
	// DELIVERY_ATTEMPTS This metric is available only for outbound campaigns.
	//
	// Unit: Count
	//
	// Valid metric filter key: ANSWERING_MACHINE_DETECTION_STATUS ,
	// CAMPAIGN_DELIVERY_EVENT_TYPE , DISCONNECT_REASON
	//
	// Valid groupings and filters: Agent, Answering Machine Detection Status,
	// Campaign, Campaign Delivery EventType, Channel,
	// contact/segmentAttributes/connect:Subtype, Disconnect Reason, Queue, Routing
	// Profile
	//
	// UI name: [Delivery attempts]
	//
	// Campaign Delivery EventType filter and grouping are only available for SMS and
	// Email campaign delivery modes. Agent, Queue, Routing Profile, Answering Machine
	// Detection Status and Disconnect Reason are only available for agent assisted
	// voice and automated voice delivery modes.
	//
	// DELIVERY_ATTEMPT_DISPOSITION_RATE This metric is available only for outbound
	// campaigns. Dispositions for the agent assisted voice and automated voice
	// delivery modes are only available with answering machine detection enabled.
	//
	// Unit: Percent
	//
	// Valid metric filter key: ANSWERING_MACHINE_DETECTION_STATUS ,
	// CAMPAIGN_DELIVERY_EVENT_TYPE , DISCONNECT_REASON
	//
	// Valid groupings and filters: Agent, Answering Machine Detection Status,
	// Campaign, Channel, contact/segmentAttributes/connect:Subtype, Disconnect Reason,
	// Queue, Routing Profile
	//
	// UI name: [Delivery attempt disposition rate]
	//
	// Campaign Delivery Event Type filter and grouping are only available for SMS and
	// Email campaign delivery modes. Agent, Queue, Routing Profile, Answering Machine
	// Detection Status and Disconnect Reason are only available for agent assisted
	// voice and automated voice delivery modes.
	//
	// EVALUATIONS_PERFORMED Unit: Count
	//
	// Valid groupings and filters: Agent, Agent Hierarchy, Channel, Evaluation Form
	// ID, Evaluation Source, Form Version, Queue, Routing Profile
	//
	// UI name: [Evaluations performed]
	//
	// FLOWS_OUTCOME Unit: Count
	//
	// Valid groupings and filters: Channel,
	// contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID,
	// Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
	// resource ID, Initiation method, Resource published timestamp
	//
	// UI name: [Flows outcome]
	//
	// FLOWS_STARTED Unit: Count
	//
	// Valid groupings and filters: Channel,
	// contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID,
	// Flows resource ID, Initiation method, Resource published timestamp
	//
	// UI name: [Flows started]
	//
	// HUMAN_ANSWERED_CALLS This metric is available only for outbound campaigns.
	// Dispositions for the agent assisted voice and automated voice delivery modes are
	// only available with answering machine detection enabled.
	//
	// Unit: Count
	//
	// Valid groupings and filters: Agent, Campaign
	//
	// UI name: [Human answered]
	//
	// MAX_FLOW_TIME Unit: Seconds
	//
	// Valid groupings and filters: Channel,
	// contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID,
	// Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
	// resource ID, Initiation method, Resource published timestamp
	//
	// UI name: [Maximum flow time]
	//
	// MAX_QUEUED_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Maximum queued time]
	//
	// MIN_FLOW_TIME Unit: Seconds
	//
	// Valid groupings and filters: Channel,
	// contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID,
	// Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
	// resource ID, Initiation method, Resource published timestamp
	//
	// UI name: [Minimum flow time]
	//
	// PERCENT_AUTOMATIC_FAILS Unit: Percent
	//
	// Valid groupings and filters: Agent, Agent Hierarchy, Channel, Evaluation Form
	// ID, Evaluation Source, Form Version, Queue, Routing Profile
	//
	// UI name: [Automatic fails percent]
	//
	// PERCENT_BOT_CONVERSATIONS_OUTCOME Unit: Percent
	//
	// Valid groupings and filters: Channel,
	// contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot version, Bot
	// locale, Flows resource ID, Flows module resource ID, Flow type, Flow action ID,
	// Invoking resource published timestamp, Initiation method, Invoking resource
	// type, Parent flows resource ID
	//
	// UI name: [Percent bot conversations outcome]
	//
	// PERCENT_BOT_INTENTS_OUTCOME Unit: Percent
	//
	// Valid groupings and filters: Channel,
	// contact/segmentAttributes/connect:Subtype, Bot ID, Bot alias, Bot version, Bot
	// locale, Bot intent name, Flows resource ID, Flows module resource ID, Flow type,
	// Flow action ID, Invoking resource published timestamp, Initiation method,
	// Invoking resource type, Parent flows resource ID
	//
	// UI name: [Percent bot intents outcome]
	//
	// PERCENT_CASES_FIRST_CONTACT_RESOLVED Unit: Percent
	//
	// Required filter key: CASE_TEMPLATE_ARN
	//
	// Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
	//
	// UI name: [Cases resolved on first contact]
	//
	// PERCENT_CONTACTS_STEP_EXPIRED Unit: Percent
	//
	// Valid groupings and filters: Queue, RoutingStepExpression
	//
	// UI name: This metric is available in Real-time Metrics UI but not on the
	// Historical Metrics UI.
	//
	// PERCENT_CONTACTS_STEP_JOINED Unit: Percent
	//
	// Valid groupings and filters: Queue, RoutingStepExpression
	//
	// UI name: This metric is available in Real-time Metrics UI but not on the
	// Historical Metrics UI.
	//
	// PERCENT_FLOWS_OUTCOME Unit: Percent
	//
	// Valid metric filter key: FLOWS_OUTCOME_TYPE
	//
	// Valid groupings and filters: Channel,
	// contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID,
	// Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows
	// resource ID, Initiation method, Resource published timestamp
	//
	// UI name: [Flows outcome percentage].
	//
	// The FLOWS_OUTCOME_TYPE is not a valid grouping.
	//
	// PERCENT_NON_TALK_TIME This metric is available only for contacts analyzed by
	// Contact Lens conversational analytics.
	//
	// Unit: Percentage
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Non-talk time percent]
	//
	// PERCENT_TALK_TIME This metric is available only for contacts analyzed by
	// Contact Lens conversational analytics.
	//
	// Unit: Percentage
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Talk time percent]
	//
	// PERCENT_TALK_TIME_AGENT This metric is available only for contacts analyzed by
	// Contact Lens conversational analytics.
	//
	// Unit: Percentage
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Agent talk time percent]
	//
	// PERCENT_TALK_TIME_CUSTOMER This metric is available only for contacts analyzed
	// by Contact Lens conversational analytics.
	//
	// Unit: Percentage
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Customer talk time percent]
	//
	// REOPENED_CASE_ACTIONS Unit: Count
	//
	// Required filter key: CASE_TEMPLATE_ARN
	//
	// Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
	//
	// UI name: [Cases reopened]
	//
	// RESOLVED_CASE_ACTIONS Unit: Count
	//
	// Required filter key: CASE_TEMPLATE_ARN
	//
	// Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
	//
	// UI name: [Cases resolved]
	//
	// SERVICE_LEVEL You can include up to 20 SERVICE_LEVEL metrics in a request.
	//
	// Unit: Percent
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect
	//
	// Threshold: For ThresholdValue , enter any whole number from 1 to 604800
	// (inclusive), in seconds. For Comparison , you can use LT (for "Less than") or
	// LTE (for "Less than equal").
	//
	// UI name: [Service level X]
	//
	// STEP_CONTACTS_QUEUED Unit: Count
	//
	// Valid groupings and filters: Queue, RoutingStepExpression
	//
	// UI name: This metric is available in Real-time Metrics UI but not on the
	// Historical Metrics UI.
	//
	// SUM_AFTER_CONTACT_WORK_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Q in Connect
	//
	// UI name: [After contact work time]
	//
	// SUM_CONNECTING_TIME_AGENT Unit: Seconds
	//
	// Valid metric filter key: INITIATION_METHOD . This metric only supports the
	// following filter keys as INITIATION_METHOD : INBOUND | OUTBOUND | CALLBACK | API
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy
	//
	// UI name: [Agent API connecting time]
	//
	// The Negate key in metric-level filters is not applicable for this metric.
	//
	// CONTACTS_ABANDONED Unit: Count
	//
	// Metric filter:
	//
	//   - Valid values: API | Incoming | Outbound | Transfer | Callback |
	//   Queue_Transfer | Disconnect
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q
	// in Connect
	//
	// UI name: [Contact abandoned]
	//
	// SUM_CONTACTS_ABANDONED_IN_X Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile,
	// contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// Threshold: For ThresholdValue , enter any whole number from 1 to 604800
	// (inclusive), in seconds. For Comparison , you can use LT (for "Less than") or
	// LTE (for "Less than equal").
	//
	// UI name: [Contacts abandoned in X seconds]
	//
	// SUM_CONTACTS_ANSWERED_IN_X Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile,
	// contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// Threshold: For ThresholdValue , enter any whole number from 1 to 604800
	// (inclusive), in seconds. For Comparison , you can use LT (for "Less than") or
	// LTE (for "Less than equal").
	//
	// UI name: [Contacts answered in X seconds]
	//
	// SUM_CONTACT_FLOW_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Q in Connect
	//
	// UI name: [Contact flow time]
	//
	// SUM_CONTACT_TIME_AGENT Unit: Seconds
	//
	// Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
	//
	// UI name: [Agent on contact time]
	//
	// SUM_CONTACTS_DISCONNECTED Valid metric filter key: DISCONNECT_REASON
	//
	// Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Contact disconnected]
	//
	// SUM_ERROR_STATUS_TIME_AGENT Unit: Seconds
	//
	// Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
	//
	// UI name: [Error status time]
	//
	// SUM_HANDLE_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Q in Connect
	//
	// UI name: [Contact handle time]
	//
	// SUM_HOLD_TIME Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Q in Connect
	//
	// UI name: [Customer hold time]
	//
	// SUM_IDLE_TIME_AGENT Unit: Seconds
	//
	// Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
	//
	// UI name: [Agent idle time]
	//
	// SUM_INTERACTION_AND_HOLD_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy, Q in Connect
	//
	// UI name: [Agent interaction and hold time]
	//
	// SUM_INTERACTION_TIME Unit: Seconds
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent
	// Hierarchy
	//
	// UI name: [Agent interaction time]
	//
	// SUM_NON_PRODUCTIVE_TIME_AGENT Unit: Seconds
	//
	// Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
	//
	// UI name: [Agent non-productive time]
	//
	// SUM_ONLINE_TIME_AGENT Unit: Seconds
	//
	// Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
	//
	// UI name: [Online time]
	//
	// SUM_RETRY_CALLBACK_ATTEMPTS Unit: Count
	//
	// Valid groupings and filters: Queue, Channel, Routing Profile,
	// contact/segmentAttributes/connect:Subtype, Q in Connect
	//
	// UI name: [Callback attempts]
	//
	// [Contacts transferred out external]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-external
	// [Average agent greeting time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-greeting-time
	// [Non-talk time percent]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#non-talk-time-percent
	// [Agent non-productive time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-non-productive-time
	// [Contacts created]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-created
	// [Adherence]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#adherence
	// [Customer talk time percent]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#customer-talk-time-percent
	// [Average conversation duration]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-conversation-duration
	// [Flows outcome]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#flows-outcome
	// [Contacts queued]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-queued
	// [Occupancy]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#occupancy
	// [Percent bot conversations outcome]: https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-conversations-outcome
	// [Minimum flow time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#minimum-flow-time
	// [Percent bot intents outcome]: https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#percent-bot-intents-outcome
	// [Contacts answered in X seconds]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-answered-in-x-seconds
	// [Average case resolution time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-case-resolution-time
	// [Agent API connecting time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-api-connecting-time
	// [Talk time percent]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#talk-time-percent
	// [Average agent talk time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-talk-time
	// [Average agent interruption time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-interruption-time
	// [Contacts transferred out]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out
	// [Campaign send attempts]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#campaign-send-attempts
	// [Average bot conversation time]: https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-time
	// [Average flow time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-flow-time
	// [Contacts hold disconnect]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-hold-disconnect
	// [Average holds]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-holds
	// [Bot conversations completed]: https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-conversations-completed
	// [API contacts handled]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#api-contacts-handled
	// [Agent non-response without customer abandons]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-non-response-without-customer-abandons
	// [Service level X]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#service-level
	// [Contact handle time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contact-handle-time
	// [Agent idle time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-idle-time
	// [Adherent time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#adherent-time
	// [Average talk time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-talk-time
	// [Average after contact work time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#after-contact-work-time
	// [Cases created]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#cases-created
	// [Average handle time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-handle-time
	// [Average customer hold time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-customer-hold-time
	// [Average weighted evaluation score]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-weighted-evaluation-score
	// [Average bot conversation turns]: https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#average-bot-conversation-turns
	// [Contacts hold customer disconnect]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-hold-customer-disconnect
	// [Human answered]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#human-answered
	// [Contacts removed from queue in X seconds]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-removed-from-queue
	// [Contacts hold agent disconnect]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-hold-agent-disconnect
	// [Contacts transferred out internal]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-internal
	// [Agent non-response]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-non-response
	// [Agent answer rate]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-answer-rate
	// [Evaluations performed]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#evaluations-performed
	// [Average agent pause time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-pause-time
	// [Campaign contacts abandoned after X rate]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#campaign-contacts-abandoned-after-x-rate
	// [Average queue abandon time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-queue-abandon-time
	// [Contacts transferred out by agent]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-by-agent
	// [Average agent API connecting time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-api-connecting-time
	// [Maximum flow time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#maximum-flow-time
	// [Average contact duration]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-contact-duration
	// [Non-adherent time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#non-adherent-time
	// [Average agent interaction and customer hold time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-interaction-and-customer-hold-time
	// [After contact work time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#after-contact-work-time
	// [Average customer talk time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-customer-talk-time
	// [Campaign contacts abandoned after X]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#campaign-contacts-abandoned-after-x
	// [Error status time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#error-status-time
	// [Maximum queued time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#maximum-queued-time
	// [Average active time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-active-time
	// [Contacts transferred out queue]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue
	// [Cases reopened]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#cases-reopened
	// [Contact flow time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contact-flow-time
	// [Average customer hold time all contacts]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-customer-hold-time-all-contacts
	// [Average agent interaction time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-interaction-time
	// [Agent on contact time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-on-contact-time
	// [Average non-talk time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-non-talk-time
	// [Flows started]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#flows-started
	// [Average contacts per case]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-contacts-per-case
	// [Agent talk time percent]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-talk-time-percent
	// [Metrics definition]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html
	// [Average resolution time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-resolution-time
	// [Flows outcome percentage]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#flows-outcome-percentage
	// [Cases resolved]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#cases-resolved
	// [Contacts queued (enqueue timestamp)]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-queued-by-enqueue
	// [Online time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#online-time
	// [Agent interaction time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-interaction-time
	// [Average agent interruptions]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-interruptions
	// [Average dials per minute]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-dials-per-minute
	// [Delivery attempt disposition rate]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#delivery-attempt-disposition-rate
	// [Contact disconnected]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contact-disconnected
	// [Contacts handled (connected to agent timestamp)]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-by-connected-to-agent-timestamp
	// [Average evaluation score]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-evaluation-score
	// [Contacts resolved in X]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-resolved
	// [Cases resolved on first contact]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#cases-resolved-on-first-contact
	// [Contact abandoned]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-abandoned
	// [Campaign interactions]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#campaign-interactions
	// [Bot intents completed]: https://docs.aws.amazon.com/connect/latest/adminguide/bot-metrics.html#bot-intents-completed
	// [Abandonment rate]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#abandonment-rate
	// [Scheduled time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#scheduled-time
	// [Contacts abandoned in X seconds]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-abandoned-in-x-seconds
	// [Average wait time after customer connection]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-wait-time-after-customer-connection
	// [Current cases]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#current-cases
	// [Average queue answer time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-queue-answer-time
	// [Customer hold time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#customer-hold-time
	// [Agent interaction and hold time]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-interaction-and-hold-time
	// [Delivery attempts]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#delivery-attempts
	// [Contacts put on hold]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-put-on-hold
	// [Automatic fails percent]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#automatic-fails-percent
	// [Callback attempts]: https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#callback-attempts
	// [Forecasting, capacity planning, and scheduling]: https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region
	//
	// This member is required.
	Metrics []types.MetricV2

	// The Amazon Resource Name (ARN) of the resource. This includes the instanceId an
	// Amazon Connect instance.
	//
	// This member is required.
	ResourceArn *string

	// The timestamp, in UNIX Epoch time format, at which to start the reporting
	// interval for the retrieval of historical metrics data. The time must be before
	// the end time timestamp. The start and end time depends on the IntervalPeriod
	// selected. By default the time range between start and end time is 35 days.
	// Historical metrics are available for 3 months.
	//
	// This member is required.
	StartTime *time.Time

	// The grouping applied to the metrics that are returned. For example, when
	// results are grouped by queue, the metrics returned are grouped by queue. The
	// values that are returned apply to the metrics for each queue. They are not
	// aggregated for all queues.
	//
	// If no grouping is specified, a summary of all metrics is returned.
	//
	// Valid grouping keys: AGENT | AGENT_HIERARCHY_LEVEL_ONE |
	// AGENT_HIERARCHY_LEVEL_TWO | AGENT_HIERARCHY_LEVEL_THREE |
	// AGENT_HIERARCHY_LEVEL_FOUR | AGENT_HIERARCHY_LEVEL_FIVE |
	// ANSWERING_MACHINE_DETECTION_STATUS | BOT_ID | BOT_ALIAS | BOT_VERSION |
	// BOT_LOCALE | BOT_INTENT_NAME | CAMPAIGN | CAMPAIGN_DELIVERY_EVENT_TYPE |
	// CASE_TEMPLATE_ARN | CASE_STATUS | CHANNEL |
	// contact/segmentAttributes/connect:Subtype | DISCONNECT_REASON | EVALUATION_FORM
	// | EVALUATION_SECTION | EVALUATION_QUESTION | EVALUATION_SOURCE |
	// FLOWS_RESOURCE_ID | FLOWS_MODULE_RESOURCE_ID | FLOW_ACTION_ID | FLOW_TYPE |
	// FLOWS_OUTCOME_TYPE | FORM_VERSION | INITIATION_METHOD |
	// INVOKING_RESOURCE_PUBLISHED_TIMESTAMP | INVOKING_RESOURCE_TYPE |
	// PARENT_FLOWS_RESOURCE_ID | Q_CONNECT_ENABLED | QUEUE |
	// RESOURCE_PUBLISHED_TIMESTAMP | ROUTING_PROFILE | ROUTING_STEP_EXPRESSION
	//
	// Type: Array of strings
	//
	// Array Members: Maximum number of 4 items
	//
	// Required: No
	Groupings []string

	// The interval period and timezone to apply to returned metrics.
	//
	//   - IntervalPeriod : An aggregated grouping applied to request metrics. Valid
	//   IntervalPeriod values are: FIFTEEN_MIN | THIRTY_MIN | HOUR | DAY | WEEK |
	//   TOTAL .
	//
	// For example, if IntervalPeriod is selected THIRTY_MIN , StartTime and EndTime
	//   differs by 1 day, then Amazon Connect returns 48 results in the response. Each
	//   result is aggregated by the THIRTY_MIN period. By default Amazon Connect
	//   aggregates results based on the TOTAL interval period.
	//
	// The following list describes restrictions on StartTime and EndTime based on
	//   which IntervalPeriod is requested.
	//
	//   - FIFTEEN_MIN : The difference between StartTime and EndTime must be less than
	//   3 days.
	//
	//   - THIRTY_MIN : The difference between StartTime and EndTime must be less than
	//   3 days.
	//
	//   - HOUR : The difference between StartTime and EndTime must be less than 3 days.
	//
	//   - DAY : The difference between StartTime and EndTime must be less than 35 days.
	//
	//   - WEEK : The difference between StartTime and EndTime must be less than 35
	//   days.
	//
	//   - TOTAL : The difference between StartTime and EndTime must be less than 35
	//   days.
	//
	//   - TimeZone : The timezone applied to requested metrics.
	Interval *types.IntervalDetails

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type GetMetricDataV2Output struct {

	// Information about the metrics requested in the API request If no grouping is
	// specified, a summary of metric data is returned.
	MetricResults []types.MetricResultV2

	// If there are additional results, this is the token for the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetMetricDataV2Middlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetMetricDataV2{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetMetricDataV2{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetMetricDataV2"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetMetricDataV2ValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetMetricDataV2(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetMetricDataV2PaginatorOptions is the paginator options for GetMetricDataV2
type GetMetricDataV2PaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetMetricDataV2Paginator is a paginator for GetMetricDataV2
type GetMetricDataV2Paginator struct {
	options   GetMetricDataV2PaginatorOptions
	client    GetMetricDataV2APIClient
	params    *GetMetricDataV2Input
	nextToken *string
	firstPage bool
}

// NewGetMetricDataV2Paginator returns a new GetMetricDataV2Paginator
func NewGetMetricDataV2Paginator(client GetMetricDataV2APIClient, params *GetMetricDataV2Input, optFns ...func(*GetMetricDataV2PaginatorOptions)) *GetMetricDataV2Paginator {
	if params == nil {
		params = &GetMetricDataV2Input{}
	}

	options := GetMetricDataV2PaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetMetricDataV2Paginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetMetricDataV2Paginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetMetricDataV2 page.
func (p *GetMetricDataV2Paginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetMetricDataV2Output, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetMetricDataV2(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetMetricDataV2APIClient is a client that implements the GetMetricDataV2
// operation.
type GetMetricDataV2APIClient interface {
	GetMetricDataV2(context.Context, *GetMetricDataV2Input, ...func(*Options)) (*GetMetricDataV2Output, error)
}

var _ GetMetricDataV2APIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetMetricDataV2(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetMetricDataV2",
	}
}
