// Code generated by smithy-go-codegen DO NOT EDIT.

package codestarnotifications

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codestarnotifications/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about a specified notification rule.
func (c *Client) DescribeNotificationRule(ctx context.Context, params *DescribeNotificationRuleInput, optFns ...func(*Options)) (*DescribeNotificationRuleOutput, error) {
	if params == nil {
		params = &DescribeNotificationRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeNotificationRule", params, optFns, c.addOperationDescribeNotificationRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeNotificationRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeNotificationRuleInput struct {

	// The Amazon Resource Name (ARN) of the notification rule.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

type DescribeNotificationRuleOutput struct {

	// The Amazon Resource Name (ARN) of the notification rule.
	//
	// This member is required.
	Arn *string

	// The name or email alias of the person who created the notification rule.
	CreatedBy *string

	// The date and time the notification rule was created, in timestamp format.
	CreatedTimestamp *time.Time

	// The level of detail included in the notifications for this resource. BASIC will
	// include only the contents of the event as it would appear in Amazon CloudWatch.
	// FULL will include any supplemental information provided by AWS CodeStar
	// Notifications and/or the service for the resource for which the notification is
	// created.
	DetailType types.DetailType

	// A list of the event types associated with the notification rule.
	EventTypes []types.EventTypeSummary

	// The date and time the notification rule was most recently updated, in timestamp
	// format.
	LastModifiedTimestamp *time.Time

	// The name of the notification rule.
	Name *string

	// The Amazon Resource Name (ARN) of the resource associated with the notification
	// rule.
	Resource *string

	// The status of the notification rule. Valid statuses are on (sending
	// notifications) or off (not sending notifications).
	Status types.NotificationRuleStatus

	// The tags associated with the notification rule.
	Tags map[string]string

	// A list of the Chatbot topics and Chatbot clients associated with the
	// notification rule.
	Targets []types.TargetSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeNotificationRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeNotificationRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeNotificationRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeNotificationRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeNotificationRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeNotificationRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeNotificationRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeNotificationRule",
	}
}
