// Code generated by smithy-go-codegen DO NOT EDIT.

package billing

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the source views (managed Amazon Web Services billing views) associated
// with the billing view.
func (c *Client) ListSourceViewsForBillingView(ctx context.Context, params *ListSourceViewsForBillingViewInput, optFns ...func(*Options)) (*ListSourceViewsForBillingViewOutput, error) {
	if params == nil {
		params = &ListSourceViewsForBillingViewInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSourceViewsForBillingView", params, optFns, c.addOperationListSourceViewsForBillingViewMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSourceViewsForBillingViewOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSourceViewsForBillingViewInput struct {

	//  The Amazon Resource Name (ARN) that can be used to uniquely identify the
	// billing view.
	//
	// This member is required.
	Arn *string

	//  The number of entries a paginated response contains.
	MaxResults *int32

	//  The pagination token that is used on subsequent calls to list billing views.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSourceViewsForBillingViewOutput struct {

	// A list of billing views used as the data source for the custom billing view.
	//
	// This member is required.
	SourceViews []string

	//  The pagination token that is used on subsequent calls to list billing views.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSourceViewsForBillingViewMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListSourceViewsForBillingView{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListSourceViewsForBillingView{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSourceViewsForBillingView"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListSourceViewsForBillingViewValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSourceViewsForBillingView(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListSourceViewsForBillingViewPaginatorOptions is the paginator options for
// ListSourceViewsForBillingView
type ListSourceViewsForBillingViewPaginatorOptions struct {
	//  The number of entries a paginated response contains.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSourceViewsForBillingViewPaginator is a paginator for
// ListSourceViewsForBillingView
type ListSourceViewsForBillingViewPaginator struct {
	options   ListSourceViewsForBillingViewPaginatorOptions
	client    ListSourceViewsForBillingViewAPIClient
	params    *ListSourceViewsForBillingViewInput
	nextToken *string
	firstPage bool
}

// NewListSourceViewsForBillingViewPaginator returns a new
// ListSourceViewsForBillingViewPaginator
func NewListSourceViewsForBillingViewPaginator(client ListSourceViewsForBillingViewAPIClient, params *ListSourceViewsForBillingViewInput, optFns ...func(*ListSourceViewsForBillingViewPaginatorOptions)) *ListSourceViewsForBillingViewPaginator {
	if params == nil {
		params = &ListSourceViewsForBillingViewInput{}
	}

	options := ListSourceViewsForBillingViewPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSourceViewsForBillingViewPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSourceViewsForBillingViewPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSourceViewsForBillingView page.
func (p *ListSourceViewsForBillingViewPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSourceViewsForBillingViewOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSourceViewsForBillingView(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSourceViewsForBillingViewAPIClient is a client that implements the
// ListSourceViewsForBillingView operation.
type ListSourceViewsForBillingViewAPIClient interface {
	ListSourceViewsForBillingView(context.Context, *ListSourceViewsForBillingViewInput, ...func(*Options)) (*ListSourceViewsForBillingViewOutput, error)
}

var _ ListSourceViewsForBillingViewAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSourceViewsForBillingView(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSourceViewsForBillingView",
	}
}
