// Code generated by smithy-go-codegen DO NOT EDIT.

package batch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a description of the specified consumable resource.
func (c *Client) DescribeConsumableResource(ctx context.Context, params *DescribeConsumableResourceInput, optFns ...func(*Options)) (*DescribeConsumableResourceOutput, error) {
	if params == nil {
		params = &DescribeConsumableResourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeConsumableResource", params, optFns, c.addOperationDescribeConsumableResourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeConsumableResourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeConsumableResourceInput struct {

	// The name or ARN of the consumable resource whose description will be returned.
	//
	// This member is required.
	ConsumableResource *string

	noSmithyDocumentSerde
}

type DescribeConsumableResourceOutput struct {

	// The Amazon Resource Name (ARN) of the consumable resource.
	//
	// This member is required.
	ConsumableResourceArn *string

	// The name of the consumable resource.
	//
	// This member is required.
	ConsumableResourceName *string

	// The amount of the consumable resource that is currently available to use.
	AvailableQuantity *int64

	// The Unix timestamp (in milliseconds) for when the consumable resource was
	// created.
	CreatedAt *int64

	// The amount of the consumable resource that is currently in use.
	InUseQuantity *int64

	// Indicates whether the resource is available to be re-used after a job
	// completes. Can be one of:
	//
	//   - REPLENISHABLE
	//
	//   - NON_REPLENISHABLE
	ResourceType *string

	// The tags that you apply to the consumable resource to help you categorize and
	// organize your resources. Each tag consists of a key and an optional value. For
	// more information, see [Tagging your Batch resources].
	//
	// [Tagging your Batch resources]: https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html
	Tags map[string]string

	// The total amount of the consumable resource that is available.
	TotalQuantity *int64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeConsumableResourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeConsumableResource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeConsumableResource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeConsumableResource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeConsumableResourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeConsumableResource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeConsumableResource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeConsumableResource",
	}
}
