// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestSearchableAttributes(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.SearchableAttributesOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.SearchableAttributes([]string{}...),
		},
		{
			opts:     []interface{}{opt.SearchableAttributes("value1")},
			expected: opt.SearchableAttributes("value1"),
		},
		{
			opts:     []interface{}{opt.SearchableAttributes("value1", "value2", "value3")},
			expected: opt.SearchableAttributes("value1", "value2", "value3"),
		},
	} {
		var (
			in  = ExtractSearchableAttributes(c.opts...)
			out opt.SearchableAttributesOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), out.Get())
	}
}

func TestSearchableAttributes_CommaSeparatedString(t *testing.T) {
	for _, c := range []struct {
		payload  string
		expected *opt.SearchableAttributesOption
	}{
		{
			payload:  `""`,
			expected: opt.SearchableAttributes([]string{}...),
		},
		{
			payload:  `"value1"`,
			expected: opt.SearchableAttributes("value1"),
		},
		{
			payload:  `"value1,value2,value3"`,
			expected: opt.SearchableAttributes("value1", "value2", "value3"),
		},
	} {
		var got opt.SearchableAttributesOption
		err := json.Unmarshal([]byte(c.payload), &got)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), got.Get())
	}
}
