## Contributing

Hi there! We're thrilled that you'd like to contribute to this project.
Your help is essential to keeping it great.

### Opening an issue

Each repository provides a template for issues. Please tell us the client and language version, and
provide a clear description of the problem you're facing. Steps to reproduce, or example code
(repository, jsfiddle, and such), are a big help.

### Submitting a pull request

Keep your changes as focused as possible. If there are multiple changes you'd like to make,
please consider submitting them as separate pull requests unless they are related to each other.

Here are a few tips to increase the likelihood of being merged:

- [ ] Write tests.
- [ ] Write a [good commit message](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html).
- [ ] Allow [edits from maintainers](https://blog.github.com/2016-09-07-improving-collaboration-with-forks/).

### Security issues
If you find any security risk in the project, please open an issue.

### API Breaking changes

We care deeply about backward compatibility for our API clients libraries. 
If it's necessary, we're ready to break backward compatibility,
but this should be pretty rare.

If you want to make a change that will break the backward compatibility of the API, 
open an issue first to discuss it with the maintainers.

### Editing `README.md` and similar files

Note that some files are managed outside this repository and are committed automatically.

The `README.md` is generated automatically from our doc. If you'd like us to update this file, 
feel free to open an issue.

`.github` directory is managed in [this repository](https://github.com/algolia/algoliasearch-client-common),
any Pull Request there is welcome.

## Label caption

Labels across all Algolia API clients repositories are normalized.

<!-- DO NOT EDIT THE TABLE NOR REMOVE HTML COMMENTS -->
<!-- LABELTABLE -->
| Label                                                                     | Meaning                                                                                |
|---------------------------------------------------------------------------|----------------------------------------------------------------------------------------|
| ![#050f2c](https://placehold.it/15/050f2c/000000?text=+) Do not merge     | PR should not be merged (decided by maintainers)                                       |
| ![#ffc168](https://placehold.it/15/ffc168/000000?text=+) WIP              | PR is not ready, no need to look at it (decided by contributors)                       |
| ![#2ede98](https://placehold.it/15/2ede98/000000?text=+) Ready            | The PR is ready, reviewed, tests are green, if you're brave enough: click merge button |
| ![#ffc168](https://placehold.it/15/ffc168/000000?text=+) Waiting for API  | The feature is implemented but the REST API is not live yet                            |
| ![#3369e6](https://placehold.it/15/3369e6/000000?text=+) Discussion       | We need everyone's opinion on this, please join the conversation and share your ideas  |
| ![#3369e6](https://placehold.it/15/3369e6/000000?text=+) Support          | A user needs help but it's not really a bug                                            |
| ![#3369e6](https://placehold.it/15/3369e6/000000?text=+) API feature      | New API feature added to every client (like query rules)                               |
| ![#3369e6](https://placehold.it/15/3369e6/000000?text=+) Chore            | CI, docs, and everything around the code                                               |
| ![#ff4f81](https://placehold.it/15/ff4f81/000000?text=+) Bug              | It's a bug, fix it!                                                                    |
| ![#b60205](https://placehold.it/15/b60205/000000?text=+) Breaking change  | RED ALERT! This means we need a new major version                                      |
| ![#ff6c5f](https://placehold.it/15/ff6c5f/000000?text=+) Good First Issue | If you want to contribute, this one is _easy_ to tackle!                               |

<!-- /LABELTABLE -->
<!-- DO NOT REMOVE ANY HTML COMMENT -->

## Resources

- [Contributing to Open Source on GitHub](https://guides.github.com/activities/contributing-to-open-source/)
- [Using Pull Requests](https://help.github.com/articles/using-pull-requests/)
- [GitHub Help](https://help.github.com)
