//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/subscription/armsubscription"
	"net/http"
	"net/url"
	"regexp"
)

// AliasServer is a fake server for instances of the armsubscription.AliasClient type.
type AliasServer struct {
	// BeginCreate is the fake for method AliasClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, aliasName string, body armsubscription.PutAliasRequest, options *armsubscription.AliasClientBeginCreateOptions) (resp azfake.PollerResponder[armsubscription.AliasClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method AliasClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, aliasName string, options *armsubscription.AliasClientDeleteOptions) (resp azfake.Responder[armsubscription.AliasClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AliasClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, aliasName string, options *armsubscription.AliasClientGetOptions) (resp azfake.Responder[armsubscription.AliasClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method AliasClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, options *armsubscription.AliasClientListOptions) (resp azfake.Responder[armsubscription.AliasClientListResponse], errResp azfake.ErrorResponder)
}

// NewAliasServerTransport creates a new instance of AliasServerTransport with the provided implementation.
// The returned AliasServerTransport instance is connected to an instance of armsubscription.AliasClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAliasServerTransport(srv *AliasServer) *AliasServerTransport {
	return &AliasServerTransport{
		srv:         srv,
		beginCreate: newTracker[azfake.PollerResponder[armsubscription.AliasClientCreateResponse]](),
	}
}

// AliasServerTransport connects instances of armsubscription.AliasClient to instances of AliasServer.
// Don't use this type directly, use NewAliasServerTransport instead.
type AliasServerTransport struct {
	srv         *AliasServer
	beginCreate *tracker[azfake.PollerResponder[armsubscription.AliasClientCreateResponse]]
}

// Do implements the policy.Transporter interface for AliasServerTransport.
func (a *AliasServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AliasClient.BeginCreate":
		resp, err = a.dispatchBeginCreate(req)
	case "AliasClient.Delete":
		resp, err = a.dispatchDelete(req)
	case "AliasClient.Get":
		resp, err = a.dispatchGet(req)
	case "AliasClient.List":
		resp, err = a.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AliasServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := a.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/providers/Microsoft\.Subscription/aliases/(?P<aliasName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsubscription.PutAliasRequest](req)
		if err != nil {
			return nil, err
		}
		aliasNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("aliasName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreate(req.Context(), aliasNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		a.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		a.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		a.beginCreate.remove(req)
	}

	return resp, nil
}

func (a *AliasServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if a.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Subscription/aliases/(?P<aliasName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	aliasNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("aliasName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Delete(req.Context(), aliasNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AliasServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Subscription/aliases/(?P<aliasName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	aliasNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("aliasName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), aliasNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AliasResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AliasServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if a.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	respr, errRespr := a.srv.List(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AliasListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
