//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple1200series/armstorsimple1200series"
	"net/http"
)

// AvailableProviderOperationsServer is a fake server for instances of the armstorsimple1200series.AvailableProviderOperationsClient type.
type AvailableProviderOperationsServer struct {
	// NewListPager is the fake for method AvailableProviderOperationsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armstorsimple1200series.AvailableProviderOperationsClientListOptions) (resp azfake.PagerResponder[armstorsimple1200series.AvailableProviderOperationsClientListResponse])
}

// NewAvailableProviderOperationsServerTransport creates a new instance of AvailableProviderOperationsServerTransport with the provided implementation.
// The returned AvailableProviderOperationsServerTransport instance is connected to an instance of armstorsimple1200series.AvailableProviderOperationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAvailableProviderOperationsServerTransport(srv *AvailableProviderOperationsServer) *AvailableProviderOperationsServerTransport {
	return &AvailableProviderOperationsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armstorsimple1200series.AvailableProviderOperationsClientListResponse]](),
	}
}

// AvailableProviderOperationsServerTransport connects instances of armstorsimple1200series.AvailableProviderOperationsClient to instances of AvailableProviderOperationsServer.
// Don't use this type directly, use NewAvailableProviderOperationsServerTransport instead.
type AvailableProviderOperationsServerTransport struct {
	srv          *AvailableProviderOperationsServer
	newListPager *tracker[azfake.PagerResponder[armstorsimple1200series.AvailableProviderOperationsClientListResponse]]
}

// Do implements the policy.Transporter interface for AvailableProviderOperationsServerTransport.
func (a *AvailableProviderOperationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AvailableProviderOperationsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AvailableProviderOperationsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		resp := a.srv.NewListPager(nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armstorsimple1200series.AvailableProviderOperationsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}
