//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/springappdiscovery/armspringappdiscovery"
	"net/http"
	"net/url"
	"regexp"
)

// ErrorSummariesServer is a fake server for instances of the armspringappdiscovery.ErrorSummariesClient type.
type ErrorSummariesServer struct {
	// Get is the fake for method ErrorSummariesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, siteName string, errorSummaryName string, options *armspringappdiscovery.ErrorSummariesClientGetOptions) (resp azfake.Responder[armspringappdiscovery.ErrorSummariesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySitePager is the fake for method ErrorSummariesClient.NewListBySitePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySitePager func(resourceGroupName string, siteName string, options *armspringappdiscovery.ErrorSummariesClientListBySiteOptions) (resp azfake.PagerResponder[armspringappdiscovery.ErrorSummariesClientListBySiteResponse])
}

// NewErrorSummariesServerTransport creates a new instance of ErrorSummariesServerTransport with the provided implementation.
// The returned ErrorSummariesServerTransport instance is connected to an instance of armspringappdiscovery.ErrorSummariesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewErrorSummariesServerTransport(srv *ErrorSummariesServer) *ErrorSummariesServerTransport {
	return &ErrorSummariesServerTransport{
		srv:                srv,
		newListBySitePager: newTracker[azfake.PagerResponder[armspringappdiscovery.ErrorSummariesClientListBySiteResponse]](),
	}
}

// ErrorSummariesServerTransport connects instances of armspringappdiscovery.ErrorSummariesClient to instances of ErrorSummariesServer.
// Don't use this type directly, use NewErrorSummariesServerTransport instead.
type ErrorSummariesServerTransport struct {
	srv                *ErrorSummariesServer
	newListBySitePager *tracker[azfake.PagerResponder[armspringappdiscovery.ErrorSummariesClientListBySiteResponse]]
}

// Do implements the policy.Transporter interface for ErrorSummariesServerTransport.
func (e *ErrorSummariesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ErrorSummariesClient.Get":
		resp, err = e.dispatchGet(req)
	case "ErrorSummariesClient.NewListBySitePager":
		resp, err = e.dispatchNewListBySitePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *ErrorSummariesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OffAzureSpringBoot/springbootsites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/errorSummaries/(?P<errorSummaryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	errorSummaryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("errorSummaryName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), resourceGroupNameParam, siteNameParam, errorSummaryNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ErrorSummary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ErrorSummariesServerTransport) dispatchNewListBySitePager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListBySitePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySitePager not implemented")}
	}
	newListBySitePager := e.newListBySitePager.get(req)
	if newListBySitePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OffAzureSpringBoot/springbootsites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/errorSummaries`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListBySitePager(resourceGroupNameParam, siteNameParam, nil)
		newListBySitePager = &resp
		e.newListBySitePager.add(req, newListBySitePager)
		server.PagerResponderInjectNextLinks(newListBySitePager, req, func(page *armspringappdiscovery.ErrorSummariesClientListBySiteResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySitePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListBySitePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySitePager) {
		e.newListBySitePager.remove(req)
	}
	return resp, nil
}
