//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicelinker

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// LinkersClient contains the methods for the Linkers group.
// Don't use this type directly, use NewLinkersClient() instead.
type LinkersClient struct {
	internal *arm.Client
}

// NewLinkersClient creates a new instance of LinkersClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewLinkersClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*LinkersClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &LinkersClient{
		internal: cl,
	}
	return client, nil
}

// BeginCreateDryrun - create a dryrun job to do necessary check before actual creation
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - resourceURI - The fully qualified Azure Resource manager identifier of the resource to be connected.
//   - dryrunName - The name of dryrun.
//   - parameters - dryrun resource.
//   - options - LinkersClientBeginCreateDryrunOptions contains the optional parameters for the LinkersClient.BeginCreateDryrun
//     method.
func (client *LinkersClient) BeginCreateDryrun(ctx context.Context, resourceURI string, dryrunName string, parameters DryrunResource, options *LinkersClientBeginCreateDryrunOptions) (*runtime.Poller[LinkersClientCreateDryrunResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createDryrun(ctx, resourceURI, dryrunName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[LinkersClientCreateDryrunResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[LinkersClientCreateDryrunResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateDryrun - create a dryrun job to do necessary check before actual creation
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
func (client *LinkersClient) createDryrun(ctx context.Context, resourceURI string, dryrunName string, parameters DryrunResource, options *LinkersClientBeginCreateDryrunOptions) (*http.Response, error) {
	var err error
	const operationName = "LinkersClient.BeginCreateDryrun"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createDryrunCreateRequest(ctx, resourceURI, dryrunName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createDryrunCreateRequest creates the CreateDryrun request.
func (client *LinkersClient) createDryrunCreateRequest(ctx context.Context, resourceURI string, dryrunName string, parameters DryrunResource, options *LinkersClientBeginCreateDryrunOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ServiceLinker/dryruns/{dryrunName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	if dryrunName == "" {
		return nil, errors.New("parameter dryrunName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dryrunName}", url.PathEscape(dryrunName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// DeleteDryrun - delete a dryrun job
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - resourceURI - The fully qualified Azure Resource manager identifier of the resource to be connected.
//   - dryrunName - The name of dryrun.
//   - options - LinkersClientDeleteDryrunOptions contains the optional parameters for the LinkersClient.DeleteDryrun method.
func (client *LinkersClient) DeleteDryrun(ctx context.Context, resourceURI string, dryrunName string, options *LinkersClientDeleteDryrunOptions) (LinkersClientDeleteDryrunResponse, error) {
	var err error
	const operationName = "LinkersClient.DeleteDryrun"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteDryrunCreateRequest(ctx, resourceURI, dryrunName, options)
	if err != nil {
		return LinkersClientDeleteDryrunResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return LinkersClientDeleteDryrunResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return LinkersClientDeleteDryrunResponse{}, err
	}
	return LinkersClientDeleteDryrunResponse{}, nil
}

// deleteDryrunCreateRequest creates the DeleteDryrun request.
func (client *LinkersClient) deleteDryrunCreateRequest(ctx context.Context, resourceURI string, dryrunName string, options *LinkersClientDeleteDryrunOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ServiceLinker/dryruns/{dryrunName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	if dryrunName == "" {
		return nil, errors.New("parameter dryrunName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dryrunName}", url.PathEscape(dryrunName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GenerateConfigurations - Generate configurations for a Linker.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - resourceURI - The fully qualified Azure Resource manager identifier of the resource to be connected.
//   - linkerName - The name Linker resource.
//   - options - LinkersClientGenerateConfigurationsOptions contains the optional parameters for the LinkersClient.GenerateConfigurations
//     method.
func (client *LinkersClient) GenerateConfigurations(ctx context.Context, resourceURI string, linkerName string, options *LinkersClientGenerateConfigurationsOptions) (LinkersClientGenerateConfigurationsResponse, error) {
	var err error
	const operationName = "LinkersClient.GenerateConfigurations"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateConfigurationsCreateRequest(ctx, resourceURI, linkerName, options)
	if err != nil {
		return LinkersClientGenerateConfigurationsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return LinkersClientGenerateConfigurationsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return LinkersClientGenerateConfigurationsResponse{}, err
	}
	resp, err := client.generateConfigurationsHandleResponse(httpResp)
	return resp, err
}

// generateConfigurationsCreateRequest creates the GenerateConfigurations request.
func (client *LinkersClient) generateConfigurationsCreateRequest(ctx context.Context, resourceURI string, linkerName string, options *LinkersClientGenerateConfigurationsOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ServiceLinker/linkers/{linkerName}/generateConfigurations"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	if linkerName == "" {
		return nil, errors.New("parameter linkerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{linkerName}", url.PathEscape(linkerName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Parameters != nil {
		if err := runtime.MarshalAsJSON(req, *options.Parameters); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// generateConfigurationsHandleResponse handles the GenerateConfigurations response.
func (client *LinkersClient) generateConfigurationsHandleResponse(resp *http.Response) (LinkersClientGenerateConfigurationsResponse, error) {
	result := LinkersClientGenerateConfigurationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ConfigurationResult); err != nil {
		return LinkersClientGenerateConfigurationsResponse{}, err
	}
	return result, nil
}

// GetDryrun - get a dryrun job
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - resourceURI - The fully qualified Azure Resource manager identifier of the resource to be connected.
//   - dryrunName - The name of dryrun.
//   - options - LinkersClientGetDryrunOptions contains the optional parameters for the LinkersClient.GetDryrun method.
func (client *LinkersClient) GetDryrun(ctx context.Context, resourceURI string, dryrunName string, options *LinkersClientGetDryrunOptions) (LinkersClientGetDryrunResponse, error) {
	var err error
	const operationName = "LinkersClient.GetDryrun"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDryrunCreateRequest(ctx, resourceURI, dryrunName, options)
	if err != nil {
		return LinkersClientGetDryrunResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return LinkersClientGetDryrunResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return LinkersClientGetDryrunResponse{}, err
	}
	resp, err := client.getDryrunHandleResponse(httpResp)
	return resp, err
}

// getDryrunCreateRequest creates the GetDryrun request.
func (client *LinkersClient) getDryrunCreateRequest(ctx context.Context, resourceURI string, dryrunName string, options *LinkersClientGetDryrunOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ServiceLinker/dryruns/{dryrunName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	if dryrunName == "" {
		return nil, errors.New("parameter dryrunName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dryrunName}", url.PathEscape(dryrunName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDryrunHandleResponse handles the GetDryrun response.
func (client *LinkersClient) getDryrunHandleResponse(resp *http.Response) (LinkersClientGetDryrunResponse, error) {
	result := LinkersClientGetDryrunResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DryrunResource); err != nil {
		return LinkersClientGetDryrunResponse{}, err
	}
	return result, nil
}

// NewListDaprConfigurationsPager - List the dapr configuration supported by Service Connector.
//
// Generated from API version 2023-04-01-preview
//   - resourceURI - The fully qualified Azure Resource manager identifier of the resource to be connected.
//   - options - LinkersClientListDaprConfigurationsOptions contains the optional parameters for the LinkersClient.NewListDaprConfigurationsPager
//     method.
func (client *LinkersClient) NewListDaprConfigurationsPager(resourceURI string, options *LinkersClientListDaprConfigurationsOptions) *runtime.Pager[LinkersClientListDaprConfigurationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[LinkersClientListDaprConfigurationsResponse]{
		More: func(page LinkersClientListDaprConfigurationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *LinkersClientListDaprConfigurationsResponse) (LinkersClientListDaprConfigurationsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "LinkersClient.NewListDaprConfigurationsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listDaprConfigurationsCreateRequest(ctx, resourceURI, options)
			}, nil)
			if err != nil {
				return LinkersClientListDaprConfigurationsResponse{}, err
			}
			return client.listDaprConfigurationsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listDaprConfigurationsCreateRequest creates the ListDaprConfigurations request.
func (client *LinkersClient) listDaprConfigurationsCreateRequest(ctx context.Context, resourceURI string, options *LinkersClientListDaprConfigurationsOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ServiceLinker/daprConfigurations"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDaprConfigurationsHandleResponse handles the ListDaprConfigurations response.
func (client *LinkersClient) listDaprConfigurationsHandleResponse(resp *http.Response) (LinkersClientListDaprConfigurationsResponse, error) {
	result := LinkersClientListDaprConfigurationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DaprConfigurationList); err != nil {
		return LinkersClientListDaprConfigurationsResponse{}, err
	}
	return result, nil
}

// NewListDryrunPager - list dryrun jobs
//
// Generated from API version 2023-04-01-preview
//   - resourceURI - The fully qualified Azure Resource manager identifier of the resource to be connected.
//   - options - LinkersClientListDryrunOptions contains the optional parameters for the LinkersClient.NewListDryrunPager method.
func (client *LinkersClient) NewListDryrunPager(resourceURI string, options *LinkersClientListDryrunOptions) *runtime.Pager[LinkersClientListDryrunResponse] {
	return runtime.NewPager(runtime.PagingHandler[LinkersClientListDryrunResponse]{
		More: func(page LinkersClientListDryrunResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *LinkersClientListDryrunResponse) (LinkersClientListDryrunResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "LinkersClient.NewListDryrunPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listDryrunCreateRequest(ctx, resourceURI, options)
			}, nil)
			if err != nil {
				return LinkersClientListDryrunResponse{}, err
			}
			return client.listDryrunHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listDryrunCreateRequest creates the ListDryrun request.
func (client *LinkersClient) listDryrunCreateRequest(ctx context.Context, resourceURI string, options *LinkersClientListDryrunOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ServiceLinker/dryruns"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDryrunHandleResponse handles the ListDryrun response.
func (client *LinkersClient) listDryrunHandleResponse(resp *http.Response) (LinkersClientListDryrunResponse, error) {
	result := LinkersClientListDryrunResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DryrunList); err != nil {
		return LinkersClientListDryrunResponse{}, err
	}
	return result, nil
}

// BeginUpdateDryrun - add a dryrun job to do necessary check before actual creation
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - resourceURI - The fully qualified Azure Resource manager identifier of the resource to be connected.
//   - dryrunName - The name of dryrun.
//   - parameters - dryrun resource.
//   - options - LinkersClientBeginUpdateDryrunOptions contains the optional parameters for the LinkersClient.BeginUpdateDryrun
//     method.
func (client *LinkersClient) BeginUpdateDryrun(ctx context.Context, resourceURI string, dryrunName string, parameters DryrunPatch, options *LinkersClientBeginUpdateDryrunOptions) (*runtime.Poller[LinkersClientUpdateDryrunResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateDryrun(ctx, resourceURI, dryrunName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[LinkersClientUpdateDryrunResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[LinkersClientUpdateDryrunResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// UpdateDryrun - add a dryrun job to do necessary check before actual creation
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
func (client *LinkersClient) updateDryrun(ctx context.Context, resourceURI string, dryrunName string, parameters DryrunPatch, options *LinkersClientBeginUpdateDryrunOptions) (*http.Response, error) {
	var err error
	const operationName = "LinkersClient.BeginUpdateDryrun"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateDryrunCreateRequest(ctx, resourceURI, dryrunName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateDryrunCreateRequest creates the UpdateDryrun request.
func (client *LinkersClient) updateDryrunCreateRequest(ctx context.Context, resourceURI string, dryrunName string, parameters DryrunPatch, options *LinkersClientBeginUpdateDryrunOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ServiceLinker/dryruns/{dryrunName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	if dryrunName == "" {
		return nil, errors.New("parameter dryrunName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dryrunName}", url.PathEscape(dryrunName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}
