//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armselfhelp

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// DiscoverySolutionClient contains the methods for the DiscoverySolution group.
// Don't use this type directly, use NewDiscoverySolutionClient() instead.
type DiscoverySolutionClient struct {
	internal *arm.Client
}

// NewDiscoverySolutionClient creates a new instance of DiscoverySolutionClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDiscoverySolutionClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*DiscoverySolutionClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DiscoverySolutionClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - Lists the relevant Azure Diagnostics, Solutions and Troubleshooters using problemClassification API [https://learn.microsoft.com/rest/api/support/problem-classifications/list?tabs=HTTP])
// AND
// resourceUri or resourceType. Discovery Solutions is the initial entry point within Help API, which identifies relevant
// Azure diagnostics and solutions.
// Required Input : problemClassificationId (Use the problemClassification API [https://learn.microsoft.com/rest/api/support/problem-classifications/list?tabs=HTTP])
// Optional input: resourceUri OR
// resource Type
// Note: ‘requiredInputs’ from Discovery solutions response must be passed via ‘additionalParameters’ as an input to Diagnostics
// and Solutions API.
//
// Generated from API version 2024-03-01-preview
//   - options - DiscoverySolutionClientListOptions contains the optional parameters for the DiscoverySolutionClient.NewListPager
//     method.
func (client *DiscoverySolutionClient) NewListPager(options *DiscoverySolutionClientListOptions) *runtime.Pager[DiscoverySolutionClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[DiscoverySolutionClientListResponse]{
		More: func(page DiscoverySolutionClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DiscoverySolutionClientListResponse) (DiscoverySolutionClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DiscoverySolutionClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return DiscoverySolutionClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *DiscoverySolutionClient) listCreateRequest(ctx context.Context, options *DiscoverySolutionClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Help/discoverySolutions"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Skiptoken != nil {
		reqQP.Set("$skiptoken", *options.Skiptoken)
	}
	reqQP.Set("api-version", "2024-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *DiscoverySolutionClient) listHandleResponse(resp *http.Response) (DiscoverySolutionClientListResponse, error) {
	result := DiscoverySolutionClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiscoveryResponse); err != nil {
		return DiscoverySolutionClientListResponse{}, err
	}
	return result, nil
}
