//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// JitNetworkAccessPoliciesServer is a fake server for instances of the armsecurity.JitNetworkAccessPoliciesClient type.
type JitNetworkAccessPoliciesServer struct {
	// CreateOrUpdate is the fake for method JitNetworkAccessPoliciesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, ascLocation string, jitNetworkAccessPolicyName string, body armsecurity.JitNetworkAccessPolicy, options *armsecurity.JitNetworkAccessPoliciesClientCreateOrUpdateOptions) (resp azfake.Responder[armsecurity.JitNetworkAccessPoliciesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method JitNetworkAccessPoliciesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, ascLocation string, jitNetworkAccessPolicyName string, options *armsecurity.JitNetworkAccessPoliciesClientDeleteOptions) (resp azfake.Responder[armsecurity.JitNetworkAccessPoliciesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method JitNetworkAccessPoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, ascLocation string, jitNetworkAccessPolicyName string, options *armsecurity.JitNetworkAccessPoliciesClientGetOptions) (resp azfake.Responder[armsecurity.JitNetworkAccessPoliciesClientGetResponse], errResp azfake.ErrorResponder)

	// Initiate is the fake for method JitNetworkAccessPoliciesClient.Initiate
	// HTTP status codes to indicate success: http.StatusAccepted
	Initiate func(ctx context.Context, resourceGroupName string, ascLocation string, jitNetworkAccessPolicyName string, body armsecurity.JitNetworkAccessPolicyInitiateRequest, options *armsecurity.JitNetworkAccessPoliciesClientInitiateOptions) (resp azfake.Responder[armsecurity.JitNetworkAccessPoliciesClientInitiateResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method JitNetworkAccessPoliciesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsecurity.JitNetworkAccessPoliciesClientListOptions) (resp azfake.PagerResponder[armsecurity.JitNetworkAccessPoliciesClientListResponse])

	// NewListByRegionPager is the fake for method JitNetworkAccessPoliciesClient.NewListByRegionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByRegionPager func(ascLocation string, options *armsecurity.JitNetworkAccessPoliciesClientListByRegionOptions) (resp azfake.PagerResponder[armsecurity.JitNetworkAccessPoliciesClientListByRegionResponse])

	// NewListByResourceGroupPager is the fake for method JitNetworkAccessPoliciesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armsecurity.JitNetworkAccessPoliciesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armsecurity.JitNetworkAccessPoliciesClientListByResourceGroupResponse])

	// NewListByResourceGroupAndRegionPager is the fake for method JitNetworkAccessPoliciesClient.NewListByResourceGroupAndRegionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupAndRegionPager func(resourceGroupName string, ascLocation string, options *armsecurity.JitNetworkAccessPoliciesClientListByResourceGroupAndRegionOptions) (resp azfake.PagerResponder[armsecurity.JitNetworkAccessPoliciesClientListByResourceGroupAndRegionResponse])
}

// NewJitNetworkAccessPoliciesServerTransport creates a new instance of JitNetworkAccessPoliciesServerTransport with the provided implementation.
// The returned JitNetworkAccessPoliciesServerTransport instance is connected to an instance of armsecurity.JitNetworkAccessPoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewJitNetworkAccessPoliciesServerTransport(srv *JitNetworkAccessPoliciesServer) *JitNetworkAccessPoliciesServerTransport {
	return &JitNetworkAccessPoliciesServerTransport{
		srv:                                  srv,
		newListPager:                         newTracker[azfake.PagerResponder[armsecurity.JitNetworkAccessPoliciesClientListResponse]](),
		newListByRegionPager:                 newTracker[azfake.PagerResponder[armsecurity.JitNetworkAccessPoliciesClientListByRegionResponse]](),
		newListByResourceGroupPager:          newTracker[azfake.PagerResponder[armsecurity.JitNetworkAccessPoliciesClientListByResourceGroupResponse]](),
		newListByResourceGroupAndRegionPager: newTracker[azfake.PagerResponder[armsecurity.JitNetworkAccessPoliciesClientListByResourceGroupAndRegionResponse]](),
	}
}

// JitNetworkAccessPoliciesServerTransport connects instances of armsecurity.JitNetworkAccessPoliciesClient to instances of JitNetworkAccessPoliciesServer.
// Don't use this type directly, use NewJitNetworkAccessPoliciesServerTransport instead.
type JitNetworkAccessPoliciesServerTransport struct {
	srv                                  *JitNetworkAccessPoliciesServer
	newListPager                         *tracker[azfake.PagerResponder[armsecurity.JitNetworkAccessPoliciesClientListResponse]]
	newListByRegionPager                 *tracker[azfake.PagerResponder[armsecurity.JitNetworkAccessPoliciesClientListByRegionResponse]]
	newListByResourceGroupPager          *tracker[azfake.PagerResponder[armsecurity.JitNetworkAccessPoliciesClientListByResourceGroupResponse]]
	newListByResourceGroupAndRegionPager *tracker[azfake.PagerResponder[armsecurity.JitNetworkAccessPoliciesClientListByResourceGroupAndRegionResponse]]
}

// Do implements the policy.Transporter interface for JitNetworkAccessPoliciesServerTransport.
func (j *JitNetworkAccessPoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "JitNetworkAccessPoliciesClient.CreateOrUpdate":
		resp, err = j.dispatchCreateOrUpdate(req)
	case "JitNetworkAccessPoliciesClient.Delete":
		resp, err = j.dispatchDelete(req)
	case "JitNetworkAccessPoliciesClient.Get":
		resp, err = j.dispatchGet(req)
	case "JitNetworkAccessPoliciesClient.Initiate":
		resp, err = j.dispatchInitiate(req)
	case "JitNetworkAccessPoliciesClient.NewListPager":
		resp, err = j.dispatchNewListPager(req)
	case "JitNetworkAccessPoliciesClient.NewListByRegionPager":
		resp, err = j.dispatchNewListByRegionPager(req)
	case "JitNetworkAccessPoliciesClient.NewListByResourceGroupPager":
		resp, err = j.dispatchNewListByResourceGroupPager(req)
	case "JitNetworkAccessPoliciesClient.NewListByResourceGroupAndRegionPager":
		resp, err = j.dispatchNewListByResourceGroupAndRegionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (j *JitNetworkAccessPoliciesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if j.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jitNetworkAccessPolicies/(?P<jitNetworkAccessPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurity.JitNetworkAccessPolicy](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	jitNetworkAccessPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jitNetworkAccessPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, ascLocationParam, jitNetworkAccessPolicyNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JitNetworkAccessPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JitNetworkAccessPoliciesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if j.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jitNetworkAccessPolicies/(?P<jitNetworkAccessPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	jitNetworkAccessPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jitNetworkAccessPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Delete(req.Context(), resourceGroupNameParam, ascLocationParam, jitNetworkAccessPolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JitNetworkAccessPoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if j.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jitNetworkAccessPolicies/(?P<jitNetworkAccessPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	jitNetworkAccessPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jitNetworkAccessPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Get(req.Context(), resourceGroupNameParam, ascLocationParam, jitNetworkAccessPolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JitNetworkAccessPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JitNetworkAccessPoliciesServerTransport) dispatchInitiate(req *http.Request) (*http.Response, error) {
	if j.srv.Initiate == nil {
		return nil, &nonRetriableError{errors.New("fake for method Initiate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jitNetworkAccessPolicies/(?P<jitNetworkAccessPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<jitNetworkAccessPolicyInitiateType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurity.JitNetworkAccessPolicyInitiateRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	jitNetworkAccessPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jitNetworkAccessPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Initiate(req.Context(), resourceGroupNameParam, ascLocationParam, jitNetworkAccessPolicyNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JitNetworkAccessRequest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JitNetworkAccessPoliciesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := j.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/jitNetworkAccessPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := j.srv.NewListPager(nil)
		newListPager = &resp
		j.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.JitNetworkAccessPoliciesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		j.newListPager.remove(req)
	}
	return resp, nil
}

func (j *JitNetworkAccessPoliciesServerTransport) dispatchNewListByRegionPager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListByRegionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByRegionPager not implemented")}
	}
	newListByRegionPager := j.newListByRegionPager.get(req)
	if newListByRegionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jitNetworkAccessPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
		if err != nil {
			return nil, err
		}
		resp := j.srv.NewListByRegionPager(ascLocationParam, nil)
		newListByRegionPager = &resp
		j.newListByRegionPager.add(req, newListByRegionPager)
		server.PagerResponderInjectNextLinks(newListByRegionPager, req, func(page *armsecurity.JitNetworkAccessPoliciesClientListByRegionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByRegionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListByRegionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByRegionPager) {
		j.newListByRegionPager.remove(req)
	}
	return resp, nil
}

func (j *JitNetworkAccessPoliciesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := j.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/jitNetworkAccessPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := j.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		j.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armsecurity.JitNetworkAccessPoliciesClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		j.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (j *JitNetworkAccessPoliciesServerTransport) dispatchNewListByResourceGroupAndRegionPager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListByResourceGroupAndRegionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupAndRegionPager not implemented")}
	}
	newListByResourceGroupAndRegionPager := j.newListByResourceGroupAndRegionPager.get(req)
	if newListByResourceGroupAndRegionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jitNetworkAccessPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
		if err != nil {
			return nil, err
		}
		resp := j.srv.NewListByResourceGroupAndRegionPager(resourceGroupNameParam, ascLocationParam, nil)
		newListByResourceGroupAndRegionPager = &resp
		j.newListByResourceGroupAndRegionPager.add(req, newListByResourceGroupAndRegionPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupAndRegionPager, req, func(page *armsecurity.JitNetworkAccessPoliciesClientListByResourceGroupAndRegionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupAndRegionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListByResourceGroupAndRegionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupAndRegionPager) {
		j.newListByResourceGroupAndRegionPager.remove(req)
	}
	return resp, nil
}
