//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armscvmm

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/scvmm/armscvmm"
	moduleVersion = "v0.4.0"
)

// AllocationMethod - Allocation method.
type AllocationMethod string

const (
	AllocationMethodDynamic AllocationMethod = "Dynamic"
	AllocationMethodStatic  AllocationMethod = "Static"
)

// PossibleAllocationMethodValues returns the possible values for the AllocationMethod const type.
func PossibleAllocationMethodValues() []AllocationMethod {
	return []AllocationMethod{
		AllocationMethodDynamic,
		AllocationMethodStatic,
	}
}

// CreateDiffDisk - Gets or sets a value indicating diff disk.
type CreateDiffDisk string

const (
	CreateDiffDiskFalse CreateDiffDisk = "false"
	CreateDiffDiskTrue  CreateDiffDisk = "true"
)

// PossibleCreateDiffDiskValues returns the possible values for the CreateDiffDisk const type.
func PossibleCreateDiffDiskValues() []CreateDiffDisk {
	return []CreateDiffDisk{
		CreateDiffDiskFalse,
		CreateDiffDiskTrue,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DynamicMemoryEnabled - Gets or sets a value indicating whether to enable dynamic memory or not.
type DynamicMemoryEnabled string

const (
	DynamicMemoryEnabledFalse DynamicMemoryEnabled = "false"
	DynamicMemoryEnabledTrue  DynamicMemoryEnabled = "true"
)

// PossibleDynamicMemoryEnabledValues returns the possible values for the DynamicMemoryEnabled const type.
func PossibleDynamicMemoryEnabledValues() []DynamicMemoryEnabled {
	return []DynamicMemoryEnabled{
		DynamicMemoryEnabledFalse,
		DynamicMemoryEnabledTrue,
	}
}

// InventoryType - The inventory type.
type InventoryType string

const (
	InventoryTypeCloud                  InventoryType = "Cloud"
	InventoryTypeVirtualMachine         InventoryType = "VirtualMachine"
	InventoryTypeVirtualMachineTemplate InventoryType = "VirtualMachineTemplate"
	InventoryTypeVirtualNetwork         InventoryType = "VirtualNetwork"
)

// PossibleInventoryTypeValues returns the possible values for the InventoryType const type.
func PossibleInventoryTypeValues() []InventoryType {
	return []InventoryType{
		InventoryTypeCloud,
		InventoryTypeVirtualMachine,
		InventoryTypeVirtualMachineTemplate,
		InventoryTypeVirtualNetwork,
	}
}

// IsCustomizable - Gets or sets a value indicating whether the vm template is customizable or not.
type IsCustomizable string

const (
	IsCustomizableFalse IsCustomizable = "false"
	IsCustomizableTrue  IsCustomizable = "true"
)

// PossibleIsCustomizableValues returns the possible values for the IsCustomizable const type.
func PossibleIsCustomizableValues() []IsCustomizable {
	return []IsCustomizable{
		IsCustomizableFalse,
		IsCustomizableTrue,
	}
}

// LimitCPUForMigration - Gets or sets a value indicating whether to enable processor compatibility mode for live migration
// of VMs.
type LimitCPUForMigration string

const (
	LimitCPUForMigrationFalse LimitCPUForMigration = "false"
	LimitCPUForMigrationTrue  LimitCPUForMigration = "true"
)

// PossibleLimitCPUForMigrationValues returns the possible values for the LimitCPUForMigration const type.
func PossibleLimitCPUForMigrationValues() []LimitCPUForMigration {
	return []LimitCPUForMigration{
		LimitCPUForMigrationFalse,
		LimitCPUForMigrationTrue,
	}
}

// OsType - Defines the different types of VM guest operating systems.
type OsType string

const (
	OsTypeLinux   OsType = "Linux"
	OsTypeOther   OsType = "Other"
	OsTypeWindows OsType = "Windows"
)

// PossibleOsTypeValues returns the possible values for the OsType const type.
func PossibleOsTypeValues() []OsType {
	return []OsType{
		OsTypeLinux,
		OsTypeOther,
		OsTypeWindows,
	}
}
