//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armreservations

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// CalculateRefundClient contains the methods for the CalculateRefund group.
// Don't use this type directly, use NewCalculateRefundClient() instead.
type CalculateRefundClient struct {
	internal *arm.Client
}

// NewCalculateRefundClient creates a new instance of CalculateRefundClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewCalculateRefundClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*CalculateRefundClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &CalculateRefundClient{
		internal: cl,
	}
	return client, nil
}

// Post - Calculate price for returning Reservations if there are no policy errors.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
//   - reservationOrderID - Order Id of the reservation
//   - body - Information needed for calculating refund of a reservation.
//   - options - CalculateRefundClientPostOptions contains the optional parameters for the CalculateRefundClient.Post method.
func (client *CalculateRefundClient) Post(ctx context.Context, reservationOrderID string, body CalculateRefundRequest, options *CalculateRefundClientPostOptions) (CalculateRefundClientPostResponse, error) {
	var err error
	const operationName = "CalculateRefundClient.Post"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.postCreateRequest(ctx, reservationOrderID, body, options)
	if err != nil {
		return CalculateRefundClientPostResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CalculateRefundClientPostResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return CalculateRefundClientPostResponse{}, err
	}
	resp, err := client.postHandleResponse(httpResp)
	return resp, err
}

// postCreateRequest creates the Post request.
func (client *CalculateRefundClient) postCreateRequest(ctx context.Context, reservationOrderID string, body CalculateRefundRequest, options *CalculateRefundClientPostOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/calculateRefund"
	if reservationOrderID == "" {
		return nil, errors.New("parameter reservationOrderID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{reservationOrderId}", url.PathEscape(reservationOrderID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// postHandleResponse handles the Post response.
func (client *CalculateRefundClient) postHandleResponse(resp *http.Response) (CalculateRefundClientPostResponse, error) {
	result := CalculateRefundClientPostResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CalculateRefundResponse); err != nil {
		return CalculateRefundClientPostResponse{}, err
	}
	return result, nil
}
