//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpolicyinsights_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/policyinsights/armpolicyinsights"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListDeploymentsManagementGroupScope.json
func ExampleRemediationsClient_NewListDeploymentsAtManagementGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRemediationsClient().NewListDeploymentsAtManagementGroupPager("financeMg", "myRemediation", &armpolicyinsights.QueryOptions{Top: nil,
		Filter:    nil,
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RemediationDeploymentsListResult = armpolicyinsights.RemediationDeploymentsListResult{
		// 	Value: []*armpolicyinsights.RemediationDeployment{
		// 		{
		// 			CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 			DeploymentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.resources/deployments/a088e8fd-8600-4126-8d74-fc7ead0e9ae4"),
		// 			LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:09.891Z"); return t}()),
		// 			RemediatedResourceID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1"),
		// 			ResourceLocation: to.Ptr("eastus"),
		// 			Status: to.Ptr("Succeeded"),
		// 		},
		// 		{
		// 			CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 			DeploymentID: to.Ptr("/subscriptions/c1164d71-0942-499f-bc2f-b6b7b0bae493/resourcegroups/myResourceGroup2/providers/microsoft.resources/deployments/6b8898c0-18a2-449e-987a-8d4d4f634f56"),
		// 			LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:09.876Z"); return t}()),
		// 			RemediatedResourceID: to.Ptr("/subscriptions/c1164d71-0942-499f-bc2f-b6b7b0bae493/resourcegroups/myResourceGroup2/providers/microsoft.storage/storageaccounts/stor1"),
		// 			ResourceLocation: to.Ptr("westus"),
		// 			Status: to.Ptr("Succeeded"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_CancelManagementGroupScope.json
func ExampleRemediationsClient_CancelAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().CancelAtManagementGroup(ctx, "financeMg", "myRemediation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("myRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/financeMg/providers/microsoft.policyinsights/remediations/myRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](2),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/providers/Microsoft.Management/managementGroups/financeMg/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListManagementGroupScope.json
func ExampleRemediationsClient_NewListForManagementGroupPager_listRemediationsAtManagementGroupScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRemediationsClient().NewListForManagementGroupPager("financeMg", &armpolicyinsights.QueryOptions{Top: nil,
		Filter:    nil,
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RemediationListResult = armpolicyinsights.RemediationListResult{
		// 	Value: []*armpolicyinsights.Remediation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementGroups/financeMg/providers/microsoft.policyinsights/remediations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](2),
		// 					TotalDeployments: to.Ptr[int32](2),
		// 				},
		// 				FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
		// 					Percentage: to.Ptr[float32](0.1),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
		// 				ParallelDeployments: to.Ptr[int32](6),
		// 				PolicyAssignmentID: to.Ptr("/providers/microsoft.management/managementGroups/financeMg/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceCount: to.Ptr[int32](42),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("0866f0cc-6cb3-422c-9fb6-a4e3e2266da8"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementGroups/financeMg/providers/microsoft.policyinsights/remediations/0866f0cc-6cb3-422c-9fb6-a4e3e2266da8"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("957378d3-a143-421e-8b0e-3048dff01932"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](2),
		// 					TotalDeployments: to.Ptr[int32](2),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				PolicyAssignmentID: to.Ptr("/providers/microsoft.management/managementGroups/financeMg/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListManagementGroupScope_WithQuery.json
func ExampleRemediationsClient_NewListForManagementGroupPager_listRemediationsAtManagementGroupScopeWithQueryParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRemediationsClient().NewListForManagementGroupPager("financeMg", &armpolicyinsights.QueryOptions{Top: to.Ptr[int32](1),
		Filter:    to.Ptr("PolicyAssignmentId eq '/providers/microsoft.management/managementGroups/financeMg/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5'"),
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RemediationListResult = armpolicyinsights.RemediationListResult{
		// 	Value: []*armpolicyinsights.Remediation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementGroups/financeMg/providers/microsoft.policyinsights/remediations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](2),
		// 					TotalDeployments: to.Ptr[int32](2),
		// 				},
		// 				FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
		// 					Percentage: to.Ptr[float32](0.1),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
		// 				ParallelDeployments: to.Ptr[int32](6),
		// 				PolicyAssignmentID: to.Ptr("/providers/microsoft.management/managementGroups/financeMg/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceCount: to.Ptr[int32](42),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_CreateManagementGroupScope.json
func ExampleRemediationsClient_CreateOrUpdateAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().CreateOrUpdateAtManagementGroup(ctx, "financeMg", "storageRemediation", armpolicyinsights.Remediation{
		Properties: &armpolicyinsights.RemediationProperties{
			PolicyAssignmentID: to.Ptr("/providers/microsoft.management/managementGroups/financeMg/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/providers/microsoft.management/managementGroups/financeMg/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](0),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		PolicyAssignmentID: to.Ptr("/providers/microsoft.management/managementGroups/financeMg/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_GetManagementGroupScope.json
func ExampleRemediationsClient_GetAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().GetAtManagementGroup(ctx, "financeMg", "storageRemediation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/financeMg/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](2),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/providers/Microsoft.Management/managementGroups/financeMg/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_DeleteManagementGroupScope.json
func ExampleRemediationsClient_DeleteAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().DeleteAtManagementGroup(ctx, "financeMg", "storageRemediation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/financeMg/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](2),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/providers/Microsoft.Management/managementGroups/financeMg/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListDeploymentsSubscriptionScope.json
func ExampleRemediationsClient_NewListDeploymentsAtSubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRemediationsClient().NewListDeploymentsAtSubscriptionPager("myRemediation", &armpolicyinsights.QueryOptions{Top: nil,
		Filter:    nil,
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RemediationDeploymentsListResult = armpolicyinsights.RemediationDeploymentsListResult{
		// 	Value: []*armpolicyinsights.RemediationDeployment{
		// 		{
		// 			CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 			DeploymentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.resources/deployments/a088e8fd-8600-4126-8d74-fc7ead0e9ae4"),
		// 			LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:09.891Z"); return t}()),
		// 			RemediatedResourceID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1"),
		// 			ResourceLocation: to.Ptr("eastus"),
		// 			Status: to.Ptr("Succeeded"),
		// 		},
		// 		{
		// 			CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 			DeploymentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup2/providers/microsoft.resources/deployments/6b8898c0-18a2-449e-987a-8d4d4f634f56"),
		// 			LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:09.876Z"); return t}()),
		// 			RemediatedResourceID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup2/providers/microsoft.storage/storageaccounts/stor1"),
		// 			ResourceLocation: to.Ptr("westus"),
		// 			Status: to.Ptr("Succeeded"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_CancelSubscriptionScope.json
func ExampleRemediationsClient_CancelAtSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().CancelAtSubscription(ctx, "myRemediation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("myRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.policyinsights/remediations/myRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](2),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListSubscriptionScope.json
func ExampleRemediationsClient_NewListForSubscriptionPager_listRemediationsAtSubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRemediationsClient().NewListForSubscriptionPager(&armpolicyinsights.QueryOptions{Top: nil,
		Filter:    nil,
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RemediationListResult = armpolicyinsights.RemediationListResult{
		// 	Value: []*armpolicyinsights.Remediation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.policyinsights/remediations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](2),
		// 					TotalDeployments: to.Ptr[int32](2),
		// 				},
		// 				FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
		// 					Percentage: to.Ptr[float32](0.1),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
		// 				ParallelDeployments: to.Ptr[int32](6),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceCount: to.Ptr[int32](42),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("0866f0cc-6cb3-422c-9fb6-a4e3e2266da8"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup2/providers/microsoft.policyinsights/remediations/0866f0cc-6cb3-422c-9fb6-a4e3e2266da8"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("957378d3-a143-421e-8b0e-3048dff01932"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](2),
		// 					TotalDeployments: to.Ptr[int32](2),
		// 				},
		// 				FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
		// 					Percentage: to.Ptr[float32](0.1),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				ParallelDeployments: to.Ptr[int32](6),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceCount: to.Ptr[int32](42),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListSubscriptionScope_WithQuery.json
func ExampleRemediationsClient_NewListForSubscriptionPager_listRemediationsAtSubscriptionScopeWithQueryParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRemediationsClient().NewListForSubscriptionPager(&armpolicyinsights.QueryOptions{Top: to.Ptr[int32](1),
		Filter:    to.Ptr("PolicyAssignmentId eq '/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5' AND PolicyDefinitionReferenceId eq 'storageSkuDef'"),
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RemediationListResult = armpolicyinsights.RemediationListResult{
		// 	Value: []*armpolicyinsights.Remediation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.policyinsights/remediations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](2),
		// 					TotalDeployments: to.Ptr[int32](2),
		// 				},
		// 				FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
		// 					Percentage: to.Ptr[float32](0.1),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
		// 				ParallelDeployments: to.Ptr[int32](6),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				PolicyDefinitionReferenceID: to.Ptr("storageSkuDef"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceCount: to.Ptr[int32](42),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("0866f0cc-6cb3-422c-9fb6-a4e3e2266da8"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/rg2/providers/microsoft.policyinsights/remediations/0866f0cc-6cb3-422c-9fb6-a4e3e2266da8"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("957378d3-a143-421e-8b0e-3048dff01932"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](2),
		// 					TotalDeployments: to.Ptr[int32](2),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				PolicyDefinitionReferenceID: to.Ptr("storageSkuDef"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_CreateSubscriptionScope.json
func ExampleRemediationsClient_CreateOrUpdateAtSubscription_createRemediationAtSubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().CreateOrUpdateAtSubscription(ctx, "storageRemediation", armpolicyinsights.Remediation{
		Properties: &armpolicyinsights.RemediationProperties{
			PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](0),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_CreateSubscriptionScope_AllProperties.json
func ExampleRemediationsClient_CreateOrUpdateAtSubscription_createRemediationAtSubscriptionScopeWithAllProperties() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().CreateOrUpdateAtSubscription(ctx, "storageRemediation", armpolicyinsights.Remediation{
		Properties: &armpolicyinsights.RemediationProperties{
			FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
				Percentage: to.Ptr[float32](0.1),
			},
			Filters: &armpolicyinsights.RemediationFilters{
				Locations: []*string{
					to.Ptr("eastus"),
					to.Ptr("westus")},
			},
			ParallelDeployments:         to.Ptr[int32](6),
			PolicyAssignmentID:          to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
			PolicyDefinitionReferenceID: to.Ptr("8c8fa9e4"),
			ResourceCount:               to.Ptr[int32](42),
			ResourceDiscoveryMode:       to.Ptr(armpolicyinsights.ResourceDiscoveryModeReEvaluateCompliance),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](0),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		PolicyDefinitionReferenceID: to.Ptr("8c8fa9e4"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeReEvaluateCompliance),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_GetSubscriptionScope.json
func ExampleRemediationsClient_GetAtSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().GetAtSubscription(ctx, "storageRemediation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](2),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_DeleteSubscriptionScope.json
func ExampleRemediationsClient_DeleteAtSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().DeleteAtSubscription(ctx, "storageRemediation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](2),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListDeploymentsResourceGroupScope.json
func ExampleRemediationsClient_NewListDeploymentsAtResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRemediationsClient().NewListDeploymentsAtResourceGroupPager("myResourceGroup", "myRemediation", &armpolicyinsights.QueryOptions{Top: nil,
		Filter:    nil,
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RemediationDeploymentsListResult = armpolicyinsights.RemediationDeploymentsListResult{
		// 	Value: []*armpolicyinsights.RemediationDeployment{
		// 		{
		// 			CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 			DeploymentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.resources/deployments/a088e8fd-8600-4126-8d74-fc7ead0e9ae4"),
		// 			LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:09.891Z"); return t}()),
		// 			RemediatedResourceID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1"),
		// 			ResourceLocation: to.Ptr("eastus"),
		// 			Status: to.Ptr("Succeeded"),
		// 		},
		// 		{
		// 			CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 			DeploymentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.resources/deployments/6b8898c0-18a2-449e-987a-8d4d4f634f56"),
		// 			LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:09.876Z"); return t}()),
		// 			RemediatedResourceID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/stor2"),
		// 			ResourceLocation: to.Ptr("westus"),
		// 			Status: to.Ptr("Succeeded"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_CancelResourceGroupScope.json
func ExampleRemediationsClient_CancelAtResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().CancelAtResourceGroup(ctx, "myResourceGroup", "myRemediation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("myRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.policyinsights/remediations/myRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](2),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListResourceGroupScope.json
func ExampleRemediationsClient_NewListForResourceGroupPager_listRemediationsAtResourceGroupScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRemediationsClient().NewListForResourceGroupPager("myResourceGroup", &armpolicyinsights.QueryOptions{Top: nil,
		Filter:    nil,
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RemediationListResult = armpolicyinsights.RemediationListResult{
		// 	Value: []*armpolicyinsights.Remediation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.policyinsights/remediations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](2),
		// 					TotalDeployments: to.Ptr[int32](2),
		// 				},
		// 				FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
		// 					Percentage: to.Ptr[float32](0.1),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
		// 				ParallelDeployments: to.Ptr[int32](6),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceCount: to.Ptr[int32](42),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("0866f0cc-6cb3-422c-9fb6-a4e3e2266da8"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.policyinsights/remediations/0866f0cc-6cb3-422c-9fb6-a4e3e2266da8"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("957378d3-a143-421e-8b0e-3048dff01932"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](2),
		// 					TotalDeployments: to.Ptr[int32](2),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListResourceGroupScope_WithQuery.json
func ExampleRemediationsClient_NewListForResourceGroupPager_listRemediationsAtResourceGroupScopeWithQueryParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRemediationsClient().NewListForResourceGroupPager("myResourceGroup", &armpolicyinsights.QueryOptions{Top: to.Ptr[int32](1),
		Filter:    to.Ptr("PolicyAssignmentId eq '/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourceGroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5'"),
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RemediationListResult = armpolicyinsights.RemediationListResult{
		// 	Value: []*armpolicyinsights.Remediation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.policyinsights/remediations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](2),
		// 					TotalDeployments: to.Ptr[int32](2),
		// 				},
		// 				FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
		// 					Percentage: to.Ptr[float32](0.1),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
		// 				ParallelDeployments: to.Ptr[int32](6),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceCount: to.Ptr[int32](42),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("0866f0cc-6cb3-422c-9fb6-a4e3e2266da8"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.policyinsights/remediations/0866f0cc-6cb3-422c-9fb6-a4e3e2266da8"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("957378d3-a143-421e-8b0e-3048dff01932"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](2),
		// 					TotalDeployments: to.Ptr[int32](2),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_CreateResourceGroupScope.json
func ExampleRemediationsClient_CreateOrUpdateAtResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().CreateOrUpdateAtResourceGroup(ctx, "myResourceGroup", "storageRemediation", armpolicyinsights.Remediation{
		Properties: &armpolicyinsights.RemediationProperties{
			PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourceGroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourceGroups/myResourceGroup/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](0),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourceGroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-15T18:52:27.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_GetResourceGroupScope.json
func ExampleRemediationsClient_GetAtResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().GetAtResourceGroup(ctx, "myResourceGroup", "storageRemediation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](2),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_DeleteResourceGroupScope.json
func ExampleRemediationsClient_DeleteAtResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().DeleteAtResourceGroup(ctx, "myResourceGroup", "storageRemediation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](2),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListDeploymentsResourceScope.json
func ExampleRemediationsClient_NewListDeploymentsAtResourcePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRemediationsClient().NewListDeploymentsAtResourcePager("subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1", "myRemediation", &armpolicyinsights.QueryOptions{Top: nil,
		Filter:    nil,
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RemediationDeploymentsListResult = armpolicyinsights.RemediationDeploymentsListResult{
		// 	Value: []*armpolicyinsights.RemediationDeployment{
		// 		{
		// 			CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 			DeploymentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.resources/deployments/a088e8fd-8600-4126-8d74-fc7ead0e9ae4"),
		// 			LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:09.891Z"); return t}()),
		// 			RemediatedResourceID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1"),
		// 			ResourceLocation: to.Ptr("eastus"),
		// 			Status: to.Ptr("Succeeded"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_CancelResourceScope.json
func ExampleRemediationsClient_CancelAtResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().CancelAtResource(ctx, "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1", "myRemediation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("myRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1/providers/microsoft.policyinsights/remediations/myRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.085Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](1),
	// 			TotalDeployments: to.Ptr[int32](1),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListResourceScope.json
func ExampleRemediationsClient_NewListForResourcePager_listRemediationsAtIndividualResourceScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRemediationsClient().NewListForResourcePager("subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1", &armpolicyinsights.QueryOptions{Top: nil,
		Filter:    nil,
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RemediationListResult = armpolicyinsights.RemediationListResult{
		// 	Value: []*armpolicyinsights.Remediation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1/providers/microsoft.policyinsights/remediations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](1),
		// 					TotalDeployments: to.Ptr[int32](1),
		// 				},
		// 				FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
		// 					Percentage: to.Ptr[float32](0.1),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
		// 				ParallelDeployments: to.Ptr[int32](6),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceCount: to.Ptr[int32](42),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:49:16.463Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:50:18.464Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_ListResourceScope_WithQuery.json
func ExampleRemediationsClient_NewListForResourcePager_listRemediationsAtIndividualResourceScopeWithQueryParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRemediationsClient().NewListForResourcePager("subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1", &armpolicyinsights.QueryOptions{Top: to.Ptr[int32](1),
		Filter:    to.Ptr("PolicyAssignmentId eq '/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5'"),
		OrderBy:   nil,
		Select:    nil,
		From:      nil,
		To:        nil,
		Apply:     nil,
		SkipToken: nil,
		Expand:    nil,
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RemediationListResult = armpolicyinsights.RemediationListResult{
		// 	Value: []*armpolicyinsights.Remediation{
		// 		{
		// 			Name: to.Ptr("790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
		// 			ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1/providers/microsoft.policyinsights/remediations/790996e6-9871-4b1f-9cd9-ec42cd6ced1e"),
		// 			Properties: &armpolicyinsights.RemediationProperties{
		// 				CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
		// 				CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 				DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
		// 					FailedDeployments: to.Ptr[int32](0),
		// 					SuccessfulDeployments: to.Ptr[int32](1),
		// 					TotalDeployments: to.Ptr[int32](1),
		// 				},
		// 				FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
		// 					Percentage: to.Ptr[float32](0.1),
		// 				},
		// 				LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
		// 				ParallelDeployments: to.Ptr[int32](6),
		// 				PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceCount: to.Ptr[int32](42),
		// 				ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
		// 				StatusMessage: to.Ptr("Remediation extended status"),
		// 			},
		// 			SystemData: &armpolicyinsights.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
		// 				CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
		// 				LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_CreateResourceScope.json
func ExampleRemediationsClient_CreateOrUpdateAtResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().CreateOrUpdateAtResource(ctx, "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1", "storageRemediation", armpolicyinsights.Remediation{
		Properties: &armpolicyinsights.RemediationProperties{
			PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourceGroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](0),
	// 			TotalDeployments: to.Ptr[int32](2),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourceGroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-12T20:58:58.753Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_GetResourceScope.json
func ExampleRemediationsClient_GetAtResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().GetAtResource(ctx, "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1", "storageRemediation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](1),
	// 			TotalDeployments: to.Ptr[int32](1),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2021-10-01/examples/Remediations_DeleteResourceScope.json
func ExampleRemediationsClient_DeleteAtResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRemediationsClient().DeleteAtResource(ctx, "subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1", "storageRemediation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Remediation = armpolicyinsights.Remediation{
	// 	Name: to.Ptr("storageRemediation"),
	// 	Type: to.Ptr("Microsoft.PolicyInsights/remediations"),
	// 	ID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.storage/storageaccounts/storAc1/providers/microsoft.policyinsights/remediations/storageRemediation"),
	// 	Properties: &armpolicyinsights.RemediationProperties{
	// 		CorrelationID: to.Ptr("a14e1d60-dae9-4771-b4be-a556d69e77a6"),
	// 		CreatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		DeploymentStatus: &armpolicyinsights.RemediationDeploymentSummary{
	// 			FailedDeployments: to.Ptr[int32](0),
	// 			SuccessfulDeployments: to.Ptr[int32](1),
	// 			TotalDeployments: to.Ptr[int32](1),
	// 		},
	// 		FailureThreshold: &armpolicyinsights.RemediationPropertiesFailureThreshold{
	// 			Percentage: to.Ptr[float32](0.1),
	// 		},
	// 		LastUpdatedOn: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		ParallelDeployments: to.Ptr[int32](6),
	// 		PolicyAssignmentID: to.Ptr("/subscriptions/35ee058e-5fa0-414c-8145-3ebb8d09b6e2/resourcegroups/myResourceGroup/providers/microsoft.authorization/policyassignments/b101830944f246d8a14088c5"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceCount: to.Ptr[int32](42),
	// 		ResourceDiscoveryMode: to.Ptr(armpolicyinsights.ResourceDiscoveryModeExistingNonCompliant),
	// 		StatusMessage: to.Ptr("Remediation extended status"),
	// 	},
	// 	SystemData: &armpolicyinsights.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:51:09.075Z"); return t}()),
	// 		CreatedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		CreatedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-13T21:52:10.001Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("b69a9388-9488-4534-b470-7ec6d41beef6"),
	// 		LastModifiedByType: to.Ptr(armpolicyinsights.CreatedByTypeUser),
	// 	},
	// }
}
