//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/keyvault/armkeyvault"
	"net/http"
	"net/url"
	"regexp"
)

// MHSMRegionsServer is a fake server for instances of the armkeyvault.MHSMRegionsClient type.
type MHSMRegionsServer struct {
	// NewListByResourcePager is the fake for method MHSMRegionsClient.NewListByResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourcePager func(resourceGroupName string, name string, options *armkeyvault.MHSMRegionsClientListByResourceOptions) (resp azfake.PagerResponder[armkeyvault.MHSMRegionsClientListByResourceResponse])
}

// NewMHSMRegionsServerTransport creates a new instance of MHSMRegionsServerTransport with the provided implementation.
// The returned MHSMRegionsServerTransport instance is connected to an instance of armkeyvault.MHSMRegionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMHSMRegionsServerTransport(srv *MHSMRegionsServer) *MHSMRegionsServerTransport {
	return &MHSMRegionsServerTransport{
		srv:                    srv,
		newListByResourcePager: newTracker[azfake.PagerResponder[armkeyvault.MHSMRegionsClientListByResourceResponse]](),
	}
}

// MHSMRegionsServerTransport connects instances of armkeyvault.MHSMRegionsClient to instances of MHSMRegionsServer.
// Don't use this type directly, use NewMHSMRegionsServerTransport instead.
type MHSMRegionsServerTransport struct {
	srv                    *MHSMRegionsServer
	newListByResourcePager *tracker[azfake.PagerResponder[armkeyvault.MHSMRegionsClientListByResourceResponse]]
}

// Do implements the policy.Transporter interface for MHSMRegionsServerTransport.
func (m *MHSMRegionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MHSMRegionsClient.NewListByResourcePager":
		resp, err = m.dispatchNewListByResourcePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MHSMRegionsServerTransport) dispatchNewListByResourcePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourcePager not implemented")}
	}
	newListByResourcePager := m.newListByResourcePager.get(req)
	if newListByResourcePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.KeyVault/managedHSMs/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByResourcePager(resourceGroupNameParam, nameParam, nil)
		newListByResourcePager = &resp
		m.newListByResourcePager.add(req, newListByResourcePager)
		server.PagerResponderInjectNextLinks(newListByResourcePager, req, func(page *armkeyvault.MHSMRegionsClientListByResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourcePager) {
		m.newListByResourcePager.remove(req)
	}
	return resp, nil
}
