//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotsecurity

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewDefenderSettingsClient creates a new instance of DefenderSettingsClient.
func (c *ClientFactory) NewDefenderSettingsClient() *DefenderSettingsClient {
	subClient, _ := NewDefenderSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDeviceGroupsClient creates a new instance of DeviceGroupsClient.
func (c *ClientFactory) NewDeviceGroupsClient() *DeviceGroupsClient {
	subClient, _ := NewDeviceGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDevicesClient creates a new instance of DevicesClient.
func (c *ClientFactory) NewDevicesClient() *DevicesClient {
	subClient, _ := NewDevicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLocationsClient creates a new instance of LocationsClient.
func (c *ClientFactory) NewLocationsClient() *LocationsClient {
	subClient, _ := NewLocationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOnPremiseSensorsClient creates a new instance of OnPremiseSensorsClient.
func (c *ClientFactory) NewOnPremiseSensorsClient() *OnPremiseSensorsClient {
	subClient, _ := NewOnPremiseSensorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewSensorsClient creates a new instance of SensorsClient.
func (c *ClientFactory) NewSensorsClient() *SensorsClient {
	subClient, _ := NewSensorsClient(c.credential, c.options)
	return subClient
}

// NewSitesClient creates a new instance of SitesClient.
func (c *ClientFactory) NewSitesClient() *SitesClient {
	subClient, _ := NewSitesClient(c.credential, c.options)
	return subClient
}
