//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iothub/armiothub"
	"net/http"
	"regexp"
)

// ResourceProviderCommonServer is a fake server for instances of the armiothub.ResourceProviderCommonClient type.
type ResourceProviderCommonServer struct {
	// GetSubscriptionQuota is the fake for method ResourceProviderCommonClient.GetSubscriptionQuota
	// HTTP status codes to indicate success: http.StatusOK
	GetSubscriptionQuota func(ctx context.Context, options *armiothub.ResourceProviderCommonClientGetSubscriptionQuotaOptions) (resp azfake.Responder[armiothub.ResourceProviderCommonClientGetSubscriptionQuotaResponse], errResp azfake.ErrorResponder)
}

// NewResourceProviderCommonServerTransport creates a new instance of ResourceProviderCommonServerTransport with the provided implementation.
// The returned ResourceProviderCommonServerTransport instance is connected to an instance of armiothub.ResourceProviderCommonClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewResourceProviderCommonServerTransport(srv *ResourceProviderCommonServer) *ResourceProviderCommonServerTransport {
	return &ResourceProviderCommonServerTransport{srv: srv}
}

// ResourceProviderCommonServerTransport connects instances of armiothub.ResourceProviderCommonClient to instances of ResourceProviderCommonServer.
// Don't use this type directly, use NewResourceProviderCommonServerTransport instead.
type ResourceProviderCommonServerTransport struct {
	srv *ResourceProviderCommonServer
}

// Do implements the policy.Transporter interface for ResourceProviderCommonServerTransport.
func (r *ResourceProviderCommonServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ResourceProviderCommonClient.GetSubscriptionQuota":
		resp, err = r.dispatchGetSubscriptionQuota(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ResourceProviderCommonServerTransport) dispatchGetSubscriptionQuota(req *http.Request) (*http.Response, error) {
	if r.srv.GetSubscriptionQuota == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSubscriptionQuota not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/usages`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := r.srv.GetSubscriptionQuota(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).UserSubscriptionQuotaListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
