//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridnetwork

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewArtifactManifestsClient creates a new instance of ArtifactManifestsClient.
func (c *ClientFactory) NewArtifactManifestsClient() *ArtifactManifestsClient {
	subClient, _ := NewArtifactManifestsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewArtifactStoresClient creates a new instance of ArtifactStoresClient.
func (c *ClientFactory) NewArtifactStoresClient() *ArtifactStoresClient {
	subClient, _ := NewArtifactStoresClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewComponentsClient creates a new instance of ComponentsClient.
func (c *ClientFactory) NewComponentsClient() *ComponentsClient {
	subClient, _ := NewComponentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewConfigurationGroupSchemasClient creates a new instance of ConfigurationGroupSchemasClient.
func (c *ClientFactory) NewConfigurationGroupSchemasClient() *ConfigurationGroupSchemasClient {
	subClient, _ := NewConfigurationGroupSchemasClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewConfigurationGroupValuesClient creates a new instance of ConfigurationGroupValuesClient.
func (c *ClientFactory) NewConfigurationGroupValuesClient() *ConfigurationGroupValuesClient {
	subClient, _ := NewConfigurationGroupValuesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNetworkFunctionDefinitionGroupsClient creates a new instance of NetworkFunctionDefinitionGroupsClient.
func (c *ClientFactory) NewNetworkFunctionDefinitionGroupsClient() *NetworkFunctionDefinitionGroupsClient {
	subClient, _ := NewNetworkFunctionDefinitionGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNetworkFunctionDefinitionVersionsClient creates a new instance of NetworkFunctionDefinitionVersionsClient.
func (c *ClientFactory) NewNetworkFunctionDefinitionVersionsClient() *NetworkFunctionDefinitionVersionsClient {
	subClient, _ := NewNetworkFunctionDefinitionVersionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNetworkFunctionsClient creates a new instance of NetworkFunctionsClient.
func (c *ClientFactory) NewNetworkFunctionsClient() *NetworkFunctionsClient {
	subClient, _ := NewNetworkFunctionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNetworkServiceDesignGroupsClient creates a new instance of NetworkServiceDesignGroupsClient.
func (c *ClientFactory) NewNetworkServiceDesignGroupsClient() *NetworkServiceDesignGroupsClient {
	subClient, _ := NewNetworkServiceDesignGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNetworkServiceDesignVersionsClient creates a new instance of NetworkServiceDesignVersionsClient.
func (c *ClientFactory) NewNetworkServiceDesignVersionsClient() *NetworkServiceDesignVersionsClient {
	subClient, _ := NewNetworkServiceDesignVersionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewProxyArtifactClient creates a new instance of ProxyArtifactClient.
func (c *ClientFactory) NewProxyArtifactClient() *ProxyArtifactClient {
	subClient, _ := NewProxyArtifactClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPublishersClient creates a new instance of PublishersClient.
func (c *ClientFactory) NewPublishersClient() *PublishersClient {
	subClient, _ := NewPublishersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSiteNetworkServicesClient creates a new instance of SiteNetworkServicesClient.
func (c *ClientFactory) NewSiteNetworkServicesClient() *SiteNetworkServicesClient {
	subClient, _ := NewSiteNetworkServicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSitesClient creates a new instance of SitesClient.
func (c *ClientFactory) NewSitesClient() *SitesClient {
	subClient, _ := NewSitesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
