//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhdinsight

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AaddsResourceDetails.
func (a AaddsResourceDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainName", a.DomainName)
	populate(objectMap, "initialSyncComplete", a.InitialSyncComplete)
	populate(objectMap, "ldapsEnabled", a.LdapsEnabled)
	populate(objectMap, "ldapsPublicCertificateInBase64", a.LdapsPublicCertificateInBase64)
	populate(objectMap, "resourceId", a.ResourceID)
	populate(objectMap, "subnetId", a.SubnetID)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AaddsResourceDetails.
func (a *AaddsResourceDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainName":
			err = unpopulate(val, "DomainName", &a.DomainName)
			delete(rawMsg, key)
		case "initialSyncComplete":
			err = unpopulate(val, "InitialSyncComplete", &a.InitialSyncComplete)
			delete(rawMsg, key)
		case "ldapsEnabled":
			err = unpopulate(val, "LdapsEnabled", &a.LdapsEnabled)
			delete(rawMsg, key)
		case "ldapsPublicCertificateInBase64":
			err = unpopulate(val, "LdapsPublicCertificateInBase64", &a.LdapsPublicCertificateInBase64)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &a.ResourceID)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &a.SubnetID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Application.
func (a Application) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Application.
func (a *Application) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGetEndpoint.
func (a ApplicationGetEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationPort", a.DestinationPort)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "privateIPAddress", a.PrivateIPAddress)
	populate(objectMap, "publicPort", a.PublicPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGetEndpoint.
func (a *ApplicationGetEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationPort":
			err = unpopulate(val, "DestinationPort", &a.DestinationPort)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &a.PrivateIPAddress)
			delete(rawMsg, key)
		case "publicPort":
			err = unpopulate(val, "PublicPort", &a.PublicPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGetHTTPSEndpoint.
func (a ApplicationGetHTTPSEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessModes", a.AccessModes)
	populate(objectMap, "destinationPort", a.DestinationPort)
	populate(objectMap, "disableGatewayAuth", a.DisableGatewayAuth)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "privateIPAddress", a.PrivateIPAddress)
	populate(objectMap, "publicPort", a.PublicPort)
	populate(objectMap, "subDomainSuffix", a.SubDomainSuffix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGetHTTPSEndpoint.
func (a *ApplicationGetHTTPSEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessModes":
			err = unpopulate(val, "AccessModes", &a.AccessModes)
			delete(rawMsg, key)
		case "destinationPort":
			err = unpopulate(val, "DestinationPort", &a.DestinationPort)
			delete(rawMsg, key)
		case "disableGatewayAuth":
			err = unpopulate(val, "DisableGatewayAuth", &a.DisableGatewayAuth)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &a.PrivateIPAddress)
			delete(rawMsg, key)
		case "publicPort":
			err = unpopulate(val, "PublicPort", &a.PublicPort)
			delete(rawMsg, key)
		case "subDomainSuffix":
			err = unpopulate(val, "SubDomainSuffix", &a.SubDomainSuffix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationListResult.
func (a ApplicationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationListResult.
func (a *ApplicationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationProperties.
func (a ApplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationState", a.ApplicationState)
	populate(objectMap, "applicationType", a.ApplicationType)
	populate(objectMap, "computeProfile", a.ComputeProfile)
	populate(objectMap, "createdDate", a.CreatedDate)
	populate(objectMap, "errors", a.Errors)
	populate(objectMap, "httpsEndpoints", a.HTTPSEndpoints)
	populate(objectMap, "installScriptActions", a.InstallScriptActions)
	populate(objectMap, "marketplaceIdentifier", a.MarketplaceIdentifier)
	populate(objectMap, "privateLinkConfigurations", a.PrivateLinkConfigurations)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "sshEndpoints", a.SSHEndpoints)
	populate(objectMap, "uninstallScriptActions", a.UninstallScriptActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationProperties.
func (a *ApplicationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationState":
			err = unpopulate(val, "ApplicationState", &a.ApplicationState)
			delete(rawMsg, key)
		case "applicationType":
			err = unpopulate(val, "ApplicationType", &a.ApplicationType)
			delete(rawMsg, key)
		case "computeProfile":
			err = unpopulate(val, "ComputeProfile", &a.ComputeProfile)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulate(val, "CreatedDate", &a.CreatedDate)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &a.Errors)
			delete(rawMsg, key)
		case "httpsEndpoints":
			err = unpopulate(val, "HTTPSEndpoints", &a.HTTPSEndpoints)
			delete(rawMsg, key)
		case "installScriptActions":
			err = unpopulate(val, "InstallScriptActions", &a.InstallScriptActions)
			delete(rawMsg, key)
		case "marketplaceIdentifier":
			err = unpopulate(val, "MarketplaceIdentifier", &a.MarketplaceIdentifier)
			delete(rawMsg, key)
		case "privateLinkConfigurations":
			err = unpopulate(val, "PrivateLinkConfigurations", &a.PrivateLinkConfigurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "sshEndpoints":
			err = unpopulate(val, "SSHEndpoints", &a.SSHEndpoints)
			delete(rawMsg, key)
		case "uninstallScriptActions":
			err = unpopulate(val, "UninstallScriptActions", &a.UninstallScriptActions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AsyncOperationResult.
func (a AsyncOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AsyncOperationResult.
func (a *AsyncOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Autoscale.
func (a Autoscale) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", a.Capacity)
	populate(objectMap, "recurrence", a.Recurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Autoscale.
func (a *Autoscale) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &a.Capacity)
			delete(rawMsg, key)
		case "recurrence":
			err = unpopulate(val, "Recurrence", &a.Recurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoscaleCapacity.
func (a AutoscaleCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxInstanceCount", a.MaxInstanceCount)
	populate(objectMap, "minInstanceCount", a.MinInstanceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoscaleCapacity.
func (a *AutoscaleCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxInstanceCount":
			err = unpopulate(val, "MaxInstanceCount", &a.MaxInstanceCount)
			delete(rawMsg, key)
		case "minInstanceCount":
			err = unpopulate(val, "MinInstanceCount", &a.MinInstanceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoscaleConfigurationUpdateParameter.
func (a AutoscaleConfigurationUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoscale", a.Autoscale)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoscaleConfigurationUpdateParameter.
func (a *AutoscaleConfigurationUpdateParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoscale":
			err = unpopulate(val, "Autoscale", &a.Autoscale)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoscaleRecurrence.
func (a AutoscaleRecurrence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "schedule", a.Schedule)
	populate(objectMap, "timeZone", a.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoscaleRecurrence.
func (a *AutoscaleRecurrence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schedule":
			err = unpopulate(val, "Schedule", &a.Schedule)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &a.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoscaleSchedule.
func (a AutoscaleSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "days", a.Days)
	populate(objectMap, "timeAndCapacity", a.TimeAndCapacity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoscaleSchedule.
func (a *AutoscaleSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "days":
			err = unpopulate(val, "Days", &a.Days)
			delete(rawMsg, key)
		case "timeAndCapacity":
			err = unpopulate(val, "TimeAndCapacity", &a.TimeAndCapacity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoscaleTimeAndCapacity.
func (a AutoscaleTimeAndCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxInstanceCount", a.MaxInstanceCount)
	populate(objectMap, "minInstanceCount", a.MinInstanceCount)
	populate(objectMap, "time", a.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoscaleTimeAndCapacity.
func (a *AutoscaleTimeAndCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxInstanceCount":
			err = unpopulate(val, "MaxInstanceCount", &a.MaxInstanceCount)
			delete(rawMsg, key)
		case "minInstanceCount":
			err = unpopulate(val, "MinInstanceCount", &a.MinInstanceCount)
			delete(rawMsg, key)
		case "time":
			err = unpopulate(val, "Time", &a.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMonitorRequest.
func (a AzureMonitorRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primaryKey", a.PrimaryKey)
	populate(objectMap, "selectedConfigurations", a.SelectedConfigurations)
	populate(objectMap, "workspaceId", a.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMonitorRequest.
func (a *AzureMonitorRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &a.PrimaryKey)
			delete(rawMsg, key)
		case "selectedConfigurations":
			err = unpopulate(val, "SelectedConfigurations", &a.SelectedConfigurations)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &a.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMonitorResponse.
func (a AzureMonitorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterMonitoringEnabled", a.ClusterMonitoringEnabled)
	populate(objectMap, "selectedConfigurations", a.SelectedConfigurations)
	populate(objectMap, "workspaceId", a.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMonitorResponse.
func (a *AzureMonitorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterMonitoringEnabled":
			err = unpopulate(val, "ClusterMonitoringEnabled", &a.ClusterMonitoringEnabled)
			delete(rawMsg, key)
		case "selectedConfigurations":
			err = unpopulate(val, "SelectedConfigurations", &a.SelectedConfigurations)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &a.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMonitorSelectedConfigurations.
func (a AzureMonitorSelectedConfigurations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationVersion", a.ConfigurationVersion)
	populate(objectMap, "globalConfigurations", a.GlobalConfigurations)
	populate(objectMap, "tableList", a.TableList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMonitorSelectedConfigurations.
func (a *AzureMonitorSelectedConfigurations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationVersion":
			err = unpopulate(val, "ConfigurationVersion", &a.ConfigurationVersion)
			delete(rawMsg, key)
		case "globalConfigurations":
			err = unpopulate(val, "GlobalConfigurations", &a.GlobalConfigurations)
			delete(rawMsg, key)
		case "tableList":
			err = unpopulate(val, "TableList", &a.TableList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMonitorTableConfiguration.
func (a AzureMonitorTableConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMonitorTableConfiguration.
func (a *AzureMonitorTableConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingMeters.
func (b BillingMeters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "meter", b.Meter)
	populate(objectMap, "meterParameter", b.MeterParameter)
	populate(objectMap, "unit", b.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingMeters.
func (b *BillingMeters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "meter":
			err = unpopulate(val, "Meter", &b.Meter)
			delete(rawMsg, key)
		case "meterParameter":
			err = unpopulate(val, "MeterParameter", &b.MeterParameter)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &b.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingResources.
func (b BillingResources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingMeters", b.BillingMeters)
	populate(objectMap, "diskBillingMeters", b.DiskBillingMeters)
	populate(objectMap, "region", b.Region)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingResources.
func (b *BillingResources) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingMeters":
			err = unpopulate(val, "BillingMeters", &b.BillingMeters)
			delete(rawMsg, key)
		case "diskBillingMeters":
			err = unpopulate(val, "DiskBillingMeters", &b.DiskBillingMeters)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &b.Region)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingResponseListResult.
func (b BillingResponseListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingResources", b.BillingResources)
	populate(objectMap, "vmSizeFilters", b.VMSizeFilters)
	populate(objectMap, "vmSizeProperties", b.VMSizeProperties)
	populate(objectMap, "vmSizes", b.VMSizes)
	populate(objectMap, "vmSizesWithEncryptionAtHost", b.VMSizesWithEncryptionAtHost)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingResponseListResult.
func (b *BillingResponseListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingResources":
			err = unpopulate(val, "BillingResources", &b.BillingResources)
			delete(rawMsg, key)
		case "vmSizeFilters":
			err = unpopulate(val, "VMSizeFilters", &b.VMSizeFilters)
			delete(rawMsg, key)
		case "vmSizeProperties":
			err = unpopulate(val, "VMSizeProperties", &b.VMSizeProperties)
			delete(rawMsg, key)
		case "vmSizes":
			err = unpopulate(val, "VMSizes", &b.VMSizes)
			delete(rawMsg, key)
		case "vmSizesWithEncryptionAtHost":
			err = unpopulate(val, "VMSizesWithEncryptionAtHost", &b.VMSizesWithEncryptionAtHost)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapabilitiesResult.
func (c CapabilitiesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "features", c.Features)
	populate(objectMap, "quota", c.Quota)
	populate(objectMap, "regions", c.Regions)
	populate(objectMap, "versions", c.Versions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapabilitiesResult.
func (c *CapabilitiesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "features":
			err = unpopulate(val, "Features", &c.Features)
			delete(rawMsg, key)
		case "quota":
			err = unpopulate(val, "Quota", &c.Quota)
			delete(rawMsg, key)
		case "regions":
			err = unpopulate(val, "Regions", &c.Regions)
			delete(rawMsg, key)
		case "versions":
			err = unpopulate(val, "Versions", &c.Versions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientGroupInfo.
func (c ClientGroupInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", c.GroupID)
	populate(objectMap, "groupName", c.GroupName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientGroupInfo.
func (c *ClientGroupInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &c.GroupID)
			delete(rawMsg, key)
		case "groupName":
			err = unpopulate(val, "GroupName", &c.GroupName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "identity", c.Identity)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "zones", c.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Cluster.
func (c *Cluster) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &c.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &c.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterConfigurations.
func (c ClusterConfigurations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurations", c.Configurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterConfigurations.
func (c *ClusterConfigurations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurations":
			err = unpopulate(val, "Configurations", &c.Configurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterCreateParametersExtended.
func (c ClusterCreateParametersExtended) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", c.Identity)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "zones", c.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterCreateParametersExtended.
func (c *ClusterCreateParametersExtended) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &c.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &c.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterCreateProperties.
func (c ClusterCreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterDefinition", c.ClusterDefinition)
	populate(objectMap, "clusterVersion", c.ClusterVersion)
	populate(objectMap, "computeIsolationProperties", c.ComputeIsolationProperties)
	populate(objectMap, "computeProfile", c.ComputeProfile)
	populate(objectMap, "diskEncryptionProperties", c.DiskEncryptionProperties)
	populate(objectMap, "encryptionInTransitProperties", c.EncryptionInTransitProperties)
	populate(objectMap, "kafkaRestProperties", c.KafkaRestProperties)
	populate(objectMap, "minSupportedTlsVersion", c.MinSupportedTLSVersion)
	populate(objectMap, "networkProperties", c.NetworkProperties)
	populate(objectMap, "osType", c.OSType)
	populate(objectMap, "privateLinkConfigurations", c.PrivateLinkConfigurations)
	populate(objectMap, "securityProfile", c.SecurityProfile)
	populate(objectMap, "storageProfile", c.StorageProfile)
	populate(objectMap, "tier", c.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterCreateProperties.
func (c *ClusterCreateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterDefinition":
			err = unpopulate(val, "ClusterDefinition", &c.ClusterDefinition)
			delete(rawMsg, key)
		case "clusterVersion":
			err = unpopulate(val, "ClusterVersion", &c.ClusterVersion)
			delete(rawMsg, key)
		case "computeIsolationProperties":
			err = unpopulate(val, "ComputeIsolationProperties", &c.ComputeIsolationProperties)
			delete(rawMsg, key)
		case "computeProfile":
			err = unpopulate(val, "ComputeProfile", &c.ComputeProfile)
			delete(rawMsg, key)
		case "diskEncryptionProperties":
			err = unpopulate(val, "DiskEncryptionProperties", &c.DiskEncryptionProperties)
			delete(rawMsg, key)
		case "encryptionInTransitProperties":
			err = unpopulate(val, "EncryptionInTransitProperties", &c.EncryptionInTransitProperties)
			delete(rawMsg, key)
		case "kafkaRestProperties":
			err = unpopulate(val, "KafkaRestProperties", &c.KafkaRestProperties)
			delete(rawMsg, key)
		case "minSupportedTlsVersion":
			err = unpopulate(val, "MinSupportedTLSVersion", &c.MinSupportedTLSVersion)
			delete(rawMsg, key)
		case "networkProperties":
			err = unpopulate(val, "NetworkProperties", &c.NetworkProperties)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &c.OSType)
			delete(rawMsg, key)
		case "privateLinkConfigurations":
			err = unpopulate(val, "PrivateLinkConfigurations", &c.PrivateLinkConfigurations)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &c.SecurityProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &c.StorageProfile)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &c.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterCreateRequestValidationParameters.
func (c ClusterCreateRequestValidationParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fetchAaddsResource", c.FetchAaddsResource)
	populate(objectMap, "identity", c.Identity)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "tenantId", c.TenantID)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "zones", c.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterCreateRequestValidationParameters.
func (c *ClusterCreateRequestValidationParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fetchAaddsResource":
			err = unpopulate(val, "FetchAaddsResource", &c.FetchAaddsResource)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &c.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &c.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &c.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterCreateValidationResult.
func (c ClusterCreateValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aaddsResourcesDetails", c.AaddsResourcesDetails)
	populate(objectMap, "estimatedCreationDuration", c.EstimatedCreationDuration)
	populate(objectMap, "validationErrors", c.ValidationErrors)
	populate(objectMap, "validationWarnings", c.ValidationWarnings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterCreateValidationResult.
func (c *ClusterCreateValidationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aaddsResourcesDetails":
			err = unpopulate(val, "AaddsResourcesDetails", &c.AaddsResourcesDetails)
			delete(rawMsg, key)
		case "estimatedCreationDuration":
			err = unpopulate(val, "EstimatedCreationDuration", &c.EstimatedCreationDuration)
			delete(rawMsg, key)
		case "validationErrors":
			err = unpopulate(val, "ValidationErrors", &c.ValidationErrors)
			delete(rawMsg, key)
		case "validationWarnings":
			err = unpopulate(val, "ValidationWarnings", &c.ValidationWarnings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterDefinition.
func (c ClusterDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blueprint", c.Blueprint)
	populate(objectMap, "componentVersion", c.ComponentVersion)
	populateAny(objectMap, "configurations", c.Configurations)
	populate(objectMap, "kind", c.Kind)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterDefinition.
func (c *ClusterDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blueprint":
			err = unpopulate(val, "Blueprint", &c.Blueprint)
			delete(rawMsg, key)
		case "componentVersion":
			err = unpopulate(val, "ComponentVersion", &c.ComponentVersion)
			delete(rawMsg, key)
		case "configurations":
			err = unpopulate(val, "Configurations", &c.Configurations)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterDiskEncryptionParameters.
func (c ClusterDiskEncryptionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyName", c.KeyName)
	populate(objectMap, "keyVersion", c.KeyVersion)
	populate(objectMap, "vaultUri", c.VaultURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterDiskEncryptionParameters.
func (c *ClusterDiskEncryptionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyName":
			err = unpopulate(val, "KeyName", &c.KeyName)
			delete(rawMsg, key)
		case "keyVersion":
			err = unpopulate(val, "KeyVersion", &c.KeyVersion)
			delete(rawMsg, key)
		case "vaultUri":
			err = unpopulate(val, "VaultURI", &c.VaultURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterGetProperties.
func (c ClusterGetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterDefinition", c.ClusterDefinition)
	populate(objectMap, "clusterHdpVersion", c.ClusterHdpVersion)
	populate(objectMap, "clusterId", c.ClusterID)
	populate(objectMap, "clusterState", c.ClusterState)
	populate(objectMap, "clusterVersion", c.ClusterVersion)
	populate(objectMap, "computeIsolationProperties", c.ComputeIsolationProperties)
	populate(objectMap, "computeProfile", c.ComputeProfile)
	populate(objectMap, "connectivityEndpoints", c.ConnectivityEndpoints)
	populate(objectMap, "createdDate", c.CreatedDate)
	populate(objectMap, "diskEncryptionProperties", c.DiskEncryptionProperties)
	populate(objectMap, "encryptionInTransitProperties", c.EncryptionInTransitProperties)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "excludedServicesConfig", c.ExcludedServicesConfig)
	populate(objectMap, "kafkaRestProperties", c.KafkaRestProperties)
	populate(objectMap, "minSupportedTlsVersion", c.MinSupportedTLSVersion)
	populate(objectMap, "networkProperties", c.NetworkProperties)
	populate(objectMap, "osType", c.OSType)
	populate(objectMap, "privateEndpointConnections", c.PrivateEndpointConnections)
	populate(objectMap, "privateLinkConfigurations", c.PrivateLinkConfigurations)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "quotaInfo", c.QuotaInfo)
	populate(objectMap, "securityProfile", c.SecurityProfile)
	populate(objectMap, "storageProfile", c.StorageProfile)
	populate(objectMap, "tier", c.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterGetProperties.
func (c *ClusterGetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterDefinition":
			err = unpopulate(val, "ClusterDefinition", &c.ClusterDefinition)
			delete(rawMsg, key)
		case "clusterHdpVersion":
			err = unpopulate(val, "ClusterHdpVersion", &c.ClusterHdpVersion)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &c.ClusterID)
			delete(rawMsg, key)
		case "clusterState":
			err = unpopulate(val, "ClusterState", &c.ClusterState)
			delete(rawMsg, key)
		case "clusterVersion":
			err = unpopulate(val, "ClusterVersion", &c.ClusterVersion)
			delete(rawMsg, key)
		case "computeIsolationProperties":
			err = unpopulate(val, "ComputeIsolationProperties", &c.ComputeIsolationProperties)
			delete(rawMsg, key)
		case "computeProfile":
			err = unpopulate(val, "ComputeProfile", &c.ComputeProfile)
			delete(rawMsg, key)
		case "connectivityEndpoints":
			err = unpopulate(val, "ConnectivityEndpoints", &c.ConnectivityEndpoints)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulate(val, "CreatedDate", &c.CreatedDate)
			delete(rawMsg, key)
		case "diskEncryptionProperties":
			err = unpopulate(val, "DiskEncryptionProperties", &c.DiskEncryptionProperties)
			delete(rawMsg, key)
		case "encryptionInTransitProperties":
			err = unpopulate(val, "EncryptionInTransitProperties", &c.EncryptionInTransitProperties)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "excludedServicesConfig":
			err = unpopulate(val, "ExcludedServicesConfig", &c.ExcludedServicesConfig)
			delete(rawMsg, key)
		case "kafkaRestProperties":
			err = unpopulate(val, "KafkaRestProperties", &c.KafkaRestProperties)
			delete(rawMsg, key)
		case "minSupportedTlsVersion":
			err = unpopulate(val, "MinSupportedTLSVersion", &c.MinSupportedTLSVersion)
			delete(rawMsg, key)
		case "networkProperties":
			err = unpopulate(val, "NetworkProperties", &c.NetworkProperties)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &c.OSType)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &c.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "privateLinkConfigurations":
			err = unpopulate(val, "PrivateLinkConfigurations", &c.PrivateLinkConfigurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "quotaInfo":
			err = unpopulate(val, "QuotaInfo", &c.QuotaInfo)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &c.SecurityProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &c.StorageProfile)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &c.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterIdentity.
func (c ClusterIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", c.PrincipalID)
	populate(objectMap, "tenantId", c.TenantID)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "userAssignedIdentities", c.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterIdentity.
func (c *ClusterIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &c.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &c.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &c.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterListPersistedScriptActionsResult.
func (c ClusterListPersistedScriptActionsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterListPersistedScriptActionsResult.
func (c *ClusterListPersistedScriptActionsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterListResult.
func (c ClusterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterListResult.
func (c *ClusterListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterMonitoringRequest.
func (c ClusterMonitoringRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primaryKey", c.PrimaryKey)
	populate(objectMap, "workspaceId", c.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterMonitoringRequest.
func (c *ClusterMonitoringRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &c.PrimaryKey)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &c.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterMonitoringResponse.
func (c ClusterMonitoringResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterMonitoringEnabled", c.ClusterMonitoringEnabled)
	populate(objectMap, "workspaceId", c.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterMonitoringResponse.
func (c *ClusterMonitoringResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterMonitoringEnabled":
			err = unpopulate(val, "ClusterMonitoringEnabled", &c.ClusterMonitoringEnabled)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &c.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPatchParameters.
func (c ClusterPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPatchParameters.
func (c *ClusterPatchParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterResizeParameters.
func (c ClusterResizeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetInstanceCount", c.TargetInstanceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterResizeParameters.
func (c *ClusterResizeParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetInstanceCount":
			err = unpopulate(val, "TargetInstanceCount", &c.TargetInstanceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeIsolationProperties.
func (c ComputeIsolationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableComputeIsolation", c.EnableComputeIsolation)
	populate(objectMap, "hostSku", c.HostSKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeIsolationProperties.
func (c *ComputeIsolationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableComputeIsolation":
			err = unpopulate(val, "EnableComputeIsolation", &c.EnableComputeIsolation)
			delete(rawMsg, key)
		case "hostSku":
			err = unpopulate(val, "HostSKU", &c.HostSKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeProfile.
func (c ComputeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "roles", c.Roles)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeProfile.
func (c *ComputeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "roles":
			err = unpopulate(val, "Roles", &c.Roles)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityEndpoint.
func (c ConnectivityEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "port", c.Port)
	populate(objectMap, "privateIPAddress", c.PrivateIPAddress)
	populate(objectMap, "protocol", c.Protocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityEndpoint.
func (c *ConnectivityEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &c.PrivateIPAddress)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &c.Protocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataDisksGroups.
func (d DataDisksGroups) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskSizeGB", d.DiskSizeGB)
	populate(objectMap, "disksPerNode", d.DisksPerNode)
	populate(objectMap, "storageAccountType", d.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataDisksGroups.
func (d *DataDisksGroups) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &d.DiskSizeGB)
			delete(rawMsg, key)
		case "disksPerNode":
			err = unpopulate(val, "DisksPerNode", &d.DisksPerNode)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &d.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dimension.
func (d Dimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "internalName", d.InternalName)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "toBeExportedForShoebox", d.ToBeExportedForShoebox)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dimension.
func (d *Dimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "internalName":
			err = unpopulate(val, "InternalName", &d.InternalName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "toBeExportedForShoebox":
			err = unpopulate(val, "ToBeExportedForShoebox", &d.ToBeExportedForShoebox)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskBillingMeters.
func (d DiskBillingMeters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskRpMeter", d.DiskRpMeter)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tier", d.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskBillingMeters.
func (d *DiskBillingMeters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskRpMeter":
			err = unpopulate(val, "DiskRpMeter", &d.DiskRpMeter)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &d.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionProperties.
func (d DiskEncryptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionAlgorithm", d.EncryptionAlgorithm)
	populate(objectMap, "encryptionAtHost", d.EncryptionAtHost)
	populate(objectMap, "keyName", d.KeyName)
	populate(objectMap, "keyVersion", d.KeyVersion)
	populate(objectMap, "msiResourceId", d.MsiResourceID)
	populate(objectMap, "vaultUri", d.VaultURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionProperties.
func (d *DiskEncryptionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionAlgorithm":
			err = unpopulate(val, "EncryptionAlgorithm", &d.EncryptionAlgorithm)
			delete(rawMsg, key)
		case "encryptionAtHost":
			err = unpopulate(val, "EncryptionAtHost", &d.EncryptionAtHost)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &d.KeyName)
			delete(rawMsg, key)
		case "keyVersion":
			err = unpopulate(val, "KeyVersion", &d.KeyVersion)
			delete(rawMsg, key)
		case "msiResourceId":
			err = unpopulate(val, "MsiResourceID", &d.MsiResourceID)
			delete(rawMsg, key)
		case "vaultUri":
			err = unpopulate(val, "VaultURI", &d.VaultURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionInTransitProperties.
func (e EncryptionInTransitProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isEncryptionInTransitEnabled", e.IsEncryptionInTransitEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionInTransitProperties.
func (e *EncryptionInTransitProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isEncryptionInTransitEnabled":
			err = unpopulate(val, "IsEncryptionInTransitEnabled", &e.IsEncryptionInTransitEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Errors.
func (e Errors) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Errors.
func (e *Errors) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExcludedServicesConfig.
func (e ExcludedServicesConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "excludedServicesConfigId", e.ExcludedServicesConfigID)
	populate(objectMap, "excludedServicesList", e.ExcludedServicesList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExcludedServicesConfig.
func (e *ExcludedServicesConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "excludedServicesConfigId":
			err = unpopulate(val, "ExcludedServicesConfigID", &e.ExcludedServicesConfigID)
			delete(rawMsg, key)
		case "excludedServicesList":
			err = unpopulate(val, "ExcludedServicesList", &e.ExcludedServicesList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecuteScriptActionParameters.
func (e ExecuteScriptActionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "persistOnSuccess", e.PersistOnSuccess)
	populate(objectMap, "scriptActions", e.ScriptActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecuteScriptActionParameters.
func (e *ExecuteScriptActionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "persistOnSuccess":
			err = unpopulate(val, "PersistOnSuccess", &e.PersistOnSuccess)
			delete(rawMsg, key)
		case "scriptActions":
			err = unpopulate(val, "ScriptActions", &e.ScriptActions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Extension.
func (e Extension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primaryKey", e.PrimaryKey)
	populate(objectMap, "workspaceId", e.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Extension.
func (e *Extension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &e.PrimaryKey)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &e.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewaySettings.
func (g GatewaySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "restAuthCredential.isEnabled", g.IsCredentialEnabled)
	populate(objectMap, "restAuthCredential.password", g.Password)
	populate(objectMap, "restAuthCredential.username", g.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewaySettings.
func (g *GatewaySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "restAuthCredential.isEnabled":
			err = unpopulate(val, "IsCredentialEnabled", &g.IsCredentialEnabled)
			delete(rawMsg, key)
		case "restAuthCredential.password":
			err = unpopulate(val, "Password", &g.Password)
			delete(rawMsg, key)
		case "restAuthCredential.username":
			err = unpopulate(val, "UserName", &g.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareProfile.
func (h HardwareProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vmSize", h.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareProfile.
func (h *HardwareProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vmSize":
			err = unpopulate(val, "VMSize", &h.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostInfo.
func (h HostInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "effectiveDiskEncryptionKeyUrl", h.EffectiveDiskEncryptionKeyURL)
	populate(objectMap, "fqdn", h.Fqdn)
	populate(objectMap, "name", h.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostInfo.
func (h *HostInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "effectiveDiskEncryptionKeyUrl":
			err = unpopulate(val, "EffectiveDiskEncryptionKeyURL", &h.EffectiveDiskEncryptionKeyURL)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &h.Fqdn)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfiguration.
func (i IPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfiguration.
func (i *IPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfigurationProperties.
func (i IPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primary", i.Primary)
	populate(objectMap, "privateIPAddress", i.PrivateIPAddress)
	populate(objectMap, "privateIPAllocationMethod", i.PrivateIPAllocationMethod)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "subnet", i.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfigurationProperties.
func (i *IPConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primary":
			err = unpopulate(val, "Primary", &i.Primary)
			delete(rawMsg, key)
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &i.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &i.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &i.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KafkaRestProperties.
func (k KafkaRestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientGroupInfo", k.ClientGroupInfo)
	populate(objectMap, "configurationOverride", k.ConfigurationOverride)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KafkaRestProperties.
func (k *KafkaRestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientGroupInfo":
			err = unpopulate(val, "ClientGroupInfo", &k.ClientGroupInfo)
			delete(rawMsg, key)
		case "configurationOverride":
			err = unpopulate(val, "ConfigurationOverride", &k.ConfigurationOverride)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxOperatingSystemProfile.
func (l LinuxOperatingSystemProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", l.Password)
	populate(objectMap, "sshProfile", l.SSHProfile)
	populate(objectMap, "username", l.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxOperatingSystemProfile.
func (l *LinuxOperatingSystemProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &l.Password)
			delete(rawMsg, key)
		case "sshProfile":
			err = unpopulate(val, "SSHProfile", &l.SSHProfile)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &l.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalizedName.
func (l LocalizedName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", l.LocalizedValue)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalizedName.
func (l *LocalizedName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &l.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricSpecifications.
func (m MetricSpecifications) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationType", m.AggregationType)
	populate(objectMap, "category", m.Category)
	populate(objectMap, "delegateMetricNameOverride", m.DelegateMetricNameOverride)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "enableRegionalMdmAccount", m.EnableRegionalMdmAccount)
	populate(objectMap, "fillGapWithZero", m.FillGapWithZero)
	populate(objectMap, "isInternal", m.IsInternal)
	populate(objectMap, "metricFilterPattern", m.MetricFilterPattern)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "resourceIdDimensionNameOverride", m.ResourceIDDimensionNameOverride)
	populate(objectMap, "sourceMdmAccount", m.SourceMdmAccount)
	populate(objectMap, "sourceMdmNamespace", m.SourceMdmNamespace)
	populate(objectMap, "supportedAggregationTypes", m.SupportedAggregationTypes)
	populate(objectMap, "supportedTimeGrainTypes", m.SupportedTimeGrainTypes)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricSpecifications.
func (m *MetricSpecifications) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &m.AggregationType)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "delegateMetricNameOverride":
			err = unpopulate(val, "DelegateMetricNameOverride", &m.DelegateMetricNameOverride)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &m.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "enableRegionalMdmAccount":
			err = unpopulate(val, "EnableRegionalMdmAccount", &m.EnableRegionalMdmAccount)
			delete(rawMsg, key)
		case "fillGapWithZero":
			err = unpopulate(val, "FillGapWithZero", &m.FillGapWithZero)
			delete(rawMsg, key)
		case "isInternal":
			err = unpopulate(val, "IsInternal", &m.IsInternal)
			delete(rawMsg, key)
		case "metricFilterPattern":
			err = unpopulate(val, "MetricFilterPattern", &m.MetricFilterPattern)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "resourceIdDimensionNameOverride":
			err = unpopulate(val, "ResourceIDDimensionNameOverride", &m.ResourceIDDimensionNameOverride)
			delete(rawMsg, key)
		case "sourceMdmAccount":
			err = unpopulate(val, "SourceMdmAccount", &m.SourceMdmAccount)
			delete(rawMsg, key)
		case "sourceMdmNamespace":
			err = unpopulate(val, "SourceMdmNamespace", &m.SourceMdmNamespace)
			delete(rawMsg, key)
		case "supportedAggregationTypes":
			err = unpopulate(val, "SupportedAggregationTypes", &m.SupportedAggregationTypes)
			delete(rawMsg, key)
		case "supportedTimeGrainTypes":
			err = unpopulate(val, "SupportedTimeGrainTypes", &m.SupportedTimeGrainTypes)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameAvailabilityCheckRequestParameters.
func (n NameAvailabilityCheckRequestParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameAvailabilityCheckRequestParameters.
func (n *NameAvailabilityCheckRequestParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameAvailabilityCheckResult.
func (n NameAvailabilityCheckResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", n.Message)
	populate(objectMap, "nameAvailable", n.NameAvailable)
	populate(objectMap, "reason", n.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameAvailabilityCheckResult.
func (n *NameAvailabilityCheckResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &n.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &n.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &n.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProperties.
func (n NetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateLink", n.PrivateLink)
	populate(objectMap, "resourceProviderConnection", n.ResourceProviderConnection)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProperties.
func (n *NetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateLink":
			err = unpopulate(val, "PrivateLink", &n.PrivateLink)
			delete(rawMsg, key)
		case "resourceProviderConnection":
			err = unpopulate(val, "ResourceProviderConnection", &n.ResourceProviderConnection)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationProperties.
func (o OperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", o.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationProperties.
func (o *OperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &o.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OsProfile.
func (o OsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linuxOperatingSystemProfile", o.LinuxOperatingSystemProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OsProfile.
func (o *OsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linuxOperatingSystemProfile":
			err = unpopulate(val, "LinuxOperatingSystemProfile", &o.LinuxOperatingSystemProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linkIdentifier", p.LinkIdentifier)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linkIdentifier":
			err = unpopulate(val, "LinkIdentifier", &p.LinkIdentifier)
			delete(rawMsg, key)
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkConfiguration.
func (p PrivateLinkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkConfiguration.
func (p *PrivateLinkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkConfigurationProperties.
func (p PrivateLinkConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "ipConfigurations", p.IPConfigurations)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkConfigurationProperties.
func (p *PrivateLinkConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &p.IPConfigurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceListResult.
func (p *PrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaCapability.
func (q QuotaCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "coresUsed", q.CoresUsed)
	populate(objectMap, "maxCoresAllowed", q.MaxCoresAllowed)
	populate(objectMap, "regionalQuotas", q.RegionalQuotas)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaCapability.
func (q *QuotaCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "coresUsed":
			err = unpopulate(val, "CoresUsed", &q.CoresUsed)
			delete(rawMsg, key)
		case "maxCoresAllowed":
			err = unpopulate(val, "MaxCoresAllowed", &q.MaxCoresAllowed)
			delete(rawMsg, key)
		case "regionalQuotas":
			err = unpopulate(val, "RegionalQuotas", &q.RegionalQuotas)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaInfo.
func (q QuotaInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "coresUsed", q.CoresUsed)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaInfo.
func (q *QuotaInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "coresUsed":
			err = unpopulate(val, "CoresUsed", &q.CoresUsed)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegionalQuotaCapability.
func (r RegionalQuotaCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "coresAvailable", r.CoresAvailable)
	populate(objectMap, "coresUsed", r.CoresUsed)
	populate(objectMap, "regionName", r.RegionName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegionalQuotaCapability.
func (r *RegionalQuotaCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "coresAvailable":
			err = unpopulate(val, "CoresAvailable", &r.CoresAvailable)
			delete(rawMsg, key)
		case "coresUsed":
			err = unpopulate(val, "CoresUsed", &r.CoresUsed)
			delete(rawMsg, key)
		case "regionName":
			err = unpopulate(val, "RegionName", &r.RegionName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegionsCapability.
func (r RegionsCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "available", r.Available)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegionsCapability.
func (r *RegionsCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "available":
			err = unpopulate(val, "Available", &r.Available)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceID.
func (r ResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceID.
func (r *ResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Role.
func (r Role) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoscale", r.AutoscaleConfiguration)
	populate(objectMap, "dataDisksGroups", r.DataDisksGroups)
	populate(objectMap, "encryptDataDisks", r.EncryptDataDisks)
	populate(objectMap, "hardwareProfile", r.HardwareProfile)
	populate(objectMap, "minInstanceCount", r.MinInstanceCount)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "osProfile", r.OSProfile)
	populate(objectMap, "scriptActions", r.ScriptActions)
	populate(objectMap, "targetInstanceCount", r.TargetInstanceCount)
	populate(objectMap, "VMGroupName", r.VMGroupName)
	populate(objectMap, "virtualNetworkProfile", r.VirtualNetworkProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Role.
func (r *Role) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoscale":
			err = unpopulate(val, "AutoscaleConfiguration", &r.AutoscaleConfiguration)
			delete(rawMsg, key)
		case "dataDisksGroups":
			err = unpopulate(val, "DataDisksGroups", &r.DataDisksGroups)
			delete(rawMsg, key)
		case "encryptDataDisks":
			err = unpopulate(val, "EncryptDataDisks", &r.EncryptDataDisks)
			delete(rawMsg, key)
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &r.HardwareProfile)
			delete(rawMsg, key)
		case "minInstanceCount":
			err = unpopulate(val, "MinInstanceCount", &r.MinInstanceCount)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &r.OSProfile)
			delete(rawMsg, key)
		case "scriptActions":
			err = unpopulate(val, "ScriptActions", &r.ScriptActions)
			delete(rawMsg, key)
		case "targetInstanceCount":
			err = unpopulate(val, "TargetInstanceCount", &r.TargetInstanceCount)
			delete(rawMsg, key)
		case "VMGroupName":
			err = unpopulate(val, "VMGroupName", &r.VMGroupName)
			delete(rawMsg, key)
		case "virtualNetworkProfile":
			err = unpopulate(val, "VirtualNetworkProfile", &r.VirtualNetworkProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuntimeScriptAction.
func (r RuntimeScriptAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationName", r.ApplicationName)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "parameters", r.Parameters)
	populate(objectMap, "roles", r.Roles)
	populate(objectMap, "uri", r.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuntimeScriptAction.
func (r *RuntimeScriptAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationName":
			err = unpopulate(val, "ApplicationName", &r.ApplicationName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &r.Parameters)
			delete(rawMsg, key)
		case "roles":
			err = unpopulate(val, "Roles", &r.Roles)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &r.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuntimeScriptActionDetail.
func (r RuntimeScriptActionDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationName", r.ApplicationName)
	populate(objectMap, "debugInformation", r.DebugInformation)
	populate(objectMap, "endTime", r.EndTime)
	populate(objectMap, "executionSummary", r.ExecutionSummary)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "operation", r.Operation)
	populate(objectMap, "parameters", r.Parameters)
	populate(objectMap, "roles", r.Roles)
	populate(objectMap, "scriptExecutionId", r.ScriptExecutionID)
	populate(objectMap, "startTime", r.StartTime)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "uri", r.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuntimeScriptActionDetail.
func (r *RuntimeScriptActionDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationName":
			err = unpopulate(val, "ApplicationName", &r.ApplicationName)
			delete(rawMsg, key)
		case "debugInformation":
			err = unpopulate(val, "DebugInformation", &r.DebugInformation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulate(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "executionSummary":
			err = unpopulate(val, "ExecutionSummary", &r.ExecutionSummary)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &r.Operation)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &r.Parameters)
			delete(rawMsg, key)
		case "roles":
			err = unpopulate(val, "Roles", &r.Roles)
			delete(rawMsg, key)
		case "scriptExecutionId":
			err = unpopulate(val, "ScriptExecutionID", &r.ScriptExecutionID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &r.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHProfile.
func (s SSHProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicKeys", s.PublicKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHProfile.
func (s *SSHProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicKeys":
			err = unpopulate(val, "PublicKeys", &s.PublicKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKey.
func (s SSHPublicKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateData", s.CertificateData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKey.
func (s *SSHPublicKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateData":
			err = unpopulate(val, "CertificateData", &s.CertificateData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptAction.
func (s ScriptAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "uri", s.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptAction.
func (s *ScriptAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &s.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptActionExecutionHistoryList.
func (s ScriptActionExecutionHistoryList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptActionExecutionHistoryList.
func (s *ScriptActionExecutionHistoryList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptActionExecutionSummary.
func (s ScriptActionExecutionSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceCount", s.InstanceCount)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptActionExecutionSummary.
func (s *ScriptActionExecutionSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceCount":
			err = unpopulate(val, "InstanceCount", &s.InstanceCount)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptActionPersistedGetResponseSpec.
func (s ScriptActionPersistedGetResponseSpec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationName", s.ApplicationName)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "roles", s.Roles)
	populate(objectMap, "uri", s.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptActionPersistedGetResponseSpec.
func (s *ScriptActionPersistedGetResponseSpec) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationName":
			err = unpopulate(val, "ApplicationName", &s.ApplicationName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "roles":
			err = unpopulate(val, "Roles", &s.Roles)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &s.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptActionsList.
func (s ScriptActionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptActionsList.
func (s *ScriptActionsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityProfile.
func (s SecurityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aaddsResourceId", s.AaddsResourceID)
	populate(objectMap, "clusterUsersGroupDNs", s.ClusterUsersGroupDNs)
	populate(objectMap, "directoryType", s.DirectoryType)
	populate(objectMap, "domain", s.Domain)
	populate(objectMap, "domainUserPassword", s.DomainUserPassword)
	populate(objectMap, "domainUsername", s.DomainUsername)
	populate(objectMap, "ldapsUrls", s.LdapsUrls)
	populate(objectMap, "msiResourceId", s.MsiResourceID)
	populate(objectMap, "organizationalUnitDN", s.OrganizationalUnitDN)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityProfile.
func (s *SecurityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aaddsResourceId":
			err = unpopulate(val, "AaddsResourceID", &s.AaddsResourceID)
			delete(rawMsg, key)
		case "clusterUsersGroupDNs":
			err = unpopulate(val, "ClusterUsersGroupDNs", &s.ClusterUsersGroupDNs)
			delete(rawMsg, key)
		case "directoryType":
			err = unpopulate(val, "DirectoryType", &s.DirectoryType)
			delete(rawMsg, key)
		case "domain":
			err = unpopulate(val, "Domain", &s.Domain)
			delete(rawMsg, key)
		case "domainUserPassword":
			err = unpopulate(val, "DomainUserPassword", &s.DomainUserPassword)
			delete(rawMsg, key)
		case "domainUsername":
			err = unpopulate(val, "DomainUsername", &s.DomainUsername)
			delete(rawMsg, key)
		case "ldapsUrls":
			err = unpopulate(val, "LdapsUrls", &s.LdapsUrls)
			delete(rawMsg, key)
		case "msiResourceId":
			err = unpopulate(val, "MsiResourceID", &s.MsiResourceID)
			delete(rawMsg, key)
		case "organizationalUnitDN":
			err = unpopulate(val, "OrganizationalUnitDN", &s.OrganizationalUnitDN)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceSpecification.
func (s ServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metricSpecifications", s.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceSpecification.
func (s *ServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &s.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAccount.
func (s StorageAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "container", s.Container)
	populate(objectMap, "enableSecureChannel", s.EnableSecureChannel)
	populate(objectMap, "fileSystem", s.FileSystem)
	populate(objectMap, "fileshare", s.Fileshare)
	populate(objectMap, "isDefault", s.IsDefault)
	populate(objectMap, "key", s.Key)
	populate(objectMap, "msiResourceId", s.MsiResourceID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "resourceId", s.ResourceID)
	populate(objectMap, "saskey", s.Saskey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAccount.
func (s *StorageAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "container":
			err = unpopulate(val, "Container", &s.Container)
			delete(rawMsg, key)
		case "enableSecureChannel":
			err = unpopulate(val, "EnableSecureChannel", &s.EnableSecureChannel)
			delete(rawMsg, key)
		case "fileSystem":
			err = unpopulate(val, "FileSystem", &s.FileSystem)
			delete(rawMsg, key)
		case "fileshare":
			err = unpopulate(val, "Fileshare", &s.Fileshare)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &s.IsDefault)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		case "msiResourceId":
			err = unpopulate(val, "MsiResourceID", &s.MsiResourceID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &s.ResourceID)
			delete(rawMsg, key)
		case "saskey":
			err = unpopulate(val, "Saskey", &s.Saskey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageProfile.
func (s StorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "storageaccounts", s.Storageaccounts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageProfile.
func (s *StorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "storageaccounts":
			err = unpopulate(val, "Storageaccounts", &s.Storageaccounts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateClusterIdentityCertificateParameters.
func (u UpdateClusterIdentityCertificateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationId", u.ApplicationID)
	populate(objectMap, "certificate", u.Certificate)
	populate(objectMap, "certificatePassword", u.CertificatePassword)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateClusterIdentityCertificateParameters.
func (u *UpdateClusterIdentityCertificateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationId":
			err = unpopulate(val, "ApplicationID", &u.ApplicationID)
			delete(rawMsg, key)
		case "certificate":
			err = unpopulate(val, "Certificate", &u.Certificate)
			delete(rawMsg, key)
		case "certificatePassword":
			err = unpopulate(val, "CertificatePassword", &u.CertificatePassword)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateGatewaySettingsParameters.
func (u UpdateGatewaySettingsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "restAuthCredential.isEnabled", u.IsCredentialEnabled)
	populate(objectMap, "restAuthCredential.password", u.Password)
	populate(objectMap, "restAuthCredential.username", u.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateGatewaySettingsParameters.
func (u *UpdateGatewaySettingsParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "restAuthCredential.isEnabled":
			err = unpopulate(val, "IsCredentialEnabled", &u.IsCredentialEnabled)
			delete(rawMsg, key)
		case "restAuthCredential.password":
			err = unpopulate(val, "Password", &u.Password)
			delete(rawMsg, key)
		case "restAuthCredential.username":
			err = unpopulate(val, "UserName", &u.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", u.CurrentValue)
	populate(objectMap, "limit", u.Limit)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "unit", u.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Usage.
func (u *Usage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &u.CurrentValue)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &u.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsagesListResult.
func (u UsagesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsagesListResult.
func (u *UsagesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	populate(objectMap, "tenantId", u.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &u.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMSizeCompatibilityFilterV2.
func (v VMSizeCompatibilityFilterV2) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterFlavors", v.ClusterFlavors)
	populate(objectMap, "clusterVersions", v.ClusterVersions)
	populate(objectMap, "computeIsolationSupported", v.ComputeIsolationSupported)
	populate(objectMap, "espApplied", v.EspApplied)
	populate(objectMap, "filterMode", v.FilterMode)
	populate(objectMap, "nodeTypes", v.NodeTypes)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "regions", v.Regions)
	populate(objectMap, "vmSizes", v.VMSizes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMSizeCompatibilityFilterV2.
func (v *VMSizeCompatibilityFilterV2) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterFlavors":
			err = unpopulate(val, "ClusterFlavors", &v.ClusterFlavors)
			delete(rawMsg, key)
		case "clusterVersions":
			err = unpopulate(val, "ClusterVersions", &v.ClusterVersions)
			delete(rawMsg, key)
		case "computeIsolationSupported":
			err = unpopulate(val, "ComputeIsolationSupported", &v.ComputeIsolationSupported)
			delete(rawMsg, key)
		case "espApplied":
			err = unpopulate(val, "EspApplied", &v.EspApplied)
			delete(rawMsg, key)
		case "filterMode":
			err = unpopulate(val, "FilterMode", &v.FilterMode)
			delete(rawMsg, key)
		case "nodeTypes":
			err = unpopulate(val, "NodeTypes", &v.NodeTypes)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "regions":
			err = unpopulate(val, "Regions", &v.Regions)
			delete(rawMsg, key)
		case "vmSizes":
			err = unpopulate(val, "VMSizes", &v.VMSizes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMSizeProperty.
func (v VMSizeProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cores", v.Cores)
	populate(objectMap, "dataDiskStorageTier", v.DataDiskStorageTier)
	populate(objectMap, "label", v.Label)
	populate(objectMap, "maxDataDiskCount", v.MaxDataDiskCount)
	populate(objectMap, "memoryInMb", v.MemoryInMb)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "supportedByVirtualMachines", v.SupportedByVirtualMachines)
	populate(objectMap, "supportedByWebWorkerRoles", v.SupportedByWebWorkerRoles)
	populate(objectMap, "virtualMachineResourceDiskSizeInMb", v.VirtualMachineResourceDiskSizeInMb)
	populate(objectMap, "webWorkerResourceDiskSizeInMb", v.WebWorkerResourceDiskSizeInMb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMSizeProperty.
func (v *VMSizeProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cores":
			err = unpopulate(val, "Cores", &v.Cores)
			delete(rawMsg, key)
		case "dataDiskStorageTier":
			err = unpopulate(val, "DataDiskStorageTier", &v.DataDiskStorageTier)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &v.Label)
			delete(rawMsg, key)
		case "maxDataDiskCount":
			err = unpopulate(val, "MaxDataDiskCount", &v.MaxDataDiskCount)
			delete(rawMsg, key)
		case "memoryInMb":
			err = unpopulate(val, "MemoryInMb", &v.MemoryInMb)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "supportedByVirtualMachines":
			err = unpopulate(val, "SupportedByVirtualMachines", &v.SupportedByVirtualMachines)
			delete(rawMsg, key)
		case "supportedByWebWorkerRoles":
			err = unpopulate(val, "SupportedByWebWorkerRoles", &v.SupportedByWebWorkerRoles)
			delete(rawMsg, key)
		case "virtualMachineResourceDiskSizeInMb":
			err = unpopulate(val, "VirtualMachineResourceDiskSizeInMb", &v.VirtualMachineResourceDiskSizeInMb)
			delete(rawMsg, key)
		case "webWorkerResourceDiskSizeInMb":
			err = unpopulate(val, "WebWorkerResourceDiskSizeInMb", &v.WebWorkerResourceDiskSizeInMb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidationErrorInfo.
func (v ValidationErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", v.Code)
	populate(objectMap, "errorResource", v.ErrorResource)
	populate(objectMap, "message", v.Message)
	populate(objectMap, "messageArguments", v.MessageArguments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidationErrorInfo.
func (v *ValidationErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &v.Code)
			delete(rawMsg, key)
		case "errorResource":
			err = unpopulate(val, "ErrorResource", &v.ErrorResource)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		case "messageArguments":
			err = unpopulate(val, "MessageArguments", &v.MessageArguments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VersionSpec.
func (v VersionSpec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentVersions", v.ComponentVersions)
	populate(objectMap, "displayName", v.DisplayName)
	populate(objectMap, "friendlyName", v.FriendlyName)
	populate(objectMap, "isDefault", v.IsDefault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VersionSpec.
func (v *VersionSpec) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentVersions":
			err = unpopulate(val, "ComponentVersions", &v.ComponentVersions)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &v.DisplayName)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &v.FriendlyName)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &v.IsDefault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VersionsCapability.
func (v VersionsCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "available", v.Available)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VersionsCapability.
func (v *VersionsCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "available":
			err = unpopulate(val, "Available", &v.Available)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkProfile.
func (v VirtualNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "subnet", v.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkProfile.
func (v *VirtualNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &v.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
