//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/extendedlocation/armextendedlocation"
	"net/http"
	"net/url"
	"regexp"
)

// CustomLocationsServer is a fake server for instances of the armextendedlocation.CustomLocationsClient type.
type CustomLocationsServer struct {
	// BeginCreateOrUpdate is the fake for method CustomLocationsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, resourceName string, parameters armextendedlocation.CustomLocation, options *armextendedlocation.CustomLocationsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armextendedlocation.CustomLocationsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method CustomLocationsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, resourceName string, options *armextendedlocation.CustomLocationsClientBeginDeleteOptions) (resp azfake.PollerResponder[armextendedlocation.CustomLocationsClientDeleteResponse], errResp azfake.ErrorResponder)

	// FindTargetResourceGroup is the fake for method CustomLocationsClient.FindTargetResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	FindTargetResourceGroup func(ctx context.Context, resourceGroupName string, resourceName string, parameters armextendedlocation.CustomLocationFindTargetResourceGroupProperties, options *armextendedlocation.CustomLocationsClientFindTargetResourceGroupOptions) (resp azfake.Responder[armextendedlocation.CustomLocationsClientFindTargetResourceGroupResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method CustomLocationsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceName string, options *armextendedlocation.CustomLocationsClientGetOptions) (resp azfake.Responder[armextendedlocation.CustomLocationsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method CustomLocationsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armextendedlocation.CustomLocationsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armextendedlocation.CustomLocationsClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method CustomLocationsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armextendedlocation.CustomLocationsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armextendedlocation.CustomLocationsClientListBySubscriptionResponse])

	// NewListEnabledResourceTypesPager is the fake for method CustomLocationsClient.NewListEnabledResourceTypesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListEnabledResourceTypesPager func(resourceGroupName string, resourceName string, options *armextendedlocation.CustomLocationsClientListEnabledResourceTypesOptions) (resp azfake.PagerResponder[armextendedlocation.CustomLocationsClientListEnabledResourceTypesResponse])

	// NewListOperationsPager is the fake for method CustomLocationsClient.NewListOperationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListOperationsPager func(options *armextendedlocation.CustomLocationsClientListOperationsOptions) (resp azfake.PagerResponder[armextendedlocation.CustomLocationsClientListOperationsResponse])

	// Update is the fake for method CustomLocationsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, resourceName string, parameters armextendedlocation.PatchableCustomLocations, options *armextendedlocation.CustomLocationsClientUpdateOptions) (resp azfake.Responder[armextendedlocation.CustomLocationsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewCustomLocationsServerTransport creates a new instance of CustomLocationsServerTransport with the provided implementation.
// The returned CustomLocationsServerTransport instance is connected to an instance of armextendedlocation.CustomLocationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCustomLocationsServerTransport(srv *CustomLocationsServer) *CustomLocationsServerTransport {
	return &CustomLocationsServerTransport{
		srv:                              srv,
		beginCreateOrUpdate:              newTracker[azfake.PollerResponder[armextendedlocation.CustomLocationsClientCreateOrUpdateResponse]](),
		beginDelete:                      newTracker[azfake.PollerResponder[armextendedlocation.CustomLocationsClientDeleteResponse]](),
		newListByResourceGroupPager:      newTracker[azfake.PagerResponder[armextendedlocation.CustomLocationsClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:       newTracker[azfake.PagerResponder[armextendedlocation.CustomLocationsClientListBySubscriptionResponse]](),
		newListEnabledResourceTypesPager: newTracker[azfake.PagerResponder[armextendedlocation.CustomLocationsClientListEnabledResourceTypesResponse]](),
		newListOperationsPager:           newTracker[azfake.PagerResponder[armextendedlocation.CustomLocationsClientListOperationsResponse]](),
	}
}

// CustomLocationsServerTransport connects instances of armextendedlocation.CustomLocationsClient to instances of CustomLocationsServer.
// Don't use this type directly, use NewCustomLocationsServerTransport instead.
type CustomLocationsServerTransport struct {
	srv                              *CustomLocationsServer
	beginCreateOrUpdate              *tracker[azfake.PollerResponder[armextendedlocation.CustomLocationsClientCreateOrUpdateResponse]]
	beginDelete                      *tracker[azfake.PollerResponder[armextendedlocation.CustomLocationsClientDeleteResponse]]
	newListByResourceGroupPager      *tracker[azfake.PagerResponder[armextendedlocation.CustomLocationsClientListByResourceGroupResponse]]
	newListBySubscriptionPager       *tracker[azfake.PagerResponder[armextendedlocation.CustomLocationsClientListBySubscriptionResponse]]
	newListEnabledResourceTypesPager *tracker[azfake.PagerResponder[armextendedlocation.CustomLocationsClientListEnabledResourceTypesResponse]]
	newListOperationsPager           *tracker[azfake.PagerResponder[armextendedlocation.CustomLocationsClientListOperationsResponse]]
}

// Do implements the policy.Transporter interface for CustomLocationsServerTransport.
func (c *CustomLocationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CustomLocationsClient.BeginCreateOrUpdate":
		resp, err = c.dispatchBeginCreateOrUpdate(req)
	case "CustomLocationsClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "CustomLocationsClient.FindTargetResourceGroup":
		resp, err = c.dispatchFindTargetResourceGroup(req)
	case "CustomLocationsClient.Get":
		resp, err = c.dispatchGet(req)
	case "CustomLocationsClient.NewListByResourceGroupPager":
		resp, err = c.dispatchNewListByResourceGroupPager(req)
	case "CustomLocationsClient.NewListBySubscriptionPager":
		resp, err = c.dispatchNewListBySubscriptionPager(req)
	case "CustomLocationsClient.NewListEnabledResourceTypesPager":
		resp, err = c.dispatchNewListEnabledResourceTypesPager(req)
	case "CustomLocationsClient.NewListOperationsPager":
		resp, err = c.dispatchNewListOperationsPager(req)
	case "CustomLocationsClient.Update":
		resp, err = c.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CustomLocationsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := c.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ExtendedLocation/customLocations/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armextendedlocation.CustomLocation](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		c.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		c.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (c *CustomLocationsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ExtendedLocation/customLocations/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *CustomLocationsServerTransport) dispatchFindTargetResourceGroup(req *http.Request) (*http.Response, error) {
	if c.srv.FindTargetResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method FindTargetResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ExtendedLocation/customLocations/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/findTargetResourceGroup`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armextendedlocation.CustomLocationFindTargetResourceGroupProperties](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.FindTargetResourceGroup(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomLocationFindTargetResourceGroupResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CustomLocationsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ExtendedLocation/customLocations/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomLocation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CustomLocationsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := c.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ExtendedLocation/customLocations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		c.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armextendedlocation.CustomLocationsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		c.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (c *CustomLocationsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := c.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ExtendedLocation/customLocations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := c.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		c.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armextendedlocation.CustomLocationsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		c.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (c *CustomLocationsServerTransport) dispatchNewListEnabledResourceTypesPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListEnabledResourceTypesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListEnabledResourceTypesPager not implemented")}
	}
	newListEnabledResourceTypesPager := c.newListEnabledResourceTypesPager.get(req)
	if newListEnabledResourceTypesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ExtendedLocation/customLocations/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/enabledResourceTypes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListEnabledResourceTypesPager(resourceGroupNameParam, resourceNameParam, nil)
		newListEnabledResourceTypesPager = &resp
		c.newListEnabledResourceTypesPager.add(req, newListEnabledResourceTypesPager)
		server.PagerResponderInjectNextLinks(newListEnabledResourceTypesPager, req, func(page *armextendedlocation.CustomLocationsClientListEnabledResourceTypesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListEnabledResourceTypesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListEnabledResourceTypesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListEnabledResourceTypesPager) {
		c.newListEnabledResourceTypesPager.remove(req)
	}
	return resp, nil
}

func (c *CustomLocationsServerTransport) dispatchNewListOperationsPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListOperationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListOperationsPager not implemented")}
	}
	newListOperationsPager := c.newListOperationsPager.get(req)
	if newListOperationsPager == nil {
		resp := c.srv.NewListOperationsPager(nil)
		newListOperationsPager = &resp
		c.newListOperationsPager.add(req, newListOperationsPager)
		server.PagerResponderInjectNextLinks(newListOperationsPager, req, func(page *armextendedlocation.CustomLocationsClientListOperationsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListOperationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListOperationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListOperationsPager) {
		c.newListOperationsPager.remove(req)
	}
	return resp, nil
}

func (c *CustomLocationsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ExtendedLocation/customLocations/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armextendedlocation.PatchableCustomLocations](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Update(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomLocation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
