//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/edgeorderpartner/armedgeorderpartner"
	"net/http"
	"net/url"
	"regexp"
)

// APISServer is a fake server for instances of the armedgeorderpartner.APISClient type.
type APISServer struct {
	// NewListOperationsPartnerPager is the fake for method APISClient.NewListOperationsPartnerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListOperationsPartnerPager func(options *armedgeorderpartner.APISClientListOperationsPartnerOptions) (resp azfake.PagerResponder[armedgeorderpartner.APISClientListOperationsPartnerResponse])

	// BeginManageInventoryMetadata is the fake for method APISClient.BeginManageInventoryMetadata
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginManageInventoryMetadata func(ctx context.Context, familyIdentifier string, location string, serialNumber string, manageInventoryMetadataRequest armedgeorderpartner.ManageInventoryMetadataRequest, options *armedgeorderpartner.APISClientBeginManageInventoryMetadataOptions) (resp azfake.PollerResponder[armedgeorderpartner.APISClientManageInventoryMetadataResponse], errResp azfake.ErrorResponder)

	// ManageLink is the fake for method APISClient.ManageLink
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	ManageLink func(ctx context.Context, familyIdentifier string, location string, serialNumber string, manageLinkRequest armedgeorderpartner.ManageLinkRequest, options *armedgeorderpartner.APISClientManageLinkOptions) (resp azfake.Responder[armedgeorderpartner.APISClientManageLinkResponse], errResp azfake.ErrorResponder)

	// NewSearchInventoriesPager is the fake for method APISClient.NewSearchInventoriesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewSearchInventoriesPager func(searchInventoriesRequest armedgeorderpartner.SearchInventoriesRequest, options *armedgeorderpartner.APISClientSearchInventoriesOptions) (resp azfake.PagerResponder[armedgeorderpartner.APISClientSearchInventoriesResponse])
}

// NewAPISServerTransport creates a new instance of APISServerTransport with the provided implementation.
// The returned APISServerTransport instance is connected to an instance of armedgeorderpartner.APISClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAPISServerTransport(srv *APISServer) *APISServerTransport {
	return &APISServerTransport{
		srv:                           srv,
		newListOperationsPartnerPager: newTracker[azfake.PagerResponder[armedgeorderpartner.APISClientListOperationsPartnerResponse]](),
		beginManageInventoryMetadata:  newTracker[azfake.PollerResponder[armedgeorderpartner.APISClientManageInventoryMetadataResponse]](),
		newSearchInventoriesPager:     newTracker[azfake.PagerResponder[armedgeorderpartner.APISClientSearchInventoriesResponse]](),
	}
}

// APISServerTransport connects instances of armedgeorderpartner.APISClient to instances of APISServer.
// Don't use this type directly, use NewAPISServerTransport instead.
type APISServerTransport struct {
	srv                           *APISServer
	newListOperationsPartnerPager *tracker[azfake.PagerResponder[armedgeorderpartner.APISClientListOperationsPartnerResponse]]
	beginManageInventoryMetadata  *tracker[azfake.PollerResponder[armedgeorderpartner.APISClientManageInventoryMetadataResponse]]
	newSearchInventoriesPager     *tracker[azfake.PagerResponder[armedgeorderpartner.APISClientSearchInventoriesResponse]]
}

// Do implements the policy.Transporter interface for APISServerTransport.
func (a *APISServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "APISClient.NewListOperationsPartnerPager":
		resp, err = a.dispatchNewListOperationsPartnerPager(req)
	case "APISClient.BeginManageInventoryMetadata":
		resp, err = a.dispatchBeginManageInventoryMetadata(req)
	case "APISClient.ManageLink":
		resp, err = a.dispatchManageLink(req)
	case "APISClient.NewSearchInventoriesPager":
		resp, err = a.dispatchNewSearchInventoriesPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *APISServerTransport) dispatchNewListOperationsPartnerPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListOperationsPartnerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListOperationsPartnerPager not implemented")}
	}
	newListOperationsPartnerPager := a.newListOperationsPartnerPager.get(req)
	if newListOperationsPartnerPager == nil {
		resp := a.srv.NewListOperationsPartnerPager(nil)
		newListOperationsPartnerPager = &resp
		a.newListOperationsPartnerPager.add(req, newListOperationsPartnerPager)
		server.PagerResponderInjectNextLinks(newListOperationsPartnerPager, req, func(page *armedgeorderpartner.APISClientListOperationsPartnerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListOperationsPartnerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListOperationsPartnerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListOperationsPartnerPager) {
		a.newListOperationsPartnerPager.remove(req)
	}
	return resp, nil
}

func (a *APISServerTransport) dispatchBeginManageInventoryMetadata(req *http.Request) (*http.Response, error) {
	if a.srv.BeginManageInventoryMetadata == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginManageInventoryMetadata not implemented")}
	}
	beginManageInventoryMetadata := a.beginManageInventoryMetadata.get(req)
	if beginManageInventoryMetadata == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrderPartner/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/productFamilies/(?P<familyIdentifier>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inventories/(?P<serialNumber>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/manageInventoryMetadata`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armedgeorderpartner.ManageInventoryMetadataRequest](req)
		if err != nil {
			return nil, err
		}
		familyIdentifierParam, err := url.PathUnescape(matches[regex.SubexpIndex("familyIdentifier")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		serialNumberParam, err := url.PathUnescape(matches[regex.SubexpIndex("serialNumber")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginManageInventoryMetadata(req.Context(), familyIdentifierParam, locationParam, serialNumberParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginManageInventoryMetadata = &respr
		a.beginManageInventoryMetadata.add(req, beginManageInventoryMetadata)
	}

	resp, err := server.PollerResponderNext(beginManageInventoryMetadata, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginManageInventoryMetadata.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginManageInventoryMetadata) {
		a.beginManageInventoryMetadata.remove(req)
	}

	return resp, nil
}

func (a *APISServerTransport) dispatchManageLink(req *http.Request) (*http.Response, error) {
	if a.srv.ManageLink == nil {
		return nil, &nonRetriableError{errors.New("fake for method ManageLink not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrderPartner/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/productFamilies/(?P<familyIdentifier>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inventories/(?P<serialNumber>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/manageLink`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armedgeorderpartner.ManageLinkRequest](req)
	if err != nil {
		return nil, err
	}
	familyIdentifierParam, err := url.PathUnescape(matches[regex.SubexpIndex("familyIdentifier")])
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	serialNumberParam, err := url.PathUnescape(matches[regex.SubexpIndex("serialNumber")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ManageLink(req.Context(), familyIdentifierParam, locationParam, serialNumberParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *APISServerTransport) dispatchNewSearchInventoriesPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewSearchInventoriesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewSearchInventoriesPager not implemented")}
	}
	newSearchInventoriesPager := a.newSearchInventoriesPager.get(req)
	if newSearchInventoriesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EdgeOrderPartner/searchInventories`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armedgeorderpartner.SearchInventoriesRequest](req)
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewSearchInventoriesPager(body, nil)
		newSearchInventoriesPager = &resp
		a.newSearchInventoriesPager.add(req, newSearchInventoriesPager)
		server.PagerResponderInjectNextLinks(newSearchInventoriesPager, req, func(page *armedgeorderpartner.APISClientSearchInventoriesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newSearchInventoriesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newSearchInventoriesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newSearchInventoriesPager) {
		a.newSearchInventoriesPager.remove(req)
	}
	return resp, nil
}
