//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdelegatednetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/delegatednetwork/armdelegatednetwork"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/getOrchestrator.json
func ExampleOrchestratorInstanceServiceClient_GetDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOrchestratorInstanceServiceClient().GetDetails(ctx, "TestRG", "testk8s1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Orchestrator = armdelegatednetwork.Orchestrator{
	// 	Name: to.Ptr("testk8s1"),
	// 	Type: to.Ptr("Microsoft.DelegatedNetwork/orchestrators"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/orchestrators/testk8s1"),
	// 	Identity: &armdelegatednetwork.OrchestratorIdentity{
	// 		Type: to.Ptr(armdelegatednetwork.ResourceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("7a2192d7-503f-477a-9cfe-4efc3ee2bd60"),
	// 		TenantID: to.Ptr("3e2192d7-503f-477a-9cfe-4efc3ee2bd60"),
	// 	},
	// 	Kind: to.Ptr(armdelegatednetwork.OrchestratorKindKubernetes),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armdelegatednetwork.OrchestratorResourceProperties{
	// 		APIServerEndpoint: to.Ptr("https://testk8s.cloudapp.net"),
	// 		ClusterRootCA: to.Ptr("ddsadsad344mfdsfdl"),
	// 		ControllerDetails: &armdelegatednetwork.ControllerDetails{
	// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/testcontroller"),
	// 		},
	// 		OrchestratorAppID: to.Ptr("546192d7-503f-477a-9cfe-4efc3ee2b6e1"),
	// 		OrchestratorTenantID: to.Ptr("da6192d7-503f-477a-9cfe-4efc3ee2b6c3"),
	// 		PrivateLinkResourceID: to.Ptr("/subscriptions/d21192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/plrg/Microsoft.Network/PrivateLink/pl1"),
	// 		ProvisioningState: to.Ptr(armdelegatednetwork.OrchestratorInstanceStateSucceeded),
	// 		ResourceGUID: to.Ptr("1b2192d7-503f-477a-9cfe-4efc3ee2bd60"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/putOrchestrator.json
func ExampleOrchestratorInstanceServiceClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewOrchestratorInstanceServiceClient().BeginCreate(ctx, "TestRG", "testk8s1", armdelegatednetwork.Orchestrator{
		Identity: &armdelegatednetwork.OrchestratorIdentity{
			Type: to.Ptr(armdelegatednetwork.ResourceIdentityTypeSystemAssigned),
		},
		Kind:     to.Ptr(armdelegatednetwork.OrchestratorKindKubernetes),
		Location: to.Ptr("West US"),
		Properties: &armdelegatednetwork.OrchestratorResourceProperties{
			APIServerEndpoint: to.Ptr("https://testk8s.cloudapp.net"),
			ClusterRootCA:     to.Ptr("ddsadsad344mfdsfdl"),
			ControllerDetails: &armdelegatednetwork.ControllerDetails{
				ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/testcontroller"),
			},
			OrchestratorAppID:     to.Ptr("546192d7-503f-477a-9cfe-4efc3ee2b6e1"),
			OrchestratorTenantID:  to.Ptr("da6192d7-503f-477a-9cfe-4efc3ee2b6c3"),
			PrivateLinkResourceID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/privateLinkServices/plresource1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Orchestrator = armdelegatednetwork.Orchestrator{
	// 	Name: to.Ptr("testk8s1"),
	// 	Type: to.Ptr("Microsoft.DelegatedNetwork/orchestrators"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/orchestrators/testk8s1"),
	// 	Identity: &armdelegatednetwork.OrchestratorIdentity{
	// 		Type: to.Ptr(armdelegatednetwork.ResourceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("7a2192d7-503f-477a-9cfe-4efc3ee2bd60"),
	// 		TenantID: to.Ptr("3e2192d7-503f-477a-9cfe-4efc3ee2bd60"),
	// 	},
	// 	Kind: to.Ptr(armdelegatednetwork.OrchestratorKindKubernetes),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armdelegatednetwork.OrchestratorResourceProperties{
	// 		APIServerEndpoint: to.Ptr("https://testk8s.cloudapp.net"),
	// 		ClusterRootCA: to.Ptr("ddsadsad344mfdsfdl"),
	// 		ControllerDetails: &armdelegatednetwork.ControllerDetails{
	// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/testcontroller"),
	// 		},
	// 		OrchestratorAppID: to.Ptr("546192d7-503f-477a-9cfe-4efc3ee2b6e1"),
	// 		OrchestratorTenantID: to.Ptr("da6192d7-503f-477a-9cfe-4efc3ee2b6c3"),
	// 		PrivateLinkResourceID: to.Ptr("/subscriptions/d21192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/plrg/Microsoft.Network/PrivateLink/pl1"),
	// 		ProvisioningState: to.Ptr(armdelegatednetwork.OrchestratorInstanceStateSucceeded),
	// 		ResourceGUID: to.Ptr("1b2192d7-503f-477a-9cfe-4efc3ee2bd60"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/deleteOrchestrator.json
func ExampleOrchestratorInstanceServiceClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewOrchestratorInstanceServiceClient().BeginDelete(ctx, "TestRG", "k8stest1", &armdelegatednetwork.OrchestratorInstanceServiceClientBeginDeleteOptions{ForceDelete: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/patchOrchestrator.json
func ExampleOrchestratorInstanceServiceClient_Patch() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOrchestratorInstanceServiceClient().Patch(ctx, "TestRG", "testk8s1", armdelegatednetwork.OrchestratorResourceUpdateParameters{
		Tags: map[string]*string{
			"key": to.Ptr("value"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Orchestrator = armdelegatednetwork.Orchestrator{
	// 	Name: to.Ptr("testk8s1"),
	// 	Type: to.Ptr("Microsoft.DelegatedNetwork/orchestrators"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/orchestrators/testk8s1"),
	// 	Identity: &armdelegatednetwork.OrchestratorIdentity{
	// 		Type: to.Ptr(armdelegatednetwork.ResourceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("7a2192d7-503f-477a-9cfe-4efc3ee2bd60"),
	// 		TenantID: to.Ptr("3e2192d7-503f-477a-9cfe-4efc3ee2bd60"),
	// 	},
	// 	Kind: to.Ptr(armdelegatednetwork.OrchestratorKindKubernetes),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key": to.Ptr("value"),
	// 	},
	// 	Properties: &armdelegatednetwork.OrchestratorResourceProperties{
	// 		APIServerEndpoint: to.Ptr("https://testk8s.cloudapp.net"),
	// 		ClusterRootCA: to.Ptr("ddsadsad344mfdsfdl"),
	// 		ControllerDetails: &armdelegatednetwork.ControllerDetails{
	// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/testcontroller"),
	// 		},
	// 		OrchestratorAppID: to.Ptr("546192d7-503f-477a-9cfe-4efc3ee2b6e1"),
	// 		OrchestratorTenantID: to.Ptr("da6192d7-503f-477a-9cfe-4efc3ee2b6c3"),
	// 		PrivateLinkResourceID: to.Ptr("/subscriptions/d21192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/plrg/Microsoft.Network/PrivateLink/pl1"),
	// 		ProvisioningState: to.Ptr(armdelegatednetwork.OrchestratorInstanceStateSucceeded),
	// 		ResourceGUID: to.Ptr("1b2192d7-503f-477a-9cfe-4efc3ee2bd60"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/orchestratorInstanceListBySub.json
func ExampleOrchestratorInstanceServiceClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOrchestratorInstanceServiceClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.Orchestrators = armdelegatednetwork.Orchestrators{
		// 	Value: []*armdelegatednetwork.Orchestrator{
		// 		{
		// 			Name: to.Ptr("testk8s1"),
		// 			Type: to.Ptr("Microsoft.DelegatedNetwork/orchestrators"),
		// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/orchestrators/testk8s1"),
		// 			Identity: &armdelegatednetwork.OrchestratorIdentity{
		// 				Type: to.Ptr(armdelegatednetwork.ResourceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("7a2192d7-503f-477a-9cfe-4efc3ee2bd60"),
		// 				TenantID: to.Ptr("3e2192d7-503f-477a-9cfe-4efc3ee2bd60"),
		// 			},
		// 			Kind: to.Ptr(armdelegatednetwork.OrchestratorKindKubernetes),
		// 			Location: to.Ptr("West US"),
		// 			Properties: &armdelegatednetwork.OrchestratorResourceProperties{
		// 				APIServerEndpoint: to.Ptr("https://testk8s.cloudapp.net"),
		// 				ClusterRootCA: to.Ptr("ddsadsad344mfdsfdl"),
		// 				ControllerDetails: &armdelegatednetwork.ControllerDetails{
		// 					ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/testcontroller"),
		// 				},
		// 				OrchestratorAppID: to.Ptr("546192d7-503f-477a-9cfe-4efc3ee2b6e1"),
		// 				OrchestratorTenantID: to.Ptr("da6192d7-503f-477a-9cfe-4efc3ee2b6c3"),
		// 				PrivateLinkResourceID: to.Ptr("/subscriptions/d21192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/plrg/Microsoft.Network/PrivateLink/pl1"),
		// 				ProvisioningState: to.Ptr(armdelegatednetwork.OrchestratorInstanceStateSucceeded),
		// 				ResourceGUID: to.Ptr("1b2192d7-503f-477a-9cfe-4efc3ee2bd60"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/dnc/resource-manager/Microsoft.DelegatedNetwork/stable/2021-03-15/examples/orchestratorInstanceListByRG.json
func ExampleOrchestratorInstanceServiceClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdelegatednetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOrchestratorInstanceServiceClient().NewListByResourceGroupPager("testRG", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.Orchestrators = armdelegatednetwork.Orchestrators{
		// 	Value: []*armdelegatednetwork.Orchestrator{
		// 		{
		// 			Name: to.Ptr("testk8s1"),
		// 			Type: to.Ptr("Microsoft.DelegatedNetwork/orchestrators"),
		// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/orchestrators/testk8s1"),
		// 			Identity: &armdelegatednetwork.OrchestratorIdentity{
		// 				Type: to.Ptr(armdelegatednetwork.ResourceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("7a2192d7-503f-477a-9cfe-4efc3ee2bd60"),
		// 				TenantID: to.Ptr("3e2192d7-503f-477a-9cfe-4efc3ee2bd60"),
		// 			},
		// 			Kind: to.Ptr(armdelegatednetwork.OrchestratorKindKubernetes),
		// 			Location: to.Ptr("West US"),
		// 			Properties: &armdelegatednetwork.OrchestratorResourceProperties{
		// 				APIServerEndpoint: to.Ptr("https://testk8s.cloudapp.net"),
		// 				ClusterRootCA: to.Ptr("ddsadsad344mfdsfdl"),
		// 				ControllerDetails: &armdelegatednetwork.ControllerDetails{
		// 					ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/testcontroller"),
		// 				},
		// 				OrchestratorAppID: to.Ptr("546192d7-503f-477a-9cfe-4efc3ee2b6e1"),
		// 				OrchestratorTenantID: to.Ptr("da6192d7-503f-477a-9cfe-4efc3ee2b6c3"),
		// 				PrivateLinkResourceID: to.Ptr("/subscriptions/d21192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/plrg/Microsoft.Network/PrivateLink/pl1"),
		// 				ProvisioningState: to.Ptr(armdelegatednetwork.OrchestratorInstanceStateSucceeded),
		// 				ResourceGUID: to.Ptr("1b2192d7-503f-477a-9cfe-4efc3ee2bd60"),
		// 			},
		// 	}},
		// }
	}
}
