//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/databoxedge/armdataboxedge"
	"net/http"
	"net/url"
	"regexp"
)

// DeviceCapacityCheckServer is a fake server for instances of the armdataboxedge.DeviceCapacityCheckClient type.
type DeviceCapacityCheckServer struct {
	// BeginCheckResourceCreationFeasibility is the fake for method DeviceCapacityCheckClient.BeginCheckResourceCreationFeasibility
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCheckResourceCreationFeasibility func(ctx context.Context, resourceGroupName string, deviceName string, deviceCapacityRequestInfo armdataboxedge.DeviceCapacityRequestInfo, options *armdataboxedge.DeviceCapacityCheckClientBeginCheckResourceCreationFeasibilityOptions) (resp azfake.PollerResponder[armdataboxedge.DeviceCapacityCheckClientCheckResourceCreationFeasibilityResponse], errResp azfake.ErrorResponder)
}

// NewDeviceCapacityCheckServerTransport creates a new instance of DeviceCapacityCheckServerTransport with the provided implementation.
// The returned DeviceCapacityCheckServerTransport instance is connected to an instance of armdataboxedge.DeviceCapacityCheckClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDeviceCapacityCheckServerTransport(srv *DeviceCapacityCheckServer) *DeviceCapacityCheckServerTransport {
	return &DeviceCapacityCheckServerTransport{
		srv:                                   srv,
		beginCheckResourceCreationFeasibility: newTracker[azfake.PollerResponder[armdataboxedge.DeviceCapacityCheckClientCheckResourceCreationFeasibilityResponse]](),
	}
}

// DeviceCapacityCheckServerTransport connects instances of armdataboxedge.DeviceCapacityCheckClient to instances of DeviceCapacityCheckServer.
// Don't use this type directly, use NewDeviceCapacityCheckServerTransport instead.
type DeviceCapacityCheckServerTransport struct {
	srv                                   *DeviceCapacityCheckServer
	beginCheckResourceCreationFeasibility *tracker[azfake.PollerResponder[armdataboxedge.DeviceCapacityCheckClientCheckResourceCreationFeasibilityResponse]]
}

// Do implements the policy.Transporter interface for DeviceCapacityCheckServerTransport.
func (d *DeviceCapacityCheckServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DeviceCapacityCheckClient.BeginCheckResourceCreationFeasibility":
		resp, err = d.dispatchBeginCheckResourceCreationFeasibility(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DeviceCapacityCheckServerTransport) dispatchBeginCheckResourceCreationFeasibility(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCheckResourceCreationFeasibility == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCheckResourceCreationFeasibility not implemented")}
	}
	beginCheckResourceCreationFeasibility := d.beginCheckResourceCreationFeasibility.get(req)
	if beginCheckResourceCreationFeasibility == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataBoxEdge/dataBoxEdgeDevices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deviceCapacityCheck`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		body, err := server.UnmarshalRequestAsJSON[armdataboxedge.DeviceCapacityRequestInfo](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		capacityNameUnescaped, err := url.QueryUnescape(qp.Get("capacityName"))
		if err != nil {
			return nil, err
		}
		capacityNameParam := getOptional(capacityNameUnescaped)
		var options *armdataboxedge.DeviceCapacityCheckClientBeginCheckResourceCreationFeasibilityOptions
		if capacityNameParam != nil {
			options = &armdataboxedge.DeviceCapacityCheckClientBeginCheckResourceCreationFeasibilityOptions{
				CapacityName: capacityNameParam,
			}
		}
		respr, errRespr := d.srv.BeginCheckResourceCreationFeasibility(req.Context(), resourceGroupNameParam, deviceNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCheckResourceCreationFeasibility = &respr
		d.beginCheckResourceCreationFeasibility.add(req, beginCheckResourceCreationFeasibility)
	}

	resp, err := server.PollerResponderNext(beginCheckResourceCreationFeasibility, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginCheckResourceCreationFeasibility.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCheckResourceCreationFeasibility) {
		d.beginCheckResourceCreationFeasibility.remove(req)
	}

	return resp, nil
}
