//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/costmanagement/armcostmanagement/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// DimensionsServer is a fake server for instances of the armcostmanagement.DimensionsClient type.
type DimensionsServer struct {
	// NewByExternalCloudProviderTypePager is the fake for method DimensionsClient.NewByExternalCloudProviderTypePager
	// HTTP status codes to indicate success: http.StatusOK
	NewByExternalCloudProviderTypePager func(externalCloudProviderType armcostmanagement.ExternalCloudProviderType, externalCloudProviderID string, options *armcostmanagement.DimensionsClientByExternalCloudProviderTypeOptions) (resp azfake.PagerResponder[armcostmanagement.DimensionsClientByExternalCloudProviderTypeResponse])

	// NewListPager is the fake for method DimensionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	NewListPager func(scope string, options *armcostmanagement.DimensionsClientListOptions) (resp azfake.PagerResponder[armcostmanagement.DimensionsClientListResponse])
}

// NewDimensionsServerTransport creates a new instance of DimensionsServerTransport with the provided implementation.
// The returned DimensionsServerTransport instance is connected to an instance of armcostmanagement.DimensionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDimensionsServerTransport(srv *DimensionsServer) *DimensionsServerTransport {
	return &DimensionsServerTransport{
		srv:                                 srv,
		newByExternalCloudProviderTypePager: newTracker[azfake.PagerResponder[armcostmanagement.DimensionsClientByExternalCloudProviderTypeResponse]](),
		newListPager:                        newTracker[azfake.PagerResponder[armcostmanagement.DimensionsClientListResponse]](),
	}
}

// DimensionsServerTransport connects instances of armcostmanagement.DimensionsClient to instances of DimensionsServer.
// Don't use this type directly, use NewDimensionsServerTransport instead.
type DimensionsServerTransport struct {
	srv                                 *DimensionsServer
	newByExternalCloudProviderTypePager *tracker[azfake.PagerResponder[armcostmanagement.DimensionsClientByExternalCloudProviderTypeResponse]]
	newListPager                        *tracker[azfake.PagerResponder[armcostmanagement.DimensionsClientListResponse]]
}

// Do implements the policy.Transporter interface for DimensionsServerTransport.
func (d *DimensionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DimensionsClient.NewByExternalCloudProviderTypePager":
		resp, err = d.dispatchNewByExternalCloudProviderTypePager(req)
	case "DimensionsClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DimensionsServerTransport) dispatchNewByExternalCloudProviderTypePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewByExternalCloudProviderTypePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewByExternalCloudProviderTypePager not implemented")}
	}
	newByExternalCloudProviderTypePager := d.newByExternalCloudProviderTypePager.get(req)
	if newByExternalCloudProviderTypePager == nil {
		const regexStr = `/providers/Microsoft\.CostManagement/(?P<externalCloudProviderType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<externalCloudProviderId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dimensions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		externalCloudProviderTypeParam, err := parseWithCast(matches[regex.SubexpIndex("externalCloudProviderType")], func(v string) (armcostmanagement.ExternalCloudProviderType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armcostmanagement.ExternalCloudProviderType(p), nil
		})
		if err != nil {
			return nil, err
		}
		externalCloudProviderIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("externalCloudProviderId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		skiptokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skiptokenParam := getOptional(skiptokenUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armcostmanagement.DimensionsClientByExternalCloudProviderTypeOptions
		if filterParam != nil || expandParam != nil || skiptokenParam != nil || topParam != nil {
			options = &armcostmanagement.DimensionsClientByExternalCloudProviderTypeOptions{
				Filter:    filterParam,
				Expand:    expandParam,
				Skiptoken: skiptokenParam,
				Top:       topParam,
			}
		}
		resp := d.srv.NewByExternalCloudProviderTypePager(externalCloudProviderTypeParam, externalCloudProviderIDParam, options)
		newByExternalCloudProviderTypePager = &resp
		d.newByExternalCloudProviderTypePager.add(req, newByExternalCloudProviderTypePager)
	}
	resp, err := server.PagerResponderNext(newByExternalCloudProviderTypePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newByExternalCloudProviderTypePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newByExternalCloudProviderTypePager) {
		d.newByExternalCloudProviderTypePager.remove(req)
	}
	return resp, nil
}

func (d *DimensionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/dimensions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		skiptokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skiptokenParam := getOptional(skiptokenUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armcostmanagement.DimensionsClientListOptions
		if filterParam != nil || expandParam != nil || skiptokenParam != nil || topParam != nil {
			options = &armcostmanagement.DimensionsClientListOptions{
				Filter:    filterParam,
				Expand:    expandParam,
				Skiptoken: skiptokenParam,
				Top:       topParam,
			}
		}
		resp := d.srv.NewListPager(scopeParam, options)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK, http.StatusNoContent}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}
