//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcdn_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cdn/armcdn/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafListPolicies.json
func ExamplePoliciesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPoliciesClient().NewListPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WebApplicationFirewallPolicyList = armcdn.WebApplicationFirewallPolicyList{
		// 	Value: []*armcdn.WebApplicationFirewallPolicy{
		// 		{
		// 			Name: to.Ptr("MicrosoftCdnWafPolicy"),
		// 			Type: to.Ptr("Microsoft.Cdn/cdnwebapplicationfirewallpolicies"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/MicrosoftCdnWafPolicy"),
		// 			Location: to.Ptr("WestUs"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 				"key2": to.Ptr("value2"),
		// 			},
		// 			Properties: &armcdn.WebApplicationFirewallPolicyProperties{
		// 				CustomRules: &armcdn.CustomRuleList{
		// 					Rules: []*armcdn.CustomRule{
		// 						{
		// 							Name: to.Ptr("CustomRule1"),
		// 							Action: to.Ptr(armcdn.ActionTypeBlock),
		// 							EnabledState: to.Ptr(armcdn.CustomRuleEnabledStateEnabled),
		// 							MatchConditions: []*armcdn.MatchCondition{
		// 								{
		// 									MatchValue: []*string{
		// 										to.Ptr("CH")},
		// 										MatchVariable: to.Ptr(armcdn.WafMatchVariableRemoteAddr),
		// 										NegateCondition: to.Ptr(false),
		// 										Operator: to.Ptr(armcdn.OperatorGeoMatch),
		// 										Transforms: []*armcdn.TransformType{
		// 										},
		// 									},
		// 									{
		// 										MatchValue: []*string{
		// 											to.Ptr("windows")},
		// 											MatchVariable: to.Ptr(armcdn.WafMatchVariableRequestHeader),
		// 											NegateCondition: to.Ptr(false),
		// 											Operator: to.Ptr(armcdn.OperatorContains),
		// 											Selector: to.Ptr("UserAgent"),
		// 											Transforms: []*armcdn.TransformType{
		// 											},
		// 										},
		// 										{
		// 											MatchValue: []*string{
		// 												to.Ptr("<?php"),
		// 												to.Ptr("?>")},
		// 												MatchVariable: to.Ptr(armcdn.WafMatchVariableQueryString),
		// 												NegateCondition: to.Ptr(false),
		// 												Operator: to.Ptr(armcdn.OperatorContains),
		// 												Selector: to.Ptr("search"),
		// 												Transforms: []*armcdn.TransformType{
		// 													to.Ptr(armcdn.TransformTypeURLDecode),
		// 													to.Ptr(armcdn.TransformTypeLowercase)},
		// 											}},
		// 											Priority: to.Ptr[int32](2),
		// 									}},
		// 								},
		// 								EndpointLinks: []*armcdn.LinkedEndpoint{
		// 									{
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/profiles/profile1/endpoints/testEndpoint1"),
		// 									},
		// 									{
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/profiles/profile1/endpoints/testEndpoint2"),
		// 								}},
		// 								ManagedRules: &armcdn.ManagedRuleSetList{
		// 									ManagedRuleSets: []*armcdn.ManagedRuleSet{
		// 										{
		// 											RuleGroupOverrides: []*armcdn.ManagedRuleGroupOverride{
		// 												{
		// 													RuleGroupName: to.Ptr("Group1"),
		// 													Rules: []*armcdn.ManagedRuleOverride{
		// 														{
		// 															Action: to.Ptr(armcdn.ActionTypeRedirect),
		// 															EnabledState: to.Ptr(armcdn.ManagedRuleEnabledStateEnabled),
		// 															RuleID: to.Ptr("GROUP1-0001"),
		// 														},
		// 														{
		// 															EnabledState: to.Ptr(armcdn.ManagedRuleEnabledStateDisabled),
		// 															RuleID: to.Ptr("GROUP1-0002"),
		// 													}},
		// 											}},
		// 											RuleSetType: to.Ptr("DefaultRuleSet"),
		// 											RuleSetVersion: to.Ptr("preview-1.0"),
		// 									}},
		// 								},
		// 								PolicySettings: &armcdn.PolicySettings{
		// 									DefaultCustomBlockResponseBody: to.Ptr("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
		// 									DefaultCustomBlockResponseStatusCode: to.Ptr(armcdn.PolicySettingsDefaultCustomBlockResponseStatusCode(429)),
		// 									DefaultRedirectURL: to.Ptr("http://www.bing.com"),
		// 									EnabledState: to.Ptr(armcdn.PolicyEnabledStateEnabled),
		// 									Mode: to.Ptr(armcdn.PolicyModePrevention),
		// 								},
		// 								ProvisioningState: to.Ptr(armcdn.ProvisioningStateSucceeded),
		// 								RateLimitRules: &armcdn.RateLimitRuleList{
		// 									Rules: []*armcdn.RateLimitRule{
		// 										{
		// 											Name: to.Ptr("RateLimitRule1"),
		// 											Action: to.Ptr(armcdn.ActionTypeBlock),
		// 											EnabledState: to.Ptr(armcdn.CustomRuleEnabledStateEnabled),
		// 											MatchConditions: []*armcdn.MatchCondition{
		// 												{
		// 													MatchValue: []*string{
		// 														to.Ptr("192.168.1.0/24"),
		// 														to.Ptr("10.0.0.0/24")},
		// 														MatchVariable: to.Ptr(armcdn.WafMatchVariableRemoteAddr),
		// 														NegateCondition: to.Ptr(false),
		// 														Operator: to.Ptr(armcdn.OperatorIPMatch),
		// 														Transforms: []*armcdn.TransformType{
		// 														},
		// 												}},
		// 												Priority: to.Ptr[int32](1),
		// 												RateLimitDurationInMinutes: to.Ptr[int32](0),
		// 												RateLimitThreshold: to.Ptr[int32](1000),
		// 										}},
		// 									},
		// 									ResourceState: to.Ptr(armcdn.PolicyResourceStateEnabled),
		// 								},
		// 								SKU: &armcdn.SKU{
		// 									Name: to.Ptr(armcdn.SKUNameStandardMicrosoft),
		// 								},
		// 							},
		// 							{
		// 								Name: to.Ptr("VerizonStandardCdnWafPolicy"),
		// 								Type: to.Ptr("Microsoft.Cdn/cdnwebapplicationfirewallpolicies"),
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/VerizonStandardCdnWafPolicy"),
		// 								Location: to.Ptr("WestUs"),
		// 								Tags: map[string]*string{
		// 									"key1": to.Ptr("value1"),
		// 									"key2": to.Ptr("value2"),
		// 								},
		// 								Properties: &armcdn.WebApplicationFirewallPolicyProperties{
		// 									CustomRules: &armcdn.CustomRuleList{
		// 										Rules: []*armcdn.CustomRule{
		// 											{
		// 												Name: to.Ptr("CustomRule1"),
		// 												Action: to.Ptr(armcdn.ActionTypeBlock),
		// 												EnabledState: to.Ptr(armcdn.CustomRuleEnabledStateEnabled),
		// 												MatchConditions: []*armcdn.MatchCondition{
		// 													{
		// 														MatchValue: []*string{
		// 															to.Ptr("CH")},
		// 															MatchVariable: to.Ptr(armcdn.WafMatchVariableRemoteAddr),
		// 															NegateCondition: to.Ptr(false),
		// 															Operator: to.Ptr(armcdn.OperatorGeoMatch),
		// 															Transforms: []*armcdn.TransformType{
		// 															},
		// 														},
		// 														{
		// 															MatchValue: []*string{
		// 																to.Ptr("windows")},
		// 																MatchVariable: to.Ptr(armcdn.WafMatchVariableRequestHeader),
		// 																NegateCondition: to.Ptr(false),
		// 																Operator: to.Ptr(armcdn.OperatorContains),
		// 																Selector: to.Ptr("UserAgent"),
		// 															},
		// 															{
		// 																MatchValue: []*string{
		// 																	to.Ptr("<?php"),
		// 																	to.Ptr("?>")},
		// 																	MatchVariable: to.Ptr(armcdn.WafMatchVariableQueryString),
		// 																	NegateCondition: to.Ptr(false),
		// 																	Operator: to.Ptr(armcdn.OperatorContains),
		// 																	Selector: to.Ptr("search"),
		// 																	Transforms: []*armcdn.TransformType{
		// 																		to.Ptr(armcdn.TransformTypeURLDecode),
		// 																		to.Ptr(armcdn.TransformTypeLowercase)},
		// 																}},
		// 																Priority: to.Ptr[int32](2),
		// 														}},
		// 													},
		// 													EndpointLinks: []*armcdn.LinkedEndpoint{
		// 														{
		// 															ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/profiles/profile1/endpoints/testEndpoint3"),
		// 													}},
		// 													ManagedRules: &armcdn.ManagedRuleSetList{
		// 														ManagedRuleSets: []*armcdn.ManagedRuleSet{
		// 															{
		// 																RuleGroupOverrides: []*armcdn.ManagedRuleGroupOverride{
		// 																	{
		// 																		RuleGroupName: to.Ptr("XSS"),
		// 																		Rules: []*armcdn.ManagedRuleOverride{
		// 																			{
		// 																				Action: to.Ptr(armcdn.ActionTypeRedirect),
		// 																				EnabledState: to.Ptr(armcdn.ManagedRuleEnabledStateEnabled),
		// 																				RuleID: to.Ptr("XSS-0001"),
		// 																			},
		// 																			{
		// 																				EnabledState: to.Ptr(armcdn.ManagedRuleEnabledStateDisabled),
		// 																				RuleID: to.Ptr("XSS-0002"),
		// 																		}},
		// 																}},
		// 																RuleSetType: to.Ptr("ECRS"),
		// 																RuleSetVersion: to.Ptr("2018-11-2"),
		// 														}},
		// 													},
		// 													PolicySettings: &armcdn.PolicySettings{
		// 														DefaultCustomBlockResponseBody: to.Ptr("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
		// 														DefaultCustomBlockResponseStatusCode: to.Ptr(armcdn.PolicySettingsDefaultCustomBlockResponseStatusCode(429)),
		// 														DefaultRedirectURL: to.Ptr("http://www.bing.com"),
		// 														EnabledState: to.Ptr(armcdn.PolicyEnabledStateEnabled),
		// 														Mode: to.Ptr(armcdn.PolicyModePrevention),
		// 													},
		// 													ProvisioningState: to.Ptr(armcdn.ProvisioningStateSucceeded),
		// 													RateLimitRules: &armcdn.RateLimitRuleList{
		// 														Rules: []*armcdn.RateLimitRule{
		// 															{
		// 																Name: to.Ptr("RateLimitRule1"),
		// 																Action: to.Ptr(armcdn.ActionTypeBlock),
		// 																EnabledState: to.Ptr(armcdn.CustomRuleEnabledStateEnabled),
		// 																MatchConditions: []*armcdn.MatchCondition{
		// 																	{
		// 																		MatchValue: []*string{
		// 																			to.Ptr("192.168.1.0/24"),
		// 																			to.Ptr("10.0.0.0/24")},
		// 																			MatchVariable: to.Ptr(armcdn.WafMatchVariableRemoteAddr),
		// 																			NegateCondition: to.Ptr(false),
		// 																			Operator: to.Ptr(armcdn.OperatorIPMatch),
		// 																			Transforms: []*armcdn.TransformType{
		// 																			},
		// 																	}},
		// 																	Priority: to.Ptr[int32](1),
		// 																	RateLimitDurationInMinutes: to.Ptr[int32](0),
		// 																	RateLimitThreshold: to.Ptr[int32](1000),
		// 															}},
		// 														},
		// 														ResourceState: to.Ptr(armcdn.PolicyResourceStateEnabled),
		// 													},
		// 													SKU: &armcdn.SKU{
		// 														Name: to.Ptr(armcdn.SKUNameStandardVerizon),
		// 													},
		// 											}},
		// 										}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafPolicyGet.json
func ExamplePoliciesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPoliciesClient().Get(ctx, "rg1", "MicrosoftCdnWafPolicy", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WebApplicationFirewallPolicy = armcdn.WebApplicationFirewallPolicy{
	// 	Name: to.Ptr("MicrosoftCdnWafPolicy"),
	// 	Type: to.Ptr("Microsoft.Cdn/cdnwebapplicationfirewallpolicies"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/MicrosoftCdnWafPolicy"),
	// 	Location: to.Ptr("WestUs"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armcdn.WebApplicationFirewallPolicyProperties{
	// 		CustomRules: &armcdn.CustomRuleList{
	// 			Rules: []*armcdn.CustomRule{
	// 				{
	// 					Name: to.Ptr("CustomRule1"),
	// 					Action: to.Ptr(armcdn.ActionTypeBlock),
	// 					EnabledState: to.Ptr(armcdn.CustomRuleEnabledStateEnabled),
	// 					MatchConditions: []*armcdn.MatchCondition{
	// 						{
	// 							MatchValue: []*string{
	// 								to.Ptr("CH")},
	// 								MatchVariable: to.Ptr(armcdn.WafMatchVariableRemoteAddr),
	// 								NegateCondition: to.Ptr(false),
	// 								Operator: to.Ptr(armcdn.OperatorGeoMatch),
	// 								Transforms: []*armcdn.TransformType{
	// 								},
	// 							},
	// 							{
	// 								MatchValue: []*string{
	// 									to.Ptr("windows")},
	// 									MatchVariable: to.Ptr(armcdn.WafMatchVariableRequestHeader),
	// 									NegateCondition: to.Ptr(false),
	// 									Operator: to.Ptr(armcdn.OperatorContains),
	// 									Selector: to.Ptr("UserAgent"),
	// 									Transforms: []*armcdn.TransformType{
	// 									},
	// 								},
	// 								{
	// 									MatchValue: []*string{
	// 										to.Ptr("<?php"),
	// 										to.Ptr("?>")},
	// 										MatchVariable: to.Ptr(armcdn.WafMatchVariableQueryString),
	// 										NegateCondition: to.Ptr(false),
	// 										Operator: to.Ptr(armcdn.OperatorContains),
	// 										Selector: to.Ptr("search"),
	// 										Transforms: []*armcdn.TransformType{
	// 											to.Ptr(armcdn.TransformTypeURLDecode),
	// 											to.Ptr(armcdn.TransformTypeLowercase)},
	// 									}},
	// 									Priority: to.Ptr[int32](2),
	// 							}},
	// 						},
	// 						EndpointLinks: []*armcdn.LinkedEndpoint{
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/profiles/profile1/endpoints/testEndpoint1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/profiles/profile1/endpoints/testEndpoint2"),
	// 						}},
	// 						ManagedRules: &armcdn.ManagedRuleSetList{
	// 							ManagedRuleSets: []*armcdn.ManagedRuleSet{
	// 								{
	// 									RuleGroupOverrides: []*armcdn.ManagedRuleGroupOverride{
	// 										{
	// 											RuleGroupName: to.Ptr("Group1"),
	// 											Rules: []*armcdn.ManagedRuleOverride{
	// 												{
	// 													Action: to.Ptr(armcdn.ActionTypeRedirect),
	// 													EnabledState: to.Ptr(armcdn.ManagedRuleEnabledStateEnabled),
	// 													RuleID: to.Ptr("GROUP1-0001"),
	// 												},
	// 												{
	// 													EnabledState: to.Ptr(armcdn.ManagedRuleEnabledStateDisabled),
	// 													RuleID: to.Ptr("GROUP1-0002"),
	// 											}},
	// 									}},
	// 									RuleSetType: to.Ptr("DefaultRuleSet"),
	// 									RuleSetVersion: to.Ptr("preview-1.0"),
	// 							}},
	// 						},
	// 						PolicySettings: &armcdn.PolicySettings{
	// 							DefaultCustomBlockResponseBody: to.Ptr("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
	// 							DefaultCustomBlockResponseStatusCode: to.Ptr(armcdn.PolicySettingsDefaultCustomBlockResponseStatusCode(429)),
	// 							DefaultRedirectURL: to.Ptr("http://www.bing.com"),
	// 							EnabledState: to.Ptr(armcdn.PolicyEnabledStateEnabled),
	// 							Mode: to.Ptr(armcdn.PolicyModePrevention),
	// 						},
	// 						ProvisioningState: to.Ptr(armcdn.ProvisioningStateSucceeded),
	// 						RateLimitRules: &armcdn.RateLimitRuleList{
	// 							Rules: []*armcdn.RateLimitRule{
	// 								{
	// 									Name: to.Ptr("RateLimitRule1"),
	// 									Action: to.Ptr(armcdn.ActionTypeBlock),
	// 									EnabledState: to.Ptr(armcdn.CustomRuleEnabledStateEnabled),
	// 									MatchConditions: []*armcdn.MatchCondition{
	// 										{
	// 											MatchValue: []*string{
	// 												to.Ptr("192.168.1.0/24"),
	// 												to.Ptr("10.0.0.0/24")},
	// 												MatchVariable: to.Ptr(armcdn.WafMatchVariableRemoteAddr),
	// 												NegateCondition: to.Ptr(false),
	// 												Operator: to.Ptr(armcdn.OperatorIPMatch),
	// 												Transforms: []*armcdn.TransformType{
	// 												},
	// 										}},
	// 										Priority: to.Ptr[int32](1),
	// 										RateLimitDurationInMinutes: to.Ptr[int32](0),
	// 										RateLimitThreshold: to.Ptr[int32](1000),
	// 								}},
	// 							},
	// 							ResourceState: to.Ptr(armcdn.PolicyResourceStateEnabled),
	// 						},
	// 						SKU: &armcdn.SKU{
	// 							Name: to.Ptr(armcdn.SKUNameStandardMicrosoft),
	// 						},
	// 					}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafPolicyCreateOrUpdate.json
func ExamplePoliciesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPoliciesClient().BeginCreateOrUpdate(ctx, "rg1", "MicrosoftCdnWafPolicy", armcdn.WebApplicationFirewallPolicy{
		Location: to.Ptr("WestUs"),
		Properties: &armcdn.WebApplicationFirewallPolicyProperties{
			CustomRules: &armcdn.CustomRuleList{
				Rules: []*armcdn.CustomRule{
					{
						Name:         to.Ptr("CustomRule1"),
						Action:       to.Ptr(armcdn.ActionTypeBlock),
						EnabledState: to.Ptr(armcdn.CustomRuleEnabledStateEnabled),
						MatchConditions: []*armcdn.MatchCondition{
							{
								MatchValue: []*string{
									to.Ptr("CH")},
								MatchVariable:   to.Ptr(armcdn.WafMatchVariableRemoteAddr),
								NegateCondition: to.Ptr(false),
								Operator:        to.Ptr(armcdn.OperatorGeoMatch),
								Transforms:      []*armcdn.TransformType{},
							},
							{
								MatchValue: []*string{
									to.Ptr("windows")},
								MatchVariable:   to.Ptr(armcdn.WafMatchVariableRequestHeader),
								NegateCondition: to.Ptr(false),
								Operator:        to.Ptr(armcdn.OperatorContains),
								Selector:        to.Ptr("UserAgent"),
								Transforms:      []*armcdn.TransformType{},
							},
							{
								MatchValue: []*string{
									to.Ptr("<?php"),
									to.Ptr("?>")},
								MatchVariable:   to.Ptr(armcdn.WafMatchVariableQueryString),
								NegateCondition: to.Ptr(false),
								Operator:        to.Ptr(armcdn.OperatorContains),
								Selector:        to.Ptr("search"),
								Transforms: []*armcdn.TransformType{
									to.Ptr(armcdn.TransformTypeURLDecode),
									to.Ptr(armcdn.TransformTypeLowercase)},
							}},
						Priority: to.Ptr[int32](2),
					}},
			},
			ManagedRules: &armcdn.ManagedRuleSetList{
				ManagedRuleSets: []*armcdn.ManagedRuleSet{
					{
						RuleGroupOverrides: []*armcdn.ManagedRuleGroupOverride{
							{
								RuleGroupName: to.Ptr("Group1"),
								Rules: []*armcdn.ManagedRuleOverride{
									{
										Action:       to.Ptr(armcdn.ActionTypeRedirect),
										EnabledState: to.Ptr(armcdn.ManagedRuleEnabledStateEnabled),
										RuleID:       to.Ptr("GROUP1-0001"),
									},
									{
										EnabledState: to.Ptr(armcdn.ManagedRuleEnabledStateDisabled),
										RuleID:       to.Ptr("GROUP1-0002"),
									}},
							}},
						RuleSetType:    to.Ptr("DefaultRuleSet"),
						RuleSetVersion: to.Ptr("preview-1.0"),
					}},
			},
			PolicySettings: &armcdn.PolicySettings{
				DefaultCustomBlockResponseBody:       to.Ptr("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
				DefaultCustomBlockResponseStatusCode: to.Ptr(armcdn.PolicySettingsDefaultCustomBlockResponseStatusCode(200)),
				DefaultRedirectURL:                   to.Ptr("http://www.bing.com"),
			},
			RateLimitRules: &armcdn.RateLimitRuleList{
				Rules: []*armcdn.RateLimitRule{
					{
						Name:         to.Ptr("RateLimitRule1"),
						Action:       to.Ptr(armcdn.ActionTypeBlock),
						EnabledState: to.Ptr(armcdn.CustomRuleEnabledStateEnabled),
						MatchConditions: []*armcdn.MatchCondition{
							{
								MatchValue: []*string{
									to.Ptr("192.168.1.0/24"),
									to.Ptr("10.0.0.0/24")},
								MatchVariable:   to.Ptr(armcdn.WafMatchVariableRemoteAddr),
								NegateCondition: to.Ptr(false),
								Operator:        to.Ptr(armcdn.OperatorIPMatch),
								Transforms:      []*armcdn.TransformType{},
							}},
						Priority:                   to.Ptr[int32](1),
						RateLimitDurationInMinutes: to.Ptr[int32](0),
						RateLimitThreshold:         to.Ptr[int32](1000),
					}},
			},
		},
		SKU: &armcdn.SKU{
			Name: to.Ptr(armcdn.SKUNameStandardMicrosoft),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WebApplicationFirewallPolicy = armcdn.WebApplicationFirewallPolicy{
	// 	Name: to.Ptr("MicrosoftCdnWafPolicy"),
	// 	Type: to.Ptr("Microsoft.Cdn/cdnwebapplicationfirewallpolicies"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/MicrosoftCdnWafPolicy"),
	// 	Location: to.Ptr("WestUs"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armcdn.WebApplicationFirewallPolicyProperties{
	// 		CustomRules: &armcdn.CustomRuleList{
	// 			Rules: []*armcdn.CustomRule{
	// 				{
	// 					Name: to.Ptr("CustomRule1"),
	// 					Action: to.Ptr(armcdn.ActionTypeBlock),
	// 					EnabledState: to.Ptr(armcdn.CustomRuleEnabledStateEnabled),
	// 					MatchConditions: []*armcdn.MatchCondition{
	// 						{
	// 							MatchValue: []*string{
	// 								to.Ptr("CH")},
	// 								MatchVariable: to.Ptr(armcdn.WafMatchVariableRemoteAddr),
	// 								NegateCondition: to.Ptr(false),
	// 								Operator: to.Ptr(armcdn.OperatorGeoMatch),
	// 								Transforms: []*armcdn.TransformType{
	// 								},
	// 							},
	// 							{
	// 								MatchValue: []*string{
	// 									to.Ptr("windows")},
	// 									MatchVariable: to.Ptr(armcdn.WafMatchVariableRequestHeader),
	// 									NegateCondition: to.Ptr(false),
	// 									Operator: to.Ptr(armcdn.OperatorContains),
	// 									Selector: to.Ptr("UserAgent"),
	// 									Transforms: []*armcdn.TransformType{
	// 									},
	// 								},
	// 								{
	// 									MatchValue: []*string{
	// 										to.Ptr("<?php"),
	// 										to.Ptr("?>")},
	// 										MatchVariable: to.Ptr(armcdn.WafMatchVariableQueryString),
	// 										NegateCondition: to.Ptr(false),
	// 										Operator: to.Ptr(armcdn.OperatorContains),
	// 										Selector: to.Ptr("search"),
	// 										Transforms: []*armcdn.TransformType{
	// 											to.Ptr(armcdn.TransformTypeURLDecode),
	// 											to.Ptr(armcdn.TransformTypeLowercase)},
	// 									}},
	// 									Priority: to.Ptr[int32](2),
	// 							}},
	// 						},
	// 						EndpointLinks: []*armcdn.LinkedEndpoint{
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/profiles/profile1/endpoints/testEndpoint1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/profiles/profile1/endpoints/testEndpoint2"),
	// 						}},
	// 						ManagedRules: &armcdn.ManagedRuleSetList{
	// 							ManagedRuleSets: []*armcdn.ManagedRuleSet{
	// 								{
	// 									RuleGroupOverrides: []*armcdn.ManagedRuleGroupOverride{
	// 										{
	// 											RuleGroupName: to.Ptr("Group1"),
	// 											Rules: []*armcdn.ManagedRuleOverride{
	// 												{
	// 													Action: to.Ptr(armcdn.ActionTypeRedirect),
	// 													EnabledState: to.Ptr(armcdn.ManagedRuleEnabledStateEnabled),
	// 													RuleID: to.Ptr("GROUP1-0001"),
	// 												},
	// 												{
	// 													EnabledState: to.Ptr(armcdn.ManagedRuleEnabledStateDisabled),
	// 													RuleID: to.Ptr("GROUP1-0002"),
	// 											}},
	// 									}},
	// 									RuleSetType: to.Ptr("DefaultRuleSet"),
	// 									RuleSetVersion: to.Ptr("preview-1.0"),
	// 							}},
	// 						},
	// 						PolicySettings: &armcdn.PolicySettings{
	// 							DefaultCustomBlockResponseBody: to.Ptr("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
	// 							DefaultCustomBlockResponseStatusCode: to.Ptr(armcdn.PolicySettingsDefaultCustomBlockResponseStatusCode(200)),
	// 							DefaultRedirectURL: to.Ptr("http://www.bing.com"),
	// 							EnabledState: to.Ptr(armcdn.PolicyEnabledStateEnabled),
	// 							Mode: to.Ptr(armcdn.PolicyModePrevention),
	// 						},
	// 						ProvisioningState: to.Ptr(armcdn.ProvisioningStateSucceeded),
	// 						RateLimitRules: &armcdn.RateLimitRuleList{
	// 							Rules: []*armcdn.RateLimitRule{
	// 								{
	// 									Name: to.Ptr("RateLimitRule1"),
	// 									Action: to.Ptr(armcdn.ActionTypeBlock),
	// 									EnabledState: to.Ptr(armcdn.CustomRuleEnabledStateEnabled),
	// 									MatchConditions: []*armcdn.MatchCondition{
	// 										{
	// 											MatchValue: []*string{
	// 												to.Ptr("192.168.1.0/24"),
	// 												to.Ptr("10.0.0.0/24")},
	// 												MatchVariable: to.Ptr(armcdn.WafMatchVariableRemoteAddr),
	// 												NegateCondition: to.Ptr(false),
	// 												Operator: to.Ptr(armcdn.OperatorIPMatch),
	// 												Transforms: []*armcdn.TransformType{
	// 												},
	// 										}},
	// 										Priority: to.Ptr[int32](1),
	// 										RateLimitDurationInMinutes: to.Ptr[int32](0),
	// 										RateLimitThreshold: to.Ptr[int32](1000),
	// 								}},
	// 							},
	// 							ResourceState: to.Ptr(armcdn.PolicyResourceStateEnabled),
	// 						},
	// 						SKU: &armcdn.SKU{
	// 							Name: to.Ptr(armcdn.SKUNameStandardMicrosoft),
	// 						},
	// 					}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafPatchPolicy.json
func ExamplePoliciesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPoliciesClient().BeginUpdate(ctx, "rg1", "MicrosoftCdnWafPolicy", armcdn.WebApplicationFirewallPolicyPatchParameters{
		Tags: map[string]*string{
			"foo": to.Ptr("bar"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WebApplicationFirewallPolicy = armcdn.WebApplicationFirewallPolicy{
	// 	Name: to.Ptr("MicrosoftCdnWafPolicy"),
	// 	Type: to.Ptr("Microsoft.Cdn/cdnwebapplicationfirewallpolicies"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/MicrosoftCdnWafPolicy"),
	// 	Location: to.Ptr("WestUs"),
	// 	Tags: map[string]*string{
	// 		"foo": to.Ptr("bar"),
	// 	},
	// 	Properties: &armcdn.WebApplicationFirewallPolicyProperties{
	// 		CustomRules: &armcdn.CustomRuleList{
	// 			Rules: []*armcdn.CustomRule{
	// 				{
	// 					Name: to.Ptr("CustomRule1"),
	// 					Action: to.Ptr(armcdn.ActionTypeBlock),
	// 					EnabledState: to.Ptr(armcdn.CustomRuleEnabledStateEnabled),
	// 					MatchConditions: []*armcdn.MatchCondition{
	// 						{
	// 							MatchValue: []*string{
	// 								to.Ptr("CH")},
	// 								MatchVariable: to.Ptr(armcdn.WafMatchVariableRemoteAddr),
	// 								NegateCondition: to.Ptr(false),
	// 								Operator: to.Ptr(armcdn.OperatorGeoMatch),
	// 								Transforms: []*armcdn.TransformType{
	// 								},
	// 							},
	// 							{
	// 								MatchValue: []*string{
	// 									to.Ptr("windows")},
	// 									MatchVariable: to.Ptr(armcdn.WafMatchVariableRequestHeader),
	// 									NegateCondition: to.Ptr(false),
	// 									Operator: to.Ptr(armcdn.OperatorContains),
	// 									Selector: to.Ptr("UserAgent"),
	// 									Transforms: []*armcdn.TransformType{
	// 									},
	// 								},
	// 								{
	// 									MatchValue: []*string{
	// 										to.Ptr("<?php"),
	// 										to.Ptr("?>")},
	// 										MatchVariable: to.Ptr(armcdn.WafMatchVariableQueryString),
	// 										NegateCondition: to.Ptr(false),
	// 										Operator: to.Ptr(armcdn.OperatorContains),
	// 										Selector: to.Ptr("search"),
	// 										Transforms: []*armcdn.TransformType{
	// 											to.Ptr(armcdn.TransformTypeURLDecode),
	// 											to.Ptr(armcdn.TransformTypeLowercase)},
	// 									}},
	// 									Priority: to.Ptr[int32](2),
	// 							}},
	// 						},
	// 						EndpointLinks: []*armcdn.LinkedEndpoint{
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/profiles/profile1/endpoints/testEndpoint1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cdn/profiles/profile1/endpoints/testEndpoint2"),
	// 						}},
	// 						ManagedRules: &armcdn.ManagedRuleSetList{
	// 							ManagedRuleSets: []*armcdn.ManagedRuleSet{
	// 								{
	// 									RuleGroupOverrides: []*armcdn.ManagedRuleGroupOverride{
	// 										{
	// 											RuleGroupName: to.Ptr("Group1"),
	// 											Rules: []*armcdn.ManagedRuleOverride{
	// 												{
	// 													Action: to.Ptr(armcdn.ActionTypeRedirect),
	// 													EnabledState: to.Ptr(armcdn.ManagedRuleEnabledStateEnabled),
	// 													RuleID: to.Ptr("GROUP1-0001"),
	// 												},
	// 												{
	// 													EnabledState: to.Ptr(armcdn.ManagedRuleEnabledStateDisabled),
	// 													RuleID: to.Ptr("GROUP1-0002"),
	// 											}},
	// 									}},
	// 									RuleSetType: to.Ptr("DefaultRuleSet"),
	// 									RuleSetVersion: to.Ptr("preview-1.0"),
	// 							}},
	// 						},
	// 						PolicySettings: &armcdn.PolicySettings{
	// 							DefaultCustomBlockResponseBody: to.Ptr("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
	// 							DefaultCustomBlockResponseStatusCode: to.Ptr(armcdn.PolicySettingsDefaultCustomBlockResponseStatusCode(403)),
	// 							DefaultRedirectURL: to.Ptr("http://www.bing.com"),
	// 							EnabledState: to.Ptr(armcdn.PolicyEnabledStateEnabled),
	// 							Mode: to.Ptr(armcdn.PolicyModePrevention),
	// 						},
	// 						ProvisioningState: to.Ptr(armcdn.ProvisioningStateSucceeded),
	// 						RateLimitRules: &armcdn.RateLimitRuleList{
	// 							Rules: []*armcdn.RateLimitRule{
	// 								{
	// 									Name: to.Ptr("RateLimitRule1"),
	// 									Action: to.Ptr(armcdn.ActionTypeBlock),
	// 									EnabledState: to.Ptr(armcdn.CustomRuleEnabledStateEnabled),
	// 									MatchConditions: []*armcdn.MatchCondition{
	// 										{
	// 											MatchValue: []*string{
	// 												to.Ptr("192.168.1.0/24"),
	// 												to.Ptr("10.0.0.0/24")},
	// 												MatchVariable: to.Ptr(armcdn.WafMatchVariableRemoteAddr),
	// 												NegateCondition: to.Ptr(false),
	// 												Operator: to.Ptr(armcdn.OperatorIPMatch),
	// 												Transforms: []*armcdn.TransformType{
	// 												},
	// 										}},
	// 										Priority: to.Ptr[int32](1),
	// 										RateLimitDurationInMinutes: to.Ptr[int32](0),
	// 										RateLimitThreshold: to.Ptr[int32](1000),
	// 								}},
	// 							},
	// 							ResourceState: to.Ptr(armcdn.PolicyResourceStateEnabled),
	// 						},
	// 						SKU: &armcdn.SKU{
	// 							Name: to.Ptr(armcdn.SKUNameStandardMicrosoft),
	// 						},
	// 					}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/WafPolicyDelete.json
func ExamplePoliciesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPoliciesClient().Delete(ctx, "rg1", "Policy1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
