//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armazurearcdata

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DataControllersClient contains the methods for the DataControllers group.
// Don't use this type directly, use NewDataControllersClient() instead.
type DataControllersClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewDataControllersClient creates a new instance of DataControllersClient with the specified values.
//   - subscriptionID - The ID of the Azure subscription
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDataControllersClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DataControllersClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DataControllersClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginDeleteDataController - Deletes a dataController resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-03-01-preview
//   - resourceGroupName - The name of the Azure resource group
//   - dataControllerName - The name of the data controller
//   - options - DataControllersClientBeginDeleteDataControllerOptions contains the optional parameters for the DataControllersClient.BeginDeleteDataController
//     method.
func (client *DataControllersClient) BeginDeleteDataController(ctx context.Context, resourceGroupName string, dataControllerName string, options *DataControllersClientBeginDeleteDataControllerOptions) (*runtime.Poller[DataControllersClientDeleteDataControllerResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteDataController(ctx, resourceGroupName, dataControllerName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DataControllersClientDeleteDataControllerResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DataControllersClientDeleteDataControllerResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteDataController - Deletes a dataController resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-03-01-preview
func (client *DataControllersClient) deleteDataController(ctx context.Context, resourceGroupName string, dataControllerName string, options *DataControllersClientBeginDeleteDataControllerOptions) (*http.Response, error) {
	var err error
	const operationName = "DataControllersClient.BeginDeleteDataController"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteDataControllerCreateRequest(ctx, resourceGroupName, dataControllerName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteDataControllerCreateRequest creates the DeleteDataController request.
func (client *DataControllersClient) deleteDataControllerCreateRequest(ctx context.Context, resourceGroupName string, dataControllerName string, options *DataControllersClientBeginDeleteDataControllerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/dataControllers/{dataControllerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataControllerName == "" {
		return nil, errors.New("parameter dataControllerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataControllerName}", url.PathEscape(dataControllerName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetDataController - Retrieves a dataController resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-03-01-preview
//   - resourceGroupName - The name of the Azure resource group
//   - dataControllerName - The name of the data controller
//   - options - DataControllersClientGetDataControllerOptions contains the optional parameters for the DataControllersClient.GetDataController
//     method.
func (client *DataControllersClient) GetDataController(ctx context.Context, resourceGroupName string, dataControllerName string, options *DataControllersClientGetDataControllerOptions) (DataControllersClientGetDataControllerResponse, error) {
	var err error
	const operationName = "DataControllersClient.GetDataController"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDataControllerCreateRequest(ctx, resourceGroupName, dataControllerName, options)
	if err != nil {
		return DataControllersClientGetDataControllerResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DataControllersClientGetDataControllerResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DataControllersClientGetDataControllerResponse{}, err
	}
	resp, err := client.getDataControllerHandleResponse(httpResp)
	return resp, err
}

// getDataControllerCreateRequest creates the GetDataController request.
func (client *DataControllersClient) getDataControllerCreateRequest(ctx context.Context, resourceGroupName string, dataControllerName string, options *DataControllersClientGetDataControllerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/dataControllers/{dataControllerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataControllerName == "" {
		return nil, errors.New("parameter dataControllerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataControllerName}", url.PathEscape(dataControllerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDataControllerHandleResponse handles the GetDataController response.
func (client *DataControllersClient) getDataControllerHandleResponse(resp *http.Response) (DataControllersClientGetDataControllerResponse, error) {
	result := DataControllersClientGetDataControllerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DataControllerResource); err != nil {
		return DataControllersClientGetDataControllerResponse{}, err
	}
	return result, nil
}

// NewListInGroupPager - List dataController resources in the resource group
//
// Generated from API version 2022-03-01-preview
//   - resourceGroupName - The name of the Azure resource group
//   - options - DataControllersClientListInGroupOptions contains the optional parameters for the DataControllersClient.NewListInGroupPager
//     method.
func (client *DataControllersClient) NewListInGroupPager(resourceGroupName string, options *DataControllersClientListInGroupOptions) *runtime.Pager[DataControllersClientListInGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[DataControllersClientListInGroupResponse]{
		More: func(page DataControllersClientListInGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DataControllersClientListInGroupResponse) (DataControllersClientListInGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DataControllersClient.NewListInGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listInGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return DataControllersClientListInGroupResponse{}, err
			}
			return client.listInGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listInGroupCreateRequest creates the ListInGroup request.
func (client *DataControllersClient) listInGroupCreateRequest(ctx context.Context, resourceGroupName string, options *DataControllersClientListInGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/dataControllers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listInGroupHandleResponse handles the ListInGroup response.
func (client *DataControllersClient) listInGroupHandleResponse(resp *http.Response) (DataControllersClientListInGroupResponse, error) {
	result := DataControllersClientListInGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PageOfDataControllerResource); err != nil {
		return DataControllersClientListInGroupResponse{}, err
	}
	return result, nil
}

// NewListInSubscriptionPager - List dataController resources in the subscription
//
// Generated from API version 2022-03-01-preview
//   - options - DataControllersClientListInSubscriptionOptions contains the optional parameters for the DataControllersClient.NewListInSubscriptionPager
//     method.
func (client *DataControllersClient) NewListInSubscriptionPager(options *DataControllersClientListInSubscriptionOptions) *runtime.Pager[DataControllersClientListInSubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[DataControllersClientListInSubscriptionResponse]{
		More: func(page DataControllersClientListInSubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DataControllersClientListInSubscriptionResponse) (DataControllersClientListInSubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DataControllersClient.NewListInSubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listInSubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return DataControllersClientListInSubscriptionResponse{}, err
			}
			return client.listInSubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listInSubscriptionCreateRequest creates the ListInSubscription request.
func (client *DataControllersClient) listInSubscriptionCreateRequest(ctx context.Context, options *DataControllersClientListInSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.AzureArcData/dataControllers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listInSubscriptionHandleResponse handles the ListInSubscription response.
func (client *DataControllersClient) listInSubscriptionHandleResponse(resp *http.Response) (DataControllersClientListInSubscriptionResponse, error) {
	result := DataControllersClientListInSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PageOfDataControllerResource); err != nil {
		return DataControllersClientListInSubscriptionResponse{}, err
	}
	return result, nil
}

// BeginPatchDataController - Updates a dataController resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-03-01-preview
//   - resourceGroupName - The name of the Azure resource group
//   - dataControllerName - The name of the data controller
//   - dataControllerResource - The update data controller resource
//   - options - DataControllersClientBeginPatchDataControllerOptions contains the optional parameters for the DataControllersClient.BeginPatchDataController
//     method.
func (client *DataControllersClient) BeginPatchDataController(ctx context.Context, resourceGroupName string, dataControllerName string, dataControllerResource DataControllerUpdate, options *DataControllersClientBeginPatchDataControllerOptions) (*runtime.Poller[DataControllersClientPatchDataControllerResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.patchDataController(ctx, resourceGroupName, dataControllerName, dataControllerResource, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DataControllersClientPatchDataControllerResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DataControllersClientPatchDataControllerResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// PatchDataController - Updates a dataController resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-03-01-preview
func (client *DataControllersClient) patchDataController(ctx context.Context, resourceGroupName string, dataControllerName string, dataControllerResource DataControllerUpdate, options *DataControllersClientBeginPatchDataControllerOptions) (*http.Response, error) {
	var err error
	const operationName = "DataControllersClient.BeginPatchDataController"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.patchDataControllerCreateRequest(ctx, resourceGroupName, dataControllerName, dataControllerResource, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// patchDataControllerCreateRequest creates the PatchDataController request.
func (client *DataControllersClient) patchDataControllerCreateRequest(ctx context.Context, resourceGroupName string, dataControllerName string, dataControllerResource DataControllerUpdate, options *DataControllersClientBeginPatchDataControllerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/dataControllers/{dataControllerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataControllerName == "" {
		return nil, errors.New("parameter dataControllerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataControllerName}", url.PathEscape(dataControllerName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, dataControllerResource); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginPutDataController - Creates or replaces a dataController resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-03-01-preview
//   - resourceGroupName - The name of the Azure resource group
//   - dataControllerName - The name of the data controller
//   - dataControllerResource - desc
//   - options - DataControllersClientBeginPutDataControllerOptions contains the optional parameters for the DataControllersClient.BeginPutDataController
//     method.
func (client *DataControllersClient) BeginPutDataController(ctx context.Context, resourceGroupName string, dataControllerName string, dataControllerResource DataControllerResource, options *DataControllersClientBeginPutDataControllerOptions) (*runtime.Poller[DataControllersClientPutDataControllerResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.putDataController(ctx, resourceGroupName, dataControllerName, dataControllerResource, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DataControllersClientPutDataControllerResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DataControllersClientPutDataControllerResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// PutDataController - Creates or replaces a dataController resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-03-01-preview
func (client *DataControllersClient) putDataController(ctx context.Context, resourceGroupName string, dataControllerName string, dataControllerResource DataControllerResource, options *DataControllersClientBeginPutDataControllerOptions) (*http.Response, error) {
	var err error
	const operationName = "DataControllersClient.BeginPutDataController"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.putDataControllerCreateRequest(ctx, resourceGroupName, dataControllerName, dataControllerResource, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// putDataControllerCreateRequest creates the PutDataController request.
func (client *DataControllersClient) putDataControllerCreateRequest(ctx context.Context, resourceGroupName string, dataControllerName string, dataControllerResource DataControllerResource, options *DataControllersClientBeginPutDataControllerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/dataControllers/{dataControllerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataControllerName == "" {
		return nil, errors.New("parameter dataControllerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataControllerName}", url.PathEscape(dataControllerName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, dataControllerResource); err != nil {
		return nil, err
	}
	return req, nil
}
