//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomation_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/deleteDscNodeConfiguration.json
func ExampleDscNodeConfigurationClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDscNodeConfigurationClient().Delete(ctx, "rg", "myAutomationAccount20", "configName.nodeConfigName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getDscNodeConfiguration.json
func ExampleDscNodeConfigurationClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDscNodeConfigurationClient().Get(ctx, "rg", "myAutomationAccount33", "SetupServer.localhost", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DscNodeConfiguration = armautomation.DscNodeConfiguration{
	// 	Name: to.Ptr("SetupServer.localhost"),
	// 	Type: to.Ptr("Microsoft.Automation/AutomationAccounts/nodeConfigurations"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/nodeConfigurations/SetupServer.localhost"),
	// 	Properties: &armautomation.DscNodeConfigurationProperties{
	// 		Configuration: &armautomation.DscConfigurationAssociationProperty{
	// 			Name: to.Ptr("SetupServer"),
	// 		},
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
	// 		IncrementNodeConfigurationBuild: to.Ptr(false),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
	// 		NodeCount: to.Ptr[int64](0),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/createOrUpdateDscNodeConfiguration.json
func ExampleDscNodeConfigurationClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDscNodeConfigurationClient().BeginCreateOrUpdate(ctx, "rg", "myAutomationAccount20", "configName.nodeConfigName", armautomation.DscNodeConfigurationCreateOrUpdateParameters{
		Name: to.Ptr("configName.nodeConfigName"),
		Properties: &armautomation.DscNodeConfigurationCreateOrUpdateParametersProperties{
			Configuration: &armautomation.DscConfigurationAssociationProperty{
				Name: to.Ptr("configName"),
			},
			IncrementNodeConfigurationBuild: to.Ptr(true),
			Source: &armautomation.ContentSource{
				Type: to.Ptr(armautomation.ContentSourceTypeEmbeddedContent),
				Hash: &armautomation.ContentHash{
					Algorithm: to.Ptr("sha256"),
					Value:     to.Ptr("6DE256A57F01BFA29B88696D5E77A383D6E61484C7686E8DB955FA10ACE9FFE5"),
				},
				Value:   to.Ptr("\r\ninstance of MSFT_RoleResource as $MSFT_RoleResource1ref\r\n{\r\nResourceID = \"[WindowsFeature]IIS\";\r\n Ensure = \"Present\";\r\n SourceInfo = \"::3::32::WindowsFeature\";\r\n Name = \"Web-Server\";\r\n ModuleName = \"PsDesiredStateConfiguration\";\r\n\r\nModuleVersion = \"1.0\";\r\r\n ConfigurationName = \"configName\";\r\r\n};\r\ninstance of OMI_ConfigurationDocument\r\n\r\r\n                    {\r\n Version=\"2.0.0\";\r\n \r\r\n                        MinimumCompatibleVersion = \"1.0.0\";\r\n \r\r\n                        CompatibleVersionAdditionalProperties= {\"Omi_BaseResource:ConfigurationName\"};\r\n \r\r\n                        Author=\"weijiel\";\r\n \r\r\n                        GenerationDate=\"03/30/2017 13:40:25\";\r\n \r\r\n                        GenerationHost=\"TEST-BACKEND\";\r\n \r\r\n                        Name=\"configName\";\r\n\r\r\n                    };\r\n"),
				Version: to.Ptr("1.0"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listDscNodeConfigurations.json
func ExampleDscNodeConfigurationClient_NewListByAutomationAccountPager_listDscNodeConfigurationsByAutomationAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDscNodeConfigurationClient().NewListByAutomationAccountPager("rg", "myAutomationAccount33", &armautomation.DscNodeConfigurationClientListByAutomationAccountOptions{Filter: nil,
		Skip:        nil,
		Top:         nil,
		Inlinecount: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DscNodeConfigurationListResult = armautomation.DscNodeConfigurationListResult{
		// 	Value: []*armautomation.DscNodeConfiguration{
		// 		{
		// 			Name: to.Ptr("SetupServer.localhost"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/nodeConfigurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/nodeConfigurations/SetupServer.localhost"),
		// 			Properties: &armautomation.DscNodeConfigurationProperties{
		// 				Configuration: &armautomation.DscConfigurationAssociationProperty{
		// 					Name: to.Ptr("SetupServer"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				IncrementNodeConfigurationBuild: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				NodeCount: to.Ptr[int64](0),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SetupServer.localhost"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/nodeConfigurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/nodeConfigurations/SetupServer.localhost"),
		// 			Properties: &armautomation.DscNodeConfigurationProperties{
		// 				Configuration: &armautomation.DscConfigurationAssociationProperty{
		// 					Name: to.Ptr("SetupServer"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				IncrementNodeConfigurationBuild: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				NodeCount: to.Ptr[int64](0),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listPagedDscNodeConfigurationsWithNameFilter.json
func ExampleDscNodeConfigurationClient_NewListByAutomationAccountPager_listPagedDscNodeConfigurationsByAutomationAccountWithNameFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDscNodeConfigurationClient().NewListByAutomationAccountPager("rg", "myAutomationAccount33", &armautomation.DscNodeConfigurationClientListByAutomationAccountOptions{Filter: to.Ptr("contains('.localhost',name)"),
		Skip:        to.Ptr[int32](0),
		Top:         to.Ptr[int32](2),
		Inlinecount: to.Ptr("allpages"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DscNodeConfigurationListResult = armautomation.DscNodeConfigurationListResult{
		// 	TotalCount: to.Ptr[int32](6),
		// 	Value: []*armautomation.DscNodeConfiguration{
		// 		{
		// 			Name: to.Ptr("server.localhost"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/nodeConfigurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/nodeConfigurations/SetupServer.localhost"),
		// 			Properties: &armautomation.DscNodeConfigurationProperties{
		// 				Configuration: &armautomation.DscConfigurationAssociationProperty{
		// 					Name: to.Ptr("SetupServer"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				NodeCount: to.Ptr[int64](2),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SetupClient.localhost"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/nodeConfigurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/nodeConfigurations/SetupClient.localhost"),
		// 			Properties: &armautomation.DscNodeConfigurationProperties{
		// 				Configuration: &armautomation.DscConfigurationAssociationProperty{
		// 					Name: to.Ptr("SetupClient"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				NodeCount: to.Ptr[int64](6),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listPagedDscNodeConfigurationsWithNoFilter.json
func ExampleDscNodeConfigurationClient_NewListByAutomationAccountPager_listPagedDscNodeConfigurationsByAutomationAccountWithNoFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDscNodeConfigurationClient().NewListByAutomationAccountPager("rg", "myAutomationAccount33", &armautomation.DscNodeConfigurationClientListByAutomationAccountOptions{Filter: nil,
		Skip:        to.Ptr[int32](0),
		Top:         to.Ptr[int32](4),
		Inlinecount: to.Ptr("allpages"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DscNodeConfigurationListResult = armautomation.DscNodeConfigurationListResult{
		// 	TotalCount: to.Ptr[int32](12),
		// 	Value: []*armautomation.DscNodeConfiguration{
		// 		{
		// 			Name: to.Ptr("server.localhost"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/nodeConfigurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/nodeConfigurations/SetupServer.localhost"),
		// 			Properties: &armautomation.DscNodeConfigurationProperties{
		// 				Configuration: &armautomation.DscConfigurationAssociationProperty{
		// 					Name: to.Ptr("SetupServer"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				NodeCount: to.Ptr[int64](2),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SetupClient.localhost"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/nodeConfigurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/nodeConfigurations/SetupClient.localhost"),
		// 			Properties: &armautomation.DscNodeConfigurationProperties{
		// 				Configuration: &armautomation.DscConfigurationAssociationProperty{
		// 					Name: to.Ptr("SetupClient"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				NodeCount: to.Ptr[int64](6),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("webServer.localhost"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/nodeConfigurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/nodeConfigurations/webServer.localhost"),
		// 			Properties: &armautomation.DscNodeConfigurationProperties{
		// 				Configuration: &armautomation.DscConfigurationAssociationProperty{
		// 					Name: to.Ptr("webServer"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				NodeCount: to.Ptr[int64](5),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SqlServer.localhost"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/nodeConfigurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/nodeConfigurations/SqlServer.localhost"),
		// 			Properties: &armautomation.DscNodeConfigurationProperties{
		// 				Configuration: &armautomation.DscConfigurationAssociationProperty{
		// 					Name: to.Ptr("SqlServer"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:17:06.890Z"); return t}()),
		// 				NodeCount: to.Ptr[int64](1),
		// 			},
		// 	}},
		// }
	}
}
