//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomation_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/deleteDscConfiguration.json
func ExampleDscConfigurationClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDscConfigurationClient().Delete(ctx, "rg", "myAutomationAccount33", "TemplateBasic", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/getDscConfiguration.json
func ExampleDscConfigurationClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDscConfigurationClient().Get(ctx, "rg", "myAutomationAccount33", "TemplateBasic", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DscConfiguration = armautomation.DscConfiguration{
	// 	Name: to.Ptr("TemplateBasic"),
	// 	Type: to.Ptr("Microsoft.Automation/AutomationAccounts/Configurations"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/configurations/TemplateBasic"),
	// 	Location: to.Ptr("East US 2"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("\"636263396635600000\""),
	// 	Properties: &armautomation.DscConfigurationProperties{
	// 		Description: to.Ptr("sample configuration"),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:14:23.560Z"); return t}()),
	// 		JobCount: to.Ptr[int32](0),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T23:14:23.560Z"); return t}()),
	// 		LogVerbose: to.Ptr(false),
	// 		Parameters: map[string]*armautomation.DscConfigurationParameter{
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		State: to.Ptr(armautomation.DscConfigurationStatePublished),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/getDscConfigurationContent.json
func ExampleDscConfigurationClient_GetContent() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDscConfigurationClient().GetContent(ctx, "rg", "myAutomationAccount33", "ConfigName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = "Configuration ConfigName {\r\n    Node localhost {\r\n                               WindowsFeature IIS {\r\n                               Name = \"Web-Server\";\r\n            Ensure = \"Present\"\r\n        }\r\n    }\r\n}"
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/getAllDscConfigurations.json
func ExampleDscConfigurationClient_NewListByAutomationAccountPager_getDscConfiguration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDscConfigurationClient().NewListByAutomationAccountPager("rg", "myAutomationAccount33", &armautomation.DscConfigurationClientListByAutomationAccountOptions{Filter: nil,
		Skip:        nil,
		Top:         nil,
		Inlinecount: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DscConfigurationListResult = armautomation.DscConfigurationListResult{
		// 	Value: []*armautomation.DscConfiguration{
		// 		{
		// 			Name: to.Ptr("SetupServer"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/Configurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/configurations/SetupServer"),
		// 			Location: to.Ptr("East US 2"),
		// 			Properties: &armautomation.DscConfigurationProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T18:53:24.997Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T18:53:24.997Z"); return t}()),
		// 				State: to.Ptr(armautomation.DscConfigurationStatePublished),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/getPagedlDscConfigurationsWithNameFilter.json
func ExampleDscConfigurationClient_NewListByAutomationAccountPager_listPagedDscConfigurationsWithNameFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDscConfigurationClient().NewListByAutomationAccountPager("rg", "myAutomationAccount33", &armautomation.DscConfigurationClientListByAutomationAccountOptions{Filter: to.Ptr("contains(name,'server')"),
		Skip:        to.Ptr[int32](0),
		Top:         to.Ptr[int32](2),
		Inlinecount: to.Ptr("allpages"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DscConfigurationListResult = armautomation.DscConfigurationListResult{
		// 	TotalCount: to.Ptr[int32](4),
		// 	Value: []*armautomation.DscConfiguration{
		// 		{
		// 			Name: to.Ptr("SqlServerBig"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/Configurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/configurations/SqlServerBig"),
		// 			Location: to.Ptr("East US 2"),
		// 			Properties: &armautomation.DscConfigurationProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T18:53:24.997Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T18:53:24.997Z"); return t}()),
		// 				NodeConfigurationCount: to.Ptr[int32](1),
		// 				State: to.Ptr(armautomation.DscConfigurationStatePublished),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SqlServerLittle"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/Configurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/configurations/SqlServerLittle"),
		// 			Location: to.Ptr("East US 2"),
		// 			Properties: &armautomation.DscConfigurationProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T18:53:24.997Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T18:53:24.997Z"); return t}()),
		// 				NodeConfigurationCount: to.Ptr[int32](1),
		// 				State: to.Ptr(armautomation.DscConfigurationStatePublished),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/getPagedDscConfigurationsWithNoFilter.json
func ExampleDscConfigurationClient_NewListByAutomationAccountPager_listPagedDscConfigurationsWithNoFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDscConfigurationClient().NewListByAutomationAccountPager("rg", "myAutomationAccount33", &armautomation.DscConfigurationClientListByAutomationAccountOptions{Filter: nil,
		Skip:        to.Ptr[int32](0),
		Top:         to.Ptr[int32](3),
		Inlinecount: to.Ptr("allpages"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DscConfigurationListResult = armautomation.DscConfigurationListResult{
		// 	TotalCount: to.Ptr[int32](12),
		// 	Value: []*armautomation.DscConfiguration{
		// 		{
		// 			Name: to.Ptr("SqlServerBig"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/Configurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/configurations/SqlServerBig"),
		// 			Location: to.Ptr("East US 2"),
		// 			Properties: &armautomation.DscConfigurationProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T18:53:24.997Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T18:53:24.997Z"); return t}()),
		// 				NodeConfigurationCount: to.Ptr[int32](1),
		// 				State: to.Ptr(armautomation.DscConfigurationStatePublished),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SqlServerLittle"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/Configurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/configurations/SqlServerLittle"),
		// 			Location: to.Ptr("East US 2"),
		// 			Properties: &armautomation.DscConfigurationProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T18:53:24.997Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T18:53:24.997Z"); return t}()),
		// 				NodeConfigurationCount: to.Ptr[int32](1),
		// 				State: to.Ptr(armautomation.DscConfigurationStatePublished),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SetupServer"),
		// 			Type: to.Ptr("Microsoft.Automation/AutomationAccounts/Configurations"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/configurations/SetupServer"),
		// 			Location: to.Ptr("East US 2"),
		// 			Properties: &armautomation.DscConfigurationProperties{
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T18:53:24.997Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-28T18:53:24.997Z"); return t}()),
		// 				NodeConfigurationCount: to.Ptr[int32](1),
		// 				State: to.Ptr(armautomation.DscConfigurationStatePublished),
		// 			},
		// 	}},
		// }
	}
}
